/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.internal;

import com.ishikyoo.memora.internal.InMemoryPack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class InMemoryPackRepository {
    @NotNull
    private final Map<String, InMemoryPack> available = new HashMap<String, InMemoryPack>();
    @NotNull
    private Map<String, InMemoryPack> selected = new LinkedHashMap<String, InMemoryPack>();

    @NotNull
    public Optional<InMemoryPack> addPack(@NotNull InMemoryPack pack) {
        String id = pack.location().comp_2329();
        if (this.available.containsKey(id)) {
            return Optional.empty();
        }
        InMemoryPack added = this.available.put(id, pack);
        return Optional.ofNullable(added);
    }

    @NotNull
    public Optional<InMemoryPack> removePack(@NotNull String id) {
        InMemoryPack removed = this.available.remove(id);
        return Optional.ofNullable(removed);
    }

    @NotNull
    public Optional<InMemoryPack> removePack(@NotNull InMemoryPack pack) {
        return this.removePack(pack.location().comp_2329());
    }

    @NotNull
    public Optional<InMemoryPack> getPack(@NotNull String id) {
        return Optional.ofNullable(this.available.get(id));
    }

    public boolean containsPack(@NotNull String id) {
        return this.available.containsKey(id);
    }

    @NotNull
    public Collection<InMemoryPack> getAvailablePacks() {
        return Collections.unmodifiableCollection(this.available.values());
    }

    @NotNull
    public Collection<String> getAvailableIds() {
        return Collections.unmodifiableCollection(this.available.keySet());
    }

    @NotNull
    public Collection<InMemoryPack> getSelectedPacks() {
        return Collections.unmodifiableCollection(this.selected.values());
    }

    @NotNull
    public Collection<String> getSelectedIds() {
        return Collections.unmodifiableCollection(this.selected.keySet());
    }

    public void setSelected(@NotNull Collection<String> availableBasePacks) {
        LinkedHashMap<String, InMemoryPack> selected = new LinkedHashMap<String, InMemoryPack>();
        for (String packId : availableBasePacks) {
            InMemoryPack pack = this.available.get(packId);
            if (pack == null) continue;
            selected.put(packId, pack);
        }
        this.selected = selected;
    }
}

