/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.internal;

import com.ishikyoo.memora.internal.InMemoryResource;
import com.ishikyoo.memora.internal.ModContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import net.minecraft.class_7368;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class InMemoryPackResources
implements class_3262 {
    private static final Logger LOGGER = ModContext.LOGGER;
    public static final String ROOT_NAMESPACE = "root";
    public static final class_2960 ROOT_LOCATION = class_2960.method_60655((String)"root", (String)"");
    public static final class_2960 PACK_META_LOCATION = ROOT_LOCATION.method_45136("pack.mcmeta");
    @NotNull
    private final class_3264 type;
    @NotNull
    private final class_9224 location;
    @NotNull
    private final Map<String, Integer> namespaces = new HashMap<String, Integer>();
    @NotNull
    private final Map<class_2960, InMemoryResource> resources = new HashMap<class_2960, InMemoryResource>();

    public InMemoryPackResources(@NotNull class_3264 type, @NotNull class_9224 location) {
        this.type = type;
        this.location = location;
    }

    @NotNull
    public Optional<InMemoryResource> addResource(@NotNull class_2960 location, byte @NotNull [] buffer) {
        if (this.resources.containsKey(location)) {
            LOGGER.warn("Trying to add an already present in-memory resource to the pack resources: {}", (Object)location);
            return Optional.empty();
        }
        InMemoryResource resource = InMemoryResource.of(buffer, this);
        this.resources.put(location, resource);
        this.addNamespace(location.method_12836());
        return Optional.of(resource);
    }

    @NotNull
    public Optional<InMemoryResource> removeResource(@NotNull class_2960 location) {
        InMemoryResource resource = this.resources.remove(location);
        if (resource == null) {
            LOGGER.warn("Trying to remove a not present in-memory resource from the pack resources: {}", (Object)location);
            return Optional.empty();
        }
        String namespace = location.method_12836();
        this.removeNamespace(namespace);
        return Optional.of(resource);
    }

    @NotNull
    public Optional<InMemoryResource> getResource(@NotNull class_2960 location) {
        InMemoryResource resource = this.resources.get(location);
        return Optional.ofNullable(resource);
    }

    @NotNull
    public Optional<InMemoryResource> getMetadataResource() {
        return this.getResource(PACK_META_LOCATION);
    }

    public boolean containsResource(class_2960 location) {
        return this.resources.containsKey(location);
    }

    public boolean containsMetadata() {
        return this.containsResource(PACK_META_LOCATION);
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        String path = String.join((CharSequence)"/", strings);
        InMemoryResource resource = this.resources.get(ROOT_LOCATION.method_45136(path));
        return resource == null ? null : () -> ((InMemoryResource)resource).method_14482();
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
        if (!type.equals((Object)this.type)) {
            return null;
        }
        InMemoryResource resource = this.resources.get(location);
        return resource == null ? null : () -> ((InMemoryResource)resource).method_14482();
    }

    public void method_14408(class_3264 type, String namespace, String path, class_3262.class_7664 output) {
        if (!type.equals((Object)this.type)) {
            return;
        }
        Object prefix = path.isEmpty() ? "" : path + "/";
        this.resources.forEach((arg_0, arg_1) -> InMemoryPackResources.lambda$listResources$0(namespace, (String)prefix, output, arg_0, arg_1));
    }

    @NotNull
    public Set<String> method_14406(class_3264 type) {
        return Collections.unmodifiableSet(this.namespaces.keySet());
    }

    @NotNull
    public class_9224 method_56926() {
        return this.location;
    }

    @NotNull
    public String method_14409() {
        return this.location.comp_2329();
    }

    @Nullable
    public <T> T method_14407(class_7677<T> metadataSectionType) throws IOException {
        InMemoryResource resource = this.resources.get(PACK_META_LOCATION);
        if (resource == null) {
            return null;
        }
        class_7368 metadata = resource.method_14481();
        Optional section = metadata.method_43041(metadataSectionType);
        return section.orElse(null);
    }

    public void close() {
    }

    public int getResourcesCount() {
        return this.resources.size();
    }

    public int getResourcesCount(@NotNull String namespace) {
        if (this.namespaces.containsKey(namespace)) {
            return 0;
        }
        return this.namespaces.get(namespace);
    }

    public int getRootResourcesCount() {
        return this.getResourcesCount(ROOT_NAMESPACE);
    }

    private void addNamespace(@NotNull String namespace) {
        if (!this.namespaces.containsKey(namespace)) {
            this.namespaces.put(namespace, 1);
        } else {
            int count = this.namespaces.get(namespace);
            this.namespaces.replace(namespace, count + 1);
        }
    }

    private void removeNamespace(@NotNull String namespace) {
        if (!this.namespaces.containsKey(namespace)) {
            return;
        }
        int count = this.namespaces.get(namespace);
        if (count > 1) {
            this.namespaces.replace(namespace, count - 1);
        } else {
            this.namespaces.remove(namespace);
        }
    }

    private static /* synthetic */ void lambda$listResources$0(String namespace, String prefix, class_3262.class_7664 output, class_2960 key, InMemoryResource resource) {
        if (!key.method_12836().equals(namespace)) {
            return;
        }
        if (!key.method_12832().startsWith(prefix)) {
            return;
        }
        String remaining = key.method_12832().substring(prefix.length());
        if (remaining.contains("/")) {
            return;
        }
        output.accept((Object)key, () -> ((InMemoryResource)resource).method_14482());
    }

    @ApiStatus.Internal
    public static class Supplier
    implements class_3288.class_7680 {
        @NotNull
        private final InMemoryPackResources resources;

        public Supplier(@NotNull InMemoryPackResources resources) {
            this.resources = resources;
        }

        @NotNull
        public InMemoryPackResources openPrimary(class_9224 packLocationInfo) {
            return this.resources;
        }

        @NotNull
        public InMemoryPackResources openFull(class_9224 packLocationInfo, class_3288.class_7679 metadata) {
            return this.resources;
        }
    }
}

