/*
 * Decompiled with CFR 0.152.
 */
package org.crazyhouse.blocksigningplugin;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.crazyhouse.blocksigningplugin.CommandHandler;
import org.crazyhouse.blocksigningplugin.ConfigManager;
import org.crazyhouse.blocksigningplugin.EventListener;
import org.crazyhouse.blocksigningplugin.ExternalInventoryHashAssigner;
import org.crazyhouse.blocksigningplugin.InventoryMonitor;
import org.crazyhouse.blocksigningplugin.ItemHashManager;

public class BlockSigningPlugin
extends JavaPlugin {
    private static final String CONFIG_VERSION = "2.2";
    private ConfigManager configManager;
    private ItemHashManager itemHashManager;
    private InventoryMonitor inventoryMonitor;
    private EventListener eventListener;
    private CommandHandler commandHandler;
    private ExternalInventoryHashAssigner externalInventoryHashAssigner;

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.itemHashManager = new ItemHashManager(this, this.configManager);
        this.inventoryMonitor = new InventoryMonitor(this, this.configManager, this.itemHashManager);
        this.eventListener = new EventListener(this, this.configManager, this.itemHashManager, this.inventoryMonitor);
        this.commandHandler = new CommandHandler(this, this.configManager, this.itemHashManager);
        this.configManager.saveDefaultConfig();
        this.configManager.loadConfigValues();
        this.configManager.setupBansFile();
        this.configManager.setupDupeLogFile();
        this.itemHashManager.initializeCustomStackSizes();
        this.getServer().getPluginManager().registerEvents((Listener)this.eventListener, (Plugin)this);
        this.getCommand("antidupe").setExecutor((CommandExecutor)this.commandHandler);
        this.getCommand("antidupe").setTabCompleter((TabCompleter)this.commandHandler);
        this.externalInventoryHashAssigner = new ExternalInventoryHashAssigner(this, this.configManager, this.itemHashManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.externalInventoryHashAssigner, (Plugin)this);
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, this.inventoryMonitor::scanForDuplicates, 0L, this.configManager.getScanIntervalTicks());
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, this.inventoryMonitor::scanForCrossInventoryDuplicates, 0L, this.configManager.getCrossScanIntervalTicks());
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, this.configManager::flushPendingDupeLogs, 0L, 600L);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this.inventoryMonitor::checkForUnhashedItems, 20L, this.configManager.getUnhashedCheckIntervalTicks());
        if (this.configManager.isDebugEnabled()) {
            this.getLogger().info("BlockSigningPlugin v2.3 enabled.");
        }
    }

    public void onDisable() {
        this.configManager.flushPendingDupeLogs();
        this.configManager.saveBansFile();
        if (this.configManager.isDebugEnabled()) {
            this.getLogger().info("BlockSigningPlugin v2.3 disabled.");
        }
    }
}

