/*
 * Decompiled with CFR 0.152.
 */
package org.crazyhouse.blocksigningplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.crazyhouse.blocksigningplugin.ConfigManager;
import org.crazyhouse.blocksigningplugin.ItemHashManager;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final ItemHashManager itemHashManager;

    public CommandHandler(JavaPlugin plugin, ConfigManager configManager, ItemHashManager itemHashManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.itemHashManager = itemHashManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("antidupe")) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage("\u00a7cUsage: /antidupe [modifyhash [custom-hash]|viewhash|whitelist <add|remove> <player>|setstacksize <item> <amount>|excludefromscan <add|remove> <material>|onlyscan <add|remove> <material>|reload]");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "modifyhash": {
                if (!player.hasPermission("antidupe.modifyhash")) {
                    player.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                String customHash = args.length > 1 ? args[1] : null;
                return this.modifyItemHash(player, customHash);
            }
            case "viewhash": {
                if (!player.hasPermission("antidupe.viewhash")) {
                    player.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                return this.viewItemHash(player);
            }
            case "whitelist": {
                if (!player.hasPermission("antidupe.whitelist")) {
                    player.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /antidupe whitelist <add|remove> <player>");
                    return true;
                }
                return this.manageWhitelist(player, args[1], args[2]);
            }
            case "setstacksize": {
                if (!player.hasPermission("antidupe.setstacksize")) {
                    player.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /antidupe setstacksize <item> <amount>");
                    return true;
                }
                return this.setCustomStackSize(player, args[1], args[2]);
            }
            case "excludefromscan": {
                if (!player.hasPermission("antidupe.excludefromscan")) {
                    player.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /antidupe excludefromscan <add|remove> <material>");
                    return true;
                }
                return this.manageExcludedFromScan(player, args[1], args[2]);
            }
            case "onlyscan": {
                if (!player.hasPermission("antidupe.onlyscan")) {
                    player.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /antidupe onlyscan <add|remove> <material>");
                    return true;
                }
                return this.manageOnlyScan(player, args[1], args[2]);
            }
            case "reload": {
                if (!player.hasPermission("antidupe.reload")) {
                    player.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                return this.reloadConfigFiles(player);
            }
        }
        player.sendMessage("\u00a7cUsage: /antidupe [modifyhash [custom-hash]|viewhash|whitelist <add|remove> <player>|setstacksize <item> <amount>|excludefromscan <add|remove> <material>|onlyscan <add|remove> <material>|reload]");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("antidupe")) {
            this.plugin.getLogger().info("Tab complete called for non-antidupe command: " + command.getName());
            return null;
        }
        this.plugin.getLogger().info("Tab complete called with args: " + Arrays.toString(args));
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 0 || args.length == 1 && args[0].isEmpty()) {
            List<String> subcommands = Arrays.asList("modifyhash", "viewhash", "whitelist", "setstacksize", "excludefromscan", "onlyscan", "reload");
            completions.addAll(subcommands.stream().filter(subcommand -> subcommand.toLowerCase().startsWith(args.length > 0 ? args[0].toLowerCase() : "")).collect(Collectors.toList()));
        } else if (args.length == 1) {
            List<String> subcommands = Arrays.asList("modifyhash", "viewhash", "whitelist", "setstacksize", "excludefromscan", "onlyscan", "reload");
            completions.addAll(subcommands.stream().filter(subcommand -> subcommand.toLowerCase().startsWith(args[0].toLowerCase()) && (sender.hasPermission("antidupe." + subcommand.toLowerCase()) || sender.isOp())).collect(Collectors.toList()));
        } else if (args.length == 2 && (args[0].equalsIgnoreCase("whitelist") || args[0].equalsIgnoreCase("excludefromscan") || args[0].equalsIgnoreCase("onlyscan"))) {
            if (sender.hasPermission("antidupe." + args[0].toLowerCase()) || sender.isOp()) {
                completions.addAll(Arrays.asList("add", "remove").stream().filter(action -> action.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList()));
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("setstacksize")) {
            if (sender.hasPermission("antidupe.setstacksize") || sender.isOp()) {
                completions.addAll(Arrays.stream(Material.values()).map(Enum::name).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList()));
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("whitelist")) {
            if (sender.hasPermission("antidupe.whitelist") || sender.isOp()) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList()));
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("setstacksize")) {
            if (sender.hasPermission("antidupe.setstacksize") || sender.isOp()) {
                completions.addAll(Arrays.asList("1", "16", "64").stream().filter(amount -> amount.startsWith(args[2].toLowerCase())).collect(Collectors.toList()));
            }
        } else if (args.length == 3 && (args[0].equalsIgnoreCase("excludefromscan") || args[0].equalsIgnoreCase("onlyscan")) && (sender.hasPermission("antidupe." + args[0].toLowerCase()) || sender.isOp())) {
            completions.addAll(Arrays.stream(Material.values()).map(Enum::name).filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList()));
        }
        this.plugin.getLogger().info("Returning completions: " + String.valueOf(completions));
        return completions.isEmpty() ? null : completions;
    }

    private boolean modifyItemHash(Player player, String customHash) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType().isAir()) {
            player.sendMessage("\u00a7cYou must be holding an item to modify its hash!");
            return true;
        }
        ItemMeta itemMeta = itemInHand.getItemMeta();
        if (itemMeta == null) {
            player.sendMessage("\u00a7cThis item has no metadata!");
            return true;
        }
        String newHash = customHash != null && !customHash.trim().isEmpty() ? customHash.trim() : this.itemHashManager.calculateHash(player.getName(), itemInHand.getType().name(), System.currentTimeMillis(), itemInHand.getAmount());
        itemMeta.getPersistentDataContainer().set(this.itemHashManager.getKey(), PersistentDataType.STRING, (Object)newHash);
        itemInHand.setItemMeta(itemMeta);
        this.itemHashManager.getGlobalMD5Map().put(newHash, player.getUniqueId());
        player.sendMessage("\u00a7aSuccessfully modified hash of " + itemInHand.getType().name() + " to: " + newHash);
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info(player.getName() + " modified hash of " + itemInHand.getType().name() + " to: " + newHash);
        }
        return true;
    }

    private boolean viewItemHash(Player player) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType().isAir()) {
            player.sendMessage("\u00a7cYou must be holding an item to view its hash!");
            return true;
        }
        ItemMeta itemMeta = itemInHand.getItemMeta();
        if (itemMeta == null) {
            player.sendMessage("\u00a7cThis item has no metadata!");
            return true;
        }
        String hash = (String)itemMeta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING);
        player.sendMessage((String)(hash == null ? "\u00a7cThis item has no hash assigned!" : "\u00a7aHash of " + itemInHand.getType().name() + ": " + hash));
        return true;
    }

    private boolean manageWhitelist(Player sender, String action, String targetPlayerName) {
        Player target = Bukkit.getPlayerExact((String)targetPlayerName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer " + targetPlayerName + " not found!");
            return true;
        }
        UUID targetUUID = target.getUniqueId();
        List whitelist = this.plugin.getConfig().getStringList("whitelist");
        if (action.equalsIgnoreCase("add")) {
            if (this.configManager.getWhitelist().contains(targetUUID)) {
                sender.sendMessage("\u00a7cPlayer " + targetPlayerName + " is already whitelisted!");
                return true;
            }
            this.configManager.getWhitelist().add(targetUUID);
            whitelist.add(targetUUID.toString());
            this.plugin.getConfig().set("whitelist", (Object)whitelist);
            this.plugin.saveConfig();
            sender.sendMessage("\u00a7aAdded " + targetPlayerName + " to whitelist.");
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info(sender.getName() + " added " + targetPlayerName + " to whitelist.");
            }
        } else if (action.equalsIgnoreCase("remove")) {
            if (!this.configManager.getWhitelist().contains(targetUUID)) {
                sender.sendMessage("\u00a7cPlayer " + targetPlayerName + " is not whitelisted!");
                return true;
            }
            this.configManager.getWhitelist().remove(targetUUID);
            whitelist.remove(targetUUID.toString());
            this.plugin.getConfig().set("whitelist", (Object)whitelist);
            this.plugin.saveConfig();
            sender.sendMessage("\u00a7aRemoved " + targetPlayerName + " from whitelist.");
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info(sender.getName() + " removed " + targetPlayerName + " from whitelist.");
            }
        } else {
            sender.sendMessage("\u00a7cUsage: /antidupe whitelist <add|remove> <player>");
        }
        return true;
    }

    private boolean setCustomStackSize(Player player, String materialName, String sizeStr) {
        try {
            Material material = Material.valueOf((String)materialName.toUpperCase());
            int size = Integer.parseInt(sizeStr);
            if (size <= 0) {
                player.sendMessage("\u00a7cStack size must be a positive integer!");
                return true;
            }
            this.itemHashManager.getCustomStackSizes().put(material, size);
            this.plugin.getConfig().set("custom-stack-sizes." + material.name(), (Object)size);
            this.plugin.saveConfig();
            player.sendMessage("\u00a7aSet custom stack size for " + material.name() + " to " + size);
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info(player.getName() + " set stack size for " + material.name() + " to " + size);
            }
        }
        catch (IllegalArgumentException e) {
            player.sendMessage("\u00a7cInvalid item or amount: " + materialName + ", " + sizeStr);
        }
        return true;
    }

    private boolean manageExcludedFromScan(Player player, String action, String materialName) {
        try {
            Material material = Material.valueOf((String)materialName.toUpperCase());
            List excludedList = this.plugin.getConfig().getStringList("excluded-from-dupe-scans");
            if (action.equalsIgnoreCase("add")) {
                if (this.configManager.getExcludedFromDupeScans().contains(material)) {
                    player.sendMessage("\u00a7cMaterial " + materialName + " is already excluded from dupe scans!");
                    return true;
                }
                this.configManager.getExcludedFromDupeScans().add(material);
                excludedList.add(material.name());
                this.plugin.getConfig().set("excluded-from-dupe-scans", (Object)excludedList);
                this.plugin.saveConfig();
                player.sendMessage("\u00a7aAdded " + material.name() + " to excluded-from-dupe-scans.");
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info(player.getName() + " added " + material.name() + " to excluded-from-dupe-scans.");
                }
            } else if (action.equalsIgnoreCase("remove")) {
                if (!this.configManager.getExcludedFromDupeScans().contains(material)) {
                    player.sendMessage("\u00a7cMaterial " + materialName + " is not excluded from dupe scans!");
                    return true;
                }
                this.configManager.getExcludedFromDupeScans().remove(material);
                excludedList.remove(material.name());
                this.plugin.getConfig().set("excluded-from-dupe-scans", (Object)excludedList);
                this.plugin.saveConfig();
                player.sendMessage("\u00a7aRemoved " + material.name() + " from excluded-from-dupe-scans.");
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info(player.getName() + " removed " + material.name() + " from excluded-from-dupe-scans.");
                }
            } else {
                player.sendMessage("\u00a7cUsage: /antidupe excludefromscan <add|remove> <material>");
            }
        }
        catch (IllegalArgumentException e) {
            player.sendMessage("\u00a7cInvalid material: " + materialName);
        }
        return true;
    }

    private boolean manageOnlyScan(Player player, String action, String materialName) {
        try {
            Material material = Material.valueOf((String)materialName.toUpperCase());
            List onlyScanList = this.plugin.getConfig().getStringList("onlyscan");
            if (action.equalsIgnoreCase("add")) {
                if (this.configManager.getOnlyScanItems().contains(material)) {
                    player.sendMessage("\u00a7cMaterial " + materialName + " is already in onlyscan list!");
                    return true;
                }
                this.configManager.getOnlyScanItems().add(material);
                onlyScanList.add(material.name());
                this.plugin.getConfig().set("onlyscan", (Object)onlyScanList);
                this.plugin.getConfig().set("onlyscan-enabled", (Object)true);
                this.configManager.loadConfigValues();
                this.plugin.saveConfig();
                player.sendMessage("\u00a7aAdded " + material.name() + " to onlyscan list and enabled onlyscan mode.");
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info(player.getName() + " added " + material.name() + " to onlyscan list.");
                }
            } else if (action.equalsIgnoreCase("remove")) {
                if (!this.configManager.getOnlyScanItems().contains(material)) {
                    player.sendMessage("\u00a7cMaterial " + materialName + " is not in onlyscan list!");
                    return true;
                }
                this.configManager.getOnlyScanItems().remove(material);
                onlyScanList.remove(material.name());
                this.plugin.getConfig().set("onlyscan", (Object)onlyScanList);
                if (onlyScanList.isEmpty()) {
                    this.plugin.getConfig().set("onlyscan-enabled", (Object)false);
                    this.configManager.loadConfigValues();
                }
                this.plugin.saveConfig();
                player.sendMessage("\u00a7aRemoved " + material.name() + " from onlyscan list." + (onlyScanList.isEmpty() ? " onlyscan mode disabled." : ""));
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info(player.getName() + " removed " + material.name() + " from onlyscan list.");
                }
            } else {
                player.sendMessage("\u00a7cUsage: /antidupe onlyscan <add|remove> <material>");
            }
        }
        catch (IllegalArgumentException e) {
            player.sendMessage("\u00a7cInvalid material: " + materialName);
        }
        return true;
    }

    private boolean reloadConfigFiles(Player player) {
        try {
            this.plugin.reloadConfig();
            this.configManager.loadConfigValues();
            this.configManager.setupBansFile();
            this.configManager.flushPendingDupeLogs();
            this.configManager.setupDupeLogFile();
            this.itemHashManager.initializeCustomStackSizes();
            player.sendMessage("\u00a7aSuccessfully reloaded configuration files.");
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info(player.getName() + " reloaded configuration files.");
            }
        }
        catch (Exception e) {
            player.sendMessage("\u00a7cError reloading configuration files: " + e.getMessage());
            this.plugin.getLogger().log(Level.SEVERE, "Error reloading configuration files", e);
        }
        return true;
    }
}

