/*
 * Decompiled with CFR 0.152.
 */
package org.crazyhouse.blocksigningplugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private final Set<Material> blacklistedItems = EnumSet.noneOf(Material.class);
    private final Set<Material> excludedFromDupeScans = EnumSet.noneOf(Material.class);
    private final Set<Material> onlyScanItems = EnumSet.noneOf(Material.class);
    private final Set<UUID> whitelist = new HashSet<UUID>();
    private long scanIntervalTicks;
    private long crossScanIntervalTicks;
    private long unhashedCheckIntervalTicks;
    private boolean autoBanEnabled;
    private boolean debugEnabled;
    private boolean onlyScanEnabled;
    private boolean publicDupeMessages;
    private File bansFile;
    private File dupeLogFile;
    private YamlConfiguration bansConfig;
    private YamlConfiguration dupeLogConfig;
    private final List<Map<String, Object>> pendingDupeLogs = Collections.synchronizedList(new ArrayList());
    private static final String CONFIG_VERSION = "2.2";

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void saveDefaultConfig() {
        YamlConfiguration config;
        YamlConfiguration existingConfig;
        String existingVersion;
        File configFile;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if ((configFile = new File(this.plugin.getDataFolder(), "config.yml")).exists() && !CONFIG_VERSION.equals(existingVersion = (existingConfig = YamlConfiguration.loadConfiguration((File)configFile)).getString("config-version", "0.0"))) {
            this.plugin.getLogger().warning("Outdated config.yml version (" + existingVersion + ") detected. Replacing with version 2.2");
            if (configFile.delete()) {
                this.plugin.getLogger().info("Deleted outdated config.yml");
            } else {
                this.plugin.getLogger().severe("Failed to delete outdated config.yml");
            }
        }
        if (!configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
            this.plugin.getLogger().info("Created new config.yml with version 2.2");
        }
        if (!(config = YamlConfiguration.loadConfiguration((File)configFile)).isSet("onlyscan-enabled")) {
            config.set("onlyscan-enabled", (Object)false);
            config.set("onlyscan", Arrays.asList("DIAMOND", "NETHERITE_INGOT"));
        }
        if (!config.isSet("public-dupe-messages")) {
            config.set("public-dupe-messages", (Object)true);
        }
        try {
            config.save(configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save updated config.yml", e);
        }
    }

    public void loadConfigValues() {
        this.blacklistedItems.clear();
        for (String item : this.plugin.getConfig().getStringList("blacklisted-items")) {
            try {
                this.blacklistedItems.add(Material.valueOf((String)item.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material in blacklisted-items: " + item);
            }
        }
        this.excludedFromDupeScans.clear();
        for (String item : this.plugin.getConfig().getStringList("excluded-from-dupe-scans")) {
            try {
                this.excludedFromDupeScans.add(Material.valueOf((String)item.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material in excluded-from-dupe-scans: " + item);
            }
        }
        this.onlyScanItems.clear();
        for (String item : this.plugin.getConfig().getStringList("onlyscan")) {
            try {
                this.onlyScanItems.add(Material.valueOf((String)item.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material in onlyscan: " + item);
            }
        }
        this.whitelist.clear();
        for (String uuid : this.plugin.getConfig().getStringList("whitelist")) {
            try {
                this.whitelist.add(UUID.fromString(uuid));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID in whitelist: " + uuid);
            }
        }
        this.scanIntervalTicks = (long)this.plugin.getConfig().getInt("scan-interval-seconds", 5) * 20L;
        this.crossScanIntervalTicks = (long)this.plugin.getConfig().getInt("cross-inventory-scan-interval-seconds", 30) * 20L;
        this.unhashedCheckIntervalTicks = (long)this.plugin.getConfig().getInt("unhashed-check-interval-seconds", 1) * 20L;
        this.autoBanEnabled = this.plugin.getConfig().getBoolean("auto-ban-enabled", false);
        this.debugEnabled = this.plugin.getConfig().getBoolean("debug", false);
        this.onlyScanEnabled = this.plugin.getConfig().getBoolean("onlyscan-enabled", false);
        this.publicDupeMessages = this.plugin.getConfig().getBoolean("public-dupe-messages", true);
    }

    public void setupBansFile() {
        this.bansFile = new File(this.plugin.getDataFolder(), "bans.yml");
        if (!this.bansFile.exists()) {
            try {
                this.bansFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create bans.yml", e);
            }
        }
        this.bansConfig = YamlConfiguration.loadConfiguration((File)this.bansFile);
    }

    public void setupDupeLogFile() {
        this.dupeLogFile = new File(this.plugin.getDataFolder(), "dupe_log.yml");
        if (!this.dupeLogFile.exists()) {
            try {
                this.dupeLogFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create dupe_log.yml", e);
            }
        }
        this.dupeLogConfig = YamlConfiguration.loadConfiguration((File)this.dupeLogFile);
    }

    public void saveBansFile() {
        Runnable saveTask = () -> {
            try {
                this.bansConfig.save(this.bansFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save bans.yml", e);
            }
        };
        if (!this.plugin.isEnabled()) {
            saveTask.run();
        } else {
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, saveTask);
        }
    }

    public void saveDupeLogFile(boolean synchronous) {
        Runnable saveTask = () -> {
            try {
                this.dupeLogConfig.save(this.dupeLogFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save dupe_log.yml", e);
            }
        };
        if (synchronous) {
            saveTask.run();
        } else {
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, saveTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPendingDupeLogs() {
        List<Map<String, Object>> list = this.pendingDupeLogs;
        synchronized (list) {
            if (this.pendingDupeLogs.isEmpty()) {
                return;
            }
            for (Map<String, Object> log : this.pendingDupeLogs) {
                String timestamp = (String)log.get("timestamp");
                String path = "detections." + timestamp;
                this.dupeLogConfig.set(path + ".player", log.get("player"));
                this.dupeLogConfig.set(path + ".item", log.get("item"));
                this.dupeLogConfig.set(path + ".amount", log.get("amount"));
                this.dupeLogConfig.set(path + ".hash", log.get("hash"));
            }
            this.pendingDupeLogs.clear();
            this.saveDupeLogFile(!this.plugin.isEnabled());
        }
    }

    public Set<Material> getBlacklistedItems() {
        return this.blacklistedItems;
    }

    public Set<Material> getExcludedFromDupeScans() {
        return this.excludedFromDupeScans;
    }

    public Set<Material> getOnlyScanItems() {
        return this.onlyScanItems;
    }

    public Set<UUID> getWhitelist() {
        return this.whitelist;
    }

    public long getScanIntervalTicks() {
        return this.scanIntervalTicks;
    }

    public long getCrossScanIntervalTicks() {
        return this.crossScanIntervalTicks;
    }

    public long getUnhashedCheckIntervalTicks() {
        return this.unhashedCheckIntervalTicks;
    }

    public boolean isAutoBanEnabled() {
        return this.autoBanEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isOnlyScanEnabled() {
        return this.onlyScanEnabled;
    }

    public boolean isPublicDupeMessages() {
        return this.publicDupeMessages;
    }

    public YamlConfiguration getBansConfig() {
        return this.bansConfig;
    }

    public List<Map<String, Object>> getPendingDupeLogs() {
        return this.pendingDupeLogs;
    }
}

