/*
 * Decompiled with CFR 0.152.
 */
package org.crazyhouse.blocksigningplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.block.Barrel;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.crazyhouse.blocksigningplugin.BlockSigningPlugin;
import org.crazyhouse.blocksigningplugin.ConfigManager;
import org.crazyhouse.blocksigningplugin.ItemHashManager;

public class InventoryMonitor {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final ItemHashManager itemHashManager;

    public InventoryMonitor(BlockSigningPlugin plugin, ConfigManager configManager, ItemHashManager itemHashManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.itemHashManager = itemHashManager;
    }

    public void checkForUnhashedItems() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.configManager.getWhitelist().contains(player.getUniqueId())) continue;
            this.applyMD5sToInventory(player, (Inventory)player.getInventory());
            this.applyMD5sToInventory(player, player.getEnderChest());
            for (Player other : Bukkit.getOnlinePlayers()) {
                if (other.equals((Object)player)) continue;
                this.applyMD5sToInventory(player, (Inventory)other.getInventory());
                this.applyMD5sToInventory(player, other.getEnderChest());
            }
        }
    }

    private void applyMD5sToInventory(Player player, Inventory inventory) {
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType().isAir() || this.configManager.getBlacklistedItems().contains(item.getType())) continue;
            String existingHash = this.itemHashManager.getMD5(item);
            if (existingHash == null) {
                this.itemHashManager.assignMD5ToItem(player, item);
            } else if (!this.itemHashManager.verifyItemHash(item, existingHash)) {
                // empty if block
            }
            Object object = item.getItemMeta();
            if (object instanceof BundleMeta) {
                BundleMeta bundleMeta = (BundleMeta)object;
                object = bundleMeta.getItems().iterator();
                while (object.hasNext()) {
                    ItemStack bundleItem = (ItemStack)object.next();
                    if (bundleItem == null || this.configManager.getBlacklistedItems().contains(bundleItem.getType())) continue;
                    this.itemHashManager.assignMD5ToItem(player, bundleItem);
                }
            }
            if (!((object = item.getItemMeta()) instanceof BlockStateMeta)) continue;
            BlockStateMeta blockMeta = (BlockStateMeta)object;
            BlockState state = blockMeta.getBlockState();
            Inventory containerInventory = null;
            if (state instanceof Chest) {
                Chest chest = (Chest)state;
                containerInventory = chest.getBlockInventory();
            } else if (state instanceof ShulkerBox) {
                ShulkerBox shulker = (ShulkerBox)state;
                containerInventory = shulker.getInventory();
            } else if (state instanceof Barrel) {
                Barrel barrel = (Barrel)state;
                containerInventory = barrel.getInventory();
            }
            if (containerInventory == null) continue;
            this.applyMD5sToInventory(player, containerInventory);
        }
    }

    public void scanForDuplicates() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy - h:mma");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.configManager.getWhitelist().contains(player.getUniqueId())) continue;
            HashMap<String, Integer> hashCountMap = new HashMap<String, Integer>();
            HashSet<ItemStack> toRemove = new HashSet<ItemStack>();
            ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
            allItems.addAll(Arrays.asList(player.getInventory().getContents()));
            allItems.addAll(Arrays.asList(player.getEnderChest().getContents()));
            for (ItemStack item : allItems) {
                ItemMeta itemMeta;
                if (item == null || item.getType().isAir() || this.configManager.getBlacklistedItems().contains(item.getType()) || this.configManager.isOnlyScanEnabled() && !this.configManager.getOnlyScanItems().contains(item.getType()) || !this.configManager.isOnlyScanEnabled() && this.configManager.getExcludedFromDupeScans().contains(item.getType()) || (itemMeta = item.getItemMeta()) == null || !itemMeta.getPersistentDataContainer().has(this.itemHashManager.getKey(), PersistentDataType.STRING)) continue;
                String hash = (String)itemMeta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING);
                int maxAllowed = this.itemHashManager.getMaxStackSize(item);
                hashCountMap.merge(hash, item.getAmount(), Integer::sum);
                if ((Integer)hashCountMap.get(hash) <= maxAllowed) continue;
                toRemove.add(item);
            }
            for (ItemStack item : toRemove) {
                String hash = (String)item.getItemMeta().getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING);
                String formattedTimestamp = dateFormat.format(new Date(System.currentTimeMillis()));
                player.getInventory().remove(item);
                player.getEnderChest().remove(item);
                player.sendTitle("\u00a74 NO DUPING! ", "", 60, 70, 20);
                player.sendMessage("Duplicate item removed: " + hash);
                if (this.configManager.isPublicDupeMessages()) {
                    Bukkit.broadcastMessage((String)("\u00a7c[AntiDupe] " + player.getName() + " caught duping " + item.getType().name() + " (Amount: " + item.getAmount() + ", Hash: " + hash + ", Time: " + formattedTimestamp + ")"));
                }
                this.plugin.getLogger().info("Duplicate item removed for " + player.getName() + ": " + String.valueOf(item) + " " + hash);
                this.logDupeDetection(player, item, hash);
                this.banPlayer(player, "Item duplication detected (Hash: " + hash + ")");
            }
        }
    }

    public void scanForCrossInventoryDuplicates() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy - h:mma");
        HashMap<String, Set<Player>> hashToPlayers = new HashMap<String, Set<Player>>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.configManager.getWhitelist().contains(player.getUniqueId())) continue;
            this.collectHashes(player, player.getInventory().getContents(), hashToPlayers, player);
            this.collectHashes(player, player.getEnderChest().getContents(), hashToPlayers, player);
        }
        for (Map.Entry entry : hashToPlayers.entrySet()) {
            String hash = (String)entry.getKey();
            Set players = (Set)entry.getValue();
            if (players.size() <= 1) continue;
            String formattedTimestamp = dateFormat.format(new Date(System.currentTimeMillis()));
            for (Player player : players) {
                this.removeDuplicateFromInventory(player, hash, formattedTimestamp);
            }
        }
    }

    private void collectHashes(Player player, ItemStack[] items, Map<String, Set<Player>> hashToPlayers, Player owner) {
        if (items == null) {
            return;
        }
        for (ItemStack item : items) {
            String hash;
            ItemMeta meta;
            if (item == null || item.getType().isAir() || this.configManager.getBlacklistedItems().contains(item.getType()) || this.configManager.isOnlyScanEnabled() && !this.configManager.getOnlyScanItems().contains(item.getType()) || !this.configManager.isOnlyScanEnabled() && this.configManager.getExcludedFromDupeScans().contains(item.getType()) || (meta = item.getItemMeta()) == null || (hash = (String)meta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING)) == null) continue;
            hashToPlayers.computeIfAbsent(hash, k -> new HashSet()).add(owner);
        }
    }

    private void removeDuplicateFromInventory(Player player, String hash, String timestamp) {
        ItemMeta meta;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType().isAir() || (meta = item.getItemMeta()) == null || !hash.equals(meta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING))) continue;
            player.getInventory().remove(item);
            player.sendTitle("\u00a74 NO DUPING!", "", 60, 70, 20);
            player.sendMessage("Cross-inventory duplicate removed: " + hash);
        }
        for (ItemStack item : player.getEnderChest().getContents()) {
            if (item == null || item.getType().isAir() || (meta = item.getItemMeta()) == null || !hash.equals(meta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING))) continue;
            player.getEnderChest().remove(item);
            player.sendTitle("\u00a74 NO DUPING!", "", 60, 70, 20);
            player.sendMessage("Cross-inventory duplicate removed: " + hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDupeDetection(Player player, ItemStack item, String hash) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy - h:mma");
        String timestamp = dateFormat.format(new Date(System.currentTimeMillis()));
        HashMap<String, Object> log = new HashMap<String, Object>();
        log.put("timestamp", timestamp);
        log.put("player", player.getName());
        log.put("item", item.getType().name());
        log.put("amount", item.getAmount());
        log.put("hash", hash);
        List<Map<String, Object>> list = this.configManager.getPendingDupeLogs();
        synchronized (list) {
            this.configManager.getPendingDupeLogs().add(log);
        }
    }

    private void banPlayer(Player player, String reason) {
        if (this.configManager.isAutoBanEnabled()) {
            UUID playerUUID = player.getUniqueId();
            this.configManager.getBansConfig().set(String.valueOf(playerUUID) + ".name", (Object)player.getName());
            this.configManager.getBansConfig().set(String.valueOf(playerUUID) + ".reason", (Object)reason);
            this.configManager.getBansConfig().set(String.valueOf(playerUUID) + ".timestamp", (Object)System.currentTimeMillis());
            this.configManager.saveBansFile();
            Bukkit.getServer().getBanList(BanList.Type.NAME).addBan(player.getName(), reason, null, "BlockSigningPlugin");
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer("\u00a7cYou have been banned for: " + reason));
        }
    }
}

