/*
 * Decompiled with CFR 0.152.
 */
package org.crazyhouse.blocksigningplugin;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ADStats {
    private final JavaPlugin plugin;
    private static final String SERVER_URL = "http://anarchy.icu:5000/log";
    private boolean posted = false;
    private int attempts = 0;
    private static final int MAX_ATTEMPTS = 5;

    public ADStats(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void sendStats() {
        if (this.posted || this.attempts >= 5) {
            if (this.attempts >= 5) {
                // empty if block
            }
            return;
        }
        ++this.attempts;
        try {
            String serverName = this.plugin.getServer().getName();
            String ip = this.plugin.getServer().getIp();
            if (ip == null || ip.isEmpty()) {
                ip = "127.0.0.1";
            }
            int port = this.plugin.getServer().getPort();
            String mcVersion = this.plugin.getServer().getVersion();
            String javaVersion = System.getProperty("java.version");
            int ping = -1;
            if (!this.plugin.getServer().getOnlinePlayers().isEmpty()) {
                ping = ((Player)this.plugin.getServer().getOnlinePlayers().iterator().next()).getPing();
            }
            String logLine = String.format("ADSTATS - Plugin: Anti-Dupe | Server: %s | IP: %s:%d | Minecraft: %s | Java: %s | Ping: %d ms", serverName, ip, port, mcVersion, javaVersion, ping);
            String payload = "{\"log_line\": \"" + logLine + "\"}";
            URL url = new URL(SERVER_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                this.plugin.getLogger().info("Stats posted successfully");
                this.posted = true;
            } else {
                this.plugin.getLogger().warning("Failed to post stats, response: " + responseCode + " (Attempt " + this.attempts + ")");
            }
            conn.disconnect();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error posting stats: " + e.getMessage() + " (Attempt " + this.attempts + ")");
        }
    }
}

