/*
 * Decompiled with CFR 0.152.
 */
package org.crazyhouse.blocksigningplugin;

import java.lang.invoke.LambdaMetafactory;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.crazyhouse.blocksigningplugin.ConfigManager;
import org.crazyhouse.blocksigningplugin.InventoryMonitor;
import org.crazyhouse.blocksigningplugin.ItemHashManager;

public class EventListener
implements Listener {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final ItemHashManager itemHashManager;
    private final InventoryMonitor inventoryMonitor;

    public EventListener(JavaPlugin plugin, ConfigManager configManager, ItemHashManager itemHashManager, InventoryMonitor inventoryMonitor) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.itemHashManager = itemHashManager;
        this.inventoryMonitor = inventoryMonitor;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.configManager.getWhitelist().contains(player.getUniqueId())) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        for (ItemStack item : inventory.getContents()) {
            this.itemHashManager.assignMD5ToItem(player, item);
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        player = event.getPlayer();
        if (this.configManager.getWhitelist().contains(player.getUniqueId())) {
            return;
        }
        pickedItem = event.getItem().getItemStack();
        inventory = player.getInventory();
        if (pickedItem == null || pickedItem.getType().isAir() || this.configManager.getBlacklistedItems().contains(pickedItem.getType())) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Skipping pickup for " + player.getName() + ": Item is null, air, or blacklisted");
            }
            return;
        }
        if (this.configManager.isOnlyScanEnabled() && !this.configManager.getOnlyScanItems().contains(pickedItem.getType())) {
            this.itemHashManager.assignMD5ToItem(player, pickedItem);
            return;
        }
        maxStackSize = this.itemHashManager.getMaxStackSize(pickedItem);
        for (ItemStack existingItem : inventory.getContents()) {
            block8: {
                if (existingItem == null || existingItem.getType() != pickedItem.getType() || this.configManager.getBlacklistedItems().contains(existingItem.getType()) || (existingMeta = existingItem.getItemMeta()) == null || !existingMeta.getPersistentDataContainer().has(this.itemHashManager.getKey(), PersistentDataType.STRING)) continue;
                canCombine = true;
                if (pickedItem.getType() != Material.TIPPED_ARROW) break block8;
                pickedMeta = pickedItem.getItemMeta();
                if (!(existingMeta instanceof PotionMeta)) ** GOTO lbl-1000
                existingPotionMeta = (PotionMeta)existingMeta;
                if (pickedMeta instanceof PotionMeta) {
                    pickedPotionMeta = (PotionMeta)pickedMeta;
                    canCombine = existingPotionMeta.getBasePotionData().equals((Object)pickedPotionMeta.getBasePotionData());
                } else lbl-1000:
                // 2 sources

                {
                    canCombine = false;
                }
            }
            if (!canCombine || (totalAmount = existingItem.getAmount() + pickedItem.getAmount()) > maxStackSize) continue;
            oldHash = (String)existingMeta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING);
            this.itemHashManager.getGlobalMD5Map().remove(oldHash);
            newHash = this.itemHashManager.calculateHash(player.getName(), existingItem.getType().name(), System.currentTimeMillis(), totalAmount);
            existingMeta.getPersistentDataContainer().set(this.itemHashManager.getKey(), PersistentDataType.STRING, (Object)newHash);
            existingItem.setItemMeta(existingMeta);
            existingItem.setAmount(totalAmount);
            this.itemHashManager.getGlobalMD5Map().put(newHash, player.getUniqueId());
            event.getItem().remove();
            event.setCancelled(true);
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Stacked picked-up item " + pickedItem.getType().name() + " for " + player.getName() + ", new hash: " + newHash);
            }
            return;
        }
        this.itemHashManager.assignMD5ToItem(player, pickedItem);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onPlayerPickupItem$0(org.bukkit.inventory.PlayerInventory org.bukkit.inventory.ItemStack int org.bukkit.entity.Player ), ()V)((EventListener)this, (PlayerInventory)inventory, (ItemStack)pickedItem, (int)maxStackSize, (Player)player));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.configManager.getWhitelist().contains(player.getUniqueId())) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        ItemStack cursorItem = event.getCursor();
        if (event.getSlot() < 0) {
            event.setCancelled(true);
            return;
        }
        if (clickedItem != null && !clickedItem.getType().isAir() && !this.configManager.getBlacklistedItems().contains(clickedItem.getType())) {
            this.itemHashManager.assignMD5ToItem(player, clickedItem);
        }
        if (cursorItem != null && !cursorItem.getType().isAir() && !this.configManager.getBlacklistedItems().contains(cursorItem.getType())) {
            this.itemHashManager.assignMD5ToItem(player, cursorItem);
        }
        if (clickedItem == null) return;
        if (cursorItem == null) return;
        if (clickedItem.getType().isAir()) return;
        if (cursorItem.getType() != clickedItem.getType()) return;
        if (this.configManager.getBlacklistedItems().contains(clickedItem.getType())) return;
        if (this.configManager.isOnlyScanEnabled() && !this.configManager.getOnlyScanItems().contains(clickedItem.getType())) {
            this.itemHashManager.assignMD5ToItem(player, cursorItem);
            return;
        }
        boolean canCombine = true;
        if (clickedItem.getType() == Material.TIPPED_ARROW) {
            ItemMeta clickedMeta = clickedItem.getItemMeta();
            ItemMeta cursorMeta = cursorItem.getItemMeta();
            if (!(clickedMeta instanceof PotionMeta)) return;
            PotionMeta clickedPotionMeta = (PotionMeta)clickedMeta;
            if (!(cursorMeta instanceof PotionMeta)) return;
            PotionMeta cursorPotionMeta = (PotionMeta)cursorMeta;
            canCombine = clickedPotionMeta.getBasePotionData().equals((Object)cursorPotionMeta.getBasePotionData());
        }
        if (!canCombine) {
            return;
        }
        int maxStackSize = this.itemHashManager.getMaxStackSize(clickedItem);
        int totalAmount = clickedItem.getAmount() + cursorItem.getAmount();
        if (totalAmount > maxStackSize) return;
        ItemMeta clickedMeta = clickedItem.getItemMeta();
        if (clickedMeta == null) return;
        if (!clickedMeta.getPersistentDataContainer().has(this.itemHashManager.getKey(), PersistentDataType.STRING)) return;
        String oldHash = (String)clickedMeta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING);
        this.itemHashManager.getGlobalMD5Map().remove(oldHash);
        String newHash = this.itemHashManager.calculateHash(player.getName(), clickedItem.getType().name(), System.currentTimeMillis(), totalAmount);
        clickedMeta.getPersistentDataContainer().set(this.itemHashManager.getKey(), PersistentDataType.STRING, (Object)newHash);
        clickedItem.setItemMeta(clickedMeta);
        clickedItem.setAmount(totalAmount);
        this.itemHashManager.getGlobalMD5Map().put(newHash, player.getUniqueId());
        event.setCursor(null);
        if (!this.configManager.isDebugEnabled()) return;
        this.plugin.getLogger().info("Stacked items for " + player.getName() + ", new hash: " + newHash);
    }

    private /* synthetic */ void lambda$onPlayerPickupItem$0(PlayerInventory inventory, ItemStack pickedItem, int maxStackSize, Player player) {
        for (ItemStack item : inventory.getContents()) {
            if (item == null || item.getType() != pickedItem.getType() || item.getAmount() <= maxStackSize) continue;
            item.setAmount(maxStackSize);
            if (!this.configManager.isDebugEnabled()) continue;
            this.plugin.getLogger().info("Corrected stack size for " + item.getType().name() + " to " + maxStackSize + " for " + player.getName());
        }
    }
}

