/*
 * Decompiled with CFR 0.152.
 */
package org.crazyhouse.blocksigningplugin;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.block.Barrel;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.crazyhouse.blocksigningplugin.ConfigManager;
import org.crazyhouse.blocksigningplugin.ItemHashManager;

public class ExternalInventoryHashAssigner
implements Listener {
    private final JavaPlugin plugin;
    private final ItemHashManager itemHashManager;
    private final ConfigManager configManager;
    private final Set<UUID> recentShopkeeperTraders = new HashSet<UUID>();

    public ExternalInventoryHashAssigner(JavaPlugin plugin, ConfigManager configManager, ItemHashManager itemHashManager) {
        this.plugin = plugin;
        this.itemHashManager = itemHashManager;
        this.configManager = configManager;
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory openedInventory = event.getInventory();
        this.scanInventoryForPlayer(player, (Inventory)player.getInventory());
        this.scanInventoryForPlayer(player, player.getEnderChest());
        this.scanInventoryForPlayer(player, openedInventory);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.isProtectedMenu(event.getView()) && event.getCursor() != null && !event.getCursor().getType().isAir()) {
            ItemStack takenItem = event.getCursor().clone();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.scanForProtectedItem(player, takenItem), 1L);
        }
        if (event.getView().getType().name().equals("MERCHANT")) {
            UUID playerUUID = player.getUniqueId();
            this.recentShopkeeperTraders.add(playerUUID);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.scanAndFixShopkeeperItems(player);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.recentShopkeeperTraders.remove(playerUUID), 100L);
            }, 3L);
        }
    }

    private boolean isProtectedMenu(InventoryView view) {
        String title = view.getTitle();
        int size = view.getTopInventory().getSize();
        return title != null && (title.contains("Economy Shops") || title.equals("Shop Menu") || size == 27 && title.startsWith("Shop:"));
    }

    private void scanForProtectedItem(Player player, ItemStack protectedItem) {
        if (protectedItem == null || protectedItem.getType().isAir()) {
            return;
        }
        this.scanSpecificItemInInventory(player, (Inventory)player.getInventory(), protectedItem);
        this.scanSpecificItemInInventory(player, player.getEnderChest(), protectedItem);
    }

    private void scanSpecificItemInInventory(Player player, Inventory inventory, ItemStack protectedItem) {
        if (inventory == null) {
            return;
        }
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !this.itemsMatch(item, protectedItem)) continue;
            this.handleProtectedItemDupe(player, item);
        }
    }

    private boolean itemsMatch(ItemStack item1, ItemStack item2) {
        if (item1.getType() != item2.getType() || item1.getAmount() != item2.getAmount()) {
            return false;
        }
        ItemMeta meta1 = item1.getItemMeta();
        ItemMeta meta2 = item2.getItemMeta();
        if (meta1 == null || meta2 == null) {
            return meta1 == meta2;
        }
        String serialized1 = item1.serialize().toString().replace(this.itemHashManager.getKey().getKey(), "");
        String serialized2 = item2.serialize().toString().replace(this.itemHashManager.getKey().getKey(), "");
        return serialized1.equals(serialized2);
    }

    private void handleProtectedItemDupe(Player player, ItemStack item) {
        String existingHash = this.itemHashManager.getMD5(item);
        this.plugin.getLogger().warning("[AntiDupe] Player " + player.getName() + " duped protected menu item: " + String.valueOf(item.getType()) + " (Hash: " + existingHash + ")");
        player.getInventory().remove(item);
        player.getEnderChest().remove(item);
        player.sendTitle("\u00a74 NO DUPING PROTECTED ITEMS!", "", 60, 70, 20);
        player.sendMessage("Protected menu item removed from inventory.");
        if (this.configManager.isPublicDupeMessages()) {
            Bukkit.broadcastMessage((String)("\u00a7c[AntiDupe] " + player.getName() + " attempted to dupe a protected shop item: " + item.getType().name()));
        }
        this.logDupeDetection(player, item, existingHash + " (Protected)");
        if (this.configManager.isAutoBanEnabled()) {
            this.banPlayer(player, "Duplication of protected menu item detected");
        }
    }

    @EventHandler
    public void onTradeSelect(TradeSelectEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID playerUUID = player.getUniqueId();
        this.recentShopkeeperTraders.add(playerUUID);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.scanAndFixShopkeeperItems(player);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.recentShopkeeperTraders.remove(playerUUID), 100L);
        }, 3L);
    }

    private void scanAndFixShopkeeperItems(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!this.recentShopkeeperTraders.contains(playerUUID)) {
            return;
        }
        boolean fixed = this.scanSpecificItemInInventoryForFix(player, (Inventory)player.getInventory());
        this.scanSpecificItemInInventoryForFix(player, player.getEnderChest());
        if (fixed) {
            this.plugin.getLogger().info("[AntiDupe] Fixed SHOPKEEPER hash(es) for player " + player.getName() + " after Shopkeeper trade.");
        }
    }

    private boolean scanSpecificItemInInventoryForFix(Player player, Inventory inventory) {
        if (inventory == null) {
            return false;
        }
        boolean fixedAny = false;
        for (int i = 0; i < inventory.getSize(); ++i) {
            String hash;
            ItemMeta meta;
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType().isAir() || this.configManager.getBlacklistedItems().contains(item.getType()) || (meta = item.getItemMeta()) == null || !"SHOPKEEPER".equals(hash = (String)meta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING))) continue;
            String oldHash = this.itemHashManager.getMD5(item);
            meta.getPersistentDataContainer().remove(this.itemHashManager.getKey());
            item.setItemMeta(meta);
            this.itemHashManager.assignMD5ToItem(player, item);
            inventory.setItem(i, item);
            fixedAny = true;
            this.plugin.getLogger().info("[AntiDupe] Fixed SHOPKEEPER hash for player " + player.getName() + " on item: " + String.valueOf(item.getType()) + " (old: " + oldHash + ")");
        }
        return fixedAny;
    }

    public void scanInventoryForPlayer(Player player, Inventory inventory) {
        if (inventory == null) {
            return;
        }
        for (ItemStack item : inventory.getContents()) {
            this.recursivelyApplyMD5(player, item);
        }
    }

    private void recursivelyApplyMD5(Player player, ItemStack item) {
        if (item == null || item.getType().isAir() || this.configManager.getBlacklistedItems().contains(item.getType())) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String existingHash = this.itemHashManager.getMD5(item);
        if (existingHash == null) {
            this.itemHashManager.assignMD5ToItem(player, item);
        } else if (!this.itemHashManager.verifyItemHash(item, existingHash)) {
            this.handleDuplication(player, item, existingHash);
        }
        if (meta instanceof BundleMeta) {
            BundleMeta bundleMeta = (BundleMeta)meta;
            for (ItemStack bundleItem : bundleMeta.getItems()) {
                this.recursivelyApplyMD5(player, bundleItem);
            }
        }
        if (meta instanceof BlockStateMeta) {
            BlockStateMeta blockMeta = (BlockStateMeta)meta;
            BlockState state = blockMeta.getBlockState();
            Inventory containerInventory = null;
            if (state instanceof Chest) {
                Chest chest = (Chest)state;
                containerInventory = chest.getBlockInventory();
            } else if (state instanceof ShulkerBox) {
                ShulkerBox shulker = (ShulkerBox)state;
                containerInventory = shulker.getInventory();
            } else if (state instanceof Barrel) {
                Barrel barrel = (Barrel)state;
                containerInventory = barrel.getInventory();
            }
            if (containerInventory != null) {
                for (ItemStack containerItem : containerInventory.getContents()) {
                    this.recursivelyApplyMD5(player, containerItem);
                }
            }
        }
    }

    public void scanForCrossInventoryDuplicates() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy - h:mma");
        HashMap<String, Set<Player>> hashToPlayers = new HashMap<String, Set<Player>>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.configManager.getWhitelist().contains(player.getUniqueId())) continue;
            this.collectHashes(player, player.getInventory().getContents(), hashToPlayers, player);
            this.collectHashes(player, player.getEnderChest().getContents(), hashToPlayers, player);
        }
        for (Map.Entry entry : hashToPlayers.entrySet()) {
            String hash = (String)entry.getKey();
            Set players = (Set)entry.getValue();
            if (players.size() <= 1) continue;
            String formattedTimestamp = dateFormat.format(new Date(System.currentTimeMillis()));
            for (Player player : players) {
                this.removeDuplicateItems(player, hash, formattedTimestamp);
            }
        }
    }

    private void removeDuplicateItems(Player player, String hash, String timestamp) {
        List<Inventory> inventories = Arrays.asList(player.getInventory(), player.getEnderChest());
        for (Inventory inv : inventories) {
            for (ItemStack item : inv.getContents()) {
                String itemHash;
                ItemMeta meta;
                if (item == null || item.getType().isAir() || (meta = item.getItemMeta()) == null || !hash.equals(itemHash = (String)meta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING))) continue;
                inv.remove(item);
                player.sendTitle("\u00a74 NO DUPING!", "", 60, 70, 20);
                player.sendMessage("Cross-inventory duplicate removed: " + hash);
                if (this.configManager.isPublicDupeMessages()) {
                    Bukkit.broadcastMessage((String)("\u00a7c[AntiDupe] " + player.getName() + " caught duping " + item.getType().name() + " (Amount: " + item.getAmount() + ", Hash: " + hash + ", Time: " + timestamp + ")"));
                }
                this.logDupeDetection(player, item, hash);
                if (!this.configManager.isAutoBanEnabled()) continue;
                this.banPlayer(player, "Cross-inventory item duplication detected (Hash: " + hash + ")");
            }
        }
    }

    private void collectHashes(Player player, ItemStack[] items, Map<String, Set<Player>> hashToPlayers, Player owner) {
        if (items == null) {
            return;
        }
        for (ItemStack item : items) {
            ItemMeta meta;
            if (item == null || item.getType().isAir() || this.configManager.getBlacklistedItems().contains(item.getType()) || (meta = item.getItemMeta()) == null) continue;
            String hash = (String)meta.getPersistentDataContainer().get(this.itemHashManager.getKey(), PersistentDataType.STRING);
            if (hash != null) {
                hashToPlayers.computeIfAbsent(hash, k -> new HashSet()).add(owner);
            }
            if (meta instanceof BundleMeta) {
                BundleMeta bundleMeta = (BundleMeta)meta;
                this.collectHashes(player, bundleMeta.getItems().toArray(new ItemStack[0]), hashToPlayers, owner);
            }
            if (!(meta instanceof BlockStateMeta)) continue;
            BlockStateMeta blockMeta = (BlockStateMeta)meta;
            BlockState state = blockMeta.getBlockState();
            Inventory containerInventory = null;
            if (state instanceof Chest) {
                Chest chest = (Chest)state;
                containerInventory = chest.getBlockInventory();
            } else if (state instanceof ShulkerBox) {
                ShulkerBox shulker = (ShulkerBox)state;
                containerInventory = shulker.getInventory();
            } else if (state instanceof Barrel) {
                Barrel barrel = (Barrel)state;
                containerInventory = barrel.getInventory();
            }
            if (containerInventory == null) continue;
            this.collectHashes(player, containerInventory.getContents(), hashToPlayers, owner);
        }
    }

    private void handleDuplication(Player player, ItemStack item, String expectedHash) {
        this.plugin.getLogger().warning("[AntiDupe] Player " + player.getName() + " has a mismatched item: " + String.valueOf(item.getType()) + " (expected MD5: " + expectedHash + ")");
        player.getInventory().remove(item);
        player.getEnderChest().remove(item);
        player.sendTitle("\u00a74 NO DUPING!", "", 60, 70, 20);
        player.sendMessage("Suspicious item removed: " + expectedHash);
        if (this.configManager.isPublicDupeMessages()) {
            Bukkit.broadcastMessage((String)("\u00a7c[AntiDupe] " + player.getName() + " had a suspicious " + item.getType().name()));
        }
        this.logDupeDetection(player, item, expectedHash);
        if (this.configManager.isAutoBanEnabled()) {
            this.banPlayer(player, "Suspicious item detected (Hash: " + expectedHash + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDupeDetection(Player player, ItemStack item, String hash) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy - h:mma");
        String timestamp = dateFormat.format(new Date(System.currentTimeMillis()));
        HashMap<String, Object> log = new HashMap<String, Object>();
        log.put("timestamp", timestamp);
        log.put("player", player.getName());
        log.put("item", item.getType().name());
        log.put("amount", item.getAmount());
        log.put("hash", hash);
        List<Map<String, Object>> list = this.configManager.getPendingDupeLogs();
        synchronized (list) {
            this.configManager.getPendingDupeLogs().add(log);
        }
    }

    private void banPlayer(Player player, String reason) {
        if (this.configManager.isAutoBanEnabled()) {
            UUID playerUUID = player.getUniqueId();
            this.configManager.getBansConfig().set(String.valueOf(playerUUID) + ".name", (Object)player.getName());
            this.configManager.getBansConfig().set(String.valueOf(playerUUID) + ".reason", (Object)reason);
            this.configManager.getBansConfig().set(String.valueOf(playerUUID) + ".timestamp", (Object)System.currentTimeMillis());
            this.configManager.saveBansFile();
            Bukkit.getServer().getBanList(BanList.Type.NAME).addBan(player.getName(), reason, null, "BlockSigningPlugin");
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer("\u00a7cYou have been banned for: " + reason));
        }
    }
}

