/*
 * Decompiled with CFR 0.152.
 */
package org.crazyhouse.blocksigningplugin;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.crazyhouse.blocksigningplugin.ConfigManager;

public class ItemHashManager {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final NamespacedKey key;
    private final Map<Material, Integer> customStackSizes = new EnumMap<Material, Integer>(Material.class);
    private final Map<String, UUID> globalMD5Map = new ConcurrentHashMap<String, UUID>();

    public ItemHashManager(JavaPlugin plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.key = new NamespacedKey((Plugin)plugin, "hash");
    }

    public void initializeCustomStackSizes() {
        Material[] stackTo16;
        this.customStackSizes.clear();
        for (Material material : stackTo16 = new Material[]{Material.ENDER_PEARL, Material.SNOWBALL, Material.EGG, Material.HONEY_BOTTLE, Material.ARMOR_STAND, Material.OAK_SIGN, Material.SPRUCE_SIGN, Material.BIRCH_SIGN, Material.JUNGLE_SIGN, Material.ACACIA_SIGN, Material.DARK_OAK_SIGN, Material.MANGROVE_SIGN, Material.CHERRY_SIGN, Material.BAMBOO_SIGN, Material.CRIMSON_SIGN, Material.WARPED_SIGN, Material.WHITE_BANNER, Material.ORANGE_BANNER, Material.MAGENTA_BANNER, Material.LIGHT_BLUE_BANNER, Material.YELLOW_BANNER, Material.LIME_BANNER, Material.PINK_BANNER, Material.GRAY_BANNER, Material.LIGHT_GRAY_BANNER, Material.CYAN_BANNER, Material.PURPLE_BANNER, Material.BLUE_BANNER, Material.BROWN_BANNER, Material.GREEN_BANNER, Material.RED_BANNER, Material.BLACK_BANNER, Material.BUCKET}) {
            this.customStackSizes.put(material, 16);
        }
        Material[] unstackableItems = new Material[]{Material.WOODEN_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD, Material.WOODEN_PICKAXE, Material.STONE_PICKAXE, Material.IRON_PICKAXE, Material.GOLDEN_PICKAXE, Material.DIAMOND_PICKAXE, Material.NETHERITE_PICKAXE, Material.WOODEN_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE, Material.WOODEN_SHOVEL, Material.STONE_SHOVEL, Material.IRON_SHOVEL, Material.GOLDEN_SHOVEL, Material.DIAMOND_SHOVEL, Material.NETHERITE_SHOVEL, Material.WOODEN_HOE, Material.STONE_HOE, Material.IRON_HOE, Material.GOLDEN_HOE, Material.DIAMOND_HOE, Material.NETHERITE_HOE, Material.FISHING_ROD, Material.BOW, Material.CROSSBOW, Material.TRIDENT, Material.MACE, Material.FLINT_AND_STEEL, Material.SHEARS, Material.CARROT_ON_A_STICK, Material.WARPED_FUNGUS_ON_A_STICK, Material.SPYGLASS, Material.SPLASH_POTION, Material.LINGERING_POTION, Material.POTION, Material.LEATHER_HELMET, Material.CHAINMAIL_HELMET, Material.IRON_HELMET, Material.GOLDEN_HELMET, Material.DIAMOND_HELMET, Material.NETHERITE_HELMET, Material.LEATHER_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.IRON_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.NETHERITE_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.IRON_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.NETHERITE_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_BOOTS, Material.IRON_BOOTS, Material.GOLDEN_BOOTS, Material.DIAMOND_BOOTS, Material.NETHERITE_BOOTS, Material.ELYTRA, Material.TURTLE_HELMET, Material.CARVED_PUMPKIN, Material.WITHER_SKELETON_SKULL, Material.SKELETON_SKULL, Material.ZOMBIE_HEAD, Material.PLAYER_HEAD, Material.CREEPER_HEAD, Material.DRAGON_HEAD, Material.PIGLIN_HEAD, Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX, Material.SHIELD, Material.TOTEM_OF_UNDYING, Material.FILLED_MAP, Material.COMPASS, Material.RECOVERY_COMPASS, Material.CLOCK, Material.WRITTEN_BOOK, Material.WRITABLE_BOOK, Material.LEAD, Material.NAME_TAG, Material.ENCHANTED_BOOK, Material.BUNDLE, Material.BRUSH, Material.DEBUG_STICK, Material.ENCHANTED_GOLDEN_APPLE, Material.HEART_OF_THE_SEA, Material.ITEM_FRAME, Material.GLOW_ITEM_FRAME, Material.KNOWLEDGE_BOOK, Material.NAUTILUS_SHELL, Material.PAINTING, Material.SADDLE, Material.LEATHER_HORSE_ARMOR, Material.IRON_HORSE_ARMOR, Material.GOLDEN_HORSE_ARMOR, Material.DIAMOND_HORSE_ARMOR, Material.SUSPICIOUS_STEW, Material.OAK_BOAT, Material.SPRUCE_BOAT, Material.BIRCH_BOAT, Material.JUNGLE_BOAT, Material.ACACIA_BOAT, Material.DARK_OAK_BOAT, Material.MANGROVE_BOAT, Material.CHERRY_BOAT, Material.BAMBOO_RAFT, Material.MINECART, Material.FURNACE_MINECART, Material.CHEST_MINECART, Material.TNT_MINECART, Material.HOPPER_MINECART, Material.COMMAND_BLOCK_MINECART};
        for (Material material : unstackableItems) {
            this.customStackSizes.put(material, 1);
        }
        if (this.plugin.getConfig().isConfigurationSection("custom-stack-sizes")) {
            for (String materialName : this.plugin.getConfig().getConfigurationSection("custom-stack-sizes").getKeys(false)) {
                try {
                    Material material = Material.valueOf((String)materialName.toUpperCase());
                    int stackSize = this.plugin.getConfig().getInt("custom-stack-sizes." + materialName);
                    if (stackSize > 0) {
                        this.customStackSizes.put(material, stackSize);
                        continue;
                    }
                    this.plugin.getLogger().warning("Invalid stack size for " + materialName + ": " + stackSize + ". Ignoring.");
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid material in custom-stack-sizes: " + materialName);
                }
            }
        }
    }

    public void assignMD5ToItem(Player player, ItemStack item) {
        if (item == null || item.getType().isAir() || this.configManager.getBlacklistedItems().contains(item.getType())) {
            return;
        }
        if (this.configManager.isOnlyScanEnabled() && !this.configManager.getOnlyScanItems().contains(item.getType())) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null && !itemMeta.getPersistentDataContainer().has(this.key, PersistentDataType.STRING)) {
            String hash = this.calculateHash(player.getName(), item.getType().name(), System.currentTimeMillis(), item.getAmount());
            itemMeta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)hash);
            item.setItemMeta(itemMeta);
            this.globalMD5Map.put(hash, player.getUniqueId());
        }
    }

    public String getMD5(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        return (String)meta.getPersistentDataContainer().get(this.key, PersistentDataType.STRING);
    }

    public boolean verifyItemHash(ItemStack item, String expectedHash) {
        if (item == null || expectedHash == null) {
            return false;
        }
        String currentHash = this.getMD5(item);
        return currentHash != null && currentHash.equals(expectedHash);
    }

    public String calculateHash(String playerName, String itemTypeName, long timestamp, int stackSize) {
        String uniqueId = UUID.randomUUID().toString();
        return Hashing.murmur3_128().hashString((CharSequence)(playerName + itemTypeName + timestamp + stackSize + uniqueId), StandardCharsets.UTF_8).toString();
    }

    public int getMaxStackSize(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return 1;
        }
        return this.customStackSizes.getOrDefault(item.getType(), 64);
    }

    public boolean isUniqueItem(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return false;
        }
        return this.getMaxStackSize(item) == 1;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public Map<String, UUID> getGlobalMD5Map() {
        return this.globalMD5Map;
    }

    public Map<Material, Integer> getCustomStackSizes() {
        return this.customStackSizes;
    }
}

