/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="theforgotten", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue ENABLE_APPARITIONS = BUILDER.comment("Enable subtle apparitions").define("general.enableApparitions", true);
    public static final ForgeConfigSpec.BooleanValue ENABLE_AMBIENT_SOUNDS = BUILDER.comment("Enable subtle ambient misdirection sounds").define("general.enableAmbientSounds", true);
    public static final ForgeConfigSpec.BooleanValue ENABLE_MICRO_STRUCTURES = BUILDER.comment("Enable small structures/anomalies").define("general.enableMicroStructures", true);
    public static final ForgeConfigSpec.BooleanValue DEBUG_LOGS = BUILDER.comment("Enable debug logging and test commands").define("general.debugLogs", false);
    public static final ForgeConfigSpec.BooleanValue ENABLE_WORLD_SILENCE = BUILDER.comment("Enable initial world grace period where the mod remains silent (randomly a full day or half day)").define("general.enableWorldSilence", true);
    public static final ForgeConfigSpec.DoubleValue SLEEP_FRIGHT_CHANCE = BUILDER.comment("Chance (0-1) that attempting to sleep triggers a fright event").defineInRange("sleep.frightChance", 0.18, 0.0, 1.0);
    public static final ForgeConfigSpec.DoubleValue SLEEP_FRIGHT_DAMAGE = BUILDER.comment("Damage dealt in half-hearts when a sleep fright triggers (default 6 = 3 hearts)").defineInRange("sleep.frightDamage", 6.0, 0.0, 40.0);
    public static final ForgeConfigSpec.IntValue SILENCE_DURATION_FULL_TICKS = BUILDER.comment("Ticks to keep the world silent for the 'full' duration (default 36000 = one and a half MC days)").defineInRange("silence.fullTicks", 36000, 100, 10000000);
    public static final ForgeConfigSpec.IntValue SILENCE_DURATION_HALF_TICKS = BUILDER.comment("Ticks to keep the world silent for the 'half' duration (default 24000 = one MC day)").defineInRange("silence.halfTicks", 24000, 100, 10000000);
    public static final ForgeConfigSpec.DoubleValue SILENCE_FULL_CHANCE = BUILDER.comment("Probability of selecting the 'full' silence duration; otherwise the 'half' duration is used (0-1)").defineInRange("silence.fullChance", 0.6, 0.0, 1.0);
    public static final ForgeConfigSpec.IntValue SILENCE_RAMP_SECONDS = BUILDER.comment("Seconds after silence ends to gradually ramp event intensity back to normal").defineInRange("silence.rampSeconds", 60, 0, 600);
    public static final ForgeConfigSpec.DoubleValue SILENCE_RAMP_START_SCALE = BUILDER.comment("Starting intensity scale right after silence (0-1). 0.5 means events start at 50% and ramp to 100% over rampSeconds").defineInRange("silence.rampStartScale", 0.5, 0.0, 1.0);
    public static final ForgeConfigSpec.DoubleValue TENSION_INCREASE_UNDERGROUND = BUILDER.comment("Tension per second when underground/low light").defineInRange("tension.increaseUnderground", 0.12, 0.0, 10.0);
    public static final ForgeConfigSpec.DoubleValue TENSION_INCREASE_SOLITUDE = BUILDER.comment("Tension per second when alone (no players within audience radius)").defineInRange("tension.increaseSolitude", 0.1, 0.0, 10.0);
    public static final ForgeConfigSpec.DoubleValue TENSION_INCREASE_STORM_NIGHT = BUILDER.comment("Tension per second bonus during storms/night/deep caves").defineInRange("tension.increaseStormNight", 0.08, 0.0, 10.0);
    public static final ForgeConfigSpec.DoubleValue TENSION_DECREASE_SAFE = BUILDER.comment("Tension per second decrease in safe bright areas / villages").defineInRange("tension.decreaseSafe", 0.2, 0.0, 10.0);
    public static final ForgeConfigSpec.DoubleValue TENSION_DECAY_PER_SEC = BUILDER.comment("Baseline tension decay per second (gentle)").defineInRange("tension.decayPerSec", 0.03, 0.0, 10.0);
    public static final ForgeConfigSpec.DoubleValue TENSION_MIN_FOR_STRUCTURE = BUILDER.comment("Minimum tension required to consider small structure placement").defineInRange("tension.minForStructure", 35.0, 0.0, 100.0);
    public static final ForgeConfigSpec.IntValue TENSION_MIN_SUSTAIN_SECONDS = BUILDER.comment("Seconds the minimum must be sustained before trying a placement").defineInRange("tension.minSustainSeconds", 10, 0, 600);
    public static final ForgeConfigSpec.IntValue AUDIENCE_RADIUS = BUILDER.comment("Radius within which other players cancel an event (audience gating)").defineInRange("audience.radius", 80, 16, 192);
    public static final ForgeConfigSpec.IntValue PLAYER_ROLL_INTERVAL_MIN_SEC = BUILDER.comment("Minimum jittered seconds between per-player rolls").defineInRange("scheduling.rollIntervalMinSec", 10, 5, 120);
    public static final ForgeConfigSpec.IntValue PLAYER_ROLL_INTERVAL_MAX_SEC = BUILDER.comment("Maximum jittered seconds between per-player rolls").defineInRange("scheduling.rollIntervalMaxSec", 20, 6, 180);
    public static final ForgeConfigSpec.DoubleValue APPARITION_ROLL_CHANCE = BUILDER.comment("Probability on a per-roll to trigger an apparition (0-1)").defineInRange("scheduling.apparitionRollChance", 0.055, 0.0, 1.0);
    public static final ForgeConfigSpec.DoubleValue AMBIENT_ROLL_CHANCE = BUILDER.comment("Probability on a per-roll to trigger an ambient sound (0-1)").defineInRange("scheduling.ambientRollChance", 0.1, 0.0, 1.0);
    public static final ForgeConfigSpec.DoubleValue AMBIENT_DISTORT_CHANCE_OVERWORLD = BUILDER.comment("Chance that an ambient sound is played with distortion layers in normal dimensions (0-1)").defineInRange("audio.ambient.distortChanceOverworld", 0.12, 0.0, 1.0);
    public static final ForgeConfigSpec.DoubleValue AMBIENT_GLITCH_OVERLAY_CHANCE_OVERWORLD = BUILDER.comment("Chance to add a quiet glitch overlay on ambient sounds in normal dimensions (0-1)").defineInRange("audio.ambient.glitchOverlayChanceOverworld", 0.05, 0.0, 1.0);
    public static final ForgeConfigSpec.DoubleValue AMBIENT_DISTORT_CHANCE_LURE = BUILDER.comment("Chance that an ambient sound is played with distortion layers in the lure dimension (0-1)").defineInRange("audio.ambient.distortChanceLure", 0.6, 0.0, 1.0);
    public static final ForgeConfigSpec.DoubleValue AMBIENT_GLITCH_OVERLAY_CHANCE_LURE = BUILDER.comment("Chance to add a glitch overlay on ambient sounds in the lure dimension (0-1)").defineInRange("audio.ambient.glitchOverlayChanceLure", 0.9, 0.0, 1.0);
    public static final ForgeConfigSpec.BooleanValue CAVES_CHARGE_ENABLED = BUILDER.comment("Enable rare apparition charges in caves (outside the lure dimension)").define("caves.chargeEnabled", true);
    public static final ForgeConfigSpec.DoubleValue CAVES_CHARGE_CHANCE = BUILDER.comment("Per-apparition roll chance to convert to a charge in caves (0-1). Keep low.").defineInRange("caves.chargeChance", 0.04, 0.0, 1.0);
    public static final ForgeConfigSpec.IntValue CAVES_MIN_LIGHT = BUILDER.comment("Maximum allowed local brightness for cave charges to be eligible (0-15). Events only when light <= this.").defineInRange("caves.minLight", 7, 0, 15);
    public static final ForgeConfigSpec.BooleanValue CAVES_REQUIRE_UNDERGROUND = BUILDER.comment("Require that the player cannot see the sky for a cave charge to be eligible").define("caves.requireUnderground", true);
    public static final ForgeConfigSpec.BooleanValue BEHIND_TURN_ENABLED = BUILDER.comment("Enable rare behind-turn apparition jumpscare in overworld with buildup").define("apparitions.behindTurn.enabled", true);
    public static final ForgeConfigSpec.DoubleValue BEHIND_TURN_CHANCE = BUILDER.comment("Per-apparition roll chance to trigger behind-turn jumpscare (0-1). Keep low.").defineInRange("apparitions.behindTurn.chance", 0.03, 0.0, 1.0);
    public static final ForgeConfigSpec.IntValue BEHIND_TURN_BUILDUP_MIN_TICKS = BUILDER.comment("Min ticks of buildup before rotate+glitch in behind-turn jumpscare").defineInRange("apparitions.behindTurn.buildupMinTicks", 40, 0, 6000);
    public static final ForgeConfigSpec.IntValue BEHIND_TURN_BUILDUP_MAX_TICKS = BUILDER.comment("Max ticks of buildup before rotate+glitch in behind-turn jumpscare").defineInRange("apparitions.behindTurn.buildupMaxTicks", 100, 0, 6000);
    public static final ForgeConfigSpec.BooleanValue CREEPY_CHAT_ENABLED = BUILDER.comment("Enable rare forged personal chat lines").define("creepyChat.enabled", true);
    public static final ForgeConfigSpec.IntValue CREEPY_INTERVAL_MIN_SEC = BUILDER.comment("Minimum seconds between creepy chat windows per player").defineInRange("creepyChat.intervalMinSec", 180, 30, 7200);
    public static final ForgeConfigSpec.IntValue CREEPY_INTERVAL_MAX_SEC = BUILDER.comment("Maximum seconds between creepy chat windows per player").defineInRange("creepyChat.intervalMaxSec", 480, 60, 14400);
    public static final ForgeConfigSpec.DoubleValue CREEPY_SEND_CHANCE = BUILDER.comment("Chance to send a creepy chat during a window (0-1)").defineInRange("creepyChat.sendChance", 0.18, 0.0, 1.0);
    public static final ForgeConfigSpec.IntValue STRUCTURE_COOLDOWN_MIN_SEC = BUILDER.comment("Minimum cooldown seconds between small structures per player").defineInRange("structures.cooldownMinSec", 60, 30, 3600);
    public static final ForgeConfigSpec.IntValue STRUCTURE_COOLDOWN_MAX_SEC = BUILDER.comment("Maximum cooldown seconds between small structures per player").defineInRange("structures.cooldownMaxSec", 180, 60, 7200);
    public static final ForgeConfigSpec.IntValue STRUCTURE_ATTEMPT_BUDGET = BUILDER.comment("Maximum candidate location checks per attempt").defineInRange("structures.attemptBudget", 90, 10, 200);
    public static final ForgeConfigSpec.IntValue STRUCTURE_TTL_MIN_SEC = BUILDER.comment("Minimum TTL for anomalies before rollback").defineInRange("structures.ttlMinSec", 120, 5, 3600);
    public static final ForgeConfigSpec.IntValue STRUCTURE_TTL_MAX_SEC = BUILDER.comment("Maximum TTL for anomalies before rollback").defineInRange("structures.ttlMaxSec", 600, 10, 7200);
    public static final ForgeConfigSpec.BooleanValue LURE_ENTRANCE_PERMANENT = BUILDER.comment("Make lure entrances effectively permanent (no rollback). If true, active lure pits won't expire.").define("lure.entrancePermanent", false);
    public static final ForgeConfigSpec.IntValue LURE_ENTRANCE_TTL_MIN_SEC = BUILDER.comment("Minimum TTL for lure entrances before rollback (seconds). Set high for long-lived pits.").defineInRange("lure.entranceTtlMinSec", 3600, 60, 86400);
    public static final ForgeConfigSpec.IntValue LURE_ENTRANCE_TTL_MAX_SEC = BUILDER.comment("Maximum TTL for lure entrances before rollback (seconds).").defineInRange("lure.entranceTtlMaxSec", 14400, 300, 172800);
    public static final ForgeConfigSpec.BooleanValue TRIAL_ENABLED = BUILDER.comment("Enable the corridor Trial (find N buttons to be set free)").define("trial.enabled", true);
    public static final ForgeConfigSpec.IntValue TRIAL_REQUIRED_BUTTONS = BUILDER.comment("Number of unique trial buttons required to complete the Trial").defineInRange("trial.requiredButtons", 3, 1, 16);
    public static final ForgeConfigSpec.DoubleValue TRIAL_BUTTON_CHANCE = BUILDER.comment("Per-chunk chance to spawn a trial button pedestal in the lure dimension (0-1)").defineInRange("trial.buttonChancePerChunk", 0.035, 0.0, 1.0);
    static final ForgeConfigSpec SPEC = BUILDER.build();

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
    }
}

