/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tasuposed.theforgotten.server.LureDimensionManager;

@Mod.EventBusSubscriber(modid="theforgotten", value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation LOGO_TEX = new ResourceLocation("minecraft", "textures/gui/title/minecraft.png");
    private static final Random RNG = new Random();
    private static long glitchUntilMs = 0L;
    private static long lastGlitchCheckMs = 0L;

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render.Post e) {
        if (!(e.getScreen() instanceof TitleScreen)) {
            return;
        }
        GuiGraphics g = e.getGuiGraphics();
        int width = e.getScreen().f_96543_;
        int logoW = 256;
        int logoH = 44;
        int x = (width - logoW) / 2;
        int y = 30;
        long now = System.currentTimeMillis();
        float pulse = (float)(0.5 + 0.5 * Math.sin((double)now / 900.0));
        if (now - lastGlitchCheckMs > 450L && now > glitchUntilMs) {
            lastGlitchCheckMs = now;
            if (RNG.nextDouble() < 0.08) {
                glitchUntilMs = now + 300L + (long)RNG.nextInt(600);
            }
        }
        boolean glitch = now < glitchUntilMs;
        int baseColor = -16777216;
        g.m_280509_(x - 4, y - 4, x + logoW + 4, y + logoH + 4, baseColor);
        int h = e.getScreen().f_96544_;
        int scanAlpha = (int)(18.0f + 18.0f * pulse);
        int scanCol = scanAlpha << 24 | 0xFFFFFF;
        for (int sy = 0; sy < h; sy += 3) {
            g.m_280509_(0, sy, width, sy + 1, scanCol);
        }
        int border = 10;
        int vigA = 80;
        int vigCol = vigA << 24;
        g.m_280509_(0, 0, width, border, vigCol);
        g.m_280509_(0, h - border, width, h, vigCol);
        g.m_280509_(0, border, border, h - border, vigCol);
        g.m_280509_(width - border, border, width, h - border, vigCol);
        int jx = glitch ? -2 + RNG.nextInt(5) : -1 + RNG.nextInt(3);
        int jy = glitch ? -2 + RNG.nextInt(5) : 0;
        RenderSystem.setShaderColor((float)1.0f, (float)0.35f, (float)0.35f, (float)(glitch ? 0.45f : 0.28f));
        g.m_280163_(LOGO_TEX, x + jx - 1, y + jy, 0.0f, 0.0f, logoW, logoH, logoW, logoH);
        RenderSystem.setShaderColor((float)0.35f, (float)1.0f, (float)1.0f, (float)(glitch ? 0.45f : 0.28f));
        g.m_280163_(LOGO_TEX, x + jx + 1, y + jy, 0.0f, 0.0f, logoW, logoH, logoW, logoH);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        g.m_280163_(LOGO_TEX, x + jx, y + jy, 0.0f, 0.0f, logoW, logoH, logoW, logoH);
        int speckles = glitch ? 90 : 40;
        int nAlpha = glitch ? 80 : 45;
        for (int i = 0; i < speckles; ++i) {
            int nx = x + RNG.nextInt(logoW);
            int ny = y + RNG.nextInt(logoH);
            int sz = 1 + RNG.nextInt(glitch ? 3 : 2);
            int shade = 160 + RNG.nextInt(60);
            int c = nAlpha << 24 | shade << 16 | shade << 8 | shade;
            g.m_280509_(nx, ny, nx + sz, ny + sz, c);
        }
        if (glitch) {
            int bars = 4 + RNG.nextInt(4);
            for (int i = 0; i < bars; ++i) {
                int yy = y - 6 + RNG.nextInt(logoH + 12);
                int hh = 2 + RNG.nextInt(4);
                int xoff = -8 + RNG.nextInt(17);
                int a1 = 110 + RNG.nextInt(60);
                int rCol = a1 << 24 | 0xFF0000;
                int gCol = a1 << 24 | 0xFF00;
                g.m_280509_(x - 4 + xoff, yy, x + logoW + 4 + xoff, yy + hh, rCol);
                g.m_280509_(x - 3 + xoff, yy + 1, x + logoW + 5 + xoff, yy + hh + 1, gCol);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor e) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null) {
            return;
        }
        if (!mc.f_91073_.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            return;
        }
        e.setRed(0.0f);
        e.setGreen(0.0f);
        e.setBlue(0.0f);
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog e) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null) {
            return;
        }
        if (!mc.f_91073_.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            return;
        }
        float near = 0.5f;
        float far = 3.0f;
        try {
            e.setNearPlaneDistance(near);
            e.setFarPlaneDistance(far);
            e.setCanceled(true);
        }
        catch (Throwable t) {
            RenderSystem.setShaderFogStart((float)near);
            RenderSystem.setShaderFogEnd((float)far);
        }
    }
}

