/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.client.apparition;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tasuposed.theforgotten.client.apparition.GhostPlayer;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="theforgotten", value={Dist.CLIENT})
public final class ClientApparitions {
    private static final ResourceLocation TRUE_TEXTURE = new ResourceLocation("theforgotten", "textures/entity/apparition.png");
    private static final boolean TRUE_SLIM_MODEL = false;
    private static final Map<UUID, A> ACTIVE = new HashMap<UUID, A>();

    public static void spawn(UUID id, Vec3 pos, float yRot, String skinType, UUID mimicPlayer, String mimicName, int lifetimeTicks) {
        A a = new A();
        a.pos = pos;
        a.yRot = yRot;
        a.skin = skinType;
        a.mimic = mimicPlayer;
        a.mimicName = mimicName;
        long l = a.dieTick = Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_46467_() + (long)lifetimeTicks : Long.MAX_VALUE;
        if (mimicPlayer == null) {
            a.displayName = ClientApparitions.randomCrypticName();
        }
        ACTIVE.put(id, a);
    }

    public static void vanish(UUID id) {
        ACTIVE.remove(id);
    }

    public static double spotFactor() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91074_ == null || mc.f_91073_ == null || ACTIVE.isEmpty()) {
            return 0.0;
        }
        Vec3 eye = mc.f_91074_.m_20182_().m_82520_(0.0, (double)mc.f_91074_.m_20192_(), 0.0);
        Vec3 look = mc.f_91074_.m_20154_().m_82541_();
        double best = 0.0;
        double cosThresh = Math.cos(Math.toRadians(15.0));
        for (A a : ACTIVE.values()) {
            Vec3 to = a.pos.m_82546_(eye);
            double dist = to.m_82553_();
            if (dist < 1.0E-4) continue;
            Vec3 dir = to.m_82490_(1.0 / dist);
            double dot = look.m_82526_(dir);
            double align = Mth.m_14008_((double)((dot - cosThresh) / (1.0 - cosThresh)), (double)0.0, (double)1.0);
            double distFac = Mth.m_14008_((double)((24.0 - dist) / 18.0), (double)0.0, (double)1.0);
            best = Math.max(best, align * distFac);
        }
        return best;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        long time = mc.f_91073_.m_46467_();
        Iterator<Map.Entry<UUID, A>> it = ACTIVE.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, A> en = it.next();
            A a = en.getValue();
            if (time >= a.dieTick) {
                it.remove();
                continue;
            }
            if (!a.charging) continue;
            if (time >= a.chargeEndTick) {
                a.pos = a.chargeTargetPos;
                a.charging = false;
                continue;
            }
            double span = Math.max(1L, a.chargeEndTick - a.chargeStartTick);
            double t = Mth.m_14008_((double)((double)(time - a.chargeStartTick) / span), (double)0.0, (double)1.0);
            double ease = 1.0 - Math.cos(t * Math.PI * 0.5);
            a.pos = new Vec3(Mth.m_14139_((double)ease, (double)a.chargeStartPos.f_82479_, (double)a.chargeTargetPos.f_82479_), Mth.m_14139_((double)ease, (double)a.chargeStartPos.f_82480_, (double)a.chargeTargetPos.f_82480_), Mth.m_14139_((double)ease, (double)a.chargeStartPos.f_82481_, (double)a.chargeTargetPos.f_82481_));
        }
    }

    private static String randomCrypticName() {
        Random r = new Random(System.nanoTime());
        String[] base = new String[]{"\u16be", "\u16b1", "\u16df", "\u16de", "\u0416", "\u0496", "\u046a", "\u0472", "\u0480", "\u04dc", "\u04d6", "\u0489", "\u25fc", "\u25c6", "\u25c7", "\u25cf", "\u25d6", "\u25d7", "\u25a3", "\u25a9"};
        String[] comb = new String[]{"\u0300", "\u0301", "\u0302", "\u0303", "\u0304", "\u0307", "\u0308", "\u0309", "\u030a", "\u0316", "\u0317", "\u031a", "\u0334", "\u0335", "\u0336", "\u0346", "\u0350", "\u0489"};
        String[] zw = new String[]{"", "\u200b", "\u200c", "\u200d"};
        int len = 3 + r.nextInt(3);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(base[r.nextInt(base.length)]);
            int c = 1 + r.nextInt(3);
            for (int j = 0; j < c; ++j) {
                sb.append(comb[r.nextInt(comb.length)]);
            }
            sb.append(zw[r.nextInt(zw.length)]);
        }
        return sb.toString();
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        PoseStack ps = e.getPoseStack();
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        EntityRenderDispatcher erd = mc.m_91290_();
        double camX = e.getCamera().m_90583_().f_82479_;
        double camY = e.getCamera().m_90583_().f_82480_;
        double camZ = e.getCamera().m_90583_().f_82481_;
        for (Map.Entry<UUID, A> en : ACTIVE.entrySet()) {
            A a = en.getValue();
            if (a.rp == null) {
                if (a.mimic != null) {
                    Player target = mc.f_91073_.m_46003_(a.mimic);
                    if (target instanceof AbstractClientPlayer) {
                        AbstractClientPlayer t = (AbstractClientPlayer)target;
                        a.rp = new RemotePlayer(mc.f_91073_, t.m_36316_());
                    } else {
                        a.rp = new RemotePlayer(mc.f_91073_, new GameProfile(a.mimic, a.mimicName != null ? a.mimicName : "Apparition"));
                    }
                    a.rp.m_6842_(false);
                } else {
                    UUID skinId = new UUID(0L, 1L);
                    String name = a.displayName != null && !a.displayName.isEmpty() ? a.displayName : ClientApparitions.randomCrypticName();
                    a.rp = new GhostPlayer(mc.f_91073_, new GameProfile(skinId, name), TRUE_TEXTURE, false);
                    a.rp.m_6842_(false);
                    a.rp.m_6593_(null);
                    a.rp.m_20340_(false);
                }
            }
            a.rp.m_6034_(a.pos.f_82479_, a.pos.f_82480_, a.pos.f_82481_);
            a.rp.f_19790_ = a.pos.f_82479_;
            a.rp.f_19791_ = a.pos.f_82480_;
            a.rp.f_19792_ = a.pos.f_82481_;
            double dx = camX - a.pos.f_82479_;
            double dz = camZ - a.pos.f_82481_;
            float yaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
            a.rp.m_5618_(yaw);
            a.rp.m_146922_(yaw);
            a.rp.f_20885_ = yaw;
            a.rp.f_20884_ = yaw;
            a.rp.f_19859_ = yaw;
            a.rp.f_20886_ = yaw;
            a.rp.m_20334_(0.0, 0.0, 0.0);
            int packedLight = 0xF000F0;
            erd.m_114384_((Entity)a.rp, a.pos.f_82479_ - camX, a.pos.f_82480_ - camY, a.pos.f_82481_ - camZ, yaw, e.getPartialTick(), ps, (MultiBufferSource)buffers, packedLight);
        }
    }

    public static void startCharge(UUID id, int durationTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        A a = ACTIVE.get(id);
        if (a == null) {
            return;
        }
        long now = mc.f_91073_.m_46467_();
        Vec3 feet = mc.f_91074_.m_20182_();
        Vec3 look = mc.f_91074_.m_20154_().m_82541_();
        Vec3 torso = feet.m_82520_(0.0, 1.55, 0.0);
        Vec3 target = torso.m_82549_(look.m_82490_(0.18));
        a.charging = true;
        a.chargeStartTick = now;
        a.chargeEndTick = now + (long)Math.max(1, durationTicks);
        a.chargeStartPos = a.pos;
        a.chargeTargetPos = target;
    }

    private ClientApparitions() {
    }

    private static class A {
        Vec3 pos;
        float yRot;
        String skin;
        UUID mimic;
        String mimicName;
        long dieTick;
        RemotePlayer rp;
        String displayName;
        boolean charging;
        long chargeStartTick;
        long chargeEndTick;
        Vec3 chargeStartPos;
        Vec3 chargeTargetPos;

        private A() {
        }
    }
}

