/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.client.config;

import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.tasuposed.theforgotten.Config;
import net.tasuposed.theforgotten.server.RuntimeTuning;

public final class ClothConfigClient {
    private ClothConfigClient() {
    }

    public static Screen build(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.m_237113_((String)"The Forgotten - Config"));
        ConfigEntryBuilder eb = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((Component)Component.m_237113_((String)"General"));
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237113_((String)"Enable Apparitions"), ((Boolean)Config.ENABLE_APPARITIONS.get()).booleanValue()).setTooltip(new Component[]{Component.m_237113_((String)"Allow subtle stalking apparitions")}).setSaveConsumer(v -> Config.ENABLE_APPARITIONS.set(v)).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237113_((String)"Enable Ambient Sounds"), ((Boolean)Config.ENABLE_AMBIENT_SOUNDS.get()).booleanValue()).setTooltip(new Component[]{Component.m_237113_((String)"Allow misdirection ambience")}).setSaveConsumer(v -> Config.ENABLE_AMBIENT_SOUNDS.set(v)).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237113_((String)"Enable Small Structures"), ((Boolean)Config.ENABLE_MICRO_STRUCTURES.get()).booleanValue()).setTooltip(new Component[]{Component.m_237113_((String)"Allow small structures/anomalies")}).setSaveConsumer(v -> Config.ENABLE_MICRO_STRUCTURES.set(v)).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237113_((String)"Debug Logs"), ((Boolean)Config.DEBUG_LOGS.get()).booleanValue()).setTooltip(new Component[]{Component.m_237113_((String)"Extra logging and chat debug messages")}).setSaveConsumer(v -> Config.DEBUG_LOGS.set(v)).build());
        ConfigCategory scheduling = builder.getOrCreateCategory((Component)Component.m_237113_((String)"Scheduling"));
        scheduling.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237113_((String)"Player Roll Interval Min (s)"), ((Integer)Config.PLAYER_ROLL_INTERVAL_MIN_SEC.get()).intValue()).setMin(1).setMax(600).setSaveConsumer(v -> {
            Config.PLAYER_ROLL_INTERVAL_MIN_SEC.set(v);
            RuntimeTuning.setPlayerRollInterval(v, (Integer)Config.PLAYER_ROLL_INTERVAL_MAX_SEC.get());
        }).build());
        scheduling.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237113_((String)"Player Roll Interval Max (s)"), ((Integer)Config.PLAYER_ROLL_INTERVAL_MAX_SEC.get()).intValue()).setMin(1).setMax(1200).setSaveConsumer(v -> {
            Config.PLAYER_ROLL_INTERVAL_MAX_SEC.set(v);
            RuntimeTuning.setPlayerRollInterval((Integer)Config.PLAYER_ROLL_INTERVAL_MIN_SEC.get(), v);
        }).build());
        scheduling.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.m_237113_((String)"Apparition Roll Chance"), ((Double)Config.APPARITION_ROLL_CHANCE.get()).doubleValue()).setMin(0.0).setMax(1.0).setSaveConsumer(v -> {
            Config.APPARITION_ROLL_CHANCE.set(v);
            RuntimeTuning.setApparitionChance(v);
        }).build());
        scheduling.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.m_237113_((String)"Ambient Roll Chance"), ((Double)Config.AMBIENT_ROLL_CHANCE.get()).doubleValue()).setMin(0.0).setMax(1.0).setSaveConsumer(v -> {
            Config.AMBIENT_ROLL_CHANCE.set(v);
            RuntimeTuning.setAmbientChance(v);
        }).build());
        ConfigCategory structures = builder.getOrCreateCategory((Component)Component.m_237113_((String)"Structures"));
        structures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237113_((String)"Cooldown Min (s)"), ((Integer)Config.STRUCTURE_COOLDOWN_MIN_SEC.get()).intValue()).setMin(0).setMax(7200).setSaveConsumer(v -> {
            Config.STRUCTURE_COOLDOWN_MIN_SEC.set(v);
            RuntimeTuning.setStructureCooldown(v, (Integer)Config.STRUCTURE_COOLDOWN_MAX_SEC.get());
        }).build());
        structures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237113_((String)"Cooldown Max (s)"), ((Integer)Config.STRUCTURE_COOLDOWN_MAX_SEC.get()).intValue()).setMin(0).setMax(7200).setSaveConsumer(v -> {
            Config.STRUCTURE_COOLDOWN_MAX_SEC.set(v);
            RuntimeTuning.setStructureCooldown((Integer)Config.STRUCTURE_COOLDOWN_MIN_SEC.get(), v);
        }).build());
        structures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237113_((String)"Attempt Budget"), ((Integer)Config.STRUCTURE_ATTEMPT_BUDGET.get()).intValue()).setMin(1).setMax(400).setSaveConsumer(v -> Config.STRUCTURE_ATTEMPT_BUDGET.set(v)).build());
        structures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237113_((String)"TTL Min (s)"), ((Integer)Config.STRUCTURE_TTL_MIN_SEC.get()).intValue()).setMin(5).setMax(3600).setSaveConsumer(v -> Config.STRUCTURE_TTL_MIN_SEC.set(v)).build());
        structures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237113_((String)"TTL Max (s)"), ((Integer)Config.STRUCTURE_TTL_MAX_SEC.get()).intValue()).setMin(10).setMax(7200).setSaveConsumer(v -> Config.STRUCTURE_TTL_MAX_SEC.set(v)).build());
        ConfigCategory tension = builder.getOrCreateCategory((Component)Component.m_237113_((String)"Tension"));
        tension.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.m_237113_((String)"Increase Underground"), ((Double)Config.TENSION_INCREASE_UNDERGROUND.get()).doubleValue()).setMin(0.0).setMax(5.0).setSaveConsumer(v -> Config.TENSION_INCREASE_UNDERGROUND.set(v)).build());
        tension.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.m_237113_((String)"Increase Solitude"), ((Double)Config.TENSION_INCREASE_SOLITUDE.get()).doubleValue()).setMin(0.0).setMax(5.0).setSaveConsumer(v -> Config.TENSION_INCREASE_SOLITUDE.set(v)).build());
        tension.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.m_237113_((String)"Increase Storm/Night"), ((Double)Config.TENSION_INCREASE_STORM_NIGHT.get()).doubleValue()).setMin(0.0).setMax(5.0).setSaveConsumer(v -> Config.TENSION_INCREASE_STORM_NIGHT.set(v)).build());
        tension.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.m_237113_((String)"Decrease Safe"), ((Double)Config.TENSION_DECREASE_SAFE.get()).doubleValue()).setMin(0.0).setMax(5.0).setSaveConsumer(v -> Config.TENSION_DECREASE_SAFE.set(v)).build());
        tension.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.m_237113_((String)"Decay per Second"), ((Double)Config.TENSION_DECAY_PER_SEC.get()).doubleValue()).setMin(0.0).setMax(1.0).setSaveConsumer(v -> Config.TENSION_DECAY_PER_SEC.set(v)).build());
        tension.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.m_237113_((String)"Min for Structure"), ((Double)Config.TENSION_MIN_FOR_STRUCTURE.get()).doubleValue()).setMin(0.0).setMax(100.0).setSaveConsumer(v -> Config.TENSION_MIN_FOR_STRUCTURE.set(v)).build());
        tension.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237113_((String)"Min Sustain Seconds"), ((Integer)Config.TENSION_MIN_SUSTAIN_SECONDS.get()).intValue()).setMin(0).setMax(600).setSaveConsumer(v -> Config.TENSION_MIN_SUSTAIN_SECONDS.set(v)).build());
        ConfigCategory audience = builder.getOrCreateCategory((Component)Component.m_237113_((String)"Audience"));
        audience.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237113_((String)"Audience Radius"), ((Integer)Config.AUDIENCE_RADIUS.get()).intValue()).setMin(16).setMax(256).setSaveConsumer(v -> Config.AUDIENCE_RADIUS.set(v)).build());
        builder.setSavingRunnable(() -> {});
        return builder.build();
    }
}

