/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.client.fx;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tasuposed.theforgotten.client.apparition.ClientApparitions;
import net.tasuposed.theforgotten.client.fx.GlitchHumSound;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="theforgotten", value={Dist.CLIENT})
public final class GlitchFX {
    private static double intensity = 0.0;
    private static double t = 0.0;
    private static final Random RNG = new Random();
    private static GlitchHumSound HUM;
    private static int tearTicks;
    private static float tearOffset;
    private static float tearHeightNorm;
    private static float tearYNorm;
    private static float postFxPulse;
    private static boolean firstSpottingHandled;
    private static boolean episodeGlitchAllowed;
    private static boolean spottingActive;
    private static double prevTarget;
    private static int forcedGlitchTicks;
    private static float forcedGlitchLevel;

    private GlitchFX() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null) {
            return;
        }
        double target = ClientApparitions.spotFactor();
        double startThresh = 0.28;
        double endThresh = 0.18;
        if (!spottingActive && prevTarget <= startThresh && target > startThresh) {
            spottingActive = true;
            if (!firstSpottingHandled) {
                episodeGlitchAllowed = false;
                firstSpottingHandled = true;
            } else {
                episodeGlitchAllowed = RNG.nextBoolean();
            }
        }
        if (spottingActive && target < endThresh) {
            spottingActive = false;
            episodeGlitchAllowed = false;
        }
        double rateUp = 0.2;
        double rateDown = 0.15;
        intensity = intensity < target ? Mth.m_14008_((double)(intensity + rateUp), (double)0.0, (double)1.0) : Mth.m_14008_((double)(intensity - rateDown), (double)0.0, (double)1.0);
        t += 0.06 + 0.14 * intensity;
        double eI = GlitchFX.effectiveIntensity();
        if (eI > 0.001) {
            GlitchFX.ensureHum();
            if (HUM != null) {
                HUM.setTarget((float)eI);
            }
        } else if (HUM != null) {
            HUM.setTarget(0.0f);
        }
        if (eI > 0.25 && tearTicks <= 0) {
            if (RNG.nextDouble() < 0.035 * eI) {
                tearTicks = 4 + RNG.nextInt(5);
                tearOffset = (float)((RNG.nextDouble() - 0.5) * (50.0 + eI * 120.0));
                tearHeightNorm = 0.035f + RNG.nextFloat() * 0.1f;
                tearYNorm = RNG.nextFloat();
            }
        } else if (tearTicks > 0 && RNG.nextDouble() < 0.25) {
            tearOffset *= 0.85f;
        }
        if (tearTicks > 0 && --tearTicks <= 0) {
            tearOffset = 0.0f;
        }
        postFxPulse = (float)(0.5 + 0.5 * Math.sin(t * 0.65));
        if (forcedGlitchTicks > 0 && --forcedGlitchTicks <= 0) {
            forcedGlitchLevel = 0.0f;
        }
        prevTarget = target;
    }

    @SubscribeEvent
    public static void onFov(ViewportEvent.ComputeFov e) {
        double eI = GlitchFX.effectiveIntensity();
        if (eI <= 0.001) {
            return;
        }
        double base = e.getFOV();
        double wobble = Math.sin(t * 1.7) * 0.6 + Math.sin(t * 3.1) * 0.4;
        double jitter = (RNG.nextDouble() - 0.5) * 0.15;
        double delta = -2.0 * eI + wobble * eI * 0.5 + jitter * eI;
        e.setFOV(Mth.m_14008_((double)(base + delta), (double)30.0, (double)120.0));
    }

    @SubscribeEvent
    public static void onCamera(ViewportEvent.ComputeCameraAngles e) {
        double eI2 = GlitchFX.effectiveIntensity();
        if (eI2 <= 0.001) {
            return;
        }
        float yaw = e.getYaw();
        float pitch = e.getPitch();
        float roll = e.getRoll();
        float jx = (float)((RNG.nextDouble() - 0.5) * 0.4 * eI2);
        float jy = (float)((RNG.nextDouble() - 0.5) * 0.3 * eI2);
        float r = (float)(Math.sin(t * 1.4) * 0.8 * eI2);
        e.setYaw(yaw + jx);
        e.setPitch(pitch + jy);
        e.setRoll(roll + r);
    }

    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor e) {
        double eI3 = GlitchFX.effectiveIntensity();
        if (eI3 <= 0.001) {
            return;
        }
        float r = e.getRed();
        float g = e.getGreen();
        float b = e.getBlue();
        float gray = (r + g + b) / 3.0f;
        float amt = (float)((double)0.18f * eI3);
        r = Mth.m_14179_((float)amt, (float)r, (float)(gray * 0.95f));
        g = Mth.m_14179_((float)amt, (float)g, (float)(gray * 0.95f));
        b = Mth.m_14179_((float)amt, (float)b, (float)(gray * 0.95f));
        e.setRed(r);
        e.setGreen(g);
        e.setBlue(b);
    }

    @SubscribeEvent
    public static void onHud(RenderGuiEvent.Post e) {
        double eI4 = GlitchFX.effectiveIntensity();
        if (eI4 <= 0.001) {
            return;
        }
        GuiGraphics gg = e.getGuiGraphics();
        int w = e.getWindow().m_85445_();
        int h = e.getWindow().m_85446_();
        int border = (int)Mth.m_14179_((float)((float)eI4), (float)2.0f, (float)12.0f);
        int alphaVig = (int)Mth.m_14008_((double)(170.0 * eI4), (double)18.0, (double)140.0);
        int col = alphaVig << 24;
        gg.m_280509_(0, 0, w, border, col);
        gg.m_280509_(0, h - border, w, h, col);
        gg.m_280509_(0, border, border, h - border, col);
        gg.m_280509_(w - border, border, w, h - border, col);
        GlitchFX.drawColorGrade(gg, w, h, eI4);
        int alphaScan = (int)Mth.m_14008_((double)(60.0 * eI4), (double)10.0, (double)45.0);
        int colScan = alphaScan << 24 | 0xFFFFFF;
        int spacing = 3;
        for (int y = 0; y < h; y += spacing) {
            gg.m_280509_(0, y, w, y + 1, colScan);
        }
        int count = (int)(40.0 + eI4 * 150.0);
        int alphaN = (int)Mth.m_14008_((double)(95.0 * eI4), (double)20.0, (double)75.0);
        for (int i = 0; i < count; ++i) {
            int nx = RNG.nextInt(w);
            int ny = RNG.nextInt(h);
            int size = 1 + RNG.nextInt(2);
            int shade = RNG.nextInt(64) + 160 & 0xFF;
            int c = alphaN << 24 | shade << 16 | shade << 8 | shade;
            gg.m_280509_(nx, ny, Math.min(w, nx + size), Math.min(h, ny + size), c);
        }
        GlitchFX.drawDigitalArtifacts(gg, w, h, eI4);
        if (RNG.nextDouble() < 0.1 * eI4) {
            int gh = 3 + RNG.nextInt(5);
            int gy = RNG.nextInt(h - gh);
            int a = (int)Mth.m_14008_((double)(120.0 * eI4), (double)30.0, (double)90.0);
            int c1 = a << 24 | 0xFF0000;
            int c2 = a << 24 | 0xFF00;
            gg.m_280509_(0, gy, w, gy + gh, c1);
            gg.m_280509_(0, gy + 1, w, gy + gh + 1, c2);
        }
        GlitchFX.drawScreenTear(gg, w, h, eI4);
        GlitchFX.drawChromaticAberration(gg, w, h, eI4);
    }

    private static void ensureHum() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        if (HUM == null || HUM.m_7801_()) {
            HUM = new GlitchHumSound();
            mc.m_91106_().m_120367_((SoundInstance)HUM);
        }
    }

    public static void onApparitionSpawn() {
        spottingActive = false;
        episodeGlitchAllowed = false;
        firstSpottingHandled = false;
        prevTarget = 0.0;
        if (HUM != null) {
            HUM.setTarget(0.0f);
        }
    }

    public static void forceGlitch(int durationTicks) {
        GlitchFX.forceGlitch(durationTicks, 1.0f);
    }

    public static void forceGlitch(int durationTicks, float level) {
        forcedGlitchTicks = Math.max(forcedGlitchTicks, Math.max(1, durationTicks));
        forcedGlitchLevel = Mth.m_14036_((float)level, (float)0.0f, (float)1.0f);
        firstSpottingHandled = true;
    }

    private static void drawChromaticAberration(GuiGraphics gg, int w, int h, double effIntensity) {
        int steps = (int)(2.0 + effIntensity * 6.0);
        for (int i = 0; i < steps; ++i) {
            float f = (float)(i + 1) / (float)steps;
            int a = (int)Mth.m_14008_((double)(120.0 * effIntensity * (double)(1.0f - f * 0.5f)), (double)8.0, (double)60.0);
            int red = a << 24 | 0xFF0000;
            gg.m_280509_(i, 0, i + 1, h, red);
            int cyan = a << 24 | 0xFFFF;
            gg.m_280509_(w - i - 1, 0, w - i, h, cyan);
        }
    }

    private static void drawColorGrade(GuiGraphics gg, int w, int h, double effIntensity) {
        if (effIntensity <= 0.05) {
            return;
        }
        float pulse = postFxPulse;
        int a = (int)Mth.m_14008_((double)(90.0 * effIntensity * (double)(0.6f + 0.4f * pulse)), (double)10.0, (double)110.0);
        int coldTint = a << 24 | 0x303A6B;
        int warmTint = (int)Mth.m_14036_((float)((float)a * 0.65f), (float)6.0f, (float)80.0f) << 24 | 0x6B3A30;
        gg.m_280024_(0, 0, w, h / 2, coldTint, coldTint & 0xFFFFFF);
        gg.m_280024_(0, h / 2, w, h, warmTint, warmTint & 0xFFFFFF);
        int centerPulse = (int)Mth.m_14008_((double)(70.0 * effIntensity * (double)(0.4f + 0.6f * pulse)), (double)8.0, (double)95.0);
        int centerCol = centerPulse << 24 | 0x24181F;
        int inset = (int)Mth.m_14008_((double)(18.0 * effIntensity), (double)4.0, (double)26.0);
        gg.m_280509_(inset, inset, w - inset, h - inset, centerCol);
    }

    private static void drawDigitalArtifacts(GuiGraphics gg, int w, int h, double effIntensity) {
        if (effIntensity <= 0.12) {
            return;
        }
        int shards = (int)(4.0 + effIntensity * 18.0);
        for (int i = 0; i < shards; ++i) {
            if (RNG.nextDouble() > effIntensity) continue;
            int sw = 6 + RNG.nextInt((int)(20.0 + effIntensity * 60.0));
            int sh = 3 + RNG.nextInt(10);
            int sx = RNG.nextInt(Math.max(1, w - sw));
            int sy = RNG.nextInt(Math.max(1, h - sh));
            int hueShift = RNG.nextInt(3);
            int alpha = (int)Mth.m_14008_((double)(110.0 * effIntensity), (double)25.0, (double)140.0);
            int color = hueShift == 0 ? alpha << 24 | 0xFFAF00 : (hueShift == 1 ? alpha << 24 | 0xC6FF : alpha << 24 | 0xFF2A77);
            gg.m_280509_(sx, sy, sx + sw, sy + sh, color);
            int borderAlpha = (int)((float)alpha * 0.6f);
            int border = borderAlpha << 24 | 0xFFFFFF;
            gg.m_280509_(sx, sy, sx + sw, sy + 1, border);
            gg.m_280509_(sx, sy, sx + 1, sy + sh, border);
        }
    }

    private static void drawScreenTear(GuiGraphics gg, int w, int h, double effIntensity) {
        if (tearOffset == 0.0f || effIntensity <= 0.18) {
            return;
        }
        int height = Math.max(4, (int)((float)h * tearHeightNorm));
        int maxY = Math.max(1, h - height - 2);
        int y = Math.min(maxY, (int)(tearYNorm * (float)maxY));
        float strength = (float)(Math.sin((double)System.nanoTime() * 1.0E-8 + t) * 0.5 + 0.5);
        int offset = (int)(tearOffset * strength);
        int alpha = (int)Mth.m_14008_((double)(150.0 * effIntensity), (double)40.0, (double)200.0);
        int overlay = alpha << 24 | 0;
        gg.m_280509_(0, y, w, y + height, overlay);
        int scanAlpha = (int)Mth.m_14008_((double)((double)alpha * 0.6), (double)18.0, (double)150.0);
        int glitchCol1 = scanAlpha << 24 | 0xFF0044;
        int glitchCol2 = scanAlpha << 24 | 0xFFAA;
        int mid = y + height / 2;
        gg.m_280509_(0, mid - 1, w, mid + 1, glitchCol1);
        gg.m_280509_(0, mid + 1, w, mid + 2, glitchCol2);
        int blocks = 6 + RNG.nextInt(6);
        for (int i = 0; i < blocks; ++i) {
            int bw = 10 + RNG.nextInt(Math.max(10, (int)((double)w * 0.25 * effIntensity)));
            int bx = Mth.m_14045_((int)(offset + RNG.nextInt(Math.max(1, w - bw))), (int)(-w), (int)(w * 2));
            int by = y + RNG.nextInt(Math.max(1, height - 2));
            int ba = (int)Mth.m_14036_((float)((float)alpha * 0.8f), (float)20.0f, (float)180.0f);
            int col = ba << 24 | 0xFFFFFF;
            gg.m_280509_(bx, by, bx + bw, by + 1 + RNG.nextInt(2), col);
        }
    }

    private static double effectiveIntensity() {
        if (forcedGlitchTicks > 0) {
            return Math.max(intensity, (double)forcedGlitchLevel);
        }
        return episodeGlitchAllowed ? intensity : 0.0;
    }

    static {
        firstSpottingHandled = false;
        episodeGlitchAllowed = false;
        spottingActive = false;
        prevTarget = 0.0;
        forcedGlitchTicks = 0;
        forcedGlitchLevel = 0.0f;
    }
}

