/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.client.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tasuposed.theforgotten.network.S2CTextureGlitchPacket;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="theforgotten", value={Dist.CLIENT})
public final class TextureDistortionFX {
    private static final ResourceLocation NOISE_TEX = new ResourceLocation("minecraft", "textures/misc/portal.png");
    private static final List<Cluster> CLUSTERS = new ArrayList<Cluster>();
    private static final Random RNG = new Random();

    private TextureDistortionFX() {
    }

    public static void push(List<S2CTextureGlitchPacket.Sample> samples, int durationTicks, float intensity) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        if (level == null || samples.isEmpty()) {
            return;
        }
        long now = level.m_46467_();
        Cluster cluster = new Cluster();
        cluster.startTick = now;
        cluster.duration = Math.max(4, durationTicks);
        cluster.endTick = cluster.startTick + (long)cluster.duration;
        cluster.intensity = Mth.m_14036_((float)intensity, (float)0.05f, (float)1.6f);
        for (S2CTextureGlitchPacket.Sample s : samples) {
            cluster.samples.add(new ClientSample(s, RNG.nextFloat() * (float)Math.PI * 2.0f, RNG.nextFloat() * (float)Math.PI * 2.0f));
        }
        CLUSTERS.add(cluster);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            CLUSTERS.clear();
            return;
        }
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            CLUSTERS.clear();
            return;
        }
        long time = level.m_46467_();
        Iterator<Cluster> it = CLUSTERS.iterator();
        while (it.hasNext()) {
            Cluster c = it.next();
            if (time < c.endTick) continue;
            it.remove();
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (CLUSTERS.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        if (level == null || mc.f_91074_ == null) {
            return;
        }
        Camera cam = event.getCamera();
        double camX = cam.m_90583_().f_82479_;
        double camY = cam.m_90583_().f_82480_;
        double camZ = cam.m_90583_().f_82481_;
        float partial = event.getPartialTick();
        long baseTick = level.m_46467_();
        PoseStack pose = event.getPoseStack();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NOISE_TEX);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        for (Cluster cluster : CLUSTERS) {
            float life = (float)baseTick + partial - (float)cluster.startTick;
            float progress = life / (float)cluster.duration;
            if (progress >= 1.0f) continue;
            float fadeOut = 1.0f - Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
            float fade = (float)Math.pow(fadeOut, 1.3);
            float clusterIntensity = cluster.intensity * fade;
            for (ClientSample sample : cluster.samples) {
                float t = life / 20.0f;
                float spin = sample.spinPhase + sample.spinSpeed * t;
                float noise = sample.noisePhase + sample.noiseSpeed * life * 0.05f;
                float flicker = 0.65f + 0.35f * Mth.m_14031_((float)(noise * 4.5f));
                float alpha = sample.alphaScale * clusterIntensity * flicker;
                if (alpha <= 0.02f) continue;
                float uOff = Mth.m_14187_((float)(noise * 1.1f));
                float vOff = Mth.m_14187_((float)(noise * 0.77f));
                float uSpan = 0.85f + 0.15f * Mth.m_14031_((float)(noise * 3.1f));
                float vSpan = 0.85f + 0.15f * Mth.m_14089_((float)(noise * 2.3f));
                float yaw = sample.yaw + spin * 35.0f;
                float pitch = sample.pitch + Mth.m_14031_((float)(noise * 1.6f)) * 6.0f;
                pose.m_85836_();
                pose.m_85837_(sample.position.f_82479_ - camX, sample.position.f_82480_ - camY, sample.position.f_82481_ - camZ);
                pose.m_252781_(Axis.f_252436_.m_252977_(yaw));
                pose.m_252781_(Axis.f_252529_.m_252977_(pitch));
                pose.m_85841_(sample.width, sample.height, sample.width);
                Matrix4f mat = pose.m_85850_().m_252922_();
                float half = 0.5f;
                int r = sample.color >> 16 & 0xFF;
                int g = sample.color >> 8 & 0xFF;
                int b = sample.color & 0xFF;
                float rf = (float)r / 255.0f;
                float gf = (float)g / 255.0f;
                float bf = (float)b / 255.0f;
                float u0 = uOff;
                float u1 = uOff + uSpan;
                float v0 = vOff;
                float v1 = vOff + vSpan;
                buf.m_252986_(mat, -half, -half, 0.0f).m_7421_(u0, v1).m_85950_(rf, gf, bf, alpha).m_5752_();
                buf.m_252986_(mat, -half, half, 0.0f).m_7421_(u0, v0).m_85950_(rf, gf, bf, alpha).m_5752_();
                buf.m_252986_(mat, half, half, 0.0f).m_7421_(u1, v0).m_85950_(rf, gf, bf, alpha).m_5752_();
                buf.m_252986_(mat, half, -half, 0.0f).m_7421_(u1, v1).m_85950_(rf, gf, bf, alpha).m_5752_();
                pose.m_85849_();
            }
        }
        tess.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    @SubscribeEvent
    public static void onHud(RenderGuiEvent.Post event) {
        if (CLUSTERS.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        long time = level.m_46467_();
        float strength = 0.0f;
        for (Cluster cluster : CLUSTERS) {
            float progress = (float)(time - cluster.startTick) / (float)cluster.duration;
            float fade = 1.0f - Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
            strength = Math.max(strength, cluster.intensity * fade);
        }
        if (strength <= 0.01f) {
            return;
        }
        GuiGraphics gg = event.getGuiGraphics();
        int w = event.getWindow().m_85445_();
        int h = event.getWindow().m_85446_();
        int bands = 3 + (int)(strength * 10.0f);
        for (int i = 0; i < bands; ++i) {
            int bandHeight = 4 + RNG.nextInt(6);
            int y = RNG.nextInt(Math.max(1, h - bandHeight));
            float shift = (RNG.nextFloat() - 0.5f) * strength * 40.0f;
            int alpha = (int)Mth.m_14036_((float)(45.0f + strength * 140.0f), (float)25.0f, (float)160.0f);
            int color = alpha << 24 | 0xFFFFFF;
            gg.m_280411_(NOISE_TEX, (int)shift, y, w, bandHeight, 0.0f, 0.0f, w, bandHeight, 256, 256);
            gg.m_280509_(0, y, w, y + bandHeight / 2, color);
        }
        int shards = 12 + (int)(strength * 28.0f);
        for (int i = 0; i < shards; ++i) {
            int x = RNG.nextInt(w);
            int y = RNG.nextInt(h);
            int size = 2 + RNG.nextInt(3);
            int alpha = (int)Mth.m_14036_((float)(40.0f + strength * 100.0f), (float)35.0f, (float)180.0f);
            int shade = 180 + RNG.nextInt(75);
            int color = alpha << 24 | shade << 16 | shade << 8 | shade;
            gg.m_280509_(x, y, Math.min(w, x + size), Math.min(h, y + size), color);
        }
    }

    private static class Cluster {
        long startTick;
        long endTick;
        int duration;
        float intensity;
        final List<ClientSample> samples = new ArrayList<ClientSample>();

        private Cluster() {
        }
    }

    private static class ClientSample {
        final Vec3 position;
        final float yaw;
        final float pitch;
        final float width;
        final float height;
        final int color;
        final float alphaScale;
        final float noiseSpeed;
        final float spinSpeed;
        final float noisePhase;
        final float spinPhase;

        ClientSample(S2CTextureGlitchPacket.Sample sample, float noisePhase, float spinPhase) {
            this.position = sample.position();
            this.yaw = sample.yaw();
            this.pitch = sample.pitch();
            this.width = sample.width();
            this.height = sample.height();
            this.color = sample.color();
            this.alphaScale = sample.alphaScale();
            this.noiseSpeed = sample.noiseSpeed();
            this.spinSpeed = sample.spinSpeed();
            this.noisePhase = noisePhase;
            this.spinPhase = spinPhase;
        }
    }
}

