/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.tasuposed.theforgotten.Config;
import net.tasuposed.theforgotten.data.Pools;
import net.tasuposed.theforgotten.init.ModSounds;
import net.tasuposed.theforgotten.network.NetworkHandler;
import net.tasuposed.theforgotten.network.S2CPositionalSoundPacket;
import net.tasuposed.theforgotten.server.Managers;
import net.tasuposed.theforgotten.server.MicroStructureManager;
import net.tasuposed.theforgotten.server.RuntimeTuning;
import net.tasuposed.theforgotten.server.ServerEvents;
import net.tasuposed.theforgotten.server.TensionManager;
import net.tasuposed.theforgotten.server.WorldSilenceData;

public final class DebugCommands {
    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tfdebug").requires(src -> src.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ramp").executes(ctx -> DebugCommands.rampShow((CommandSourceStack)ctx.getSource()))).then(Commands.m_82127_((String)"show").executes(ctx -> DebugCommands.rampShow((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"start").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0, (int)600)).executes(ctx -> DebugCommands.rampStart((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), null))).then(Commands.m_82129_((String)"startScale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> DebugCommands.rampStart((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"startScale"))))))).then(Commands.m_82127_((String)"end").executes(ctx -> DebugCommands.rampEnd((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ambient").executes(ctx -> DebugCommands.ambientRandom((CommandSourceStack)ctx.getSource()))).then(Commands.m_82127_((String)"random").executes(ctx -> DebugCommands.ambientRandom((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"here").then(Commands.m_82129_((String)"sound", (ArgumentType)StringArgumentType.string()).executes(ctx -> DebugCommands.ambientHere((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"sound")))))).then(Commands.m_82127_((String)"breaks").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)8)).executes(ctx -> DebugCommands.ambientBreaks((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")))))).then(Commands.m_82127_((String)"steps").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)3, (int)16)).executes(ctx -> DebugCommands.ambientSteps((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), false))).then(Commands.m_82127_((String)"sprint").executes(ctx -> DebugCommands.ambientSteps((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), true)))))).then(Commands.m_82127_((String)"breath").executes(ctx -> DebugCommands.ambientBreath((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"mobassault").executes(ctx -> DebugCommands.ambientMobAssault((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"textureblink").executes(ctx -> DebugCommands.ambientTextureBlink((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"textureglitch").executes(ctx -> DebugCommands.ambientTextureGlitch((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"torchflicker").executes(ctx -> DebugCommands.ambientTorchFlicker((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"surface").executes(ctx -> DebugCommands.ambientSurface((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"pool").then(Commands.m_82129_((String)"sound", (ArgumentType)StringArgumentType.string()).executes(ctx -> DebugCommands.ambientPool((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"sound"))))))).then(Commands.m_82127_((String)"sleep").then(Commands.m_82127_((String)"fright").executes(ctx -> DebugCommands.sleepFright((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"event").then(Commands.m_82127_((String)"lan").executes(ctx -> DebugCommands.triggerLan((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"fakejoin").executes(ctx -> DebugCommands.triggerFakeJoin((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hunt").then(Commands.m_82127_((String)"trigger").executes(ctx -> DebugCommands.huntTrigger((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"status").executes(ctx -> DebugCommands.huntStatus((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"cancel").executes(ctx -> DebugCommands.huntCancel((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"cooldown").executes(ctx -> DebugCommands.huntCooldown((CommandSourceStack)ctx.getSource())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"silence").executes(ctx -> DebugCommands.showSilence((CommandSourceStack)ctx.getSource()))).then(Commands.m_82127_((String)"start").then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)864000)).executes(ctx -> DebugCommands.startSilence((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds")))))).then(Commands.m_82127_((String)"end").executes(ctx -> DebugCommands.endSilence((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lure").then(Commands.m_82127_((String)"tp").executes(ctx -> DebugCommands.tpToLure((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"entrance").executes(ctx -> DebugCommands.tpNearLureEntrance((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"button").executes(ctx -> DebugCommands.placeTrialButton((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"exit").executes(ctx -> DebugCommands.placeExitPad((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"apparition").executes(ctx -> DebugCommands.spawnApparition((CommandSourceStack)ctx.getSource()))).then(Commands.m_82127_((String)"mimic").executes(ctx -> DebugCommands.spawnApparitionMimic((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"charge").executes(ctx -> DebugCommands.spawnApparitionCharge((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"behindturn").executes(ctx -> DebugCommands.spawnApparitionBehindTurn((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"whisper").executes(ctx -> DebugCommands.apparitionWhisper((CommandSourceStack)ctx.getSource()))))).then(Commands.m_82127_((String)"tormentor").then(Commands.m_82127_((String)"spawn").executes(ctx -> DebugCommands.spawnTormentor((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"structure").executes(ctx -> DebugCommands.spawnStructure((CommandSourceStack)ctx.getSource()))).then(Commands.m_82127_((String)"torch").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.TORCH)))).then(Commands.m_82127_((String)"crafting").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.CRAFTING_TABLE)))).then(Commands.m_82127_((String)"phantomblocks").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.PHANTOM_BLOCKS)))).then(Commands.m_82127_((String)"chest").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.CHEST_EMPTY)))).then(Commands.m_82127_((String)"furnace").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.FURNACE)))).then(Commands.m_82127_((String)"ladder").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.LADDER)))).then(Commands.m_82127_((String)"redstonetorch").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.REDSTONE_TORCH)))).then(Commands.m_82127_((String)"ritual").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.REDSTONE_RITUAL)))).then(Commands.m_82127_((String)"sign").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.SIGN)))).then(Commands.m_82127_((String)"cross").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.CROSS)))).then(Commands.m_82127_((String)"shear").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.SHEAR_WALL)))).then(Commands.m_82127_((String)"shave").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.OFFSET_PATCH)))).then(Commands.m_82127_((String)"fissure").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.VOID_FISSURE)))).then(Commands.m_82127_((String)"bedrock").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.BEDROCK_BLOOM)))).then(Commands.m_82127_((String)"tree").executes(ctx -> DebugCommands.placeStructure((CommandSourceStack)ctx.getSource(), MicroStructureManager.Variant.TREE_GHOST))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chance").then(Commands.m_82127_((String)"ambient").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> DebugCommands.setAmbientChance((CommandSourceStack)ctx.getSource(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value")))))).then(Commands.m_82127_((String)"apparition").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> DebugCommands.setApparitionChance((CommandSourceStack)ctx.getSource(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value")))))).then(Commands.m_82127_((String)"mimic").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> DebugCommands.setMimicChance((CommandSourceStack)ctx.getSource(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value")))))).then(Commands.m_82127_((String)"reset").executes(ctx -> DebugCommands.resetChances((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"tension").then(Commands.m_82127_((String)"show").executes(ctx -> DebugCommands.showTension((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"poke").executes(ctx -> DebugCommands.pokeTension((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"interval").then(Commands.m_82127_((String)"rolls").then(Commands.m_82129_((String)"min", (ArgumentType)IntegerArgumentType.integer((int)1, (int)600)).then(Commands.m_82129_((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1, (int)600)).executes(ctx -> DebugCommands.setRollInterval((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"min"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"max"))))))).then(Commands.m_82127_((String)"reset").executes(ctx -> DebugCommands.resetRollInterval((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cooldown").then(Commands.m_82127_((String)"structure").then(Commands.m_82129_((String)"min", (ArgumentType)IntegerArgumentType.integer((int)1, (int)7200)).then(Commands.m_82129_((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1, (int)7200)).executes(ctx -> DebugCommands.setStructureCooldown((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"min"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"max"))))))).then(Commands.m_82127_((String)"reset").executes(ctx -> DebugCommands.resetStructureCooldown((CommandSourceStack)ctx.getSource())))));
    }

    private static int sleepFright(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        ServerEvents.forceSleepFright(sp);
        src.m_288197_(() -> Component.m_237113_((String)"Next sleep will trigger a fright."), true);
        return 1;
    }

    private static int ambientMobAssault(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.AMBIENT == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Ambient manager not initialized."));
            return 0;
        }
        boolean ok = Managers.AMBIENT.debugMobAssault(sp);
        src.m_288197_(() -> Component.m_237113_((String)(ok ? "Triggered mob assault." : "No valid mob found nearby.")), true);
        return ok ? 1 : 0;
    }

    private static int ambientTextureBlink(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.AMBIENT == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Ambient manager not initialized."));
            return 0;
        }
        boolean ok = Managers.AMBIENT.debugTextureBlink(sp);
        src.m_288197_(() -> Component.m_237113_((String)(ok ? "Triggered texture blink." : "Could not hide player (already invisible).")), true);
        return ok ? 1 : 0;
    }

    private static int ambientTorchFlicker(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.AMBIENT == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Ambient manager not initialized."));
            return 0;
        }
        boolean ok = Managers.AMBIENT.debugTorchFlicker(sp);
        src.m_288197_(() -> Component.m_237113_((String)(ok ? "Triggered torch flicker." : "No torches found nearby.")), true);
        return ok ? 1 : 0;
    }

    private static int ambientTextureGlitch(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.AMBIENT == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Ambient manager not initialized."));
            return 0;
        }
        boolean ok = Managers.AMBIENT.debugTextureGlitch(sp);
        src.m_288197_(() -> Component.m_237113_((String)(ok ? "Triggered texture glitch." : "No suitable samples generated.")), true);
        return ok ? 1 : 0;
    }

    private static int rampShow(CommandSourceStack src) {
        MinecraftServer server = src.m_81377_();
        if (server == null) {
            src.m_81352_((Component)Component.m_237113_((String)"No server."));
            return 0;
        }
        long now = server.m_129921_();
        boolean active = ServerEvents.isRampActive(now);
        long start = ServerEvents.getRampStartTick();
        long until = ServerEvents.getRampUntilTick();
        double scale = ServerEvents.getCurrentRampScale(now);
        Double ovr = ServerEvents.getRampStartScaleOverride();
        src.m_288197_(() -> Component.m_237113_((String)String.format("Ramp: %s scale=%.2f startTick=%d untilTick=%d override=%s", active ? "ACTIVE" : "INACTIVE", scale, start, until, String.valueOf(ovr))), false);
        return 1;
    }

    private static int rampStart(CommandSourceStack src, int seconds, Double startScaleOrNull) {
        MinecraftServer server = src.m_81377_();
        if (server == null) {
            src.m_81352_((Component)Component.m_237113_((String)"No server."));
            return 0;
        }
        ServerEvents.forceStartRamp(server, seconds, startScaleOrNull);
        src.m_288197_(() -> Component.m_237113_((String)("Ramp started for " + seconds + "s" + (String)(startScaleOrNull != null ? " startScale=" + startScaleOrNull : "") + ".")), true);
        return 1;
    }

    private static int rampEnd(CommandSourceStack src) {
        ServerEvents.forceEndRamp();
        src.m_288197_(() -> Component.m_237113_((String)"Ramp ended."), true);
        return 1;
    }

    private static int startSilence(CommandSourceStack src, int seconds) {
        MinecraftServer server = src.m_81377_();
        if (server == null) {
            src.m_81352_((Component)Component.m_237113_((String)"No server."));
            return 0;
        }
        if (!((Boolean)Config.ENABLE_WORLD_SILENCE.get()).booleanValue()) {
            src.m_81352_((Component)Component.m_237113_((String)"World silence disabled in config."));
            return 0;
        }
        WorldSilenceData d = WorldSilenceData.get(server);
        if (d == null) {
            src.m_81352_((Component)Component.m_237113_((String)"No silence data."));
            return 0;
        }
        long ticks = (long)seconds * 20L;
        d.startFor(server, ticks);
        src.m_288197_(() -> Component.m_237113_((String)("World silence started for " + seconds + "s.")), true);
        return 1;
    }

    private static int endSilence(CommandSourceStack src) {
        MinecraftServer server = src.m_81377_();
        if (server == null) {
            src.m_81352_((Component)Component.m_237113_((String)"No server."));
            return 0;
        }
        if (!((Boolean)Config.ENABLE_WORLD_SILENCE.get()).booleanValue()) {
            src.m_81352_((Component)Component.m_237113_((String)"World silence disabled in config."));
            return 0;
        }
        WorldSilenceData d = WorldSilenceData.get(server);
        if (d == null) {
            src.m_81352_((Component)Component.m_237113_((String)"No silence data."));
            return 0;
        }
        d.endNow(server);
        src.m_288197_(() -> Component.m_237113_((String)"World silence ended."), true);
        return 1;
    }

    private static int showSilence(CommandSourceStack src) {
        MinecraftServer server = src.m_81377_();
        if (server == null) {
            src.m_81352_((Component)Component.m_237113_((String)"No server."));
            return 0;
        }
        if (!((Boolean)Config.ENABLE_WORLD_SILENCE.get()).booleanValue()) {
            src.m_288197_(() -> Component.m_237113_((String)"World silence: DISABLED in config."), false);
            return 1;
        }
        WorldSilenceData d = WorldSilenceData.get(server);
        boolean active = d != null && d.isSilenceActive(server);
        src.m_288197_(() -> Component.m_237113_((String)("World silence: " + (active ? "ACTIVE" : "INACTIVE"))), false);
        return 1;
    }

    private static int spawnTormentor(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.TORMENTOR == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Tormentor manager not initialized."));
            return 0;
        }
        Managers.TORMENTOR.forceSpawnFor(sp, sp.f_8924_.m_129921_());
        src.m_288197_(() -> Component.m_237113_((String)"Tormentor spawned (caves only)."), true);
        return 1;
    }

    private static int apparitionWhisper(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.APPARITIONS == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Apparition manager not initialized."));
            return 0;
        }
        Managers.APPARITIONS.debugWhisper(sp);
        src.m_288197_(() -> Component.m_237113_((String)"Whisper sent."), true);
        return 1;
    }

    private static int placeAnomaly(CommandSourceStack src, MicroStructureManager.Variant v) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.MICRO == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Micro manager not initialized."));
            return 0;
        }
        boolean ok = Managers.MICRO.debugPlaceVariant(sp, v);
        if (ok) {
            src.m_288197_(() -> Component.m_237113_((String)("Anomaly placed: " + String.valueOf((Object)v))), true);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)"Failed to place anomaly here."));
        return 0;
    }

    private static int placeStructure(CommandSourceStack src, MicroStructureManager.Variant v) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.MICRO == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Micro manager not initialized."));
            return 0;
        }
        boolean ok = Managers.MICRO.debugPlaceVariant(sp, v);
        if (ok) {
            src.m_288197_(() -> Component.m_237113_((String)("Structure placed: " + String.valueOf((Object)v))), true);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)"Failed to place structure here."));
        return 0;
    }

    private static int triggerLan(CommandSourceStack src) {
        MinecraftServer server = src.m_81377_();
        if (server == null) {
            src.m_81352_((Component)Component.m_237113_((String)"No server."));
            return 0;
        }
        ServerEvents.debugOpenLan(server);
        src.m_288197_(() -> Component.m_237113_((String)"LAN open triggered."), true);
        return 1;
    }

    private static int triggerFakeJoin(CommandSourceStack src) {
        MinecraftServer server = src.m_81377_();
        if (server == null) {
            src.m_81352_((Component)Component.m_237113_((String)"No server."));
            return 0;
        }
        ServerEvents.debugFakeJoinSoon(server);
        src.m_288197_(() -> Component.m_237113_((String)"Fake join scheduled."), true);
        return 1;
    }

    private static int huntTrigger(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        boolean ok = ServerEvents.triggerHuntEvent(sp);
        if (ok) {
            src.m_288197_(() -> Component.m_237113_((String)"Hunt event triggered."), true);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)"Hunt already active or on cooldown."));
        return 0;
    }

    private static int huntStatus(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Integer step = ServerEvents.getHuntEventStep(sp);
        long until = ServerEvents.huntEventTimeUntilNext(sp);
        long cd = ServerEvents.huntEventCooldownRemaining(sp);
        boolean active = ServerEvents.isHuntEventActive(sp);
        MutableComponent msg = Component.m_237113_((String)String.format("Hunt status: %s step=%s nextIn=%ds cooldown=%ds", active ? "ACTIVE" : (cd > 0L ? "COOLDOWN" : "IDLE"), step == null ? "-" : step.toString(), until / 20L, cd / 20L));
        src.m_288197_(() -> DebugCommands.lambda$huntStatus$84((Component)msg), false);
        return 1;
    }

    private static int huntCancel(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        boolean had = ServerEvents.forceEndHunt(sp, false);
        if (had) {
            src.m_288197_(() -> Component.m_237113_((String)"Hunt event canceled."), true);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)"No hunt active."));
        return 0;
    }

    private static int huntCooldown(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        long remaining = ServerEvents.huntEventCooldownRemaining(sp);
        ServerEvents.forceEndHunt(sp, true);
        if (remaining > 0L) {
            src.m_288197_(() -> Component.m_237113_((String)"Hunt cooldown cleared."), true);
        } else {
            src.m_288197_(() -> Component.m_237113_((String)"Hunt was not on cooldown."), false);
        }
        return 1;
    }

    private static int placeExitPad(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.LUREDIM == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Lure manager not initialized."));
            return 0;
        }
        boolean ok = Managers.LUREDIM.debugPlaceExitNear(sp);
        if (ok) {
            src.m_288197_(() -> Component.m_237113_((String)"Placed an exit pad near you."), true);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)"Failed to place an exit here (not in lure or no valid spot)."));
        return 0;
    }

    private static int tpNearLureEntrance(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.MICRO == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Micro manager not initialized."));
            return 0;
        }
        ServerLevel ow = sp.f_8924_.m_129783_();
        if (ow == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Overworld not available."));
            return 0;
        }
        RandomSource r = sp.m_217043_();
        long now = sp.f_8924_.m_129921_();
        BlockPos near = sp.m_20183_();
        BlockPos target = Managers.MICRO.scheduleLureForNoteFor(sp, ow, near, r, now);
        if (target == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Failed to find or create lure target."));
            return 0;
        }
        double dx = (double)target.m_123341_() - sp.m_20185_();
        double dz = (double)target.m_123343_() - sp.m_20189_();
        double len = Math.max(1.0, Math.sqrt(dx * dx + dz * dz));
        double ux = dx / len;
        double uz = dz / len;
        int px = target.m_123341_() - (int)Math.round(ux * 12.0);
        int pz = target.m_123343_() - (int)Math.round(uz * 12.0);
        int py = ow.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, px, pz);
        float yaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
        sp.m_8999_(ow, (double)px + 0.5, (double)py + 0.1, (double)pz + 0.5, yaw, sp.m_146909_());
        src.m_288197_(() -> Component.m_237113_((String)("Teleported near current lure entrance at " + target.m_123341_() + ", " + target.m_123342_() + ", " + target.m_123343_())), true);
        return 1;
    }

    private static int placeTrialButton(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.LUREDIM == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Lure manager not initialized."));
            return 0;
        }
        boolean ok = Managers.LUREDIM.debugPlaceTrialButtonNear(sp);
        if (ok) {
            src.m_288197_(() -> Component.m_237113_((String)"Placed a trial button pedestal near you."), true);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)"Failed to place a trial button here (not in lure or no valid spot)."));
        return 0;
    }

    private static int tpToLure(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.LUREDIM == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Lure manager not initialized."));
            return 0;
        }
        Managers.LUREDIM.teleportToSpawnRoom(sp.f_8924_, sp);
        src.m_288197_(() -> Component.m_237113_((String)"Teleported to the lure spawn room."), true);
        return 1;
    }

    private static int consentAgree(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        ServerEvents.finishConsent(sp, true);
        return 1;
    }

    private static int consentDecline(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        ServerEvents.finishConsent(sp, false);
        return 1;
    }

    private static int spawnApparitionCharge(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Managers.APPARITIONS.spawnChargeTest(sp, sp.f_8924_.m_129921_());
        src.m_288197_(() -> Component.m_237113_((String)"Requested apparition charge test."), true);
        return 1;
    }

    private static int spawnApparitionBehindTurn(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.APPARITIONS == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Apparition manager not initialized."));
            return 0;
        }
        Managers.APPARITIONS.spawnBehindTurnTest(sp, sp.f_8924_.m_129921_());
        src.m_288197_(() -> Component.m_237113_((String)"Requested apparition behind-turn test."), true);
        return 1;
    }

    private static int playAmbient(CommandSourceStack src, String soundStr) {
        ResourceLocation chosen;
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (soundStr == null || soundStr.isBlank()) {
            List<ResourceLocation> pool = Pools.getAmbientSoundPool(sp);
            if (pool.isEmpty()) {
                src.m_81352_((Component)Component.m_237113_((String)"No ambient sounds available in pool."));
                return 0;
            }
            chosen = pool.get(sp.m_217043_().m_188503_(pool.size()));
        } else {
            ResourceLocation rl;
            Object raw = soundStr.trim().replace("(", "").replace(")", "");
            if (!((String)raw).contains(":")) {
                raw = "minecraft:" + (String)raw;
            }
            if ((rl = ResourceLocation.m_135820_((String)raw)) == null || !ForgeRegistries.SOUND_EVENTS.containsKey(rl)) {
                src.m_81352_((Component)Component.m_237113_((String)("Invalid or unknown sound id: " + (String)raw)));
                return 0;
            }
            chosen = rl;
        }
        Vec3 at = sp.m_20182_().m_82520_(0.0, (double)sp.m_20192_(), 0.0).m_82549_(sp.m_20154_().m_82490_(-4.0));
        float volume = 1.0f;
        float pitch = 1.0f;
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(chosen, at.f_82479_, at.f_82480_, at.f_82481_, volume, pitch, SoundSource.AMBIENT));
        src.m_288197_(() -> Component.m_237113_((String)("Played ambient sound " + String.valueOf(chosen))), true);
        return 1;
    }

    private static int ambientHere(CommandSourceStack src, String soundStr) {
        ResourceLocation rl;
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Object raw = soundStr.trim().replace("(", "").replace(")", "");
        if (!((String)raw).contains(":")) {
            raw = "theforgotten:" + (String)raw;
        }
        if ((rl = ResourceLocation.m_135820_((String)raw)) == null || !ForgeRegistries.SOUND_EVENTS.containsKey(rl)) {
            src.m_81352_((Component)Component.m_237113_((String)("Invalid or unknown sound id: " + (String)raw)));
            return 0;
        }
        Vec3 at = sp.m_20182_().m_82520_(0.0, (double)sp.m_20192_(), 0.0);
        float volume = 2.0f;
        float pitch = 1.0f;
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(rl, at.f_82479_, at.f_82480_, at.f_82481_, volume, pitch, SoundSource.MASTER));
        src.m_288197_(() -> Component.m_237113_((String)("Played HERE: " + String.valueOf(rl))), true);
        return 1;
    }

    private static int ambientRandom(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Managers.AMBIENT.debugRandomSequence(sp);
        src.m_288197_(() -> Component.m_237113_((String)"Queued random ambient sequence."), true);
        return 1;
    }

    private static int ambientBreaks(CommandSourceStack src, int count) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Managers.AMBIENT.playBlockBreakSequence(sp, Math.max(1, count));
        src.m_288197_(() -> Component.m_237113_((String)("Queued block break sequence x" + Math.max(1, count))), true);
        return 1;
    }

    private static int ambientSteps(CommandSourceStack src, int count, boolean sprint) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Managers.AMBIENT.playFootstepsSequence(sp, Math.max(3, count), sprint);
        src.m_288197_(() -> Component.m_237113_((String)("Queued footsteps sequence x" + Math.max(3, count) + (sprint ? " (sprint)" : ""))), true);
        return 1;
    }

    private static int ambientBreath(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        if (Managers.AMBIENT == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Ambient manager not initialized."));
            return 0;
        }
        ModSounds.AMBIENT_BREATH.get();
        Managers.AMBIENT.debugBreath(sp);
        src.m_288197_(() -> Component.m_237113_((String)"Queued breath behind you."), true);
        return 1;
    }

    private static int ambientSurface(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Managers.AMBIENT.playSurfaceMobAbove(sp);
        src.m_288197_(() -> Component.m_237113_((String)"Queued surface mob illusion above you."), true);
        return 1;
    }

    private static int ambientPool(CommandSourceStack src, String soundStr) {
        ResourceLocation rl;
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Object raw = soundStr.trim().replace("(", "").replace(")", "");
        if (!((String)raw).contains(":")) {
            raw = "minecraft:" + (String)raw;
        }
        if ((rl = ResourceLocation.m_135820_((String)raw)) == null || !ForgeRegistries.SOUND_EVENTS.containsKey(rl)) {
            src.m_81352_((Component)Component.m_237113_((String)("Invalid or unknown sound id: " + (String)raw)));
            return 0;
        }
        Managers.AMBIENT.playPoolAmbient(sp, rl);
        src.m_288197_(() -> Component.m_237113_((String)("Queued pool ambient: " + String.valueOf(rl))), true);
        return 1;
    }

    private static int spawnApparition(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Managers.APPARITIONS.spawnTest(sp, sp.f_8924_.m_129921_(), false);
        src.m_288197_(() -> Component.m_237113_((String)"Requested apparition test."), true);
        return 1;
    }

    private static int spawnApparitionMimic(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        Managers.APPARITIONS.spawnTest(sp, sp.f_8924_.m_129921_(), true);
        src.m_288197_(() -> Component.m_237113_((String)"Requested apparition mimic test."), true);
        return 1;
    }

    private static int spawnStructure(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        boolean ok = Managers.MICRO.trySpawnNear(sp, sp.f_8924_.m_129921_());
        src.m_288197_(() -> Component.m_237113_((String)(ok ? "Structure test spawned." : "No valid spot found.")), true);
        return ok ? 1 : 0;
    }

    private static int setAmbientChance(CommandSourceStack src, double value) {
        RuntimeTuning.setAmbientChance(value);
        src.m_288197_(() -> Component.m_237113_((String)("Ambient chance set to " + value)), true);
        return 1;
    }

    private static int setApparitionChance(CommandSourceStack src, double value) {
        RuntimeTuning.setApparitionChance(value);
        src.m_288197_(() -> Component.m_237113_((String)("Apparition chance set to " + value)), true);
        return 1;
    }

    private static int setMimicChance(CommandSourceStack src, double value) {
        RuntimeTuning.setApparitionMimicChance(value);
        src.m_288197_(() -> Component.m_237113_((String)("Mimic chance set to " + value)), true);
        return 1;
    }

    private static int resetChances(CommandSourceStack src) {
        RuntimeTuning.setAmbientChance(null);
        RuntimeTuning.setApparitionChance(null);
        RuntimeTuning.setApparitionMimicChance(null);
        src.m_288197_(() -> Component.m_237113_((String)"Chances reset to config."), true);
        return 1;
    }

    private static int setRollInterval(CommandSourceStack src, int min, int max) {
        if (max < min) {
            int t = min;
            min = max;
            max = t;
        }
        RuntimeTuning.setPlayerRollInterval(min, max);
        int fmin = min;
        int fmax = max;
        src.m_288197_(() -> Component.m_237113_((String)("Player roll interval set to " + fmin + ".." + fmax + " seconds")), true);
        return 1;
    }

    private static int resetRollInterval(CommandSourceStack src) {
        RuntimeTuning.setPlayerRollInterval(null, null);
        src.m_288197_(() -> Component.m_237113_((String)"Player roll interval reset to config."), true);
        return 1;
    }

    private static int setStructureCooldown(CommandSourceStack src, int min, int max) {
        if (max < min) {
            int t = min;
            min = max;
            max = t;
        }
        RuntimeTuning.setStructureCooldown(min, max);
        int fmin = min;
        int fmax = max;
        src.m_288197_(() -> Component.m_237113_((String)("Structure cooldown set to " + fmin + ".." + fmax + " seconds")), true);
        return 1;
    }

    private static int resetStructureCooldown(CommandSourceStack src) {
        RuntimeTuning.setStructureCooldown(null, null);
        src.m_288197_(() -> Component.m_237113_((String)"Structure cooldown reset to config."), true);
        return 1;
    }

    private static int showTension(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        TensionManager.TensionState st = Managers.TENSION.state((Player)sp);
        src.m_288197_(() -> Component.m_237113_((String)String.format("Tension=%.1f sustain=%s nextRoll=%d", st.tension, st.aboveMinSinceTick >= 0L, st.nextRollTick)), false);
        return 1;
    }

    private static int pokeTension(CommandSourceStack src) {
        ServerPlayer sp;
        try {
            sp = src.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            src.m_81352_((Component)Component.m_237113_((String)"Must be a player."));
            return 0;
        }
        TensionManager.TensionState st = Managers.TENSION.state((Player)sp);
        st.tension = Math.min(100.0, st.tension + 15.0);
        src.m_288197_(() -> Component.m_237113_((String)"Tension poked by +15"), true);
        return 1;
    }

    private DebugCommands() {
    }

    private static /* synthetic */ Component lambda$huntStatus$84(Component msg) {
        return msg;
    }
}

