/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;

public final class Pools {
    private static final Gson GSON = new Gson();
    private static List<ResourceLocation> AMBIENT_SOUNDS = new ArrayList<ResourceLocation>();
    private static List<String> SIGN_TEXTS = new ArrayList<String>();

    public static void registerReloaders(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)new PoolReloader());
    }

    private static void addOptionalDark(List<ResourceLocation> target) {
        ResourceLocation rl;
        String[] ids;
        for (String id : ids = new String[]{"dark1", "dark2", "dark3", "dark4"}) {
            rl = new ResourceLocation("minecraft", id);
            if (!ForgeRegistries.SOUND_EVENTS.containsKey(rl) || target.contains(rl)) continue;
            target.add(rl);
        }
        for (String id : ids) {
            rl = new ResourceLocation("theforgotten", "custom." + id);
            if (!ForgeRegistries.SOUND_EVENTS.containsKey(rl) || target.contains(rl)) continue;
            target.add(rl);
        }
    }

    public static List<ResourceLocation> getAmbientSoundPool(ServerPlayer ctx) {
        if (AMBIENT_SOUNDS.isEmpty()) {
            return Pools.defaultAmbient();
        }
        return AMBIENT_SOUNDS;
    }

    public static String randomSignText(Random r) {
        List<String> pool = SIGN_TEXTS.isEmpty() ? Pools.defaultSigns() : SIGN_TEXTS;
        return pool.get(r.nextInt(pool.size()));
    }

    public static String randomSignText(RandomSource r) {
        List<String> pool = SIGN_TEXTS.isEmpty() ? Pools.defaultSigns() : SIGN_TEXTS;
        return pool.get(r.m_188503_(pool.size()));
    }

    private static List<ResourceLocation> defaultAmbient() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(List.of(new ResourceLocation("minecraft", "ambient.cave"), new ResourceLocation("minecraft", "block.wooden_door.open"), new ResourceLocation("minecraft", "entity.villager.ambient"), new ResourceLocation("minecraft", "block.chest.open")));
        Pools.addOptionalDark(list);
        return list;
    }

    private static List<String> defaultSigns() {
        return List.of("he\u200be\u200bl\u200bl\u200bo\u200b", "i see you", "who's there", "turn around", "h\u0336e\u0336l\u0336l\u0336o\u0336", "do not look");
    }

    private Pools() {
    }

    private static class PoolReloader
    extends SimplePreparableReloadListener<Map<String, List<String>>> {
        private PoolReloader() {
        }

        protected Map<String, List<String>> prepare(ResourceManager manager, ProfilerFiller profiler) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put("ambient_sounds", new ArrayList());
            map.put("sign_texts", new ArrayList());
            this.readList(manager, "theforgotten:pools/ambient_sounds.json").ifPresent(list -> map.put("ambient_sounds", (List<String>)list));
            this.readList(manager, "theforgotten:pools/sign_texts.json").ifPresent(list -> map.put("sign_texts", (List<String>)list));
            return map;
        }

        protected void apply(Map<String, List<String>> prepared, ResourceManager manager, ProfilerFiller profiler) {
            AMBIENT_SOUNDS = new ArrayList<ResourceLocation>();
            for (String s : prepared.getOrDefault("ambient_sounds", List.of())) {
                try {
                    ResourceLocation rl = ResourceLocation.m_135820_((String)s);
                    if (rl == null) continue;
                    AMBIENT_SOUNDS.add(rl);
                }
                catch (Exception exception) {}
            }
            Pools.addOptionalDark(AMBIENT_SOUNDS);
            SIGN_TEXTS = new ArrayList<String>(prepared.getOrDefault("sign_texts", List.of()));
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private Optional<List<String>> readList(ResourceManager manager, String id) {
            try {
                ResourceLocation rl = new ResourceLocation(id);
                Optional opt = manager.m_213713_(rl);
                if (opt.isEmpty()) {
                    return Optional.empty();
                }
                try (InputStream in = ((Resource)opt.get()).m_215507_();){
                    Optional optional;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                        JsonElement el = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                        ArrayList<String> out = new ArrayList<String>();
                        if (el != null && el.isJsonObject()) {
                            JsonObject obj = el.getAsJsonObject();
                            JsonArray arr = obj.getAsJsonArray("values");
                            if (arr != null) {
                                for (JsonElement e : arr) {
                                    out.add(e.getAsString());
                                }
                            }
                        } else if (el != null && el.isJsonArray()) {
                            for (JsonElement e : el.getAsJsonArray()) {
                                out.add(e.getAsString());
                            }
                        }
                        optional = Optional.of(out);
                    }
                    return optional;
                }
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
    }
}

