/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.tasuposed.theforgotten.client.apparition.ClientApparitions;

public class S2CApparitionChargePacket {
    private final UUID apparitionId;
    private final int durationTicks;

    public S2CApparitionChargePacket(UUID id, int durationTicks) {
        this.apparitionId = id;
        this.durationTicks = Math.max(1, durationTicks);
    }

    public static void encode(S2CApparitionChargePacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.apparitionId);
        buf.m_130130_(msg.durationTicks);
    }

    public static S2CApparitionChargePacket decode(FriendlyByteBuf buf) {
        UUID id = buf.m_130259_();
        int dur = buf.m_130242_();
        return new S2CApparitionChargePacket(id, dur);
    }

    public static void handle(S2CApparitionChargePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> S2CApparitionChargePacket.handleClient(msg));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(S2CApparitionChargePacket msg) {
        ClientApparitions.startCharge(msg.apparitionId, msg.durationTicks);
    }
}

