/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.tasuposed.theforgotten.client.apparition.ClientApparitions;
import net.tasuposed.theforgotten.client.fx.GlitchFX;

public class S2CApparitionSpawnPacket {
    private final UUID apparitionId;
    private final Vec3 pos;
    private final float yRot;
    private final SkinType skinType;
    private final UUID mimicPlayer;
    private final String mimicName;
    private final int lifetimeTicks;

    public S2CApparitionSpawnPacket(UUID apparitionId, Vec3 pos, float yRot, SkinType skinType, UUID mimicPlayer, String mimicName, int lifetimeTicks) {
        this.apparitionId = apparitionId;
        this.pos = pos;
        this.yRot = yRot;
        this.skinType = skinType;
        this.mimicPlayer = mimicPlayer;
        this.mimicName = mimicName;
        this.lifetimeTicks = lifetimeTicks;
    }

    public static void encode(S2CApparitionSpawnPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.apparitionId);
        buf.writeDouble(msg.pos.f_82479_);
        buf.writeDouble(msg.pos.f_82480_);
        buf.writeDouble(msg.pos.f_82481_);
        buf.writeFloat(msg.yRot);
        buf.m_130068_((Enum)msg.skinType);
        buf.writeBoolean(msg.mimicPlayer != null);
        if (msg.mimicPlayer != null) {
            buf.m_130077_(msg.mimicPlayer);
            buf.writeBoolean(msg.mimicName != null);
            if (msg.mimicName != null) {
                buf.m_130072_(msg.mimicName, 64);
            }
        }
        buf.m_130130_(msg.lifetimeTicks);
    }

    public static S2CApparitionSpawnPacket decode(FriendlyByteBuf buf) {
        UUID id = buf.m_130259_();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float rot = buf.readFloat();
        SkinType type = (SkinType)buf.m_130066_(SkinType.class);
        UUID mimic = null;
        String mimicName = null;
        if (buf.readBoolean()) {
            mimic = buf.m_130259_();
            if (buf.readBoolean()) {
                mimicName = buf.m_130136_(64);
            }
        }
        int lifetime = buf.m_130242_();
        return new S2CApparitionSpawnPacket(id, new Vec3(x, y, z), rot, type, mimic, mimicName, lifetime);
    }

    public static void handle(S2CApparitionSpawnPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> S2CApparitionSpawnPacket.handleClient(msg));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(S2CApparitionSpawnPacket msg) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        ClientApparitions.spawn(msg.apparitionId, msg.pos, msg.yRot, msg.skinType.name(), msg.mimicPlayer, msg.mimicName, msg.lifetimeTicks);
        GlitchFX.onApparitionSpawn();
    }

    public static enum SkinType {
        STEVE,
        ALEX,
        SILHOUETTE,
        MIMIC;

    }
}

