/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.tasuposed.theforgotten.client.fx.GlitchFX;

public class S2CForceGlitchPacket {
    private final int durationTicks;
    private final float level;

    public S2CForceGlitchPacket(int durationTicks) {
        this(durationTicks, 1.0f);
    }

    public S2CForceGlitchPacket(int durationTicks, float level) {
        this.durationTicks = Math.max(1, durationTicks);
        this.level = Mth.m_14036_((float)level, (float)0.0f, (float)1.0f);
    }

    public static void encode(S2CForceGlitchPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.durationTicks);
        buf.writeFloat(msg.level);
    }

    public static S2CForceGlitchPacket decode(FriendlyByteBuf buf) {
        int d = buf.m_130242_();
        float lvl = buf.readFloat();
        return new S2CForceGlitchPacket(d, lvl);
    }

    public static void handle(S2CForceGlitchPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> S2CForceGlitchPacket.handleClient(msg));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(S2CForceGlitchPacket msg) {
        GlitchFX.forceGlitch(msg.durationTicks, msg.level);
    }
}

