/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class S2CPositionalSoundPacket {
    private final ResourceLocation soundId;
    private final double x;
    private final double y;
    private final double z;
    private final float volume;
    private final float pitch;
    private final SoundSource source;

    public S2CPositionalSoundPacket(ResourceLocation soundId, double x, double y, double z, float volume, float pitch, SoundSource source) {
        this.soundId = soundId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.volume = volume;
        this.pitch = pitch;
        this.source = source;
    }

    public static void encode(S2CPositionalSoundPacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.soundId);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeFloat(msg.volume);
        buf.writeFloat(msg.pitch);
        buf.m_130068_((Enum)msg.source);
    }

    public static S2CPositionalSoundPacket decode(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float vol = buf.readFloat();
        float pitch = buf.readFloat();
        SoundSource src = (SoundSource)buf.m_130066_(SoundSource.class);
        return new S2CPositionalSoundPacket(id, x, y, z, vol, pitch, src);
    }

    public static void handle(S2CPositionalSoundPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> S2CPositionalSoundPacket.handleClient(msg));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(S2CPositionalSoundPacket msg) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(msg.soundId);
        if (sound == null) {
            return;
        }
        level.m_7785_(msg.x, msg.y, msg.z, sound, msg.source, msg.volume, msg.pitch, false);
    }
}

