/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.tasuposed.theforgotten.client.fx.LoopingSounds;

public class S2CStartLoopSoundPacket {
    private final String channelId;
    private final ResourceLocation soundId;
    private final String sourceName;
    private final float volume;
    private final float pitch;
    private final boolean relative;
    private final double x;
    private final double y;
    private final double z;

    public S2CStartLoopSoundPacket(String channelId, ResourceLocation soundId, SoundSource source, boolean relative, double x, double y, double z, float volume, float pitch) {
        this.channelId = channelId;
        this.soundId = soundId;
        this.sourceName = source.name();
        this.relative = relative;
        this.x = x;
        this.y = y;
        this.z = z;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static void encode(S2CStartLoopSoundPacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.channelId);
        buf.m_130085_(msg.soundId);
        buf.m_130070_(msg.sourceName);
        buf.writeBoolean(msg.relative);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeFloat(msg.volume);
        buf.writeFloat(msg.pitch);
    }

    public static S2CStartLoopSoundPacket decode(FriendlyByteBuf buf) {
        String ch = buf.m_130277_();
        ResourceLocation sid = buf.m_130281_();
        String src = buf.m_130277_();
        boolean rel = buf.readBoolean();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float vol = buf.readFloat();
        float pit = buf.readFloat();
        return new S2CStartLoopSoundPacket(ch, sid, SoundSource.valueOf((String)src), rel, x, y, z, vol, pit);
    }

    public static void handle(S2CStartLoopSoundPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> S2CStartLoopSoundPacket.handleClient(msg));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(S2CStartLoopSoundPacket msg) {
        LoopingSounds.start(msg.channelId, msg.soundId, SoundSource.valueOf((String)msg.sourceName), msg.relative, msg.x, msg.y, msg.z, msg.volume, msg.pitch);
    }
}

