/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.tasuposed.theforgotten.client.fx.TextureDistortionFX;

public class S2CTextureGlitchPacket {
    private final List<Sample> samples;
    private final int durationTicks;
    private final float intensity;

    public S2CTextureGlitchPacket(List<Sample> samples, int durationTicks, float intensity) {
        this.samples = new ArrayList<Sample>(samples);
        this.durationTicks = Math.max(1, durationTicks);
        this.intensity = Math.max(0.05f, Math.min(intensity, 1.5f));
    }

    public static void encode(S2CTextureGlitchPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.durationTicks);
        buf.writeFloat(msg.intensity);
        buf.m_130130_(msg.samples.size());
        for (Sample s : msg.samples) {
            buf.writeDouble(s.position.f_82479_);
            buf.writeDouble(s.position.f_82480_);
            buf.writeDouble(s.position.f_82481_);
            buf.writeFloat(s.yaw);
            buf.writeFloat(s.pitch);
            buf.writeFloat(s.width);
            buf.writeFloat(s.height);
            buf.writeInt(s.color);
            buf.writeFloat(s.alphaScale);
            buf.writeFloat(s.noiseSpeed);
            buf.writeFloat(s.spinSpeed);
        }
    }

    public static S2CTextureGlitchPacket decode(FriendlyByteBuf buf) {
        int duration = buf.m_130242_();
        float intensity = buf.readFloat();
        int count = buf.m_130242_();
        ArrayList<Sample> samples = new ArrayList<Sample>(count);
        for (int i = 0; i < count; ++i) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float yaw = buf.readFloat();
            float pitch = buf.readFloat();
            float width = buf.readFloat();
            float height = buf.readFloat();
            int color = buf.readInt();
            float alpha = buf.readFloat();
            float noise = buf.readFloat();
            float spin = buf.readFloat();
            samples.add(new Sample(new Vec3(x, y, z), yaw, pitch, width, height, color, alpha, noise, spin));
        }
        return new S2CTextureGlitchPacket(samples, duration, intensity);
    }

    public static void handle(S2CTextureGlitchPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> S2CTextureGlitchPacket.handleClient(msg));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(S2CTextureGlitchPacket msg) {
        TextureDistortionFX.push(msg.samples, msg.durationTicks, msg.intensity);
    }

    public record Sample(Vec3 position, float yaw, float pitch, float width, float height, int color, float alphaScale, float noiseSpeed, float spinSpeed) {
    }
}

