/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.tasuposed.theforgotten.Config;
import net.tasuposed.theforgotten.data.Pools;
import net.tasuposed.theforgotten.network.NetworkHandler;
import net.tasuposed.theforgotten.network.S2CForceGlitchPacket;
import net.tasuposed.theforgotten.network.S2CPositionalSoundPacket;
import net.tasuposed.theforgotten.network.S2CTextureGlitchPacket;
import net.tasuposed.theforgotten.server.LureDimensionManager;
import net.tasuposed.theforgotten.server.Managers;
import net.tasuposed.theforgotten.server.PlayerFlags;
import net.tasuposed.theforgotten.server.RuntimeTuning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmbientSoundManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmbientSoundManager.class);
    private static final ResourceLocation BREATH_SOUND = new ResourceLocation("theforgotten", "ambient.breath");
    private static final long BREATH_CHAIN_RESET_TICKS = 500L;
    private static final long BREATH_COOLDOWN_TICKS = 1800L;
    private final Map<UUID, ThreatState> threatStates = new HashMap<UUID, ThreatState>();
    private final Map<UUID, TextureBlinkState> textureBlinks = new HashMap<UUID, TextureBlinkState>();
    private final List<TorchFlicker> torchFlickers = new ArrayList<TorchFlicker>();
    private final Map<UUID, Long> visualCooldowns = new HashMap<UUID, Long>();
    private static final long VISUAL_COOLDOWN_TICKS = 200L;
    private final List<PendingSound> pending = new ArrayList<PendingSound>();

    public void playBreathBehind(ServerPlayer sp, float volume) {
        if (!this.allowAmbient(sp)) {
            return;
        }
        Vec3 base = sp.m_20182_();
        Vec3 look = sp.m_20154_().m_82541_();
        Vec3 dir = look.m_82490_(-1.0).m_82541_();
        double dist = 2.0;
        Vec3 origin = base.m_82549_(dir.m_82490_(dist)).m_82520_(0.0, 1.2, 0.0);
        long now = sp.f_8924_.m_129921_();
        float vol = Math.max(0.08f, Math.min(volume, 0.4f));
        float pit = (float)(0.86 + sp.m_217043_().m_188500_() * 0.12);
        this.scheduleClean(sp, BREATH_SOUND, origin.f_82479_, origin.f_82480_, origin.f_82481_, vol, pit, SoundSource.AMBIENT, now);
        this.registerBreathThreat(sp, now);
    }

    public void debugBreath(ServerPlayer sp) {
        this.playBreathBehind(sp, 0.24f);
    }

    public void playScanSequence(ServerPlayer sp, BlockPos at, int beeps) {
        if (!this.allowAmbient(sp)) {
            return;
        }
        if (beeps <= 0) {
            return;
        }
        ResourceLocation beep = new ResourceLocation("minecraft", "block.note_block.harp");
        long now = sp.f_8924_.m_129921_();
        for (int i = 0; i < beeps; ++i) {
            float vol = 0.7f;
            float pit = 0.95f + (float)i * 0.08f;
            double x = (double)at.m_123341_() + 0.5;
            double y = (double)at.m_123342_() + 1.2;
            double z = (double)at.m_123343_() + 0.5;
            this.pending.add(new PendingSound(sp.m_20148_(), beep, x, y, z, vol, pit, SoundSource.BLOCKS, now + (long)(i * 6)));
        }
    }

    public void playFootstepsBurst(ServerPlayer sp, int count) {
        if (!this.allowAmbient(sp)) {
            return;
        }
        if (count <= 0) {
            return;
        }
        Vec3 base = sp.m_20182_();
        Vec3 look = sp.m_20154_().m_82541_();
        Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
        double jitter = (sp.m_217043_().m_188500_() - 0.5) * 0.5;
        Vec3 dir = look.m_82490_(-1.0).m_82549_(right.m_82490_(jitter)).m_82541_();
        double dist = 6.0 + sp.m_217043_().m_188500_() * 4.0;
        Vec3 origin = base.m_82549_(dir.m_82490_(dist)).m_82520_(0.0, 0.1, 0.0);
        ResourceLocation chosenStep = new ResourceLocation("minecraft", "block.deepslate.step");
        long now = sp.f_8924_.m_129921_();
        int interval = 5;
        for (int i = 0; i < count; ++i) {
            float vol = 1.0f;
            float pit = 1.0f;
            double stepDist = (double)i * 0.5;
            Vec3 pos = origin.m_82549_(dir.m_82490_(stepDist));
            this.pending.add(new PendingSound(sp.m_20148_(), chosenStep, pos.f_82479_, pos.f_82480_, pos.f_82481_, vol, pit, SoundSource.PLAYERS, now + (long)(i * interval)));
        }
    }

    public void tick(MinecraftServer server, long time) {
        if (this.pending.isEmpty()) {
            return;
        }
        Iterator<PendingSound> it = this.pending.iterator();
        while (it.hasNext()) {
            PendingSound ps = it.next();
            if (ps.playTick > time) continue;
            ServerPlayer sp = server.m_6846_().m_11259_(ps.playerId);
            if (sp != null) {
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(ps.soundId, ps.x, ps.y, ps.z, ps.volume, ps.pitch, ps.source));
            }
            it.remove();
        }
        if (!this.torchFlickers.isEmpty()) {
            Iterator<TorchFlicker> tf = this.torchFlickers.iterator();
            while (tf.hasNext()) {
                TorchFlicker flick = tf.next();
                ServerPlayer sp = server.m_6846_().m_11259_(flick.playerId);
                if (sp != null && time < flick.restoreTick) continue;
                if (sp != null) {
                    this.restoreTorches(sp, flick.positions, flick.states);
                }
                tf.remove();
            }
        }
        if (!this.textureBlinks.isEmpty()) {
            Iterator<Map.Entry<UUID, TextureBlinkState>> bt = this.textureBlinks.entrySet().iterator();
            while (bt.hasNext()) {
                Map.Entry<UUID, TextureBlinkState> en2 = bt.next();
                TextureBlinkState blink = en2.getValue();
                ServerPlayer sp = server.m_6846_().m_11259_(en2.getKey());
                if (sp != null && time < blink.untilTick) continue;
                if (sp != null && !sp.m_21023_(MobEffects.f_19609_)) {
                    sp.m_6842_(blink.restoreInvisible);
                }
                bt.remove();
            }
        }
        if (!this.threatStates.isEmpty()) {
            this.threatStates.entrySet().removeIf(en -> time - ((ThreatState)en.getValue()).lastTick > 3600L);
        }
    }

    private void scheduleDistorted(ServerPlayer sp, ResourceLocation id, double x, double y, double z, float volume, float pitch, SoundSource source, long baseTick) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        boolean inLure = sp.m_9236_().m_46472_().equals(LureDimensionManager.LURE_DIM);
        double distortChance = inLure ? (Double)Config.AMBIENT_DISTORT_CHANCE_LURE.get() : (Double)Config.AMBIENT_DISTORT_CHANCE_OVERWORLD.get();
        double overlayChance = inLure ? (Double)Config.AMBIENT_GLITCH_OVERLAY_CHANCE_LURE.get() : (Double)Config.AMBIENT_GLITCH_OVERLAY_CHANCE_OVERWORLD.get();
        if (r.nextDouble() < distortChance) {
            int layers = 2 + (r.nextBoolean() ? 1 : 0);
            for (int i = 0; i < layers; ++i) {
                float detune = (float)(0.94 + r.nextDouble() * 0.16);
                float v = i == 0 ? volume : volume * 0.65f;
                long delay = baseTick + (long)(i == 0 ? 0 : 1 + r.nextInt(2));
                this.pending.add(new PendingSound(sp.m_20148_(), id, x, y, z, v, pitch * detune, source, delay));
            }
        } else {
            this.pending.add(new PendingSound(sp.m_20148_(), id, x, y, z, volume, pitch, source, baseTick));
        }
        if (r.nextDouble() < overlayChance) {
            ResourceLocation glitch = new ResourceLocation("theforgotten", "fx.glitch");
            float gv = Math.max(0.05f, volume * 0.22f);
            float gp = (float)(0.92 + r.nextDouble() * 0.18);
            long gdelay = baseTick + (long)(r.nextBoolean() ? 0 : 1);
            this.pending.add(new PendingSound(sp.m_20148_(), glitch, x, y, z, gv, gp, SoundSource.AMBIENT, gdelay));
        }
    }

    private void scheduleClean(ServerPlayer sp, ResourceLocation id, double x, double y, double z, float volume, float pitch, SoundSource source, long tick) {
        this.pending.add(new PendingSound(sp.m_20148_(), id, x, y, z, volume, pitch, source, tick));
    }

    private void registerBreathThreat(ServerPlayer sp, long now) {
        if (!this.allowAmbient(sp)) {
            return;
        }
        ThreatState state = this.threatStates.computeIfAbsent(sp.m_20148_(), id -> new ThreatState());
        if (now - state.lastTick > 500L) {
            state.breathChain = 0;
            if (now >= state.cooldownUntil) {
                state.stage = ThreatStage.CALM;
            }
        }
        state.lastTick = now;
        if (now < state.cooldownUntil) {
            state.breathChain = Math.min(state.breathChain + 1, 2);
            return;
        }
        ++state.breathChain;
        if (state.stage == ThreatStage.CALM && state.breathChain >= 2) {
            state.stage = ThreatStage.WARN;
            state.breathChain = 0;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(12, 0.55f));
            this.playFootstepsBurst(sp, 3 + sp.m_217043_().m_188503_(2));
            return;
        }
        if (state.stage == ThreatStage.WARN && state.breathChain >= 2) {
            state.stage = ThreatStage.HUNT;
            state.breathChain = 0;
            state.cooldownUntil = now + 1800L;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(32, 0.9f));
            this.playBlockBreakSequence(sp, 3);
            if (Managers.APPARITIONS != null) {
                boolean triggered = Managers.APPARITIONS.triggerAggressive(sp, now);
                if (!triggered) {
                    state.stage = ThreatStage.WARN;
                    state.cooldownUntil = now + 500L;
                } else {
                    state.stage = ThreatStage.CALM;
                }
            } else {
                state.stage = ThreatStage.WARN;
                state.cooldownUntil = now + 500L;
            }
        }
    }

    public void maybePlayFor(ServerPlayer sp) {
        if (!((Boolean)Config.ENABLE_AMBIENT_SOUNDS.get()).booleanValue()) {
            return;
        }
        if (!this.allowAmbient(sp)) {
            return;
        }
        long now = sp.f_8924_.m_129921_();
        double roll = sp.m_217043_().m_188500_();
        if (roll > RuntimeTuning.ambientChance()) {
            return;
        }
        boolean underground = !sp.m_9236_().m_46861_(sp.m_20183_());
        boolean deep = sp.m_20183_().m_123342_() <= -10;
        boolean triggered = false;
        double category = sp.m_217043_().m_188500_();
        if (category < 0.55) {
            triggered = this.triggerSoundScenario(sp, underground, deep);
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue() && triggered) {
                LOGGER.info("[Ambient] {} -> sound scenario (category={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", category));
            }
        } else if (category < 0.8) {
            triggered = this.triggerVisualScenario(sp, now);
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue() && triggered) {
                LOGGER.info("[Ambient] {} -> visual scenario (category={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", category));
            }
        } else {
            triggered = this.playMobAssault(sp);
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue() && triggered) {
                LOGGER.info("[Ambient] {} -> mob assault (category={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", category));
            }
        }
        if (!triggered) {
            if (category < 0.55) {
                triggered = this.triggerVisualScenario(sp, now);
                if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue() && triggered) {
                    LOGGER.info("[Ambient] {} -> visual fallback", (Object)sp.m_36316_().getName());
                }
            } else {
                triggered = this.triggerSoundScenario(sp, underground, deep);
                if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue() && triggered) {
                    LOGGER.info("[Ambient] {} -> sound fallback", (Object)sp.m_36316_().getName());
                }
            }
        }
        if (!triggered) {
            List<ResourceLocation> pool = Pools.getAmbientSoundPool(sp);
            if (pool.isEmpty()) {
                return;
            }
            ResourceLocation chosen = pool.get(sp.m_217043_().m_188503_(pool.size()));
            this.playPoolAmbient(sp, chosen);
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Ambient] {} -> ambient pool {}", (Object)sp.m_36316_().getName(), (Object)chosen);
            }
        }
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            LOGGER.info("[Ambient] {} complete triggered={}", (Object)sp.m_36316_().getName(), (Object)triggered);
        }
    }

    private boolean triggerSoundScenario(ServerPlayer sp, boolean underground, boolean deep) {
        if (!this.allowAmbient(sp)) {
            return false;
        }
        double sRoll = sp.m_217043_().m_188500_();
        if (underground && sRoll < 0.32) {
            this.playBlockBreakSequence(sp, 2 + sp.m_217043_().m_188503_(3));
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Ambient] {} sound:block_break (roll={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", sRoll));
            }
            return true;
        }
        if (underground && sRoll < 0.62) {
            this.playFootstepsSequence(sp, true);
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Ambient] {} sound:footsteps (roll={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", sRoll));
            }
            return true;
        }
        if (underground && sRoll < 0.82) {
            this.playBreathBehind(sp, 0.22f);
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Ambient] {} sound:breath (roll={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", sRoll));
            }
            return true;
        }
        if (deep && sRoll < 0.92) {
            this.playSurfaceMobAbove(sp);
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Ambient] {} sound:surface_mob (roll={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", sRoll));
            }
            return true;
        }
        return false;
    }

    private boolean triggerVisualScenario(ServerPlayer sp, long now) {
        if (!this.allowAmbient(sp)) {
            return false;
        }
        double vRoll = sp.m_217043_().m_188500_();
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue() && this.visualOnCooldown(sp, now)) {
            LOGGER.info("[Ambient] {} visual blocked by cooldown", (Object)sp.m_36316_().getName());
        }
        if (vRoll < 0.38 && this.triggerTextureBlink(sp, now, false)) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Ambient] {} visual:texture_blink (roll={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", vRoll));
            }
            return true;
        }
        if (vRoll < 0.7 && this.triggerTorchFlicker(sp, now, false)) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Ambient] {} visual:torch_flicker (roll={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", vRoll));
            }
            return true;
        }
        if (this.triggerTextureGlitch(sp, now, false)) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Ambient] {} visual:texture_glitch (roll={})", (Object)sp.m_36316_().getName(), (Object)String.format("%.2f", vRoll));
            }
            return true;
        }
        return false;
    }

    public void playBlockBreakSequence(ServerPlayer sp, int breaks) {
        if (!this.allowAmbient(sp)) {
            return;
        }
        Vec3 base = sp.m_20182_().m_82520_(0.0, (double)sp.m_20192_() * 0.5, 0.0);
        Vec3 look = sp.m_20154_().m_82541_();
        double angleDeg = (double)(sp.m_217043_().m_188499_() ? 150 : -150) + sp.m_217043_().m_188500_() * 60.0;
        double angleRad = Math.toRadians(angleDeg);
        Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
        Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
        double dist = 6.0 + sp.m_217043_().m_188500_() * 8.0;
        Vec3 at = base.m_82549_(dir.m_82490_(dist));
        ResourceLocation[] pool = new ResourceLocation[]{new ResourceLocation("minecraft", "block.stone.break"), new ResourceLocation("minecraft", "block.deepslate.break"), new ResourceLocation("minecraft", "block.gravel.break"), new ResourceLocation("minecraft", "block.tuff.break"), new ResourceLocation("minecraft", "block.basalt.break")};
        long now = sp.f_8924_.m_129921_();
        ResourceLocation chosenBreak = pool[sp.m_217043_().m_188503_(pool.length)];
        for (int i = 0; i < breaks; ++i) {
            float vol = (float)(0.9 + sp.m_217043_().m_188500_() * 0.4);
            float pit = (float)(0.9 + sp.m_217043_().m_188500_() * 0.15);
            Vec3 off = at.m_82520_((sp.m_217043_().m_188500_() - 0.5) * 1.0, (sp.m_217043_().m_188500_() - 0.5) * 0.6, (sp.m_217043_().m_188500_() - 0.5) * 1.0);
            long tickAt = now + (long)(i * (4 + sp.m_217043_().m_188503_(6)));
            this.scheduleDistorted(sp, chosenBreak, off.f_82479_, off.f_82480_, off.f_82481_, vol, pit, SoundSource.BLOCKS, tickAt);
        }
    }

    private void playFootstepsSequence(ServerPlayer sp, boolean sprintMaybe) {
        Vec3 base = sp.m_20182_();
        double radius = 6.0 + sp.m_217043_().m_188500_() * 8.0;
        double theta = sp.m_217043_().m_188500_() * Math.PI * 2.0;
        Vec3 origin = base.m_82520_(Math.cos(theta) * radius, 0.0, Math.sin(theta) * radius);
        ResourceLocation[] steps = new ResourceLocation[]{new ResourceLocation("minecraft", "block.stone.step"), new ResourceLocation("minecraft", "block.deepslate.step"), new ResourceLocation("minecraft", "block.gravel.step"), new ResourceLocation("minecraft", "block.tuff.step"), new ResourceLocation("minecraft", "block.basalt.step")};
        int count = 4 + sp.m_217043_().m_188503_(5);
        boolean sprint = sprintMaybe && sp.m_217043_().m_188500_() < 0.15;
        int interval = sprint ? 3 + sp.m_217043_().m_188503_(3) : 6 + sp.m_217043_().m_188503_(4);
        long now = sp.f_8924_.m_129921_();
        ResourceLocation chosenStep = steps[sp.m_217043_().m_188503_(steps.length)];
        for (int i = 0; i < count; ++i) {
            float vol = sprint ? 1.1f : 0.9f;
            float pit = (float)(0.92 + sp.m_217043_().m_188500_() * 0.12);
            double stepDir = theta + (sp.m_217043_().m_188500_() - 0.5) * 0.6;
            double stepDist = (double)i * 0.5 * (sprint ? 1.4 : 1.0);
            Vec3 pos = origin.m_82520_(Math.cos(stepDir) * stepDist, 0.0, Math.sin(stepDir) * stepDist).m_82520_(0.0, 0.1, 0.0);
            long tickAt = now + (long)(i * interval);
            this.scheduleDistorted(sp, chosenStep, pos.f_82479_, pos.f_82480_, pos.f_82481_, vol, pit, SoundSource.PLAYERS, tickAt);
        }
    }

    public void playSurfaceMobAbove(ServerPlayer sp) {
        if (!this.allowAmbient(sp)) {
            return;
        }
        ResourceLocation[] mobs = new ResourceLocation[]{new ResourceLocation("minecraft", "entity.cow.ambient"), new ResourceLocation("minecraft", "entity.pig.ambient"), new ResourceLocation("minecraft", "entity.sheep.ambient"), new ResourceLocation("minecraft", "entity.chicken.ambient"), new ResourceLocation("minecraft", "entity.horse.ambient"), new ResourceLocation("minecraft", "entity.donkey.ambient")};
        ResourceLocation rl = mobs[sp.m_217043_().m_188503_(mobs.length)];
        double hOff = 4.0 + sp.m_217043_().m_188500_() * 8.0;
        double ang = sp.m_217043_().m_188500_() * Math.PI * 2.0;
        double x = sp.m_20185_() + Math.cos(ang) * hOff;
        double z = sp.m_20189_() + Math.sin(ang) * hOff;
        double y = sp.m_20186_() + 12.0 + sp.m_217043_().m_188500_() * 10.0;
        float vol = (float)(0.9 + sp.m_217043_().m_188500_() * 0.5);
        float pit = (float)(0.98 + sp.m_217043_().m_188500_() * 0.08);
        this.scheduleDistorted(sp, rl, x, y, z, vol, pit, SoundSource.AMBIENT, sp.f_8924_.m_129921_());
    }

    public void playFootstepsSequence(ServerPlayer sp, int count, boolean sprint) {
        if (!this.allowAmbient(sp)) {
            return;
        }
        Vec3 base = sp.m_20182_();
        double radius = 6.0 + sp.m_217043_().m_188500_() * 8.0;
        double theta = sp.m_217043_().m_188500_() * Math.PI * 2.0;
        Vec3 origin = base.m_82520_(Math.cos(theta) * radius, 0.0, Math.sin(theta) * radius);
        ResourceLocation[] steps = new ResourceLocation[]{new ResourceLocation("minecraft", "block.stone.step"), new ResourceLocation("minecraft", "block.deepslate.step"), new ResourceLocation("minecraft", "block.gravel.step"), new ResourceLocation("minecraft", "block.tuff.step"), new ResourceLocation("minecraft", "block.basalt.step")};
        int c = Math.max(4, count);
        int interval = sprint ? 3 : 7;
        long now = sp.f_8924_.m_129921_();
        ResourceLocation chosenStep = steps[sp.m_217043_().m_188503_(steps.length)];
        for (int i = 0; i < c; ++i) {
            float vol = sprint ? 1.1f : 0.9f;
            float pit = (float)(0.92 + sp.m_217043_().m_188500_() * 0.12);
            double stepDir = theta + (sp.m_217043_().m_188500_() - 0.5) * 0.6;
            double stepDist = (double)i * 0.5 * (sprint ? 1.4 : 1.0);
            Vec3 pos = origin.m_82520_(Math.cos(stepDir) * stepDist, 0.0, Math.sin(stepDir) * stepDist).m_82520_(0.0, 0.1, 0.0);
            this.scheduleDistorted(sp, chosenStep, pos.f_82479_, pos.f_82480_, pos.f_82481_, vol, pit, SoundSource.PLAYERS, now + (long)(i * interval));
        }
    }

    private boolean playMobAssault(ServerPlayer sp) {
        Vec3 dir;
        float current;
        if (!this.allowAmbient(sp)) {
            return false;
        }
        ServerLevel level = sp.m_284548_();
        double radius = 8.0 + sp.m_217043_().m_188500_() * 8.0;
        AABB box = new AABB(sp.m_20185_() - radius, sp.m_20186_() - 3.0, sp.m_20189_() - radius, sp.m_20185_() + radius, sp.m_20186_() + 4.0, sp.m_20189_() + radius);
        List mobs = level.m_6443_(Mob.class, box, mob -> {
            TamableAnimal tame;
            return mob.m_6084_() && !mob.m_213877_() && !mob.m_5833_() && mob.m_20280_((Entity)sp) > 9.0 && (!(mob instanceof TamableAnimal) || !(tame = (TamableAnimal)mob).m_21830_((LivingEntity)sp));
        });
        if (mobs.isEmpty()) {
            return false;
        }
        Mob target = (Mob)mobs.get(sp.m_217043_().m_188503_(mobs.size()));
        Vec3 targetPos = target.m_20182_();
        double damage = 1.5 + sp.m_217043_().m_188500_() * 2.5;
        float applied = (float)Math.min(damage, Math.max(0.2, (double)(current = target.m_21223_()) - 0.5));
        if (applied > 0.0f) {
            target.m_6469_(level.m_269111_().m_269425_(), applied);
        }
        if ((dir = sp.m_20182_().m_82546_(targetPos)).m_82556_() < 0.001) {
            dir = new Vec3(sp.m_217043_().m_188500_() - 0.5, 0.0, sp.m_217043_().m_188500_() - 0.5);
        }
        dir = dir.m_82541_();
        target.m_147240_((double)(0.6f + sp.m_217043_().m_188501_() * 0.4f), -dir.f_82479_, -dir.f_82481_);
        level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 0.9f, 0.9f + sp.m_217043_().m_188501_() * 0.2f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), 8, 0.3, 0.4, 0.3, 0.05);
        return true;
    }

    public boolean debugMobAssault(ServerPlayer sp) {
        return this.playMobAssault(sp);
    }

    public boolean debugTextureBlink(ServerPlayer sp) {
        long now = sp != null && sp.f_8924_ != null ? (long)sp.f_8924_.m_129921_() : 0L;
        return this.triggerTextureBlink(sp, now, true);
    }

    private boolean triggerTextureBlink(ServerPlayer sp, long now, boolean force) {
        if (sp == null) {
            return false;
        }
        if (!force && !this.allowAmbient(sp)) {
            return false;
        }
        if (!force && this.visualOnCooldown(sp, now)) {
            return false;
        }
        if (sp.m_5833_()) {
            return false;
        }
        if (sp.m_21023_(MobEffects.f_19609_)) {
            return false;
        }
        if (sp.m_20145_()) {
            return false;
        }
        if (this.textureBlinks.containsKey(sp.m_20148_())) {
            return false;
        }
        TextureBlinkState state = new TextureBlinkState();
        state.restoreInvisible = sp.m_20145_();
        state.untilTick = sp.f_8924_.m_129921_() + 8 + sp.m_217043_().m_188503_(12);
        sp.m_6842_(true);
        this.textureBlinks.put(sp.m_20148_(), state);
        this.markVisualCooldown(sp, now);
        return true;
    }

    public boolean debugTorchFlicker(ServerPlayer sp) {
        long now = sp != null && sp.f_8924_ != null ? (long)sp.f_8924_.m_129921_() : 0L;
        return this.triggerTorchFlicker(sp, now, true);
    }

    public boolean debugTextureGlitch(ServerPlayer sp) {
        long now = sp != null && sp.f_8924_ != null ? (long)sp.f_8924_.m_129921_() : 0L;
        return this.triggerTextureGlitch(sp, now, true);
    }

    private boolean triggerTorchFlicker(ServerPlayer sp, long now, boolean force) {
        if (sp == null) {
            return false;
        }
        if (!force && !this.allowAmbient(sp)) {
            return false;
        }
        if (!force && this.visualOnCooldown(sp, now)) {
            return false;
        }
        ServerLevel level = sp.m_284548_();
        int radius = 8;
        BlockPos origin = sp.m_20183_();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-radius, -2, -radius), (BlockPos)origin.m_7918_(radius, 3, radius))) {
            BlockState state;
            if (!level.m_46749_(pos) || !(state = level.m_8055_(pos)).m_60713_(Blocks.f_50081_) && !state.m_60713_(Blocks.f_50082_) && !state.m_60713_(Blocks.f_50139_) && !state.m_60713_(Blocks.f_50140_)) continue;
            candidates.add(pos.m_7949_());
        }
        if (candidates.isEmpty()) {
            return false;
        }
        long seed = sp.m_217043_().m_188505_();
        Collections.shuffle(candidates, new Random(seed));
        int max = Math.min(3, candidates.size());
        int count = 1 + sp.m_217043_().m_188503_(max);
        TorchFlicker flick = new TorchFlicker();
        flick.playerId = sp.m_20148_();
        flick.restoreTick = sp.f_8924_.m_129921_() + 8 + sp.m_217043_().m_188503_(10);
        for (int i = 0; i < count; ++i) {
            BlockPos pos = (BlockPos)candidates.get(i);
            BlockState real = level.m_8055_(pos);
            flick.positions.add(pos);
            flick.states.add(real);
            sp.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(pos, Blocks.f_50016_.m_49966_()));
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.5, 3, 0.1, 0.2, 0.1, 0.01);
        }
        this.torchFlickers.add(flick);
        this.markVisualCooldown(sp, now);
        return true;
    }

    private boolean triggerTextureGlitch(ServerPlayer sp, long now, boolean force) {
        if (sp == null) {
            return false;
        }
        if (!force && !this.allowAmbient(sp)) {
            return false;
        }
        if (!force && this.visualOnCooldown(sp, now)) {
            return false;
        }
        Vec3 eye = sp.m_20182_().m_82520_(0.0, (double)sp.m_20192_(), 0.0);
        RandomSource rand = sp.m_217043_();
        ArrayList<S2CTextureGlitchPacket.Sample> samples = new ArrayList<S2CTextureGlitchPacket.Sample>();
        int shards = 7 + rand.m_188503_(6);
        for (int i = 0; i < shards; ++i) {
            double radius = 1.8 + rand.m_188500_() * 3.4;
            double theta = rand.m_188500_() * Math.PI * 2.0;
            double yOffset = (rand.m_188500_() - 0.35) * 2.6;
            Vec3 pos = eye.m_82520_(Math.cos(theta) * radius, yOffset, Math.sin(theta) * radius);
            Vec3 toPlayer = eye.m_82546_(pos);
            double dist = toPlayer.m_82553_();
            if (dist < 0.25) continue;
            Vec3 dir = toPlayer.m_82490_(1.0 / dist);
            float yaw = (float)Math.toDegrees(Math.atan2(dir.f_82481_, dir.f_82479_)) + 90.0f;
            float pitch = (float)(-Math.toDegrees(Math.asin(dir.f_82480_)));
            float width = 0.8f + rand.m_188501_() * 1.3f;
            float height = 1.0f + rand.m_188501_() * 1.5f;
            float tint = 0.65f + rand.m_188501_() * 0.35f;
            int baseR = Mth.m_14045_((int)((int)(tint * (float)(180 + rand.m_188503_(60)))), (int)0, (int)255);
            int baseG = Mth.m_14045_((int)((int)(tint * (float)(140 + rand.m_188503_(80)))), (int)0, (int)255);
            int baseB = Mth.m_14045_((int)((int)(tint * (float)(200 + rand.m_188503_(55)))), (int)0, (int)255);
            if (rand.m_188500_() < 0.3) {
                baseR = Mth.m_14045_((int)(baseR + 40), (int)0, (int)255);
            } else if (rand.m_188500_() < 0.6) {
                baseB = Mth.m_14045_((int)(baseB + 45), (int)0, (int)255);
            }
            int color = baseR << 16 | baseG << 8 | baseB;
            float alpha = 0.38f + rand.m_188501_() * 0.42f;
            float noise = 0.35f + rand.m_188501_() * 0.7f;
            float spin = 0.25f + rand.m_188501_() * 0.8f;
            samples.add(new S2CTextureGlitchPacket.Sample(pos, yaw, pitch, width, height, color, alpha, noise, spin));
        }
        if (samples.isEmpty()) {
            return false;
        }
        int duration = 14 + rand.m_188503_(12);
        float intensity = 0.45f + rand.m_188501_() * 0.55f;
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CTextureGlitchPacket(samples, duration, intensity));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(duration + 6, Mth.m_14036_((float)(intensity + 0.25f), (float)0.55f, (float)1.0f)));
        this.markVisualCooldown(sp, now);
        return true;
    }

    private boolean visualOnCooldown(ServerPlayer sp, long now) {
        Long until = this.visualCooldowns.get(sp.m_20148_());
        return until != null && now < until;
    }

    private void markVisualCooldown(ServerPlayer sp, long now) {
        this.visualCooldowns.put(sp.m_20148_(), now + 200L);
    }

    private boolean allowAmbient(ServerPlayer sp) {
        if (sp == null) {
            return false;
        }
        if (!PlayerFlags.isTrialComplete(sp)) {
            return true;
        }
        return PlayerFlags.isReawakened(sp);
    }

    private boolean isDoorSound(ResourceLocation rl) {
        if (rl == null) {
            return false;
        }
        String path = rl.m_135815_();
        return path != null && path.contains("door");
    }

    private boolean isChestSound(ResourceLocation rl) {
        if (rl == null) {
            return false;
        }
        String path = rl.m_135815_();
        return path != null && path.contains("chest");
    }

    private Vec3 findAmbientTarget(ServerLevel level, BlockPos origin, AmbientTarget target, int radius, int vertical, RandomSource rand) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        BlockPos min = origin.m_7918_(-radius, -vertical, -radius);
        BlockPos max = origin.m_7918_(radius, vertical, radius);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            if (!level.m_46749_(pos)) continue;
            BlockState state = level.m_8055_(pos);
            if (target == AmbientTarget.DOOR ? !(state.m_60734_() instanceof DoorBlock) || state.m_61138_((Property)DoorBlock.f_52730_) && state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER : target != AmbientTarget.CHEST || !(state.m_60734_() instanceof ChestBlock) && !(state.m_60734_() instanceof TrappedChestBlock)) continue;
            candidates.add(pos.m_7949_());
        }
        if (candidates.isEmpty()) {
            return null;
        }
        BlockPos pick = (BlockPos)candidates.get(rand.m_188503_(candidates.size()));
        double yOffset = target == AmbientTarget.DOOR ? 1.0 : 0.9;
        return new Vec3((double)pick.m_123341_() + 0.5, (double)pick.m_123342_() + yOffset, (double)pick.m_123343_() + 0.5);
    }

    private void restoreTorches(ServerPlayer sp, List<BlockPos> positions, List<BlockState> states) {
        if (sp.f_8906_ == null) {
            return;
        }
        ServerLevel level = sp.m_284548_();
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos pos = positions.get(i);
            BlockState real = i < states.size() && states.get(i) != null ? states.get(i) : level.m_8055_(pos);
            sp.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(pos, real));
        }
    }

    public void playPoolAmbient(ServerPlayer sp, ResourceLocation chosen) {
        Vec3 at;
        boolean underground;
        if (!this.allowAmbient(sp)) {
            return;
        }
        ServerLevel level = sp.m_284548_();
        boolean bl = underground = !level.m_46861_(sp.m_20183_());
        if (AmbientSoundManager.isMinecartSound(chosen) && !underground) {
            return;
        }
        RandomSource rand = sp.m_217043_();
        if (this.isDoorSound(chosen)) {
            Vec3 doorPos = this.findAmbientTarget(level, sp.m_20183_(), AmbientTarget.DOOR, 16, 4, rand);
            if (doorPos == null) {
                return;
            }
            at = doorPos.m_82520_((rand.m_188500_() - 0.5) * 0.5, 0.0, (rand.m_188500_() - 0.5) * 0.5);
        } else if (this.isChestSound(chosen)) {
            Vec3 chestPos = this.findAmbientTarget(level, sp.m_20183_(), AmbientTarget.CHEST, 14, 3, rand);
            if (chestPos == null) {
                return;
            }
            at = chestPos.m_82520_((rand.m_188500_() - 0.5) * 0.4, 0.0, (rand.m_188500_() - 0.5) * 0.4);
        } else {
            Vec3 base = sp.m_20182_().m_82520_(0.0, (double)sp.m_20192_(), 0.0);
            Vec3 look = sp.m_20154_().m_82541_();
            double angleDeg = (double)(rand.m_188499_() ? 140 : -140) + rand.m_188500_() * 40.0;
            double angleRad = Math.toRadians(angleDeg);
            Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
            Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
            double dist = 10.0 + rand.m_188500_() * 12.0;
            at = base.m_82549_(dir.m_82490_(dist));
        }
        float volume = 1.0f;
        float pitch = 1.0f;
        this.scheduleDistorted(sp, chosen, at.f_82479_, at.f_82480_, at.f_82481_, volume, pitch, SoundSource.AMBIENT, sp.f_8924_.m_129921_());
    }

    private static boolean isMinecartSound(ResourceLocation rl) {
        if (rl == null) {
            return false;
        }
        String path = rl.m_135815_();
        return path != null && path.contains("minecart");
    }

    public void debugRandomSequence(ServerPlayer sp) {
        boolean underground = !sp.m_9236_().m_46861_(sp.m_20183_());
        boolean deep = sp.m_20183_().m_123342_() <= -10;
        double kind = sp.m_217043_().m_188500_();
        if (underground && kind < 0.35) {
            this.playBlockBreakSequence(sp, 2 + sp.m_217043_().m_188503_(3));
            return;
        }
        if (underground && kind < 0.6) {
            this.playFootstepsSequence(sp, true);
            return;
        }
        if (deep && kind < 0.75) {
            this.playSurfaceMobAbove(sp);
            return;
        }
        List<ResourceLocation> pool = Pools.getAmbientSoundPool(sp);
        if (pool.isEmpty()) {
            return;
        }
        ResourceLocation chosen = pool.get(sp.m_217043_().m_188503_(pool.size()));
        this.playPoolAmbient(sp, chosen);
    }

    private static class PendingSound {
        UUID playerId;
        ResourceLocation soundId;
        double x;
        double y;
        double z;
        float volume;
        float pitch;
        SoundSource source;
        long playTick;

        PendingSound(UUID playerId, ResourceLocation id, double x, double y, double z, float volume, float pitch, SoundSource src, long tick) {
            this.playerId = playerId;
            this.soundId = id;
            this.x = x;
            this.y = y;
            this.z = z;
            this.volume = volume;
            this.pitch = pitch;
            this.source = src;
            this.playTick = tick;
        }
    }

    private static class TorchFlicker {
        UUID playerId;
        List<BlockPos> positions = new ArrayList<BlockPos>();
        List<BlockState> states = new ArrayList<BlockState>();
        long restoreTick;

        private TorchFlicker() {
        }
    }

    private static class TextureBlinkState {
        long untilTick;
        boolean restoreInvisible;

        private TextureBlinkState() {
        }
    }

    private static class ThreatState {
        int breathChain;
        ThreatStage stage = ThreatStage.CALM;
        long lastTick;
        long cooldownUntil;

        private ThreatState() {
        }
    }

    private static enum ThreatStage {
        CALM,
        WARN,
        HUNT;

    }

    private static enum AmbientTarget {
        DOOR,
        CHEST;

    }
}

