/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.tasuposed.theforgotten.Config;
import net.tasuposed.theforgotten.network.NetworkHandler;
import net.tasuposed.theforgotten.network.S2CApparitionChargePacket;
import net.tasuposed.theforgotten.network.S2CApparitionSpawnPacket;
import net.tasuposed.theforgotten.network.S2CApparitionVanishPacket;
import net.tasuposed.theforgotten.network.S2CForceGlitchPacket;
import net.tasuposed.theforgotten.server.LureDimensionManager;
import net.tasuposed.theforgotten.server.Managers;
import net.tasuposed.theforgotten.server.PlayerFlags;
import net.tasuposed.theforgotten.server.RuntimeTuning;
import org.slf4j.Logger;

public class ApparitionManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String[] WHISPERS = new String[]{"Something is watching", "You are not alone", "Stay quiet", "Keep moving", "It is close"};
    private static final double NOTE_DROP_CHANCE = 0.35;
    private static final int NOTE_GATE_MIN = 6;
    private static final int NOTE_GATE_RANGE = 4;
    private final Map<UUID, ApparitionData> active = new HashMap<UUID, ApparitionData>();
    private final Map<UUID, Integer> stalkingChain = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastAggressiveTick = new HashMap<UUID, Long>();
    private static final int FORCED_CHARGE_CHAIN = 3;
    private static final long FORCED_CHARGE_COOLDOWN = 1600L;

    private static Component chatLike(String sender, String msg) {
        return Component.m_237110_((String)"chat.type.text", (Object[])new Object[]{Component.m_237113_((String)sender), Component.m_237113_((String)msg)});
    }

    public void spawnTest(ServerPlayer sp, long time, boolean forceMimic) {
        if (this.active.containsKey(sp.m_20148_())) {
            LOGGER.info("[TheForgotten] Apparition spawn skipped for {}: one already active.", (Object)sp.m_36316_().getName());
            return;
        }
        ServerLevel level = sp.m_284548_();
        Vec3 pos = this.pickSpawnPos(level, sp);
        if (pos == null) {
            LOGGER.info("[TheForgotten] Apparition spawn failed for {}: no valid spawn position found.", (Object)sp.m_36316_().getName());
            return;
        }
        S2CApparitionSpawnPacket.SkinType skin = S2CApparitionSpawnPacket.SkinType.STEVE;
        UUID mimic = null;
        String mimicName = null;
        if (forceMimic) {
            for (ServerPlayer op : sp.f_8924_.m_6846_().m_11314_()) {
                if (op == sp) continue;
                mimic = op.m_20148_();
                mimicName = op.m_36316_().getName();
                break;
            }
            if (mimic == null) {
                mimic = sp.m_20148_();
                mimicName = sp.m_36316_().getName();
            }
            if (mimic != null) {
                skin = S2CApparitionSpawnPacket.SkinType.MIMIC;
            }
        }
        double dx = sp.m_20185_() - pos.f_82479_;
        double dz = sp.m_20189_() - pos.f_82481_;
        float yRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        boolean underground = !level.m_46861_(sp.m_20183_());
        int lifetime = underground ? 60 + sp.m_217043_().m_188503_(60) : 40 + sp.m_217043_().m_188503_(40);
        ApparitionData ad = new ApparitionData();
        ad.id = UUID.randomUUID();
        ad.pos = pos;
        ad.yRot = yRot;
        ad.spawnTick = time;
        ad.lifetimeTicks = lifetime;
        ad.skinType = skin;
        ad.mimicOf = mimic;
        ad.lastWhisperIndex = -1;
        ad.nextWhisperTick = time + 60L + (long)sp.m_217043_().m_188503_(160);
        this.active.put(sp.m_20148_(), ad);
        int chain = this.stalkingChain.merge(sp.m_20148_(), 1, Integer::sum);
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CApparitionSpawnPacket(ad.id, ad.pos, ad.yRot, ad.skinType, ad.mimicOf, mimicName, ad.lifetimeTicks));
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            LOGGER.info("[Apparition] {} spawnTest chain={} pos=({}, {}, {})", new Object[]{sp.m_36316_().getName(), chain, String.format("%.1f", ad.pos.f_82479_), String.format("%.1f", ad.pos.f_82480_), String.format("%.1f", ad.pos.f_82481_)});
        }
        LOGGER.info("[TheForgotten] Apparition spawned for {} at ({}, {}, {}) form={}{}", new Object[]{sp.m_36316_().getName(), ad.pos.f_82479_, ad.pos.f_82480_, ad.pos.f_82481_, ad.skinType == S2CApparitionSpawnPacket.SkinType.MIMIC ? "MIMIC" : "TRUE", ad.skinType == S2CApparitionSpawnPacket.SkinType.MIMIC && mimicName != null ? " mimicOf=" + mimicName : ""});
        sp.m_213846_((Component)Component.m_237113_((String)String.format("[TheForgotten] Apparition %s at (%.1f, %.1f, %.1f)%s", ad.skinType == S2CApparitionSpawnPacket.SkinType.MIMIC ? "MIMIC" : "TRUE", ad.pos.f_82479_, ad.pos.f_82480_, ad.pos.f_82481_, ad.skinType == S2CApparitionSpawnPacket.SkinType.MIMIC && mimicName != null ? " mimicOf=" + mimicName : "")));
    }

    public void clearFor(ServerPlayer sp) {
        UUID id = sp.m_20148_();
        this.active.remove(id);
        this.stalkingChain.remove(id);
        this.lastAggressiveTick.remove(id);
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            LOGGER.info("[Apparition] {} cleared tracking", (Object)sp.m_36316_().getName());
        }
    }

    public void spawnBehindTurnTest(ServerPlayer sp, long time) {
        if (this.active.containsKey(sp.m_20148_())) {
            return;
        }
        if (sp.m_9236_().m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            return;
        }
        ServerLevel level = sp.m_284548_();
        Vec3 look = sp.m_20154_();
        RandomSource rand = sp.m_217043_();
        int playerY = sp.m_20183_().m_123342_();
        Vec3 base = sp.m_20182_();
        double angleDeg = 180.0 + (rand.m_188500_() * 40.0 - 20.0);
        double angleRad = Math.toRadians(angleDeg);
        Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
        Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
        double dist = 7.0 + rand.m_188500_() * 3.0;
        Vec3 horiz = base.m_82549_(dir.m_82490_(dist));
        for (int dy = -1; dy <= 1; ++dy) {
            BlockPos p0 = new BlockPos(Mth.m_14107_((double)horiz.f_82479_), playerY + dy, Mth.m_14107_((double)horiz.f_82481_));
            BlockPos p1 = p0.m_7494_();
            if (!level.m_46859_(p0) || !level.m_46859_(p1)) continue;
            Vec3 pos = Vec3.m_82539_((Vec3i)p0);
            double dx = sp.m_20185_() - pos.f_82479_;
            double dz = sp.m_20189_() - pos.f_82481_;
            float yRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            ApparitionData ad = new ApparitionData();
            ad.id = UUID.randomUUID();
            ad.pos = pos;
            ad.yRot = yRot;
            ad.spawnTick = time;
            ad.scareTick = time + 30L;
            ad.vanishTick = ad.scareTick + 12L;
            long remain = ad.vanishTick - time + 5L;
            if (remain < 80L) {
                remain = 80L;
            }
            if (remain > Integer.MAX_VALUE) {
                remain = Integer.MAX_VALUE;
            }
            ad.lifetimeTicks = (int)remain;
            ad.skinType = S2CApparitionSpawnPacket.SkinType.STEVE;
            ad.mimicOf = null;
            ad.behindTurn = true;
            ad.didRotate = false;
            ad.lastWhisperIndex = -1;
            ad.nextWhisperTick = time + 20L + (long)rand.m_188503_(40);
            this.active.put(sp.m_20148_(), ad);
            this.stalkingChain.merge(sp.m_20148_(), 1, Integer::sum);
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CApparitionSpawnPacket(ad.id, ad.pos, ad.yRot, ad.skinType, ad.mimicOf, null, ad.lifetimeTicks));
            if (Managers.AMBIENT != null) {
                Managers.AMBIENT.playFootstepsBurst(sp, 1);
            }
            return;
        }
    }

    public boolean triggerAggressive(ServerPlayer sp, long time) {
        if (!((Boolean)Config.ENABLE_APPARITIONS.get()).booleanValue()) {
            return false;
        }
        if (PlayerFlags.isEscaped(sp) && !PlayerFlags.isReawakened(sp)) {
            return false;
        }
        ApparitionData existing = this.active.get(sp.m_20148_());
        if (existing != null && existing.testCharge) {
            return true;
        }
        if (existing != null) {
            return false;
        }
        ServerLevel level = sp.m_284548_();
        Vec3 look = sp.m_20154_();
        RandomSource rand = sp.m_217043_();
        int playerY = sp.m_20183_().m_123342_();
        Vec3 base = sp.m_20182_();
        double angleDeg = 180.0 + (rand.m_188500_() * 40.0 - 20.0);
        double angleRad = Math.toRadians(angleDeg);
        Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
        Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
        double dist = 9.0 + rand.m_188500_() * 5.0;
        Vec3 horiz = base.m_82549_(dir.m_82490_(dist));
        for (int dy = -2; dy <= 2; ++dy) {
            BlockPos p0 = new BlockPos(Mth.m_14107_((double)horiz.f_82479_), playerY + dy, Mth.m_14107_((double)horiz.f_82481_));
            BlockPos p1 = p0.m_7494_();
            if (!level.m_46859_(p0) || !level.m_46859_(p1)) continue;
            Vec3 pos = Vec3.m_82539_((Vec3i)p0);
            double dx = sp.m_20185_() - pos.f_82479_;
            double dz = sp.m_20189_() - pos.f_82481_;
            float yRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            ApparitionData ad = new ApparitionData();
            ad.id = UUID.randomUUID();
            ad.pos = pos;
            ad.yRot = yRot;
            ad.spawnTick = time;
            ad.lifetimeTicks = 80 + rand.m_188503_(40);
            ad.skinType = S2CApparitionSpawnPacket.SkinType.STEVE;
            ad.mimicOf = null;
            ad.testCharge = true;
            ad.damageAmount = 6.0f;
            ad.hitTick = 0L;
            ad.lastWhisperIndex = -1;
            ad.nextWhisperTick = time + 120L + (long)rand.m_188503_(120);
            ad.scareTick = time + 10L + (long)rand.m_188503_(10);
            ad.didRotate = false;
            this.active.put(sp.m_20148_(), ad);
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CApparitionSpawnPacket(ad.id, ad.pos, ad.yRot, ad.skinType, ad.mimicOf, null, ad.lifetimeTicks));
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(45, 1.0f));
            if (Managers.AMBIENT != null) {
                Managers.AMBIENT.playFootstepsBurst(sp, 6);
            }
            this.stalkingChain.put(sp.m_20148_(), 0);
            this.lastAggressiveTick.put(sp.m_20148_(), time);
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Apparition] {} triggered aggressive manually", (Object)sp.m_36316_().getName());
            }
            return true;
        }
        return false;
    }

    private boolean shouldForceAggressive(ServerPlayer sp, long time) {
        UUID id = sp.m_20148_();
        int chain = this.stalkingChain.getOrDefault(id, 0);
        if (chain < 3) {
            return false;
        }
        long last = this.lastAggressiveTick.getOrDefault(id, Long.MIN_VALUE);
        return time - last >= 1600L;
    }

    public void tick(MinecraftServer server, long time) {
        Iterator<Map.Entry<UUID, ApparitionData>> it = this.active.entrySet().iterator();
        while (it.hasNext()) {
            Vec3 to;
            float yaw;
            int dz;
            boolean airBelow;
            boolean hazard;
            BlockPos feet;
            ServerLevel lvl;
            Map.Entry<UUID, ApparitionData> e = it.next();
            ServerPlayer sp = server.m_6846_().m_11259_(e.getKey());
            if (sp == null) {
                it.remove();
                continue;
            }
            ApparitionData ad = e.getValue();
            if (ad.behindTurn) {
                if (!ad.didRotate && time < ad.scareTick) {
                    RandomSource r = sp.m_217043_();
                    if (Managers.AMBIENT != null && r.m_188500_() < 0.05) {
                        Managers.AMBIENT.playFootstepsBurst(sp, 1);
                    }
                    if (r.m_188500_() < 0.04) {
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(6));
                    }
                }
                if (!ad.didRotate && time >= ad.scareTick) {
                    lvl = sp.m_284548_();
                    feet = sp.m_20183_();
                    hazard = false;
                    if (lvl.m_6425_(feet).m_164512_((Fluid)Fluids.f_76195_) || lvl.m_6425_(feet.m_7495_()).m_164512_((Fluid)Fluids.f_76195_)) {
                        hazard = true;
                    }
                    airBelow = lvl.m_8055_(feet.m_7495_()).m_60795_();
                    block1: for (int dx = -1; dx <= 1 && !hazard; ++dx) {
                        for (dz = -1; dz <= 1 && !hazard; ++dz) {
                            BlockPos p = feet.m_7918_(dx, -1, dz);
                            if (!lvl.m_6425_(p).m_164512_((Fluid)Fluids.f_76195_) && !lvl.m_8055_(p).m_60713_(Blocks.f_50083_)) continue;
                            hazard = true;
                            continue block1;
                        }
                    }
                    if (!hazard && !airBelow) {
                        double dxr = ad.pos.f_82479_ - sp.m_20185_();
                        double dzr = ad.pos.f_82481_ - sp.m_20189_();
                        yaw = (float)(Mth.m_14136_((double)dzr, (double)dxr) * 57.29577951308232) - 90.0f;
                        sp.m_8999_(sp.m_284548_(), sp.m_20185_(), sp.m_20186_(), sp.m_20189_(), yaw, sp.m_146909_());
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(28));
                    } else {
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(12));
                    }
                    ad.didRotate = true;
                }
                if (ad.didRotate && ad.vanishTick > 0L && time >= ad.vanishTick) {
                    this.vanish(server, sp, ad, time);
                    it.remove();
                    continue;
                }
            }
            if (ad.testCharge) {
                boolean los;
                Vec3 to2;
                if (!ad.didRotate && ad.scareTick > 0L && time >= ad.scareTick) {
                    lvl = sp.m_284548_();
                    feet = sp.m_20183_();
                    hazard = false;
                    if (lvl.m_6425_(feet).m_164512_((Fluid)Fluids.f_76195_) || lvl.m_6425_(feet.m_7495_()).m_164512_((Fluid)Fluids.f_76195_)) {
                        hazard = true;
                    }
                    airBelow = lvl.m_8055_(feet.m_7495_()).m_60795_();
                    block3: for (int dx = -1; dx <= 1 && !hazard; ++dx) {
                        for (dz = -1; dz <= 1 && !hazard; ++dz) {
                            BlockPos p = feet.m_7918_(dx, -1, dz);
                            if (!lvl.m_6425_(p).m_164512_((Fluid)Fluids.f_76195_) && !lvl.m_8055_(p).m_60713_(Blocks.f_50083_)) continue;
                            hazard = true;
                            continue block3;
                        }
                    }
                    if (!hazard && !airBelow) {
                        double dxr = ad.pos.f_82479_ - sp.m_20185_();
                        double dzr = ad.pos.f_82481_ - sp.m_20189_();
                        yaw = (float)(Mth.m_14136_((double)dzr, (double)dxr) * 57.29577951308232) - 90.0f;
                        sp.m_8999_(sp.m_284548_(), sp.m_20185_(), sp.m_20186_(), sp.m_20189_(), yaw, sp.m_146909_());
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(18));
                        ad.didRotate = true;
                    } else {
                        ad.scareTick = time + 15L;
                        ad.didRotate = false;
                        ad.hitTick = 0L;
                        ad.stareTicks = 0;
                        ad.windupBreakTicks = 0;
                        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                            LOGGER.info("[Apparition] {} charge blocked by hazard -> reschedule scareTick={}", (Object)sp.m_36316_().getName(), (Object)ad.scareTick);
                        }
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(10));
                        continue;
                    }
                }
                Vec3 eyePos = sp.m_146892_();
                Vec3 look = sp.m_20154_().m_82541_();
                double dot = look.m_82526_(to2 = ad.pos.m_82520_(0.0, 1.62, 0.0).m_82546_(eyePos).m_82541_());
                boolean facing = dot > Math.cos(Math.toRadians(22.0));
                BlockHitResult hr = sp.m_284548_().m_45547_(new ClipContext(eyePos, ad.pos.m_82520_(0.0, 1.62, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)sp));
                boolean bl = los = hr.m_6662_() == HitResult.Type.MISS;
                if (facing && los) {
                    ++ad.stareTicks;
                    if (ad.stareTicks == 1) {
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(10));
                    }
                } else {
                    ad.stareTicks = Math.max(0, ad.stareTicks - 2);
                }
                if (ad.hitTick <= 0L && ad.stareTicks >= 16) {
                    ad.hitTick = time + 8L;
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(40));
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CApparitionChargePacket(ad.id, 8));
                    ad.windupBreakTicks = 0;
                }
                if (!(ad.hitTick <= 0L || time >= ad.hitTick || facing && los)) {
                    ++ad.windupBreakTicks;
                    if (ad.windupBreakTicks >= 6) {
                        ad.hitTick = time + 12L;
                        ad.windupBreakTicks = 0;
                        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                            LOGGER.info("[Apparition] {} charge windup broken -> retry at {}", (Object)sp.m_36316_().getName(), (Object)ad.hitTick);
                        }
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(8));
                        if (Managers.AMBIENT != null) {
                            Managers.AMBIENT.playFootstepsBurst(sp, 1);
                        }
                    }
                }
                if (ad.hitTick > 0L && time >= ad.hitTick) {
                    if (facing && los) {
                        sp.m_6469_(sp.m_269291_().m_269264_(), ad.damageAmount <= 0.0f ? 4.0f : ad.damageAmount);
                    } else if (facing) {
                        sp.m_6469_(sp.m_269291_().m_269264_(), (ad.damageAmount <= 0.0f ? 4.0f : ad.damageAmount) * 0.6f);
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(18));
                    } else {
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(12));
                        if (Managers.AMBIENT != null) {
                            Managers.AMBIENT.playFootstepsBurst(sp, 1);
                        }
                    }
                    this.vanish(server, sp, ad, time);
                    it.remove();
                    continue;
                }
            }
            RandomSource rr = sp.m_217043_();
            if (ad.nextWhisperTick <= 0L) {
                ad.nextWhisperTick = time + 180L + (long)rr.m_188503_(300);
            }
            if (time >= ad.nextWhisperTick) {
                if (rr.m_188500_() < 0.25) {
                    int idx = rr.m_188503_(WHISPERS.length);
                    if (ad.lastWhisperIndex >= 0 && idx == ad.lastWhisperIndex) {
                        idx = (idx + 1 + rr.m_188503_(Math.max(1, WHISPERS.length - 1))) % WHISPERS.length;
                    }
                    String msg = WHISPERS[idx];
                    ad.lastWhisperIndex = idx;
                    String sender = rr.m_188500_() < 0.5 ? "Guest" : "???";
                    sp.m_213846_(ApparitionManager.chatLike(sender, msg));
                }
                ad.nextWhisperTick = time + (long)(180 + rr.m_188503_(300));
            }
            if (ad.testCharge && ad.hitTick > 0L) {
                ad.lifetimeTicks = (int)Math.max((long)ad.lifetimeTicks, time - ad.spawnTick + 60L);
            } else if (time >= ad.spawnTick + (long)ad.lifetimeTicks) {
                this.vanish(server, sp, ad, time);
                it.remove();
                continue;
            }
            if (!ad.testCharge && !ad.behindTurn && sp.m_20182_().m_82557_(ad.pos) <= 64.0) {
                this.vanish(server, sp, ad, time);
                it.remove();
                continue;
            }
            if (ad.testCharge || ad.behindTurn) continue;
            Vec3 look = sp.m_20154_().m_82541_();
            double dot = look.m_82526_(to = ad.pos.m_82546_(sp.m_146892_()).m_82541_());
            if (dot > Math.cos(Math.toRadians(15.0))) {
                ++ad.stareTicks;
                if (ad.stareTicks == 1 && sp.m_217043_().m_188500_() < 0.15) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(8));
                }
                if (ad.stareTicks <= 20) continue;
                this.vanish(server, sp, ad, time);
                it.remove();
                continue;
            }
            ad.stareTicks = Math.max(0, ad.stareTicks - 1);
        }
    }

    public void maybeSpawnFor(ServerPlayer sp, long time) {
        boolean underground;
        ServerLevel level;
        Vec3 pos;
        double baseChance;
        if (!((Boolean)Config.ENABLE_APPARITIONS.get()).booleanValue()) {
            return;
        }
        if (PlayerFlags.isEscaped(sp) && !PlayerFlags.isReawakened(sp)) {
            return;
        }
        if (this.active.containsKey(sp.m_20148_())) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[TheForgotten] Apparition roll skipped for {}: one already active.", (Object)sp.m_36316_().getName());
            }
            return;
        }
        double roll = sp.m_217043_().m_188500_();
        double chance = baseChance = RuntimeTuning.apparitionChance();
        if (PlayerFlags.isReawakened(sp)) {
            chance = Math.min(0.95, chance * 1.8);
        }
        if (sp.m_9236_().m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            chance = Math.min(0.95, chance * 4.2);
        }
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            LOGGER.info("[Apparition] {} roll={} baseChance={} adjustedChance={} reawakened={} lure={} chain={} lastAgg={}", new Object[]{sp.m_36316_().getName(), String.format("%.3f", roll), String.format("%.3f", baseChance), String.format("%.3f", chance), PlayerFlags.isReawakened(sp), sp.m_9236_().m_46472_().equals(LureDimensionManager.LURE_DIM), this.stalkingChain.getOrDefault(sp.m_20148_(), 0), this.lastAggressiveTick.getOrDefault(sp.m_20148_(), -1L)});
        }
        if (roll > chance) {
            return;
        }
        boolean inLure = sp.m_9236_().m_46472_().equals(LureDimensionManager.LURE_DIM);
        boolean doChargeCorridor = inLure && sp.m_217043_().m_188500_() < 0.22;
        boolean doChargeCave = false;
        if (!inLure && ((Boolean)Config.CAVES_CHARGE_ENABLED.get()).booleanValue()) {
            boolean darkEnough;
            ServerLevel lvl = sp.m_284548_();
            boolean undergroundOK = (Boolean)Config.CAVES_REQUIRE_UNDERGROUND.get() == false || !lvl.m_46861_(sp.m_20183_());
            int light = lvl.m_46803_(sp.m_20183_());
            boolean bl = darkEnough = light <= (Integer)Config.CAVES_MIN_LIGHT.get();
            if (undergroundOK && darkEnough) {
                boolean bl2 = doChargeCave = sp.m_217043_().m_188500_() < (Double)Config.CAVES_CHARGE_CHANCE.get();
            }
        }
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            LOGGER.info("[Apparition] {} chargeCheck corridor={} cave={}", new Object[]{sp.m_36316_().getName(), doChargeCorridor, doChargeCave});
        }
        if (doChargeCorridor || doChargeCave) {
            ServerLevel level2 = sp.m_284548_();
            Vec3 eye = sp.m_146892_();
            Vec3 look = sp.m_20154_();
            RandomSource rand = sp.m_217043_();
            int playerY = sp.m_20183_().m_123342_();
            Vec3 base = sp.m_20182_();
            double angleDeg = 180.0 + (rand.m_188500_() * 40.0 - 20.0);
            double angleRad = Math.toRadians(angleDeg);
            Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
            Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
            double dist = 10.0 + rand.m_188500_() * 6.0;
            Vec3 horiz = base.m_82549_(dir.m_82490_(dist));
            for (int dy = -2; dy <= 2; ++dy) {
                BlockPos p0 = new BlockPos(Mth.m_14107_((double)horiz.f_82479_), playerY + dy, Mth.m_14107_((double)horiz.f_82481_));
                BlockPos p1 = p0.m_7494_();
                if (!level2.m_46859_(p0) || !level2.m_46859_(p1)) continue;
                Vec3 pos2 = Vec3.m_82539_((Vec3i)p0);
                double dx = sp.m_20185_() - pos2.f_82479_;
                double dz = sp.m_20189_() - pos2.f_82481_;
                float yRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                ApparitionData ad = new ApparitionData();
                ad.id = UUID.randomUUID();
                ad.pos = pos2;
                ad.yRot = yRot;
                ad.spawnTick = time;
                ad.lifetimeTicks = 70 + rand.m_188503_(40);
                ad.skinType = S2CApparitionSpawnPacket.SkinType.STEVE;
                ad.mimicOf = null;
                ad.testCharge = true;
                ad.hitTick = 0L;
                ad.damageAmount = inLure ? 4.0f : 1.5f;
                ad.lastWhisperIndex = -1;
                ad.nextWhisperTick = time + 180L + (long)rand.m_188503_(300);
                this.active.put(sp.m_20148_(), ad);
                this.stalkingChain.put(sp.m_20148_(), 0);
                this.lastAggressiveTick.put(sp.m_20148_(), time);
                if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                    LOGGER.info("[Apparition] {} charge spawn type={} pos=({}, {}, {})", new Object[]{sp.m_36316_().getName(), doChargeCorridor ? "corridor" : "cave", String.format("%.1f", ad.pos.f_82479_), String.format("%.1f", ad.pos.f_82480_), String.format("%.1f", ad.pos.f_82481_)});
                }
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CApparitionSpawnPacket(ad.id, ad.pos, ad.yRot, ad.skinType, ad.mimicOf, null, ad.lifetimeTicks));
                if (Managers.AMBIENT != null) {
                    if (rand.m_188500_() < 0.8) {
                        Managers.AMBIENT.playFootstepsBurst(sp, 5);
                    } else {
                        Managers.AMBIENT.playFootstepsBurst(sp, 3);
                    }
                }
                ad.didRotate = false;
                ad.scareTick = time + 14L + (long)rand.m_188503_(8);
                return;
            }
        }
        if (!doChargeCorridor && !doChargeCave && this.shouldForceAggressive(sp, time)) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Apparition] {} forcing aggressive after chain {}", (Object)sp.m_36316_().getName(), (Object)this.stalkingChain.getOrDefault(sp.m_20148_(), 0));
            }
            if (this.triggerAggressive(sp, time)) {
                this.stalkingChain.put(sp.m_20148_(), 0);
                this.lastAggressiveTick.put(sp.m_20148_(), time);
                return;
            }
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[Apparition] {} force aggressive failed (existing active?)", (Object)sp.m_36316_().getName());
            }
        }
        if (!inLure && ((Boolean)Config.BEHIND_TURN_ENABLED.get()).booleanValue()) {
            double behindTurnChance = Math.max(0.0, Math.min(1.0, (Double)Config.BEHIND_TURN_CHANCE.get() * 0.65));
            if (sp.m_217043_().m_188500_() < behindTurnChance) {
                if (this.attemptBehindTurnSpawn(sp, time)) {
                    int newChain = this.stalkingChain.merge(sp.m_20148_(), 1, Integer::sum);
                    if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                        LOGGER.info("[Apparition] {} behind-turn spawn chain={}", (Object)sp.m_36316_().getName(), (Object)newChain);
                    }
                    return;
                }
                if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                    LOGGER.info("[Apparition] {} behind-turn placement failed", (Object)sp.m_36316_().getName());
                }
            }
        }
        if ((pos = this.pickSpawnPos(level = sp.m_284548_(), sp)) == null) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[TheForgotten] Apparition roll for {} failed: no valid spawn position.", (Object)sp.m_36316_().getName());
            }
            return;
        }
        S2CApparitionSpawnPacket.SkinType skin = S2CApparitionSpawnPacket.SkinType.STEVE;
        UUID mimic = null;
        String mimicName = null;
        if (sp.m_217043_().m_188500_() < RuntimeTuning.apparitionMimicChance()) {
            ArrayList<ServerPlayer> others = new ArrayList<ServerPlayer>();
            for (ServerPlayer op : sp.f_8924_.m_6846_().m_11314_()) {
                if (op == sp) continue;
                others.add(op);
            }
            if (!others.isEmpty()) {
                ServerPlayer pick = (ServerPlayer)others.get(sp.m_217043_().m_188503_(others.size()));
                mimic = pick.m_20148_();
                mimicName = pick.m_36316_().getName();
                skin = S2CApparitionSpawnPacket.SkinType.MIMIC;
            } else {
                mimic = sp.m_20148_();
                mimicName = sp.m_36316_().getName();
                skin = S2CApparitionSpawnPacket.SkinType.MIMIC;
            }
        }
        double dx2 = sp.m_20185_() - pos.f_82479_;
        double dz2 = sp.m_20189_() - pos.f_82481_;
        float yRot = (float)(Mth.m_14136_((double)dz2, (double)dx2) * 57.29577951308232) - 90.0f;
        boolean bl = underground = !level.m_46861_(sp.m_20183_());
        int lifetime = sp.m_9236_().m_46472_().equals(LureDimensionManager.LURE_DIM) ? 70 + sp.m_217043_().m_188503_(70) : (underground ? 60 + sp.m_217043_().m_188503_(60) : 40 + sp.m_217043_().m_188503_(40));
        ApparitionData ad = new ApparitionData();
        ad.id = UUID.randomUUID();
        ad.pos = pos;
        ad.yRot = yRot;
        ad.spawnTick = time;
        ad.lifetimeTicks = lifetime;
        ad.skinType = skin;
        ad.mimicOf = mimic;
        this.active.put(sp.m_20148_(), ad);
        int chainAfter = this.stalkingChain.merge(sp.m_20148_(), 1, Integer::sum);
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            LOGGER.info("[Apparition] {} stalking spawn chain={} pos=({}, {}, {})", new Object[]{sp.m_36316_().getName(), chainAfter, String.format("%.1f", ad.pos.f_82479_), String.format("%.1f", ad.pos.f_82480_), String.format("%.1f", ad.pos.f_82481_)});
        }
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CApparitionSpawnPacket(ad.id, ad.pos, ad.yRot, ad.skinType, ad.mimicOf, mimicName, ad.lifetimeTicks));
    }

    private boolean attemptBehindTurnSpawn(ServerPlayer sp, long time) {
        RandomSource rand = sp.m_217043_();
        ServerLevel level = sp.m_284548_();
        Vec3 look = sp.m_20154_();
        int playerY = sp.m_20183_().m_123342_();
        Vec3 base = sp.m_20182_();
        double angleDeg = 180.0 + (rand.m_188500_() * 40.0 - 20.0);
        double angleRad = Math.toRadians(angleDeg);
        Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
        Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
        double dist = 6.0 + rand.m_188500_() * 4.0;
        Vec3 horiz = base.m_82549_(dir.m_82490_(dist));
        for (int dy = -1; dy <= 1; ++dy) {
            BlockPos p0 = new BlockPos(Mth.m_14107_((double)horiz.f_82479_), playerY + dy, Mth.m_14107_((double)horiz.f_82481_));
            BlockPos p1 = p0.m_7494_();
            if (!level.m_46859_(p0) || !level.m_46859_(p1)) continue;
            Vec3 pos = Vec3.m_82539_((Vec3i)p0);
            double dx = sp.m_20185_() - pos.f_82479_;
            double dz = sp.m_20189_() - pos.f_82481_;
            float yRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            ApparitionData ad = new ApparitionData();
            ad.id = UUID.randomUUID();
            ad.pos = pos;
            ad.yRot = yRot;
            ad.spawnTick = time;
            int minB = (Integer)Config.BEHIND_TURN_BUILDUP_MIN_TICKS.get();
            int maxB = Math.max(minB, (Integer)Config.BEHIND_TURN_BUILDUP_MAX_TICKS.get());
            int buildup = minB + rand.m_188503_(Math.max(1, maxB - minB + 1));
            ad.scareTick = time + (long)buildup;
            ad.vanishTick = ad.scareTick + (long)(10 + rand.m_188503_(10));
            long remain = ad.vanishTick - time + 5L;
            if (remain < 80L) {
                remain = 80L;
            }
            if (remain > Integer.MAX_VALUE) {
                remain = Integer.MAX_VALUE;
            }
            ad.lifetimeTicks = (int)remain;
            ad.skinType = S2CApparitionSpawnPacket.SkinType.STEVE;
            ad.mimicOf = null;
            ad.behindTurn = true;
            ad.didRotate = false;
            ad.lastWhisperIndex = -1;
            ad.nextWhisperTick = time + 20L + (long)rand.m_188503_(60);
            this.active.put(sp.m_20148_(), ad);
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CApparitionSpawnPacket(ad.id, ad.pos, ad.yRot, ad.skinType, ad.mimicOf, null, ad.lifetimeTicks));
            if (Managers.AMBIENT != null) {
                Managers.AMBIENT.playFootstepsBurst(sp, 5);
            }
            return true;
        }
        return false;
    }

    private void vanish(MinecraftServer server, ServerPlayer sp, ApparitionData ad, long time) {
        BlockPos target;
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CApparitionVanishPacket(ad.id));
        CompoundTag noteData = null;
        try {
            CompoundTag tag = sp.getPersistentData();
            noteData = tag.m_128469_("theforgotten_apparitions");
            this.ensureNoteGate(noteData, sp);
            int seen = noteData.m_128451_("seenCount") + 1;
            noteData.m_128405_("seenCount", seen);
            if (noteData.m_128471_("noteCooldown")) {
                noteData.m_128379_("noteCooldown", false);
                tag.m_128365_("theforgotten_apparitions", (Tag)noteData);
                return;
            }
            int gate = noteData.m_128451_("noteGate");
            tag.m_128365_("theforgotten_apparitions", (Tag)noteData);
            if (seen < gate) {
                return;
            }
        }
        catch (Throwable ignored) {
            return;
        }
        if (ad.testCharge) {
            return;
        }
        if (PlayerFlags.isEscaped(sp) && !PlayerFlags.isReawakened(sp)) {
            return;
        }
        if (sp.m_217043_().m_188500_() >= 0.35) {
            this.resetNoteProgress(sp, noteData, false);
            return;
        }
        ServerLevel level = sp.m_284548_();
        if (level.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            return;
        }
        if (Managers.MICRO == null) {
            return;
        }
        BlockPos start = BlockPos.m_274561_((double)Math.floor(ad.pos.f_82479_), (double)Math.floor(ad.pos.f_82480_), (double)Math.floor(ad.pos.f_82481_));
        BlockPos ground = this.findGround(level, start, 16);
        if (ground == null) {
            ground = sp.m_20183_();
        }
        if ((target = Managers.MICRO.scheduleLureForNoteFor(sp, level, ground, sp.m_217043_(), time)) == null) {
            this.resetNoteProgress(sp, noteData, false);
            return;
        }
        char axis = sp.m_217043_().m_188499_() ? (char)'X' : 'Z';
        int val = axis == 'X' ? target.m_123341_() : target.m_123343_();
        String hint = ApparitionManager.buildAxisHint(level, axis, val);
        ItemStack paper = new ItemStack((ItemLike)Items.f_42516_);
        paper.m_41714_((Component)Component.m_237113_((String)hint));
        ItemEntity ent = new ItemEntity((Level)level, (double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 1.0, (double)ground.m_123343_() + 0.5, paper);
        level.m_7967_((Entity)ent);
        this.resetNoteProgress(sp, noteData, true);
    }

    private void ensureNoteGate(CompoundTag noteData, ServerPlayer sp) {
        if (!noteData.m_128441_("noteGate")) {
            noteData.m_128405_("noteGate", this.nextNoteGate(sp));
        }
    }

    private void resetNoteProgress(ServerPlayer sp, CompoundTag noteData, boolean cooldown) {
        if (noteData == null) {
            return;
        }
        noteData.m_128405_("seenCount", 0);
        noteData.m_128405_("noteGate", this.nextNoteGate(sp));
        noteData.m_128379_("noteCooldown", cooldown);
        sp.getPersistentData().m_128365_("theforgotten_apparitions", (Tag)noteData);
    }

    private int nextNoteGate(ServerPlayer sp) {
        return 6 + sp.m_217043_().m_188503_(4);
    }

    private static String buildAxisHint(ServerLevel level, char axis, int value) {
        int step = 128;
        int half = 64;
        int anchor = ApparitionManager.worldAnchor(level, step);
        int bucket = (int)Math.round(((double)value - (double)anchor) / (double)step) * step + anchor;
        String dir = axis == 'X' ? (value < 0 ? "W" : "E") : (value < 0 ? "N" : "S");
        return axis + " \u2248 " + bucket + " (" + dir + " \u00b1" + half + ")";
    }

    private static int worldAnchor(ServerLevel level, int step) {
        long s = level.m_7328_();
        long mix = s ^ s >>> 33 ^ s << 11;
        int mod = step;
        int off = Math.floorMod(mix, mod);
        return off - step / 2;
    }

    private Vec3 pickSpawnPos(ServerLevel level, ServerPlayer sp) {
        Vec3 eye = sp.m_146892_();
        Vec3 look = sp.m_20154_();
        RandomSource rand = sp.m_217043_();
        boolean underground = !level.m_46861_(sp.m_20183_());
        int playerY = sp.m_20183_().m_123342_();
        Vec3 base = sp.m_20182_();
        for (int i = 0; i < 16; ++i) {
            Vec3 center;
            Vec3 head;
            BlockHitResult hr;
            double distMax;
            double distMin;
            double angleDeg;
            if (underground) {
                angleDeg = rand.m_188500_() * 60.0 - 30.0;
                distMin = 8.0;
                distMax = 16.0;
            } else {
                angleDeg = (double)(rand.m_188499_() ? 140 : -140) + rand.m_188500_() * 40.0;
                distMin = 12.0;
                distMax = 24.0;
            }
            double angleRad = Math.toRadians(angleDeg);
            Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
            Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
            double dist = distMin + rand.m_188500_() * (distMax - distMin);
            Vec3 horiz = base.m_82549_(dir.m_82490_(dist));
            BlockPos ground = this.findGround(level, BlockPos.m_274561_((double)horiz.f_82479_, (double)playerY, (double)horiz.f_82481_), 8);
            if (ground == null) continue;
            BlockPos air0 = ground.m_7494_();
            BlockPos air1 = air0.m_7494_();
            if (!level.m_46859_(air0) || !level.m_46859_(air1) || (hr = level.m_45547_(new ClipContext(eye, head = (center = Vec3.m_82539_((Vec3i)air0)).m_82520_(0.0, 1.62, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)sp))).m_6662_() != HitResult.Type.MISS) continue;
            return center;
        }
        return null;
    }

    private BlockPos findGround(ServerLevel level, BlockPos start, int range) {
        BlockPos p;
        int dy;
        BlockPos pos = start;
        for (dy = 0; dy < range; ++dy) {
            p = pos.m_6625_(dy);
            if (!this.canStandOn(level, p)) continue;
            return p;
        }
        for (dy = 1; dy < range; ++dy) {
            p = pos.m_6630_(dy);
            if (!this.canStandOn(level, p)) continue;
            return p;
        }
        return null;
    }

    private boolean canStandOn(ServerLevel level, BlockPos p) {
        BlockState state = level.m_8055_(p);
        if (state.m_60713_(Blocks.f_152499_)) {
            return false;
        }
        if (state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_50127_)) {
            return true;
        }
        return Block.m_49863_((LevelReader)level, (BlockPos)p, (Direction)Direction.UP);
    }

    public void spawnChargeTest(ServerPlayer sp, long time) {
        if (this.active.containsKey(sp.m_20148_())) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[TheForgotten] Charge test skipped for {}: one already active.", (Object)sp.m_36316_().getName());
            }
            return;
        }
        ServerLevel level = sp.m_284548_();
        Vec3 eye = sp.m_146892_();
        Vec3 look = sp.m_20154_();
        RandomSource rand = sp.m_217043_();
        int playerY = sp.m_20183_().m_123342_();
        Vec3 base = sp.m_20182_();
        double angleDeg = 180.0 + (rand.m_188500_() * 40.0 - 20.0);
        double angleRad = Math.toRadians(angleDeg);
        Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
        Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
        double dist = 10.0 + rand.m_188500_() * 6.0;
        Vec3 horiz = base.m_82549_(dir.m_82490_(dist));
        BlockPos p0 = new BlockPos(Mth.m_14107_((double)horiz.f_82479_), playerY, Mth.m_14107_((double)horiz.f_82481_));
        BlockPos p1 = p0.m_7494_();
        if (!level.m_46859_(p0) || !level.m_46859_(p1)) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[TheForgotten] Charge test failed for {}: space blocked.", (Object)sp.m_36316_().getName());
            }
            return;
        }
        Vec3 pos = Vec3.m_82539_((Vec3i)p0);
        Vec3 head = pos.m_82520_(0.0, 1.62, 0.0);
        BlockHitResult hr = level.m_45547_(new ClipContext(eye, head, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)sp));
        if (hr.m_6662_() != HitResult.Type.MISS) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                LOGGER.info("[TheForgotten] Charge test failed for {}: obstructed.", (Object)sp.m_36316_().getName());
            }
            return;
        }
        double dx = sp.m_20185_() - pos.f_82479_;
        double dz = sp.m_20189_() - pos.f_82481_;
        float yRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        ApparitionData ad = new ApparitionData();
        ad.id = UUID.randomUUID();
        ad.pos = pos;
        ad.yRot = yRot;
        ad.spawnTick = time;
        ad.lifetimeTicks = 60;
        ad.skinType = S2CApparitionSpawnPacket.SkinType.STEVE;
        ad.mimicOf = null;
        ad.testCharge = true;
        ad.hitTick = 0L;
        ad.damageAmount = 6.0f;
        this.active.put(sp.m_20148_(), ad);
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CApparitionSpawnPacket(ad.id, ad.pos, ad.yRot, ad.skinType, ad.mimicOf, null, ad.lifetimeTicks));
        sp.m_213846_((Component)Component.m_237113_((String)"[TheForgotten] Charge test spawned behind you. Brace!"));
    }

    public void debugWhisper(ServerPlayer sp) {
        ServerPlayer mp;
        RandomSource rr = sp.m_217043_();
        ApparitionData ad = this.active.get(sp.m_20148_());
        int last = ad != null ? ad.lastWhisperIndex : -1;
        int idx = rr.m_188503_(WHISPERS.length);
        if (last >= 0 && idx == last) {
            idx = (idx + 1 + rr.m_188503_(Math.max(1, WHISPERS.length - 1))) % WHISPERS.length;
        }
        String sender = "???";
        if (ad != null && ad.mimicOf != null && (mp = sp.f_8924_.m_6846_().m_11259_(ad.mimicOf)) != null) {
            sender = mp.m_36316_().getName();
        }
        sp.m_213846_(ApparitionManager.chatLike(sender, WHISPERS[idx]));
        if (ad != null) {
            ad.lastWhisperIndex = idx;
            ad.nextWhisperTick = sp.f_8924_.m_129921_() + 80;
        }
    }

    private static class ApparitionData {
        UUID id;
        Vec3 pos;
        float yRot;
        long spawnTick;
        int lifetimeTicks;
        int stareTicks;
        UUID mimicOf;
        S2CApparitionSpawnPacket.SkinType skinType;
        boolean testCharge;
        long hitTick;
        float damageAmount;
        int windupBreakTicks;
        boolean behindTurn;
        boolean didRotate;
        long scareTick;
        long vanishTick;
        int lastWhisperIndex;
        long nextWhisperTick;

        private ApparitionData() {
        }
    }
}

