/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.tasuposed.theforgotten.Config;
import net.tasuposed.theforgotten.network.NetworkHandler;
import net.tasuposed.theforgotten.network.S2CForceGlitchPacket;
import net.tasuposed.theforgotten.network.S2CPositionalSoundPacket;
import net.tasuposed.theforgotten.server.Managers;
import net.tasuposed.theforgotten.server.PlayerFlags;
import net.tasuposed.theforgotten.server.ServerEvents;
import org.slf4j.Logger;

public class LureDimensionManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<Level> LURE_DIM = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("theforgotten", "lure"));
    public static final ResourceKey<Level> EXIT_TARGET_DIM = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("theforgotten", "beyond"));
    private final Set<Long> processed = new HashSet<Long>();
    private final Set<UUID> spawnedStart = new HashSet<UUID>();
    private final Set<Long> exitProhibited = new HashSet<Long>();
    private final Set<Long> exitChunks = new HashSet<Long>();
    private final Set<Long> buttonChunks = new HashSet<Long>();
    private final Map<UUID, Long> nextExitFeedbackTick = new HashMap<UUID, Long>();
    public static final int BASE_Y = 48;
    public static final int CORRIDOR_H = 3;
    public static final int CELL = 8;

    public void onChunkLoad(ServerLevel level, LevelChunk chunk) {
        if (!level.m_46472_().equals(LURE_DIM)) {
            return;
        }
    }

    private boolean tryPlaceTrialButton(ServerLevel level, int baseX, int baseZ, RandomSource r) {
        for (int tries = 0; tries < 28; ++tries) {
            int lz;
            int z;
            int lx = r.m_188503_(16);
            int x = baseX + lx;
            if (!this.isCorridor(x, z = baseZ + (lz = r.m_188503_(16)))) continue;
            BlockPos base = new BlockPos(x, 48, z);
            BlockPos top = base.m_7494_();
            if (!level.m_8055_(base).m_60795_() || !level.m_8055_(top).m_60795_() || level.m_8055_(base.m_7495_()).m_60795_()) continue;
            this.set(level, base, Blocks.f_50734_.m_49966_());
            BlockState btn = (BlockState)((BlockState)Blocks.f_50124_.m_49966_().m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
            this.set(level, top, btn);
            return true;
        }
        return false;
    }

    public boolean debugPlaceExitNear(ServerPlayer sp) {
        if (!sp.m_9236_().m_46472_().equals(LURE_DIM)) {
            return false;
        }
        ServerLevel level = (ServerLevel)sp.m_9236_();
        ChunkPos cp = new ChunkPos(sp.m_20183_());
        int baseX = cp.m_45604_();
        int baseZ = cp.m_45605_();
        for (int lz = 1; lz < 15; ++lz) {
            for (int lx = 1; lx < 15; ++lx) {
                int x = baseX + lx;
                int z = baseZ + lz;
                if (!this.isCorridor(x, z)) continue;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        for (int y = 48; y < 51; ++y) {
                            this.set(level, new BlockPos(x + dx, y, z + dz), Blocks.f_50016_.m_49966_());
                        }
                        this.set(level, new BlockPos(x + dx, 47, z + dz), Blocks.f_50652_.m_49966_());
                    }
                }
                BlockPos pad = new BlockPos(x, 48, z);
                this.set(level, pad.m_7495_(), Blocks.f_50734_.m_49966_());
                this.set(level, pad, Blocks.f_50165_.m_49966_());
                BlockPos signPos = pad.m_122012_();
                this.set(level, signPos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(0)));
                BlockEntity be = level.m_7702_(signPos);
                if (be instanceof SignBlockEntity) {
                    SignBlockEntity sign = (SignBlockEntity)be;
                    try {
                        SignText front = sign.m_277142_();
                        front = front.m_276913_(0, (Component)Component.m_237113_((String)"EXIT"));
                        front = front.m_276913_(1, (Component)Component.m_237113_((String)">>>"));
                        sign.m_276956_(front, true);
                        sign.m_6596_();
                        level.m_7260_(signPos, level.m_8055_(signPos), level.m_8055_(signPos), 3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void tick(MinecraftServer server) {
        ServerLevel level = server.m_129880_(LURE_DIM);
        if (level == null) {
            return;
        }
        long now = server.m_129921_();
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            if (!sp.m_9236_().m_46472_().equals(LURE_DIM)) continue;
            BlockPos feet = sp.m_20183_();
            List mobs = level.m_45976_(Mob.class, new AABB(feet).m_82400_(32.0));
            for (Mob m : mobs) {
                if (m.m_213877_()) continue;
                m.m_146870_();
            }
            BlockPos at = feet;
            BlockPos under = feet.m_7495_();
            BlockPos platePos = null;
            if (level.m_8055_(at).m_60713_(Blocks.f_50165_) && level.m_8055_(at.m_7495_()).m_60713_(Blocks.f_50734_)) {
                platePos = at;
            } else if (level.m_8055_(under).m_60713_(Blocks.f_50165_) && level.m_8055_(under.m_7495_()).m_60713_(Blocks.f_50734_)) {
                platePos = under;
            }
            if (platePos != null) {
                if (((Boolean)Config.TRIAL_ENABLED.get()).booleanValue() && !PlayerFlags.isTrialComplete(sp)) {
                    Long next = this.nextExitFeedbackTick.get(sp.m_20148_());
                    if (next != null && now < next) continue;
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(40, 0.5f));
                    ResourceLocation sFail = new ResourceLocation("theforgotten", "fail");
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(sFail, sp.m_20185_(), sp.m_20186_() + (double)sp.m_20192_(), sp.m_20189_(), 1.0f, 1.0f, SoundSource.MASTER));
                    int have = Math.min(PlayerFlags.getTrialPressedCount(sp), (Integer)Config.TRIAL_REQUIRED_BUTTONS.get());
                    int need = (Integer)Config.TRIAL_REQUIRED_BUTTONS.get();
                    sp.m_213846_((Component)Component.m_237113_((String)("analysis: INCOMPLETE (" + have + "/" + need + ")")));
                    this.nextExitFeedbackTick.put(sp.m_20148_(), now + 40L);
                    continue;
                }
                this.teleportToExit(server, sp);
                continue;
            }
            if (!this.spawnedStart.contains(sp.m_20148_())) {
                BlockPos center = BlockPos.m_274561_((double)sp.m_20185_(), (double)48.0, (double)sp.m_20189_());
                level.m_46745_(center);
                this.buildSpawnRoom(level, center, level.m_213780_());
                this.markNoExitZoneAround(center, 6);
                sp.m_8999_(level, (double)center.m_123341_() + 0.5, 49.0, (double)center.m_123343_() + 0.5, sp.m_146908_(), sp.m_146909_());
                this.paintChunk(level, level.m_46745_(center));
                this.processed.add(new ChunkPos(center).m_45588_());
                this.spawnedStart.add(sp.m_20148_());
                continue;
            }
            int budget = (Boolean)Config.DEBUG_LOGS.get() != false ? 14 : 8;
            ChunkPos center = new ChunkPos(feet);
            for (int dz = -1; dz <= 1 && budget > 0; ++dz) {
                for (int dx = -1; dx <= 1 && budget > 0; ++dx) {
                    ChunkPos cp = new ChunkPos(center.f_45578_ + dx, center.f_45579_ + dz);
                    long key = cp.m_45588_();
                    if (this.processed.contains(key) || !level.m_7232_(cp.f_45578_, cp.f_45579_)) continue;
                    LevelChunk chunk = level.m_6325_(cp.f_45578_, cp.f_45579_);
                    this.paintChunk(level, chunk);
                    this.processed.add(key);
                    --budget;
                }
            }
        }
    }

    public void teleportToSpawnRoom(MinecraftServer server, ServerPlayer sp) {
        ServerLevel dst = server.m_129880_(LURE_DIM);
        if (dst == null) {
            dst = server.m_129783_();
        }
        if (dst == null) {
            return;
        }
        BlockPos center = BlockPos.m_274561_((double)sp.m_20185_(), (double)48.0, (double)sp.m_20189_());
        dst.m_46745_(center);
        this.buildSpawnRoom(dst, center, dst.m_213780_());
        this.markNoExitZoneAround(center, 6);
        sp.m_8999_(dst, (double)center.m_123341_() + 0.5, 49.0, (double)center.m_123343_() + 0.5, sp.m_146908_(), sp.m_146909_());
        ChunkPos c = new ChunkPos(center);
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                ChunkPos cp = new ChunkPos(c.f_45578_ + dx, c.f_45579_ + dz);
                long key = cp.m_45588_();
                if (this.processed.contains(key) || !dst.m_7232_(cp.f_45578_, cp.f_45579_)) continue;
                LevelChunk ch = dst.m_6325_(cp.f_45578_, cp.f_45579_);
                this.paintChunk(dst, ch);
                this.processed.add(key);
            }
        }
        this.processed.add(new ChunkPos(center).m_45588_());
        this.spawnedStart.add(sp.m_20148_());
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(120, 0.6f));
        try {
            ServerEvents.startLureHum(sp);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean debugPlaceTrialButtonNear(ServerPlayer sp) {
        if (!sp.m_9236_().m_46472_().equals(LURE_DIM)) {
            return false;
        }
        ServerLevel level = (ServerLevel)sp.m_9236_();
        ChunkPos cp = new ChunkPos(sp.m_20183_());
        level.m_46745_(sp.m_20183_());
        this.paintChunk(level, level.m_6325_(cp.f_45578_, cp.f_45579_));
        this.processed.add(cp.m_45588_());
        int baseX = cp.m_45604_();
        int baseZ = cp.m_45605_();
        for (int lz = 0; lz < 16; ++lz) {
            for (int lx = 0; lx < 16; ++lx) {
                int x = baseX + lx;
                int z = baseZ + lz;
                if (!this.isCorridor(x, z)) continue;
                BlockPos base = new BlockPos(x, 48, z);
                BlockPos top = base.m_7494_();
                if (!level.m_8055_(base).m_60795_() || !level.m_8055_(top).m_60795_() || level.m_8055_(base.m_7495_()).m_60795_()) continue;
                this.set(level, base, Blocks.f_50734_.m_49966_());
                BlockState btn = (BlockState)((BlockState)Blocks.f_50124_.m_49966_().m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
                this.set(level, top, btn);
                return true;
            }
        }
        return false;
    }

    private void buildSpawnRoom(ServerLevel level, BlockPos center, RandomSource r) {
        int wall;
        int z;
        int radius = 4;
        int floorY = 47;
        int ceilingY = 51;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int x = center.m_123341_() + dx;
                z = center.m_123343_() + dz;
                this.set(level, new BlockPos(x, floorY, z), Blocks.f_50652_.m_49966_());
                wall = Math.abs(dx) == radius || Math.abs(dz) == radius ? 1 : 0;
                for (int y = 48; y <= ceilingY; ++y) {
                    BlockPos p = new BlockPos(x, y, z);
                    if (wall != 0) {
                        this.set(level, p, Blocks.f_50652_.m_49966_());
                        continue;
                    }
                    this.set(level, p, Blocks.f_50016_.m_49966_());
                }
            }
        }
        Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        String[] lines = new String[]{"follow", "don't turn back", "he waits", "wrong way", "hear it?", "no exit", "come closer", "it watches", "help", "RUN"};
        Direction[] x = dirs;
        z = x.length;
        for (wall = 0; wall < z; ++wall) {
            Direction d;
            Direction face = d = x[wall];
            for (int i = -3; i <= 3; ++i) {
                BlockPos torch;
                if (!(r.m_188501_() < 0.25f)) continue;
                int x2 = center.m_123341_() + (face.m_122434_() == Direction.Axis.X ? (face == Direction.EAST ? radius : -radius) : i);
                int z2 = center.m_123343_() + (face.m_122434_() == Direction.Axis.Z ? (face == Direction.SOUTH ? radius : -radius) : i);
                BlockPos p = new BlockPos(x2, 49, z2);
                BlockState ws = (BlockState)Blocks.f_50158_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face.m_122424_());
                this.set(level, p, ws);
                BlockEntity be = level.m_7702_(p);
                if (be instanceof SignBlockEntity) {
                    SignBlockEntity sign = (SignBlockEntity)be;
                    try {
                        SignText front = sign.m_277142_();
                        front = front.m_276913_(0, (Component)Component.m_237113_((String)lines[r.m_188503_(lines.length)]));
                        front = front.m_276913_(1, (Component)Component.m_237113_((String)lines[r.m_188503_(lines.length)]));
                        front = front.m_276913_(2, (Component)Component.m_237113_((String)lines[r.m_188503_(lines.length)]));
                        sign.m_276956_(front, true);
                        sign.m_6596_();
                        level.m_7260_(p, level.m_8055_(p), level.m_8055_(p), 3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!(r.m_188501_() < 0.1f) || !level.m_8055_(torch = p.m_7495_()).m_60713_(Blocks.f_50016_)) continue;
                this.set(level, torch, (r.m_188499_() ? Blocks.f_50174_ : Blocks.f_50081_).m_49966_());
            }
        }
        BlockPos pad = center.m_122013_(radius - 1);
        this.set(level, pad.m_7495_(), Blocks.f_50734_.m_49966_());
        this.set(level, pad, Blocks.f_50165_.m_49966_());
        BlockPos signPos = pad.m_122012_();
        this.set(level, signPos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(0)));
        BlockEntity be = level.m_7702_(signPos);
        if (be instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)be;
            try {
                SignText front = sign.m_277142_();
                front = front.m_276913_(0, (Component)Component.m_237113_((String)"EXIT"));
                front = front.m_276913_(1, (Component)Component.m_237113_((String)">>>"));
                front = front.m_276913_(2, (Component)Component.m_237113_((String)"to BEYOND"));
                sign.m_276956_(front, true);
                sign.m_6596_();
                level.m_7260_(signPos, level.m_8055_(signPos), level.m_8055_(signPos), 3);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void paintChunk(ServerLevel level, LevelChunk chunk) {
        ChunkPos cp = chunk.m_7697_();
        int baseX = cp.m_45604_();
        int baseZ = cp.m_45605_();
        for (int lx = 0; lx < 16; ++lx) {
            for (int lz = 0; lz < 16; ++lz) {
                int x = baseX + lx;
                int z = baseZ + lz;
                boolean corridor = this.isCorridor(x, z);
                if (!corridor) continue;
                for (int y = 48; y < 51; ++y) {
                    BlockPos p = new BlockPos(x, y, z);
                    if (level.m_8055_(p).m_60795_()) continue;
                    level.m_7731_(p, Blocks.f_50016_.m_49966_(), 2);
                }
                BlockPos floor = new BlockPos(x, 47, z);
                if (!level.m_8055_(floor).m_60795_()) continue;
                level.m_7731_(floor, Blocks.f_50652_.m_49966_(), 2);
            }
        }
        long seed = level.m_7328_() ^ (long)cp.f_45578_ * 341873128712L ^ (long)cp.f_45579_ * 132897987541L;
        RandomSource r = RandomSource.m_216335_((long)seed);
        for (int i = 0; i < 1; ++i) {
            BlockPos below;
            BlockPos torchPos;
            int lz;
            int z;
            int lx = r.m_188503_(16);
            int x = baseX + lx;
            if (!this.isCorridor(x, z = baseZ + (lz = r.m_188503_(16))) || this.isCorridor(x + 1, z) && this.isCorridor(x - 1, z) && this.isCorridor(x, z + 1) && this.isCorridor(x, z - 1) || !level.m_8055_(torchPos = new BlockPos(x, 48, z)).m_60795_() || level.m_8055_(below = torchPos.m_7495_()).m_60795_() || !(r.m_188501_() < 0.15f)) continue;
            BlockState torch = (r.m_188501_() < 0.1f ? Blocks.f_50174_ : Blocks.f_50081_).m_49966_();
            this.set(level, torchPos, torch);
        }
        if (r.m_188501_() < 0.012f) {
            this.tryPlaceStoryChest(level, baseX, baseZ, r);
        }
        if (((Boolean)Config.TRIAL_ENABLED.get()).booleanValue()) {
            double trialChance = Math.max(0.03, Math.min(0.06, (Double)Config.TRIAL_BUTTON_CHANCE.get()));
            int minSpacingChunks = 2;
            if (!this.hasNearby(this.buttonChunks, cp, minSpacingChunks) && r.m_188500_() < trialChance && this.tryPlaceTrialButton(level, baseX, baseZ, r)) {
                this.buttonChunks.add(cp.m_45588_());
            }
        }
        String[] lines = new String[]{"follow", "don't turn back", "he waits", "wrong way", "hear it?", "no exit", "come closer", "it watches", "help", "RUN", "behind you", "listen"};
        for (int i = 0; i < 1; ++i) {
            BlockPos signPos;
            int lz;
            int z;
            int lx = r.m_188503_(16);
            int x = baseX + lx;
            if (!this.isCorridor(x, z = baseZ + (lz = r.m_188503_(16)))) continue;
            Direction wallDir = null;
            if (!this.isCorridor(x + 1, z)) {
                wallDir = Direction.EAST;
            } else if (!this.isCorridor(x - 1, z)) {
                wallDir = Direction.WEST;
            } else if (!this.isCorridor(x, z + 1)) {
                wallDir = Direction.SOUTH;
            } else if (!this.isCorridor(x, z - 1)) {
                wallDir = Direction.NORTH;
            }
            if (wallDir == null || r.m_188501_() >= 0.25f || !level.m_8055_(signPos = new BlockPos(x, 49, z)).m_60795_()) continue;
            BlockState ws = (BlockState)Blocks.f_50158_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)wallDir.m_122424_());
            this.set(level, signPos, ws);
            BlockEntity be = level.m_7702_(signPos);
            if (!(be instanceof SignBlockEntity)) continue;
            SignBlockEntity sign = (SignBlockEntity)be;
            try {
                SignText front = sign.m_277142_();
                front = front.m_276913_(0, (Component)Component.m_237113_((String)lines[r.m_188503_(lines.length)]));
                if (r.m_188501_() < 0.6f) {
                    front = front.m_276913_(1, (Component)Component.m_237113_((String)lines[r.m_188503_(lines.length)]));
                }
                if (r.m_188501_() < 0.35f) {
                    front = front.m_276913_(2, (Component)Component.m_237113_((String)lines[r.m_188503_(lines.length)]));
                }
                sign.m_276956_(front, true);
                sign.m_6596_();
                level.m_7260_(signPos, level.m_8055_(signPos), level.m_8055_(signPos), 3);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        double exitChance = 0.02;
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            exitChance = Math.max(exitChance, 0.03);
        }
        int exitSpacing = 5;
        long ckey = cp.m_45588_();
        if (!this.exitProhibited.contains(ckey) && !this.hasNearby(this.exitChunks, cp, exitSpacing) && r.m_188500_() < exitChance) {
            this.placeExit(level, cp, r);
            this.exitChunks.add(ckey);
        }
    }

    private boolean hasNearby(Set<Long> placed, ChunkPos cp, int chebyshev) {
        int cx = cp.f_45578_;
        int cz = cp.f_45579_;
        for (long key : placed) {
            int dz;
            ChunkPos other = new ChunkPos(key);
            int dx = Math.abs(cx - other.f_45578_);
            if (Math.max(dx, dz = Math.abs(cz - other.f_45579_)) > chebyshev) continue;
            return true;
        }
        return false;
    }

    private boolean isWall(ServerLevel level, int x, int z) {
        if (this.isCorridor(x, z)) {
            return false;
        }
        BlockPos p = new BlockPos(x, 49, z);
        return level.m_8055_(p).m_60713_(Blocks.f_50652_);
    }

    private boolean isCorridor(int x, int z) {
        int mx = Mth.m_14100_((int)x, (int)8);
        int mz = Mth.m_14100_((int)z, (int)8);
        boolean cx = mx == 3 || mx == 4;
        boolean cz = mz == 3 || mz == 4;
        return cx || cz;
    }

    private void set(ServerLevel level, BlockPos pos, BlockState state) {
        if (!level.m_46749_(pos)) {
            return;
        }
        level.m_7731_(pos, state, 2);
    }

    private void setIfDifferent(ServerLevel level, BlockPos pos, BlockState state) {
        if (!level.m_46749_(pos)) {
            return;
        }
        if (level.m_8055_(pos).equals(state)) {
            return;
        }
        level.m_7731_(pos, state, 2);
    }

    private void placeExit(ServerLevel level, ChunkPos cp, RandomSource r) {
        int baseX = cp.m_45604_();
        int baseZ = cp.m_45605_();
        for (int tries = 0; tries < 12; ++tries) {
            int z;
            int x = baseX + 2 + r.m_188503_(12);
            if (!this.isCorridor(x, z = baseZ + 2 + r.m_188503_(12))) continue;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    for (int y = 48; y < 51; ++y) {
                        this.set(level, new BlockPos(x + dx, y, z + dz), Blocks.f_50016_.m_49966_());
                    }
                    this.set(level, new BlockPos(x + dx, 47, z + dz), Blocks.f_50652_.m_49966_());
                }
            }
            BlockPos pad = new BlockPos(x, 48, z);
            this.set(level, pad.m_7495_(), Blocks.f_50734_.m_49966_());
            this.set(level, pad, Blocks.f_50165_.m_49966_());
            BlockPos signPos = pad.m_122012_();
            this.set(level, signPos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(0)));
            BlockEntity be = level.m_7702_(signPos);
            if (be instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)be;
                try {
                    SignText front = sign.m_277142_();
                    front = front.m_276913_(0, (Component)Component.m_237113_((String)"EXIT"));
                    front = front.m_276913_(1, (Component)Component.m_237113_((String)">>>"));
                    sign.m_276956_(front, true);
                    sign.m_6596_();
                    level.m_7260_(signPos, level.m_8055_(signPos), level.m_8055_(signPos), 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
    }

    private boolean tryPlaceStoryChest(ServerLevel level, int baseX, int baseZ, RandomSource r) {
        for (int tries = 0; tries < 16; ++tries) {
            BlockPos pos;
            int lz;
            int z;
            int lx = r.m_188503_(16);
            int x = baseX + lx;
            if (!this.isCorridor(x, z = baseZ + (lz = r.m_188503_(16)))) continue;
            Direction wallDir = null;
            if (!this.isCorridor(x + 1, z)) {
                wallDir = Direction.EAST;
            } else if (!this.isCorridor(x - 1, z)) {
                wallDir = Direction.WEST;
            } else if (!this.isCorridor(x, z + 1)) {
                wallDir = Direction.SOUTH;
            } else if (!this.isCorridor(x, z - 1)) {
                wallDir = Direction.NORTH;
            }
            if (wallDir == null || !level.m_8055_(pos = new BlockPos(x, 48, z)).m_60795_() || level.m_8055_(pos.m_7495_()).m_60795_()) continue;
            Direction face = wallDir.m_122424_();
            BlockState chest = (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face);
            this.set(level, pos, chest);
            this.fillStoryChest(level, pos, r);
            return true;
        }
        return false;
    }

    private void fillStoryChest(ServerLevel level, BlockPos pos, RandomSource r) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof ChestBlockEntity)) {
            return;
        }
        ChestBlockEntity cbe = (ChestBlockEntity)be;
        String[] notes = new String[]{"session: active", "crawl: incomplete", "link: dead", "cache: cold", "redirect: /logout", "do not respond", "EYES FRONT", "stay in corridors", "no reply", "trace: lost"};
        int count = 1 + r.m_188503_(3);
        for (int i = 0; i < count; ++i) {
            ItemStack paper = new ItemStack((ItemLike)Items.f_42516_);
            paper.m_41714_((Component)Component.m_237113_((String)notes[r.m_188503_(notes.length)]));
            int slot = r.m_188503_(cbe.m_6643_());
            cbe.m_6836_(slot, paper);
        }
        if (r.m_188501_() < 0.45f) {
            ItemStack[] foods = new ItemStack[]{new ItemStack((ItemLike)Items.f_42406_, 1 + r.m_188503_(2)), new ItemStack((ItemLike)Items.f_42410_, 1 + r.m_188503_(2)), new ItemStack((ItemLike)Items.f_42530_, 1 + r.m_188503_(2)), new ItemStack((ItemLike)Items.f_42531_, 1 + r.m_188503_(2)), new ItemStack((ItemLike)Items.f_42576_, 2 + r.m_188503_(4))};
            int stacks = 1 + (r.m_188501_() < 0.5f ? 1 : 0);
            for (int i = 0; i < stacks; ++i) {
                ItemStack food = foods[r.m_188503_(foods.length)].m_41777_();
                int slot = r.m_188503_(cbe.m_6643_());
                if (!cbe.m_8020_(slot).m_41619_()) continue;
                cbe.m_6836_(slot, food);
            }
        }
        cbe.m_6596_();
        level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 3);
    }

    private void markNoExitZoneAround(BlockPos center, int chunkRadius) {
        ChunkPos c = new ChunkPos(center);
        for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
            for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
                ChunkPos cp = new ChunkPos(c.f_45578_ + dx, c.f_45579_ + dz);
                this.exitProhibited.add(cp.m_45588_());
            }
        }
    }

    private void teleportToExit(MinecraftServer server, ServerPlayer sp) {
        if (((Boolean)Config.TRIAL_ENABLED.get()).booleanValue() && !PlayerFlags.isTrialComplete(sp)) {
            if (Managers.AMBIENT != null) {
                Managers.AMBIENT.playScanSequence(sp, sp.m_20183_(), 2);
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(40, 0.5f));
            ResourceLocation sFail = new ResourceLocation("theforgotten", "fail");
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(sFail, sp.m_20185_(), sp.m_20186_() + (double)sp.m_20192_(), sp.m_20189_(), 1.0f, 1.0f, SoundSource.MASTER));
            int have = PlayerFlags.getTrialPressedCount(sp);
            int need = (Integer)Config.TRIAL_REQUIRED_BUTTONS.get();
            sp.m_213846_((Component)Component.m_237113_((String)("analysis: INCOMPLETE (" + have + "/" + need + ")")));
            return;
        }
        ServerLevel dst = server.m_129880_(EXIT_TARGET_DIM);
        if (dst == null) {
            dst = server.m_129783_();
        }
        if (dst == null) {
            return;
        }
        PlayerFlags.setEscaped(sp, true);
        sp.m_213846_((Component)Component.m_237113_((String)"TRIAL COMPLETE. You are set free."));
        ResourceLocation sSucc = new ResourceLocation("theforgotten", "success");
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(sSucc, sp.m_20185_(), sp.m_20186_() + (double)sp.m_20192_(), sp.m_20189_(), 1.0f, 1.0f, SoundSource.MASTER));
        int y = Math.max(64, dst.m_5736_() + 16);
        BlockPos safe = BlockPos.m_274561_((double)sp.m_20185_(), (double)y, (double)sp.m_20189_());
        sp.m_8999_(dst, (double)safe.m_123341_() + 0.5, (double)safe.m_123342_(), (double)safe.m_123343_() + 0.5, sp.m_146908_(), sp.m_146909_());
    }
}

