/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.tasuposed.theforgotten.Config;
import net.tasuposed.theforgotten.data.Pools;
import net.tasuposed.theforgotten.network.NetworkHandler;
import net.tasuposed.theforgotten.network.S2CForceGlitchPacket;
import net.tasuposed.theforgotten.network.S2CPositionalSoundPacket;
import net.tasuposed.theforgotten.server.LureDimensionManager;
import net.tasuposed.theforgotten.server.Managers;
import net.tasuposed.theforgotten.server.PlayerFlags;
import org.slf4j.Logger;

public class MicroStructureManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceKey<Level> LURE_TARGET_DIM = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("theforgotten", "lure"));
    private final List<Entry> active = new ArrayList<Entry>();
    private final Map<UUID, Variant> lastVariantByPlayer = new HashMap<UUID, Variant>();
    private final Map<UUID, Entry> campaignByPlayer = new HashMap<UUID, Entry>();
    private static final int ANOMALY_DENSITY_RADIUS = 64;
    private static final int ANOMALY_MAX_NEARBY = 3;
    private static final int MIN_ANOMALY_DIST_SQ = 256;

    public void shutdown(MinecraftServer server) {
        this.rollbackAll(server);
    }

    public void tick(MinecraftServer server, long time) {
        Iterator<Entry> it = this.active.iterator();
        while (it.hasNext()) {
            Entry e = it.next();
            if (time >= e.expiresAt) {
                e.rollback(server);
                it.remove();
                try {
                    this.campaignByPlayer.entrySet().removeIf(en -> en.getValue() == e);
                }
                catch (Throwable throwable) {}
                continue;
            }
            this.processLure(server, e);
        }
    }

    public BlockPos scheduleLureForNote(ServerLevel level, BlockPos near, RandomSource r, long time) {
        Entry existing = this.findActiveLureNear(level, near, 512);
        if (existing != null) {
            BlockPos target = existing.lure.target;
            double travelDist = Math.sqrt(near.m_203198_((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5));
            int needed = (int)Math.ceil(travelDist / 4.3 + 40.0);
            int minTTL = 180;
            int maxTTL = 1200;
            int ttl = Math.max(minTTL, Math.min(maxTTL, needed));
            existing.expiresAt = Math.max(existing.expiresAt, time + (long)ttl * 20L);
            return target;
        }
        BlockPos target = this.pickLureTargetNear(level, near, r);
        if (target == null) {
            target = this.fallbackLureTarget(level, near);
        }
        if (target == null) {
            return null;
        }
        Entry e = new Entry();
        e.dimension = level.m_46472_();
        e.lure = new Lure(target);
        double travelDist = Math.sqrt(near.m_203198_((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5));
        int needed = (int)Math.ceil(travelDist / 3.6 + 90.0);
        int minTTL = Math.max(60, (Integer)Config.LURE_ENTRANCE_TTL_MIN_SEC.get());
        int maxTTL = Math.max(minTTL, (Integer)Config.LURE_ENTRANCE_TTL_MAX_SEC.get());
        int ttl = Math.max(minTTL, Math.min(maxTTL, needed));
        e.expiresAt = (Boolean)Config.LURE_ENTRANCE_PERMANENT.get() != false ? 0x1FFFFFFFFFFFFFFFL : time + (long)ttl * 20L;
        this.active.add(e);
        try {
            this.prepareLureSite(level, e, e.lure);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return target;
    }

    public BlockPos scheduleLureForNoteFor(ServerPlayer sp, ServerLevel level, BlockPos near, RandomSource r, long time) {
        Entry campaign = this.campaignByPlayer.get(sp.m_20148_());
        if (campaign != null) {
            boolean valid;
            boolean bl = valid = campaign.lure != null && campaign.dimension.equals((Object)level.m_46472_()) && this.active.contains(campaign);
            if (!valid) {
                this.campaignByPlayer.remove(sp.m_20148_());
                campaign = null;
            }
        }
        if (campaign != null) {
            BlockPos target = campaign.lure.target;
            double travelDist = Math.sqrt(near.m_203198_((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5));
            int needed = (int)Math.ceil(travelDist / 4.3 + 40.0);
            int minTTL = 180;
            int maxTTL = 1200;
            int ttl = Math.max(minTTL, Math.min(maxTTL, needed));
            campaign.expiresAt = Math.max(campaign.expiresAt, time + (long)ttl * 20L);
            return target;
        }
        Entry existing = this.findActiveLureNear(level, near, 512);
        if (existing != null) {
            this.campaignByPlayer.put(sp.m_20148_(), existing);
            return this.scheduleLureForNote(level, near, r, time);
        }
        BlockPos target = this.pickLureTargetNear(level, near, r);
        if (target == null) {
            target = this.fallbackLureTarget(level, near);
        }
        if (target == null) {
            return null;
        }
        Entry e = new Entry();
        e.dimension = level.m_46472_();
        e.lure = new Lure(target);
        double travelDist = Math.sqrt(near.m_203198_((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5));
        int needed = (int)Math.ceil(travelDist / 3.6 + 90.0);
        int minTTL = Math.max(60, (Integer)Config.LURE_ENTRANCE_TTL_MIN_SEC.get());
        int maxTTL = Math.max(minTTL, (Integer)Config.LURE_ENTRANCE_TTL_MAX_SEC.get());
        int ttl = Math.max(minTTL, Math.min(maxTTL, needed));
        e.expiresAt = (Boolean)Config.LURE_ENTRANCE_PERMANENT.get() != false ? 0x1FFFFFFFFFFFFFFFL : time + (long)ttl * 20L;
        this.active.add(e);
        this.campaignByPlayer.put(sp.m_20148_(), e);
        try {
            this.prepareLureSite(level, e, e.lure);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return target;
    }

    private Entry findActiveLureNear(ServerLevel level, BlockPos near, int radius) {
        Entry best = null;
        double bestD2 = Double.POSITIVE_INFINITY;
        double r2 = (double)radius * (double)radius;
        for (Entry e : this.active) {
            double dz;
            BlockPos t;
            double dx;
            double d2;
            if (e.lure == null || !e.dimension.equals((Object)level.m_46472_()) || !((d2 = (dx = (double)((t = e.lure.target).m_123341_() - near.m_123341_())) * dx + (dz = (double)(t.m_123343_() - near.m_123343_())) * dz) <= r2) || !(d2 < bestD2)) continue;
            bestD2 = d2;
            best = e;
        }
        return best;
    }

    public boolean trySpawnNear(ServerPlayer sp, long time) {
        if (PlayerFlags.isEscaped(sp) && !PlayerFlags.isReawakened(sp)) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                sp.m_213846_((Component)Component.m_237113_((String)"[TheForgotten] skip: player escaped (no lures/anomalies)."));
            }
            return false;
        }
        if (!((Boolean)Config.ENABLE_MICRO_STRUCTURES.get()).booleanValue()) {
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                sp.m_213846_((Component)Component.m_237113_((String)"[TheForgotten] disabled: small structures off in config."));
            }
            return false;
        }
        int r = (Integer)Config.AUDIENCE_RADIUS.get();
        for (ServerPlayer other : sp.f_8924_.m_6846_().m_11314_()) {
            if (other == sp || !other.m_9236_().m_46472_().equals((Object)sp.m_9236_().m_46472_()) || !(other.m_20280_((Entity)sp) <= (double)(r * r))) continue;
            if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                sp.m_213846_((Component)Component.m_237113_((String)("[TheForgotten] gated: audience within " + r + " blocks.")));
            }
            return false;
        }
        ServerLevel level = sp.m_284548_();
        RandomSource rand = sp.m_217043_();
        int attempts = (Integer)Config.STRUCTURE_ATTEMPT_BUDGET.get();
        int dbgNoGround = 0;
        int dbgAngle = 0;
        int dbgTooClose = 0;
        int dbgDensity = 0;
        int dbgVariantFail = 0;
        Vec3 eye = sp.m_146892_();
        Vec3 look = sp.m_20154_().m_82541_();
        for (int i = 0; i < attempts; ++i) {
            double dot;
            Vec3 lookH = new Vec3(look.f_82479_, 0.0, look.f_82481_);
            if (lookH.m_82556_() < 1.0E-6) {
                lookH = new Vec3(0.0, 0.0, 1.0);
            }
            lookH = lookH.m_82541_();
            Vec3 rightH = new Vec3(lookH.f_82481_, 0.0, -lookH.f_82479_).m_82541_();
            boolean leftSide = rand.m_188499_();
            double sideCenter = leftSide ? 90.0 : -90.0;
            double offset = rand.m_188500_() * 60.0 - 30.0;
            double angleDeg = sideCenter + offset;
            double angleRad = Math.toRadians(angleDeg);
            Vec3 dir = lookH.m_82490_(Math.cos(angleRad)).m_82549_(rightH.m_82490_(Math.sin(angleRad))).m_82541_();
            Variant chosen = this.randomVariantExcluding(rand, this.lastVariantByPlayer.get(sp.m_20148_()));
            if (PlayerFlags.isReawakened(sp) && !this.isAnomaly(chosen) && rand.m_188500_() < 0.35) {
                int pick = rand.m_188503_(3);
                chosen = pick == 0 ? Variant.SHEAR_WALL : (pick == 1 ? Variant.OFFSET_PATCH : Variant.VOID_FISSURE);
            }
            boolean anomaly = this.isAnomaly(chosen);
            double dist = chosen == Variant.PHANTOM_BLOCKS ? 12.0 + rand.m_188500_() * 10.0 : (anomaly ? 38.0 + rand.m_188500_() * 34.0 : 20.0 + rand.m_188500_() * 36.0);
            Vec3 candidate = eye.m_82549_(dir.m_82490_(dist));
            BlockPos ground = this.findGround(level, BlockPos.m_274446_((Position)candidate));
            if (ground == null) {
                ++dbgNoGround;
                continue;
            }
            Vec3 look2d = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_();
            Vec3 to2d = new Vec3((double)ground.m_123341_() + 0.5 - eye.f_82479_, 0.0, (double)ground.m_123343_() + 0.5 - eye.f_82481_).m_82541_();
            if (look2d.m_82556_() > 1.0E-4 && to2d.m_82556_() > 1.0E-4 && (dot = look2d.m_82526_(to2d)) > 0.6) {
                ++dbgAngle;
                continue;
            }
            if (sp.m_20183_().m_203198_((double)ground.m_123341_() + 0.5, (double)(ground.m_123342_() + 1), (double)ground.m_123343_() + 0.5) < 256.0) {
                ++dbgTooClose;
                continue;
            }
            if (this.countActiveNear(level, ground, 64) >= 3) {
                ++dbgDensity;
                continue;
            }
            Entry placed = this.placeVariant(level, ground, chosen, rand, sp, time);
            if (placed != null) {
                int min = (Integer)Config.STRUCTURE_TTL_MIN_SEC.get();
                int max = (Integer)Config.STRUCTURE_TTL_MAX_SEC.get();
                int ttl = min + rand.m_188503_(Math.max(1, max - min + 1));
                if (placed.lure != null) {
                    double travelDistSqr = sp.m_20183_().m_203198_((double)placed.lure.target.m_123341_() + 0.5, (double)placed.lure.target.m_123342_() + 0.5, (double)placed.lure.target.m_123343_() + 0.5);
                    double travelDist2 = Math.sqrt(travelDistSqr);
                    int needed2 = (int)Math.ceil(travelDist2 / 3.6 + 90.0);
                    int minTTL2 = Math.max(60, (Integer)Config.LURE_ENTRANCE_TTL_MIN_SEC.get());
                    int maxTTL2 = Math.max(minTTL2, (Integer)Config.LURE_ENTRANCE_TTL_MAX_SEC.get());
                    int extended = Math.max(minTTL2, Math.min(maxTTL2, needed2));
                    if (((Boolean)Config.LURE_ENTRANCE_PERMANENT.get()).booleanValue()) {
                        extended = maxTTL2;
                    }
                    ttl = Math.max(ttl, extended);
                }
                placed.expiresAt = time + (long)ttl * 20L;
                this.active.add(placed);
                this.lastVariantByPlayer.put(sp.m_20148_(), chosen);
                if (placed.lure != null) {
                    this.campaignByPlayer.put(sp.m_20148_(), placed);
                }
                if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                    sp.m_213846_((Component)Component.m_237113_((String)String.format("[TheForgotten] %s placed at %s in %s TTL=%ds", MicroStructureManager.humanName(chosen), ground, level.m_46472_().m_135782_(), ttl)));
                }
                return true;
            }
            ++dbgVariantFail;
        }
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            String msg = String.format("[TheForgotten] placement failed: noGround=%d angle=%d tooClose=%d density=%d variantFail=%d (budget=%d)", dbgNoGround, dbgAngle, dbgTooClose, dbgDensity, dbgVariantFail, attempts);
            sp.m_213846_((Component)Component.m_237113_((String)msg));
            LOGGER.info(msg);
        }
        return false;
    }

    private BlockPos findNearestLand(ServerLevel level, int x, int z, int maxRadius) {
        BlockPos best = null;
        double bestD2 = Double.POSITIVE_INFINITY;
        for (int dx = -maxRadius; dx <= maxRadius; dx += 3) {
            for (int dz = -maxRadius; dz <= maxRadius; dz += 3) {
                double d2;
                int cx = x + dx;
                int cz = z + dz;
                Holder bh = level.m_204166_(new BlockPos(cx, level.m_5736_(), cz));
                if (bh.m_203656_(BiomeTags.f_207603_) || bh.m_203656_(BiomeTags.f_207605_) || this.isWaterAtSurface(level, cx, cz) || !((d2 = (double)dx * (double)dx + (double)dz * (double)dz) < bestD2)) continue;
                bestD2 = d2;
                best = new BlockPos(cx, 0, cz);
            }
        }
        return best;
    }

    private static String[] creepyFollowLines(BlockPos p) {
        return new String[]{"", "", "", ""};
    }

    private boolean isAnomaly(Variant v) {
        return v == Variant.SHEAR_WALL || v == Variant.OFFSET_PATCH || v == Variant.VOID_FISSURE || v == Variant.BEDROCK_BLOOM;
    }

    private Variant randomVariant(RandomSource r) {
        boolean pickAnom;
        Variant[] nonAnoms = new Variant[]{Variant.TORCH, Variant.CRAFTING_TABLE, Variant.PHANTOM_BLOCKS, Variant.CHEST_EMPTY, Variant.FURNACE, Variant.LADDER, Variant.REDSTONE_TORCH, Variant.REDSTONE_RITUAL, Variant.SIGN, Variant.CROSS};
        Variant[] anoms = new Variant[]{Variant.SHEAR_WALL, Variant.OFFSET_PATCH, Variant.VOID_FISSURE, Variant.BEDROCK_BLOOM};
        double pAnom = 0.15;
        boolean bl = pickAnom = r.m_188500_() < pAnom;
        if (pickAnom) {
            return anoms[r.m_188503_(anoms.length)];
        }
        return nonAnoms[r.m_188503_(nonAnoms.length)];
    }

    private static String humanName(Variant v) {
        switch (v) {
            case SHEAR_WALL: {
                return "Vertical Air Seam";
            }
            case OFFSET_PATCH: {
                return "Shaved Chunk Top";
            }
            case VOID_FISSURE: {
                return "Vertical Ground Crack";
            }
            case BEDROCK_BLOOM: {
                return "Bedrock Pillars";
            }
            case TREE_GHOST: {
                return "Tree Copy";
            }
            case TORCH: {
                return "Torch";
            }
            case CRAFTING_TABLE: {
                return "Crafting Table";
            }
            case PHANTOM_BLOCKS: {
                return "Phantom Blocks";
            }
            case CHEST_EMPTY: {
                return "Empty Chest";
            }
            case FURNACE: {
                return "Furnace";
            }
            case LADDER: {
                return "Ladder";
            }
            case REDSTONE_TORCH: {
                return "Redstone Torch";
            }
            case REDSTONE_RITUAL: {
                return "Redstone Cross with Torches";
            }
            case CROSS: {
                return "Cross";
            }
            case SIGN: {
                return "Sign";
            }
        }
        return v.name();
    }

    private Variant randomVariantExcluding(RandomSource r, Variant exclude) {
        for (int tries = 0; tries < 16; ++tries) {
            Variant pick = this.randomVariant(r);
            if (pick == Variant.TREE_GHOST || exclude != null && pick == exclude) continue;
            return pick;
        }
        return Variant.TORCH;
    }

    private Entry placeVariant(ServerLevel level, BlockPos near, Variant v, RandomSource r, ServerPlayer owner, long now) {
        return switch (v) {
            default -> throw new IncompatibleClassChangeError();
            case Variant.TORCH -> {
                Entry var8_7;
                yield var8_7 = this.placeTorch(level, near);
            }
            case Variant.CRAFTING_TABLE -> {
                Entry var8_8;
                yield var8_8 = this.placeSimple(level, near, Blocks.f_50091_.m_49966_());
            }
            case Variant.PHANTOM_BLOCKS -> {
                Entry var8_9;
                yield var8_9 = this.placeInventoryBlock(level, near, owner, r);
            }
            case Variant.CHEST_EMPTY -> {
                Entry var8_10;
                yield var8_10 = this.placeChestPossiblyClue(level, near, r, owner, now);
            }
            case Variant.FURNACE -> {
                Entry var8_11;
                yield var8_11 = this.placeFacing(level, near, Blocks.f_50094_.m_49966_());
            }
            case Variant.LADDER -> {
                Entry var8_12;
                yield var8_12 = this.placeLadder(level, near);
            }
            case Variant.REDSTONE_TORCH -> {
                Entry var8_13;
                yield var8_13 = this.placeRedstoneTorch(level, near);
            }
            case Variant.REDSTONE_RITUAL -> {
                Entry var8_14;
                yield var8_14 = this.placeRedstoneRitual(level, near, r);
            }
            case Variant.CROSS -> {
                Entry var8_15;
                yield var8_15 = this.placeCross(level, near, r);
            }
            case Variant.SIGN -> {
                Entry var8_18;
                if (r.m_188500_() < 0.75) {
                    Entry campaign;
                    Entry v1 = campaign = owner != null ? this.campaignByPlayer.get(owner.m_20148_()) : null;
                    if (campaign == null) {
                        campaign = this.findActiveLureNear(level, near, 512);
                    }
                    if (campaign != null) {
                        Entry var8_16;
                        BlockPos target = campaign.lure.target;
                        String[] lines = MicroStructureManager.creepyFollowLines(target);
                        Entry placed = this.placeSignLinesNear(level, near, lines, r);
                        if (placed != null) {
                            BlockPos signOrigin = this.extractPrimaryPos(placed, near);
                            campaign.snapshots.addAll(placed.snapshots);
                            try {
                                Snapshot last = placed.snapshots.get(placed.snapshots.size() - 1);
                                campaign.lure.signPos = last.pos;
                            }
                            catch (Throwable last) {
                                // empty catch block
                            }
                            double travelDist = Math.sqrt(signOrigin.m_203198_((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5));
                            int needed = (int)Math.ceil(travelDist / 4.3 + 40.0);
                            int minTTL = 180;
                            int maxTTL = 1200;
                            int ttl = Math.max(minTTL, Math.min(maxTTL, needed));
                            campaign.expiresAt = Math.max(campaign.expiresAt, now + (long)ttl * 20L);
                            this.placeBreadcrumbTrail(level, campaign, signOrigin, target, r);
                            char axis = r.m_188499_() ? (char)'X' : 'Z';
                            int val = axis == 'X' ? target.m_123341_() : target.m_123343_();
                            this.placeAxisHintSign(level, campaign, signOrigin, axis, val, r);
                        } else if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                            LOGGER.warn("[TheForgotten] Failed to place lure sign (campaign) near {}", (Object)near);
                        }
                        yield var8_16 = placed;
                    }
                    BlockPos target = this.pickLureTargetNear(level, near, r);
                    if (target != null) {
                        Entry var8_17;
                        String[] lines = MicroStructureManager.creepyFollowLines(target);
                        Entry e = this.placeSignLinesNear(level, near, lines, r);
                        if (e != null) {
                            BlockPos signOrigin = this.extractPrimaryPos(e, near);
                            e.lure = new Lure(target);
                            try {
                                Snapshot last = e.snapshots.get(e.snapshots.size() - 1);
                                e.lure.signPos = last.pos;
                            }
                            catch (Throwable last) {
                                // empty catch block
                            }
                            this.placeBreadcrumbTrail(level, e, signOrigin, target, r);
                            char axis = r.m_188499_() ? (char)'X' : 'Z';
                            int val = axis == 'X' ? target.m_123341_() : target.m_123343_();
                            this.placeAxisHintSign(level, e, signOrigin, axis, val, r);
                            if (owner != null) {
                                this.campaignByPlayer.put(owner.m_20148_(), e);
                            }
                        } else if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                            LOGGER.warn("[TheForgotten] Failed to place new lure sign near {}", (Object)near);
                        }
                        yield var8_17 = e;
                    }
                }
                String text = owner != null ? this.personalCreepyText(owner, r) : this.randomSafeSignText(r);
                yield var8_18 = this.placeSign(level, near, text, r);
            }
            case Variant.SHEAR_WALL -> {
                Entry var8_19;
                yield var8_19 = this.placeShearWall(level, near, r);
            }
            case Variant.OFFSET_PATCH -> {
                Entry var8_20;
                yield var8_20 = this.placeOffsetPatch(level, near, r);
            }
            case Variant.VOID_FISSURE -> {
                Entry var8_21;
                yield var8_21 = this.placeVoidFissure(level, near, r);
            }
            case Variant.BEDROCK_BLOOM -> {
                Entry var8_22;
                yield var8_22 = this.placeBedrockBloom(level, near, r);
            }
            case Variant.TREE_GHOST -> {
                if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                    LOGGER.info("[TheForgotten] TREE_GHOST placement skipped (disabled).");
                }
                Object var8_23 = null;
                yield var8_23;
            }
        };
    }

    private Entry placeShearWall(ServerLevel level, BlockPos near, RandomSource r) {
        LevelChunk chunk = level.m_46745_(near);
        int baseX = chunk.m_7697_().m_45604_();
        int baseZ = chunk.m_7697_().m_45605_();
        boolean alongX = r.m_188499_();
        int seamA0 = 7;
        int seamA1 = 8;
        Entry e = new Entry();
        e.dimension = level.m_46472_();
        for (int a = 0; a < 16; ++a) {
            for (int seam = 0; seam < 2; ++seam) {
                int aa = seam == 0 ? seamA0 : seamA1;
                int x = alongX ? baseX + aa : baseX + a;
                int z = alongX ? baseZ + a : baseZ + aa;
                int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                int depth = 8 + r.m_188503_(7);
                int bottom = Math.max(level.m_141937_() + 1, surfaceY - depth);
                for (int y = surfaceY; y >= bottom; --y) {
                    BlockPos p = new BlockPos(x, y, z);
                    this.replaceAndSnap(level, e, p, Blocks.f_50016_.m_49966_());
                }
            }
        }
        return e.snapshots.isEmpty() ? null : e;
    }

    private Entry placeOffsetPatch(ServerLevel level, BlockPos near, RandomSource r) {
        LevelChunk chunk = level.m_46745_(near);
        int baseX = chunk.m_7697_().m_45604_();
        int baseZ = chunk.m_7697_().m_45605_();
        int depth = 3 + r.m_188503_(3);
        Entry e = new Entry();
        e.dimension = level.m_46472_();
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int x = baseX + dx;
                int z = baseZ + dz;
                int yTop = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                int yBottom = Math.max(level.m_141937_() + 1, yTop - depth + 1);
                for (int y = yTop; y >= yBottom; --y) {
                    BlockPos p = new BlockPos(x, y, z);
                    this.replaceAndSnap(level, e, p, Blocks.f_50016_.m_49966_());
                }
            }
        }
        return e.snapshots.isEmpty() ? null : e;
    }

    private Entry placeVoidFissure(ServerLevel level, BlockPos near, RandomSource r) {
        boolean alongX = r.m_188499_();
        int len = 6 + r.m_188503_(6);
        int startX = near.m_123341_();
        int startZ = near.m_123343_();
        Entry e = new Entry();
        e.dimension = level.m_46472_();
        for (int i = 0; i < len; ++i) {
            int x = alongX ? startX + i : startX;
            int z = alongX ? startZ : startZ + i;
            int yTop = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
            int yBottom = Math.max(level.m_141937_() + 5, yTop - (6 + r.m_188503_(10)));
            for (int y = yTop; y >= yBottom; --y) {
                this.replaceAndSnap(level, e, new BlockPos(x, y, z), Blocks.f_50016_.m_49966_());
            }
        }
        return e.snapshots.isEmpty() ? null : e;
    }

    private Entry placeBedrockBloom(ServerLevel level, BlockPos near, RandomSource r) {
        int pillars = 3 + r.m_188503_(3);
        Entry e = new Entry();
        e.dimension = level.m_46472_();
        for (int k = 0; k < pillars; ++k) {
            int ox = near.m_123341_() + r.m_188503_(5) - 2;
            int oz = near.m_123343_() + r.m_188503_(5) - 2;
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ox, oz);
            int h = 2 + r.m_188503_(3);
            for (int dy = 0; dy <= h; ++dy) {
                this.replaceAndSnap(level, e, new BlockPos(ox, y + dy, oz), Blocks.f_50752_.m_49966_());
            }
        }
        return e.snapshots.isEmpty() ? null : e;
    }

    private Entry placeTreeGhost(ServerLevel level, BlockPos near, RandomSource r) {
        BlockPos armPos;
        int i;
        BlockPos ground = this.findGround(level, near);
        if (ground == null) {
            return null;
        }
        BlockPos base = ground.m_7494_();
        AABB footprint = new AABB(base.m_7918_(-2, 0, -2), base.m_7918_(2, 6, 2));
        for (int x = (int)footprint.f_82288_; x <= (int)footprint.f_82291_; ++x) {
            for (int y = (int)footprint.f_82289_; y <= (int)footprint.f_82292_; ++y) {
                for (int z = (int)footprint.f_82290_; z <= (int)footprint.f_82293_; ++z) {
                    BlockPos check = new BlockPos(x, y, z);
                    if (level.m_8055_(check).m_247087_() || level.m_8055_(check).m_60795_()) continue;
                    return null;
                }
            }
        }
        Entry e = new Entry();
        e.dimension = level.m_46472_();
        int trunkHeight = 4 + r.m_188503_(2);
        BlockState vertical = (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
        BlockState weathered = (BlockState)Blocks.f_50010_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
        for (int i2 = 0; i2 < trunkHeight; ++i2) {
            BlockPos p = base.m_6630_(i2);
            BlockState state = i2 == 0 || i2 == trunkHeight - 1 ? weathered : vertical;
            this.replaceAndSnap(level, e, p, state);
        }
        BlockPos top = base.m_6630_(trunkHeight - 1);
        Direction.Axis axis = r.m_188499_() ? Direction.Axis.X : Direction.Axis.Z;
        Direction longDir = axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
        Direction shortDir = longDir.m_122424_();
        if (r.m_188499_()) {
            Direction tmp = longDir;
            longDir = shortDir;
            shortDir = tmp;
        }
        BlockState horizontal = (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis);
        BlockState exposed = (BlockState)Blocks.f_50010_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis);
        int longArm = 2;
        int shortArm = 1;
        for (i = 1; i <= longArm; ++i) {
            armPos = top.m_5484_(longDir, i);
            this.replaceAndSnap(level, e, armPos, horizontal);
        }
        for (i = 1; i <= shortArm; ++i) {
            armPos = top.m_5484_(shortDir, i);
            this.replaceAndSnap(level, e, armPos, horizontal);
        }
        BlockPos cutTip = top.m_5484_(shortDir, shortArm);
        this.replaceAndSnap(level, e, cutTip, exposed);
        BlockState slab = (BlockState)Blocks.f_50398_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
        this.replaceAndSnap(level, e, top.m_7494_(), slab);
        return e.snapshots.isEmpty() ? null : e;
    }

    public boolean debugPlaceVariant(ServerPlayer sp, Variant v) {
        Entry placed;
        double dist;
        Vec3 rightH;
        Vec3 behind;
        Vec3 dir;
        Vec3 target;
        BlockPos ground;
        ServerLevel level = sp.m_284548_();
        RandomSource r = level.m_213780_();
        Vec3 eye = sp.m_146892_();
        Vec3 look = sp.m_20154_().m_82541_();
        Vec3 lookH = new Vec3(look.f_82479_, 0.0, look.f_82481_);
        if (lookH.m_82556_() < 1.0E-6) {
            lookH = new Vec3(0.0, 0.0, 1.0);
        }
        if ((ground = this.findGround(level, BlockPos.m_274446_((Position)(target = eye.m_82549_((dir = (behind = (lookH = lookH.m_82541_()).m_82490_(-1.0)).m_82549_((rightH = new Vec3(behind.f_82481_, 0.0, -behind.f_82479_).m_82541_()).m_82490_((r.m_188500_() - 0.5) * 0.4)).m_82541_()).m_82490_(dist = 28.0)))))) == null) {
            ground = sp.m_20183_().m_7918_(0, -1, 0);
        }
        if ((placed = this.placeVariant(level, ground, v, r, sp, sp.f_8924_.m_129921_())) == null) {
            return false;
        }
        int ttl = 180;
        placed.expiresAt = (long)sp.f_8924_.m_129921_() + (long)ttl * 20L;
        this.active.add(placed);
        return true;
    }

    private Entry placeTorch(ServerLevel level, BlockPos near) {
        BlockPos above = this.findOpenAbove(level, near);
        if (above == null) {
            return null;
        }
        BlockPos support = above.m_7495_();
        if (!MicroStructureManager.canStandOn(level, support)) {
            return null;
        }
        return this.replaceSingle(level, above, Blocks.f_50081_.m_49966_());
    }

    private Entry placeRedstoneTorch(ServerLevel level, BlockPos near) {
        BlockPos above = this.findOpenAbove(level, near);
        if (above == null) {
            return null;
        }
        BlockPos support = above.m_7495_();
        if (!MicroStructureManager.canStandOn(level, support)) {
            return null;
        }
        return this.replaceSingle(level, above, Blocks.f_50174_.m_49966_());
    }

    private Entry placeRedstoneRitual(ServerLevel level, BlockPos near, RandomSource r) {
        BlockPos p;
        BlockPos ground = this.findGround(level, near);
        if (ground == null) {
            return null;
        }
        BlockPos origin = ground.m_7494_();
        Entry e = new Entry();
        e.dimension = level.m_46472_();
        int[][] dustOffsets = new int[][]{{0, 0}, {1, 0}, {2, 0}, {-1, 0}, {-2, 0}, {0, 1}, {0, 2}, {0, -1}, {0, -2}};
        int[][] torchOffsets = new int[][]{{2, 2}, {2, -2}, {-2, 2}, {-2, -2}};
        boolean any = false;
        for (int[] d : dustOffsets) {
            p = origin.m_7918_(d[0], 0, d[1]);
            if (!MicroStructureManager.isReplaceable(level, p) || !MicroStructureManager.canStandOn(level, p.m_7495_())) continue;
            this.replaceAndSnap(level, e, p, Blocks.f_50088_.m_49966_());
            any = true;
        }
        for (int[] t : torchOffsets) {
            p = origin.m_7918_(t[0], 0, t[1]);
            if (!MicroStructureManager.isReplaceable(level, p) || !MicroStructureManager.canStandOn(level, p.m_7495_())) continue;
            this.replaceAndSnap(level, e, p, Blocks.f_50174_.m_49966_());
            any = true;
        }
        return any ? e : null;
    }

    private Entry placeCross(ServerLevel level, BlockPos near, RandomSource r) {
        BlockState below;
        BlockPos ground = this.findGround(level, near);
        if (ground == null) {
            return null;
        }
        if (!MicroStructureManager.canStandOn(level, ground)) {
            return null;
        }
        BlockState base = level.m_8055_(ground);
        if ((base.m_60713_(Blocks.f_50125_) || base.m_60713_(Blocks.f_50127_)) && !(below = level.m_8055_(ground.m_7495_())).m_60795_()) {
            base = below;
        }
        if (base.m_60734_() instanceof FallingBlock) {
            base = Blocks.f_50069_.m_49966_();
        }
        Entry e = new Entry();
        e.dimension = level.m_46472_();
        BlockState gState = level.m_8055_(ground);
        if (gState.m_60713_(Blocks.f_50125_) || gState.m_60713_(Blocks.f_50127_)) {
            this.replaceAndSnap(level, e, ground, base);
        }
        int[][] offsets = new int[][]{{0, 0, 0}, {0, 3, 0}, {-1, 2, 0}, {0, 2, 0}, {1, 2, 0}, {0, 1, 0}};
        BlockPos c0 = ground;
        BlockPos c1 = ground.m_7918_(0, 1, 0);
        BlockPos c2 = ground.m_7918_(0, 2, 0);
        BlockPos c3 = ground.m_7918_(0, 3, 0);
        if (!(this.canOverrideForCross(level, c0) && this.canOverrideForCross(level, c1) && this.canOverrideForCross(level, c2) && this.canOverrideForCross(level, c3))) {
            return null;
        }
        boolean any = false;
        for (int[] d : offsets) {
            BlockPos p = ground.m_7918_(d[0], d[1], d[2]);
            if (!this.canOverrideForCross(level, p)) continue;
            this.replaceAndSnap(level, e, p, base);
            any = true;
        }
        return any ? e : null;
    }

    private boolean canOverrideForCross(ServerLevel level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        if (!(level.m_6425_(pos).m_76178_() || level.m_6425_(pos).m_76152_() != Fluids.f_76193_ && level.m_6425_(pos).m_76152_() != Fluids.f_76192_)) {
            return false;
        }
        if (level.m_46859_(pos)) {
            return true;
        }
        BlockState s = level.m_8055_(pos);
        if (s.m_60713_(Blocks.f_50125_)) {
            return true;
        }
        if (s.m_60713_(Blocks.f_50127_)) {
            return true;
        }
        if (s.m_60734_() instanceof BushBlock) {
            return true;
        }
        if (s.m_60734_() instanceof CarpetBlock) {
            return true;
        }
        if (s.m_60713_(Blocks.f_152543_)) {
            return true;
        }
        if (s.m_60713_(Blocks.f_50440_)) {
            return true;
        }
        if (s.m_60713_(Blocks.f_50493_)) {
            return true;
        }
        if (s.m_60713_(Blocks.f_50546_)) {
            return true;
        }
        if (s.m_60713_(Blocks.f_152549_)) {
            return true;
        }
        if (s.m_60713_(Blocks.f_50599_)) {
            return true;
        }
        if (s.m_60713_(Blocks.f_50195_)) {
            return true;
        }
        if (s.m_60713_(Blocks.f_220864_)) {
            return true;
        }
        return s.m_60713_(Blocks.f_49994_);
    }

    private Entry placeLadder(ServerLevel level, BlockPos near) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            Entry e;
            BlockPos place;
            BlockPos wall = near.m_121945_(d);
            if (level.m_46859_(wall) || !MicroStructureManager.isReplaceable(level, place = wall.m_121945_(d.m_122424_())) || (e = this.replaceSingle(level, place, (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)d))) == null) continue;
            return e;
        }
        return null;
    }

    private BlockPos fallbackLureTarget(ServerLevel level, BlockPos origin) {
        BlockPos land = this.findNearestLand(level, origin.m_123341_(), origin.m_123343_(), 512);
        int x = land != null ? land.m_123341_() : origin.m_123341_();
        int z = land != null ? land.m_123343_() : origin.m_123343_();
        int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        return new BlockPos(x, y, z);
    }

    private Entry placeWallSign(ServerLevel level, BlockPos near, String text) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockState state;
            Entry e;
            BlockPos place;
            BlockPos wall = near.m_121945_(d);
            if (level.m_8055_(wall).m_60795_() || !MicroStructureManager.isReplaceable(level, place = wall.m_121945_(d.m_122424_())) || (e = this.replaceSingle(level, place, state = (BlockState)Blocks.f_50158_.m_49966_().m_61124_((Property)WallSignBlock.f_58064_, (Comparable)d))) == null) continue;
            BlockEntity be = level.m_7702_(place);
            if (be instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)be;
                try {
                    SignText front = sign.m_277142_();
                    front = front.m_276913_(0, (Component)Component.m_237113_((String)text));
                    sign.m_276956_(front, true);
                    sign.m_6596_();
                    level.m_7260_(place, state, state, 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return e;
        }
        return null;
    }

    private Entry placeStandingSign(ServerLevel level, BlockPos near, String text, RandomSource r) {
        BlockPos place = this.findOpenAbove(level, near);
        if (place == null) {
            return null;
        }
        int rot = r.m_188503_(16);
        BlockState state = (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rot));
        Entry e = this.replaceSingle(level, place, state);
        if (e != null) {
            BlockEntity be = level.m_7702_(place);
            if (be instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)be;
                try {
                    SignText front = sign.m_277142_();
                    front = front.m_276913_(0, (Component)Component.m_237113_((String)text));
                    sign.m_276956_(front, true);
                    sign.m_6596_();
                    level.m_7260_(place, state, state, 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return e;
        }
        return null;
    }

    private Entry placeSign(ServerLevel level, BlockPos near, String text, RandomSource r) {
        Entry e = this.placeStandingSign(level, near, text, r);
        if (e != null) {
            return e;
        }
        e = this.placeWallSign(level, near, text);
        if (e != null) {
            return e;
        }
        String[] lines = new String[]{text, "", "", ""};
        return this.placeSignLinesNear(level, near, lines, r);
    }

    private Entry placeStandingSignLines(ServerLevel level, BlockPos near, String[] lines, RandomSource r) {
        BlockPos place = this.findOpenAbove(level, near);
        if (place == null) {
            return null;
        }
        int rot = r.m_188503_(16);
        BlockState state = (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rot));
        Entry e = this.replaceSingle(level, place, state);
        if (e != null) {
            this.writeSignLines(level, place, state, lines);
            return e;
        }
        return null;
    }

    private Entry placeWallSignLines(ServerLevel level, BlockPos near, String[] lines) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockState state;
            Entry e;
            BlockPos place;
            BlockPos wall = near.m_121945_(d);
            if (level.m_8055_(wall).m_60795_() || !MicroStructureManager.isReplaceable(level, place = wall.m_121945_(d.m_122424_())) || (e = this.replaceSingle(level, place, state = (BlockState)Blocks.f_50158_.m_49966_().m_61124_((Property)WallSignBlock.f_58064_, (Comparable)d))) == null) continue;
            this.writeSignLines(level, place, state, lines);
            return e;
        }
        return null;
    }

    private Entry placeSignLines(ServerLevel level, BlockPos near, String[] lines, RandomSource r) {
        Entry e = this.placeStandingSignLines(level, near, lines, r);
        if (e != null) {
            return e;
        }
        return this.placeWallSignLines(level, near, lines);
    }

    private Entry placeSignLinesNear(ServerLevel level, BlockPos near, String[] lines, RandomSource r) {
        Entry direct = this.placeSignLines(level, near, lines, r);
        if (direct != null) {
            return direct;
        }
        int maxRadius = 3;
        for (int radius = 1; radius <= maxRadius; ++radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos candidate;
                    Entry attempt;
                    if (Math.abs(dx) != radius && Math.abs(dz) != radius || (attempt = this.placeSignLines(level, candidate = near.m_7918_(dx, 0, dz), lines, r)) == null) continue;
                    if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
                        LOGGER.info("[TheForgotten] Lure sign fallback succeeded at {} (radius {})", (Object)candidate, (Object)radius);
                    }
                    return attempt;
                }
            }
        }
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            LOGGER.warn("[TheForgotten] Lure sign placement failed after fallback around {}", (Object)near);
        }
        return null;
    }

    private void placeBreadcrumbTrail(ServerLevel level, Entry into, BlockPos from, BlockPos target, RandomSource r) {
        int steps = 2 + r.m_188503_(3);
        double dx = target.m_123341_() - from.m_123341_();
        double dz = target.m_123343_() - from.m_123343_();
        double len = Math.max(1.0, Math.sqrt(dx * dx + dz * dz));
        double ux = dx / len;
        double uz = dz / len;
        for (int i = 1; i <= steps; ++i) {
            int pz;
            int y;
            int px = from.m_123341_() + (int)Math.round(ux * ((double)i * (len / (double)(steps + 1))));
            BlockPos ground = new BlockPos(px, y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, px, pz = from.m_123343_() + (int)Math.round(uz * ((double)i * (len / (double)(steps + 1))))), pz);
            Entry e = this.placeStandingSign(level, ground, ">>>", r);
            if (e == null) continue;
            into.snapshots.addAll(e.snapshots);
        }
    }

    private void placeAxisHintSign(ServerLevel level, Entry into, BlockPos near, char axis, int value, RandomSource r) {
        int step = 128;
        int half = 64;
        int anchor = MicroStructureManager.worldAnchor(level, step);
        int bucket = (int)Math.round(((double)value - (double)anchor) / (double)step) * step + anchor;
        String dir = "";
        if (axis == 'X') {
            dir = value < 0 ? "W" : "E";
        } else if (axis == 'Z') {
            dir = value < 0 ? "N" : "S";
        }
        String[] lines = new String[]{axis + " \u2248 " + bucket, dir + " \u00b1" + half, "", ""};
        Entry e = this.placeSignLines(level, near, lines, r);
        if (e != null) {
            into.snapshots.addAll(e.snapshots);
        }
    }

    private String axisHintString(ServerLevel level, char axis, int value) {
        int step = 128;
        int half = 64;
        int anchor = MicroStructureManager.worldAnchor(level, step);
        int bucket = (int)Math.round(((double)value - (double)anchor) / (double)step) * step + anchor;
        String dir = "";
        if (axis == 'X') {
            dir = value < 0 ? "W" : "E";
        } else if (axis == 'Z') {
            dir = value < 0 ? "N" : "S";
        }
        return axis + " \u2248 " + bucket + " (" + dir + " \u00b1" + half + ")";
    }

    private static int worldAnchor(ServerLevel level, int step) {
        long s = level.m_7328_();
        long mix = s ^ s >>> 33 ^ s << 11;
        int mod = step;
        int off = Math.floorMod(mix, mod);
        return off - step / 2;
    }

    private void writeSignLines(ServerLevel level, BlockPos pos, BlockState state, String[] lines) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        try {
            SignText front = sign.m_277142_();
            for (int i = 0; i < Math.min(4, lines.length); ++i) {
                front = front.m_276913_(i, (Component)Component.m_237113_((String)(lines[i] == null ? "" : lines[i])));
            }
            sign.m_276956_(front, true);
            sign.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Entry placeFacing(ServerLevel level, BlockPos near, BlockState base) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockPos p = near.m_121945_(d.m_122424_());
            if (!MicroStructureManager.isReplaceable(level, p) || !MicroStructureManager.canStandOn(level, p.m_7495_())) continue;
            BlockState placed = base;
            if (placed.m_61138_((Property)BlockStateProperties.f_61374_)) {
                placed = (BlockState)placed.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)d);
            }
            return this.replaceSingle(level, p, placed);
        }
        return null;
    }

    private Entry placeSimple(ServerLevel level, BlockPos near, BlockState state) {
        BlockPos p = this.findOpenAbove(level, near);
        if (p == null) {
            return null;
        }
        return this.replaceSingle(level, p, state);
    }

    private Entry placeInventoryBlock(ServerLevel level, BlockPos near, ServerPlayer owner, RandomSource r) {
        if (owner == null) {
            return this.placeSimple(level, near, Blocks.f_50493_.m_49966_());
        }
        ArrayList<Integer> blockSlots = new ArrayList<Integer>();
        for (int i = 0; i < owner.m_150109_().f_35974_.size(); ++i) {
            BlockItem blockItem;
            BlockState state;
            Item item;
            ItemStack stack = (ItemStack)owner.m_150109_().f_35974_.get(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BlockItem) || (state = (blockItem = (BlockItem)item).m_40614_().m_49966_()).m_60795_()) continue;
            blockSlots.add(i);
        }
        if (blockSlots.isEmpty()) {
            return this.placeSimple(level, near, Blocks.f_50493_.m_49966_());
        }
        int pickedIndex = (Integer)blockSlots.get(r.m_188503_(blockSlots.size()));
        ItemStack pickedStack = (ItemStack)owner.m_150109_().f_35974_.get(pickedIndex);
        BlockItem pickedItem = (BlockItem)pickedStack.m_41720_();
        BlockState toPlace = pickedItem.m_40614_().m_49966_();
        Entry result = this.placeSimple(level, near, toPlace);
        if (result != null) {
            pickedStack.m_41774_(1);
            if (pickedStack.m_41619_()) {
                owner.m_150109_().f_35974_.set(pickedIndex, (Object)ItemStack.f_41583_);
            }
            owner.m_150109_().m_6596_();
        }
        return result;
    }

    private Entry placeChestPossiblyClue(ServerLevel level, BlockPos near, RandomSource r, ServerPlayer owner, long now) {
        Entry chest = this.placeFacing(level, near, Blocks.f_50087_.m_49966_());
        if (chest == null) {
            return null;
        }
        if (r.m_188500_() < 0.35) {
            BlockPos target;
            Entry campaign;
            Entry entry = campaign = owner != null ? this.campaignByPlayer.get(owner.m_20148_()) : null;
            if (campaign == null) {
                campaign = this.findActiveLureNear(level, near, 512);
            }
            BlockPos blockPos = target = campaign != null ? campaign.lure.target : this.pickLureTargetNear(level, near, r);
            if (target != null) {
                Snapshot last = chest.snapshots.get(chest.snapshots.size() - 1);
                BlockPos chestPos = last.pos;
                BlockEntity be = level.m_7702_(chestPos);
                if (be instanceof ChestBlockEntity) {
                    ChestBlockEntity cbe = (ChestBlockEntity)be;
                    char axis = r.m_188499_() ? (char)'X' : 'Z';
                    int val = axis == 'X' ? target.m_123341_() : target.m_123343_();
                    String hint = this.axisHintString(level, axis, val);
                    ItemStack paper = new ItemStack((ItemLike)Items.f_42516_);
                    paper.m_41714_((Component)Component.m_237113_((String)hint));
                    int slot = 13;
                    if (slot >= 0 && slot < cbe.m_6643_()) {
                        cbe.m_6836_(slot, paper);
                    }
                    cbe.m_6596_();
                    level.m_7260_(chestPos, level.m_8055_(chestPos), level.m_8055_(chestPos), 3);
                }
                if (campaign != null) {
                    campaign.snapshots.addAll(chest.snapshots);
                    double travelDist = Math.sqrt(near.m_203198_((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5));
                    int needed = (int)Math.ceil(travelDist / 4.3 + 40.0);
                    int minTTL = 180;
                    int maxTTL = 1200;
                    int ttl = Math.max(minTTL, Math.min(maxTTL, needed));
                    campaign.expiresAt = Math.max(campaign.expiresAt, now + (long)ttl * 20L);
                } else {
                    chest.lure = new Lure(target);
                    if (owner != null) {
                        this.campaignByPlayer.put(owner.m_20148_(), chest);
                    }
                }
            }
        }
        return chest;
    }

    private Entry replaceSingle(ServerLevel level, BlockPos pos, BlockState newState) {
        if (!level.m_46749_(pos)) {
            return null;
        }
        if (!level.m_46859_(pos) && !level.m_8055_(pos).m_60713_(Blocks.f_50125_)) {
            return null;
        }
        if (level.m_6425_(pos) == Fluids.f_76193_.m_76145_()) {
            return null;
        }
        BlockState old = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        CompoundTag nbt = null;
        if (be != null) {
            nbt = be.m_187482_();
        }
        if (!level.m_7731_(pos, newState, 3)) {
            return null;
        }
        Entry e = new Entry();
        e.snapshots.add(new Snapshot(pos, old, nbt));
        e.dimension = level.m_46472_();
        return e;
    }

    private String randomSafeSignText(RandomSource r) {
        String raw = Pools.randomSignText(r);
        String base = this.sanitizeSignText(raw);
        if (base.isEmpty()) {
            return base;
        }
        return this.stylizeCipheredLore(base, r);
    }

    private String sanitizeSignText(String raw) {
        if (raw == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int max = Math.min(30, raw.length());
        for (int i = 0; i < max; ++i) {
            char c = raw.charAt(i);
            if (Character.isISOControl(c) || c < ' ' || c > '\u036f') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private String stylizeCipheredLore(String base, RandomSource r) {
        double roll = r.m_188500_();
        String variant = roll < 0.4 ? this.sanitizeSignText(this.applyCaesarShift(base, 1 + r.m_188503_(5))) : (roll < 0.7 ? this.sanitizeSignText(this.applyCombiningMarks(base, r)) : (roll < 0.85 ? this.sanitizeSignText(this.insertCipherBreaks(base, r)) : base));
        return variant.isEmpty() ? base : variant;
    }

    private String applyCaesarShift(String text, int shift) {
        StringBuilder out = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            int offset;
            char c = text.charAt(i);
            if (c >= 'a' && c <= 'z') {
                offset = (c - 97 + shift) % 26;
                out.append((char)(97 + offset));
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                offset = (c - 65 + shift) % 26;
                out.append((char)(65 + offset));
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private String applyCombiningMarks(String text, RandomSource r) {
        StringBuilder out = new StringBuilder();
        char[] marks = new char[]{'\u0000', '\u0336', '\u0304', '\u0307', '\u0301'};
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            out.append(c);
            if (!Character.isLetterOrDigit(c) || !(r.m_188500_() < 0.65)) continue;
            char mark = marks[1 + r.m_188503_(marks.length - 1)];
            out.append(mark);
        }
        return out.toString();
    }

    private String insertCipherBreaks(String text, RandomSource r) {
        StringBuilder normalized = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ') continue;
            if (Character.isLetter(c)) {
                normalized.append(Character.toUpperCase(c));
                continue;
            }
            normalized.append(c);
        }
        if (normalized.length() == 0) {
            return text;
        }
        StringBuilder out = new StringBuilder();
        char[] separators = new char[]{':', '/', '.'};
        int group = 0;
        for (int i = 0; i < normalized.length(); ++i) {
            boolean last;
            char c = normalized.charAt(i);
            out.append(c);
            boolean bl = last = i == normalized.length() - 1;
            if (!last && ++group >= 3) {
                char sep = separators[r.m_188503_(separators.length)];
                out.append(sep);
                group = 0;
                continue;
            }
            if (last || !(r.m_188500_() < 0.1)) continue;
            out.append(' ');
        }
        return out.toString();
    }

    private String personalCreepyText(ServerPlayer owner, RandomSource r) {
        String name = owner != null ? owner.m_36316_().getName() : "you";
        String[] msgs = new String[]{name + ", don't look back", "stop hiding, " + name, name + ", keep walking", "we saw you, " + name, name + ", closer", "behind you, " + name, "stay quiet, " + name, name + ", why are you here", "not this way, " + name, name + ", hush"};
        String pick = msgs[r.m_188503_(msgs.length)];
        if (pick.length() > 30) {
            pick = pick.substring(0, 30);
        }
        return pick;
    }

    private BlockPos findGround(ServerLevel level, BlockPos around) {
        BlockPos p;
        int dy;
        for (dy = 0; dy <= 8 && level.m_46749_(p = around.m_6625_(dy)); ++dy) {
            BlockPos above = p.m_7494_();
            if (!MicroStructureManager.isReplaceable(level, above) || !MicroStructureManager.canStandOn(level, p)) continue;
            for (Direction d : Direction.Plane.HORIZONTAL) {
                if (level.m_46859_(above.m_121945_(d))) continue;
                return p;
            }
        }
        for (dy = 0; dy <= 8 && level.m_46749_(p = around.m_6625_(dy)); ++dy) {
            if (!MicroStructureManager.canStandOn(level, p)) continue;
            return p;
        }
        for (int radius = 1; radius <= 3; ++radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos p2;
                    if (Math.abs(dx) != radius && Math.abs(dz) != radius) continue;
                    BlockPos shifted = around.m_7918_(dx, 0, dz);
                    for (int dy2 = 0; dy2 <= 8 && level.m_46749_(p2 = shifted.m_6625_(dy2)); ++dy2) {
                        BlockPos above = p2.m_7494_();
                        if (!MicroStructureManager.isReplaceable(level, above) || !MicroStructureManager.canStandOn(level, p2)) continue;
                        return p2;
                    }
                }
            }
        }
        if (((Boolean)Config.DEBUG_LOGS.get()).booleanValue()) {
            LOGGER.warn("[TheForgotten] Unable to find ground near {}", (Object)around);
        }
        return null;
    }

    private BlockPos extractPrimaryPos(Entry entry, BlockPos fallback) {
        if (entry == null || entry.snapshots.isEmpty()) {
            return fallback;
        }
        Snapshot last = entry.snapshots.get(entry.snapshots.size() - 1);
        return last != null && last.pos != null ? last.pos : fallback;
    }

    private BlockPos findOpenAbove(ServerLevel level, BlockPos ground) {
        BlockPos p = ground.m_7494_();
        if (!MicroStructureManager.isReplaceable(level, p)) {
            return null;
        }
        if (!MicroStructureManager.canStandOn(level, ground)) {
            return null;
        }
        return p;
    }

    private static boolean canStandOn(ServerLevel level, BlockPos ground) {
        BlockState s = level.m_8055_(ground);
        if (s.m_60713_(Blocks.f_152499_)) {
            return false;
        }
        if (s.m_60713_(Blocks.f_50125_) || s.m_60713_(Blocks.f_50127_)) {
            return true;
        }
        return Block.m_49863_((LevelReader)level, (BlockPos)ground, (Direction)Direction.UP);
    }

    private static boolean isReplaceable(ServerLevel level, BlockPos pos) {
        BlockState s = level.m_8055_(pos);
        return level.m_46859_(pos) || s.m_60713_(Blocks.f_50125_);
    }

    private int countActiveNear(ServerLevel level, BlockPos center, int radius) {
        int count = 0;
        double r2 = (double)radius * (double)radius;
        for (Entry e : this.active) {
            if (!e.dimension.equals((Object)level.m_46472_())) continue;
            boolean near = false;
            for (Snapshot s : e.snapshots) {
                double dz;
                double dx = (double)s.pos.m_123341_() + 0.5 - (double)center.m_123341_();
                if (!(dx * dx + (dz = (double)s.pos.m_123343_() + 0.5 - (double)center.m_123343_()) * dz <= r2)) continue;
                near = true;
                break;
            }
            if (!near || ++count < 3) continue;
            return count;
        }
        return count;
    }

    public void rollbackAll(MinecraftServer server) {
        for (Entry e : new ArrayList<Entry>(this.active)) {
            e.rollback(server);
        }
        this.active.clear();
        try {
            this.campaignByPlayer.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onChunkUnload(ServerLevel level, LevelChunk chunk) {
        Iterator<Entry> it = this.active.iterator();
        while (it.hasNext()) {
            Entry e = it.next();
            if (e.dimension != level.m_46472_() || e.lure != null) continue;
            boolean inChunk = false;
            for (Snapshot s : e.snapshots) {
                if (chunk.m_7697_().f_45578_ != s.pos.m_123341_() >> 4 || chunk.m_7697_().f_45579_ != s.pos.m_123343_() >> 4) continue;
                inChunk = true;
                break;
            }
            if (!inChunk) continue;
            e.rollback(level.m_7654_());
            it.remove();
            try {
                this.campaignByPlayer.entrySet().removeIf(en -> en.getValue() == e);
            }
            catch (Throwable throwable) {}
        }
    }

    private static String coordsString(BlockPos p) {
        return p.m_123341_() + " " + p.m_123342_() + " " + p.m_123343_();
    }

    private static String creepyFollowText(String coords) {
        Object base = "follow " + coords;
        if (((String)base).length() > 30) {
            base = ((String)base).substring(0, 30);
        }
        return ((String)base).replace("o", "o\u0336");
    }

    private static String randomArgPitText(RandomSource r) {
        String[] msgs = new String[]{"keep going", "down you go", "no way back", "do not look", "hush hush", "closer"};
        String pick = msgs[r.m_188503_(msgs.length)];
        if (pick.length() > 30) {
            pick = pick.substring(0, 30);
        }
        return pick;
    }

    private BlockPos pickLureTargetNear(ServerLevel level, BlockPos origin, RandomSource r) {
        BlockPos spawn = level.m_7654_() != null && level.m_7654_().m_129783_() != null ? level.m_7654_().m_129783_().m_220360_() : new BlockPos(0, 0, 0);
        int minFromSpawn = 400;
        double minSpawnD2 = (double)minFromSpawn * (double)minFromSpawn;
        for (int tries = 0; tries < 96; ++tries) {
            Holder bh;
            double dzs;
            double angle = r.m_188500_() * Math.PI * 2.0;
            double dist = 400.0 + r.m_188500_() * 800.0;
            int tx = origin.m_123341_() + (int)Math.round(Math.cos(angle) * dist);
            int tz = origin.m_123343_() + (int)Math.round(Math.sin(angle) * dist);
            double dxs = (double)tx - (double)spawn.m_123341_();
            if (dxs * dxs + (dzs = (double)tz - (double)spawn.m_123343_()) * dzs < minSpawnD2 || (bh = level.m_204166_(new BlockPos(tx, level.m_5736_(), tz))).m_203656_(BiomeTags.f_207603_) || bh.m_203656_(BiomeTags.f_207605_)) continue;
            if (this.isWaterAtSurface(level, tx, tz)) {
                BlockPos land = this.findNearestLand(level, tx, tz, 512);
                if (land == null) continue;
                int ty2 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, land.m_123341_(), land.m_123343_());
                return new BlockPos(land.m_123341_(), ty2, land.m_123343_());
            }
            int ty = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, tx, tz);
            return new BlockPos(tx, ty, tz);
        }
        return null;
    }

    private static boolean isWater(ServerLevel level, BlockPos p) {
        FluidState fs = level.m_6425_(p);
        return !fs.m_76178_() && (fs.m_76152_() == Fluids.f_76193_ || fs.m_76152_() == Fluids.f_76192_);
    }

    private boolean isWaterAtSurface(ServerLevel level, int x, int z) {
        int wsY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        BlockPos p = new BlockPos(x, wsY, z);
        if (MicroStructureManager.isWater(level, p)) {
            return true;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                int wsY2;
                BlockPos p2;
                if (dx == 0 && dz == 0 || !MicroStructureManager.isWater(level, p2 = new BlockPos(x + dx, wsY2 = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x + dx, z + dz), z + dz))) continue;
                return true;
            }
        }
        return false;
    }

    private void processLure(MinecraftServer server, Entry e) {
        if (e.lure == null) {
            return;
        }
        ServerLevel level = server.m_129880_(e.dimension);
        if (level == null) {
            return;
        }
        Lure l = e.lure;
        if (!l.prepared) {
            for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                int minSec;
                double dz;
                if (!sp.m_9236_().m_46472_().equals((Object)level.m_46472_())) continue;
                double dx = sp.m_20185_() - (double)l.target.m_123341_();
                double d2 = dx * dx + (dz = sp.m_20189_() - (double)l.target.m_123343_()) * dz;
                if (d2 <= 38416.0) {
                    this.prepareLureSite(level, e, l);
                    if (((Boolean)Config.LURE_ENTRANCE_PERMANENT.get()).booleanValue()) {
                        e.expiresAt = 0x1FFFFFFFFFFFFFFFL;
                        break;
                    }
                    minSec = Math.max(60, (Integer)Config.LURE_ENTRANCE_TTL_MIN_SEC.get());
                    e.expiresAt = Math.max(e.expiresAt, (long)server.m_129921_() + (long)minSec * 20L);
                    break;
                }
                if (!(d2 <= 4096.0)) continue;
                this.prepareLureSite(level, e, l);
                if (((Boolean)Config.LURE_ENTRANCE_PERMANENT.get()).booleanValue()) {
                    e.expiresAt = 0x1FFFFFFFFFFFFFFFL;
                    break;
                }
                minSec = Math.max(60, (Integer)Config.LURE_ENTRANCE_TTL_MIN_SEC.get());
                e.expiresAt = Math.max(e.expiresAt, (long)server.m_129921_() + (long)minSec * 20L);
                break;
            }
        }
        if (!l.prepared) {
            return;
        }
        int minX = Math.min(l.target.m_123341_(), l.target.m_123341_() + 1);
        int maxX = minX + 1;
        int minZ = Math.min(l.target.m_123343_(), l.target.m_123343_() + 1);
        int maxZ = minZ + 1;
        double totalDepth = Math.max(1.0, (double)(l.topY - l.bottomY));
        double depthTrigger = Math.max(16.0, totalDepth * 0.3);
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            double fallen;
            if (!sp.m_9236_().m_46472_().equals((Object)level.m_46472_()) || PlayerFlags.isEscaped(sp)) continue;
            boolean marked = PlayerFlags.hasLureMark(sp, server.m_129921_());
            if (l.done.contains(sp.m_20148_()) && !marked) continue;
            double x = sp.m_20185_();
            double z = sp.m_20189_();
            if (!(x >= (double)minX) || !(x < (double)(maxX + 1)) || !(z >= (double)minZ) || !(z < (double)(maxZ + 1))) continue;
            double vY = sp.m_20184_().f_82480_;
            if (vY < -0.05) {
                ResourceLocation soundId;
                double depth = Mth.m_14008_((double)((double)l.topY - sp.m_20186_()), (double)0.0, (double)totalDepth);
                double progress = depth / totalDepth;
                float intensity = (float)Mth.m_14008_((double)(0.25 + 0.75 * progress), (double)0.25, (double)1.0);
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(5, intensity));
                if (progress > 0.4 && sp.f_19797_ % 6 == 0) {
                    this.spawnCorridorFallingDust(level, sp);
                }
                if (progress > 0.65 && sp.f_19797_ % 12 == 0 && (soundId = ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_276532_)) != null) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(soundId, sp.m_20185_(), sp.m_20186_(), sp.m_20189_(), 0.6f, 0.7f + sp.m_217043_().m_188501_() * 0.2f, SoundSource.AMBIENT));
                }
                if (progress > 0.85 && sp.f_19797_ % 14 == 0) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(9, intensity));
                }
            }
            if (!((fallen = (double)l.topY - sp.m_20186_()) >= depthTrigger)) continue;
            this.teleportToLureDimension(server, sp);
            if (marked) continue;
            l.done.add(sp.m_20148_());
        }
    }

    private void spawnCorridorFallingDust(ServerLevel level, ServerPlayer sp) {
        BlockState wall = Blocks.f_50652_.m_49966_();
        BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123814_, wall);
        double spread = 0.9;
        for (int i = 0; i < 6; ++i) {
            double ox = (sp.m_217043_().m_188500_() - 0.5) * spread;
            double oz = (sp.m_217043_().m_188500_() - 0.5) * spread;
            double oy = sp.m_217043_().m_188500_() * 1.2;
            level.m_8767_((ParticleOptions)particle, sp.m_20185_() + ox, sp.m_20186_() + oy, sp.m_20189_() + oz, 1, 0.0, -0.25, 0.0, 0.02);
        }
    }

    private void prepareLureSite(ServerLevel level, Entry into, Lure l) {
        int y;
        int gx = l.target.m_123341_();
        int gz = l.target.m_123343_();
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, gx, gz);
        BlockPos base = new BlockPos(gx, Math.max(surfaceY, level.m_141937_() + 1), gz);
        int topY = base.m_123342_();
        int bottomY = level.m_141937_();
        try {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    level.m_46745_(new BlockPos(base.m_123341_() + dx * 16, base.m_123342_(), base.m_123343_() + dz * 16));
                }
            }
        }
        catch (Throwable dx) {
            // empty catch block
        }
        for (y = topY; y >= bottomY; --y) {
            BlockPos p00 = new BlockPos(base.m_123341_(), y, base.m_123343_());
            BlockPos p10 = p00.m_122029_();
            BlockPos p01 = p00.m_122019_();
            BlockPos p11 = p10.m_122019_();
            this.replaceAndSnap(level, into, p00, Blocks.f_50016_.m_49966_());
            this.replaceAndSnap(level, into, p10, Blocks.f_50016_.m_49966_());
            this.replaceAndSnap(level, into, p01, Blocks.f_50016_.m_49966_());
            this.replaceAndSnap(level, into, p11, Blocks.f_50016_.m_49966_());
        }
        for (y = topY; y >= bottomY; --y) {
            for (int dx = -1; dx <= 2; ++dx) {
                for (int dz = -1; dz <= 2; ++dz) {
                    if (dx >= 0 && dx <= 1 && dz >= 0 && dz <= 1 || dx != -1 && dx != 2 && dz != -1 && dz != 2) continue;
                    Iterator wallPos = new BlockPos(base.m_123341_() + dx, y, base.m_123343_() + dz);
                    this.replaceAndSnap(level, into, (BlockPos)wallPos, Blocks.f_50652_.m_49966_());
                }
            }
        }
        RandomSource r = level.m_213780_();
        String t = MicroStructureManager.randomArgPitText(r);
        boolean placed = false;
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (placed) break;
            BlockPos rimGround = base.m_121945_(d);
            Entry se = this.placeStandingSign(level, rimGround, t, r);
            if (se == null) continue;
            into.snapshots.addAll(se.snapshots);
            placed = true;
        }
        l.prepared = true;
        l.topY = topY;
        l.bottomY = bottomY;
        l.target = base;
        if (l.signPos != null && level.m_46749_(l.signPos)) {
            BlockState s = level.m_8055_(l.signPos);
            this.writeSignLines(level, l.signPos, s, MicroStructureManager.creepyFollowLines(base));
        }
    }

    private void replaceAndSnap(ServerLevel level, Entry into, BlockPos pos, BlockState newState) {
        if (!level.m_46749_(pos)) {
            return;
        }
        BlockState old = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        CompoundTag nbt = null;
        if (be != null) {
            nbt = be.m_187482_();
        }
        level.m_7731_(pos, newState, 3);
        into.snapshots.add(new Snapshot(pos, old, nbt));
    }

    public boolean isStructureBlock(ServerLevel level, BlockPos pos) {
        for (Entry e : this.active) {
            if (!e.dimension.equals((Object)level.m_46472_())) continue;
            for (Snapshot s : e.snapshots) {
                if (s.pos == null || !s.pos.equals((Object)pos)) continue;
                return true;
            }
        }
        return false;
    }

    private void carveCorridorSlice(ServerLevel level, Entry entry, BlockPos center, Direction forward, BlockState centerFloor, BlockState sideFloor, BlockState wall, int[] bounds) {
        Direction left = forward.m_122428_();
        Direction right = forward.m_122427_();
        BlockPos centerFloorPos = center;
        BlockPos leftFloorPos = center.m_121945_(left);
        BlockPos rightFloorPos = center.m_121945_(right);
        this.replaceAndSnap(level, entry, centerFloorPos, centerFloor);
        this.replaceAndSnap(level, entry, leftFloorPos, sideFloor);
        this.replaceAndSnap(level, entry, rightFloorPos, sideFloor);
        for (int h = 1; h <= 5; ++h) {
            this.replaceAndSnap(level, entry, centerFloorPos.m_6630_(h), Blocks.f_50016_.m_49966_());
            this.replaceAndSnap(level, entry, leftFloorPos.m_6630_(h), Blocks.f_50016_.m_49966_());
            this.replaceAndSnap(level, entry, rightFloorPos.m_6630_(h), Blocks.f_50016_.m_49966_());
        }
        BlockPos leftWall = leftFloorPos.m_121945_(left);
        BlockPos rightWall = rightFloorPos.m_121945_(right);
        for (int h = 0; h <= 5; ++h) {
            this.replaceAndSnap(level, entry, leftWall.m_6630_(h), wall);
            this.replaceAndSnap(level, entry, rightWall.m_6630_(h), wall);
        }
        BlockPos ceiling = centerFloorPos.m_6630_(5);
        this.replaceAndSnap(level, entry, ceiling, wall);
        this.replaceAndSnap(level, entry, ceiling.m_121945_(left), wall);
        this.replaceAndSnap(level, entry, ceiling.m_121945_(right), wall);
        MicroStructureManager.includeBounds(bounds, centerFloorPos);
        MicroStructureManager.includeBounds(bounds, leftFloorPos);
        MicroStructureManager.includeBounds(bounds, rightFloorPos);
        MicroStructureManager.includeBounds(bounds, centerFloorPos.m_7494_());
        MicroStructureManager.includeBounds(bounds, leftFloorPos.m_7494_());
        MicroStructureManager.includeBounds(bounds, rightFloorPos.m_7494_());
        MicroStructureManager.includeBounds(bounds, ceiling);
        MicroStructureManager.includeBounds(bounds, ceiling.m_121945_(left));
        MicroStructureManager.includeBounds(bounds, ceiling.m_121945_(right));
        MicroStructureManager.includeBounds(bounds, ceiling.m_7494_());
    }

    private static int[] newBoundsArray() {
        return new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    }

    private static void includeBounds(int[] bounds, BlockPos pos) {
        if (bounds == null || pos == null) {
            return;
        }
        if (bounds[0] > pos.m_123341_()) {
            bounds[0] = pos.m_123341_();
        }
        if (bounds[1] > pos.m_123342_()) {
            bounds[1] = pos.m_123342_();
        }
        if (bounds[2] > pos.m_123343_()) {
            bounds[2] = pos.m_123343_();
        }
        if (bounds[3] < pos.m_123341_()) {
            bounds[3] = pos.m_123341_();
        }
        if (bounds[4] < pos.m_123342_()) {
            bounds[4] = pos.m_123342_();
        }
        if (bounds[5] < pos.m_123343_()) {
            bounds[5] = pos.m_123343_();
        }
    }

    private static AABB boundsToAabb(int[] bounds) {
        if (bounds == null || bounds[0] == Integer.MAX_VALUE) {
            return null;
        }
        return new AABB((double)bounds[0], (double)bounds[1], (double)bounds[2], (double)(bounds[3] + 1), (double)(bounds[4] + 1), (double)(bounds[5] + 1));
    }

    private void teleportToLureDimension(MinecraftServer server, ServerPlayer sp) {
        try {
            sp.m_20334_(0.0, 0.0, 0.0);
            sp.m_183634_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Managers.LUREDIM != null) {
            Managers.LUREDIM.teleportToSpawnRoom(server, sp);
        } else {
            ServerLevel target = server.m_129880_(LureDimensionManager.LURE_DIM);
            if (target == null) {
                target = server.m_129880_(Level.f_46430_);
            }
            if (target == null) {
                target = server.m_129783_();
            }
            double tx = sp.m_20185_();
            double tz = sp.m_20189_();
            int y = Math.min(target.m_151558_() - 10, 300);
            sp.m_8999_(target, tx, (double)y + 0.1, tz, sp.m_146908_(), sp.m_146909_());
        }
        try {
            sp.m_20334_(0.0, 0.0, 0.0);
            sp.m_183634_();
            sp.f_19864_ = true;
            sp.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 40, 0, false, false));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class Entry {
        long expiresAt;
        final List<Snapshot> snapshots = new ArrayList<Snapshot>();
        ResourceKey<Level> dimension;
        Lure lure;

        Entry() {
        }

        void rollback(MinecraftServer server) {
            ServerLevel level = server.m_129880_(this.dimension);
            if (level == null) {
                return;
            }
            for (Snapshot s : this.snapshots) {
                BlockEntity be;
                if (!level.m_46749_(s.pos)) continue;
                level.m_7731_(s.pos, s.prev, 3);
                if (s.beNbt == null || (be = level.m_7702_(s.pos)) == null) continue;
                be.m_142466_(s.beNbt);
                be.m_6596_();
            }
        }
    }

    static class Lure {
        BlockPos target;
        boolean prepared;
        int topY;
        int bottomY;
        final Set<UUID> done = new HashSet<UUID>();
        BlockPos signPos;

        Lure(BlockPos target) {
            this.target = target;
        }
    }

    public static enum Variant {
        TORCH,
        CRAFTING_TABLE,
        PHANTOM_BLOCKS,
        CHEST_EMPTY,
        FURNACE,
        LADDER,
        REDSTONE_TORCH,
        REDSTONE_RITUAL,
        CROSS,
        SIGN,
        SHEAR_WALL,
        OFFSET_PATCH,
        VOID_FISSURE,
        BEDROCK_BLOOM,
        TREE_GHOST;

    }

    static class Snapshot {
        final BlockPos pos;
        final BlockState prev;
        final CompoundTag beNbt;

        Snapshot(BlockPos pos, BlockState prev, CompoundTag beNbt) {
            this.pos = pos;
            this.prev = prev;
            this.beNbt = beNbt;
        }
    }
}

