/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="theforgotten")
public final class MobSpawnLimiter {
    private static final Set<MobSpawnType> BLOCKED_TYPES = EnumSet.of(MobSpawnType.NATURAL, new MobSpawnType[]{MobSpawnType.CHUNK_GENERATION, MobSpawnType.PATROL, MobSpawnType.REINFORCEMENT, MobSpawnType.EVENT, MobSpawnType.MOB_SUMMONED});
    private static final double PEACEFUL_ALLOW_CHANCE = 0.08;
    private static final String PEACEFUL_ALLOW_TAG = "theforgotten:allow_peaceful_spawn";
    private static final Set<SpawnAllowance> PEACEFUL_ALLOWANCES = Collections.newSetFromMap(new ConcurrentHashMap());

    private static boolean shouldBlock(MobSpawnType type) {
        return type != null && BLOCKED_TYPES.contains(type);
    }

    private static boolean isPeacefulMob(LivingEntity entity) {
        if (!(entity instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)entity;
        return mob.m_6095_().m_20674_() != MobCategory.MONSTER;
    }

    private static boolean randomAllowPeaceful(MobSpawnEvent.SpawnPlacementCheck e) {
        if (e.getEntityType() == null) {
            return false;
        }
        if (e.getEntityType().m_20674_() == MobCategory.MONSTER) {
            return false;
        }
        if (ThreadLocalRandom.current().nextDouble() >= 0.08) {
            return false;
        }
        BlockPos pos = e.getPos();
        ResourceKey dimension = null;
        ServerLevelAccessor serverLevelAccessor = e.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)serverLevelAccessor;
            dimension = level.m_46472_();
        }
        if (pos != null && dimension != null) {
            PEACEFUL_ALLOWANCES.add(new SpawnAllowance((ResourceKey<Level>)dimension, pos.m_7949_()));
        }
        return true;
    }

    private static boolean consumeAllowance(LivingEntity entity) {
        if (entity == null || !MobSpawnLimiter.isPeacefulMob(entity)) {
            return false;
        }
        SpawnAllowance key = new SpawnAllowance((ResourceKey<Level>)entity.m_9236_().m_46472_(), entity.m_20183_().m_7949_());
        if (PEACEFUL_ALLOWANCES.remove(key)) {
            entity.getPersistentData().m_128379_(PEACEFUL_ALLOW_TAG, true);
            return true;
        }
        return entity.getPersistentData().m_128471_(PEACEFUL_ALLOW_TAG);
    }

    private static void clearAllowance(LivingEntity entity) {
        if (entity != null) {
            entity.getPersistentData().m_128473_(PEACEFUL_ALLOW_TAG);
        }
    }

    @SubscribeEvent
    public static void onSpawnPlacementCheck(MobSpawnEvent.SpawnPlacementCheck e) {
        if (MobSpawnLimiter.shouldBlock(e.getSpawnType())) {
            if (MobSpawnLimiter.randomAllowPeaceful(e)) {
                e.setResult(Event.Result.ALLOW);
                return;
            }
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onFinalizeSpawn(MobSpawnEvent.FinalizeSpawn e) {
        if (MobSpawnLimiter.shouldBlock(e.getSpawnType())) {
            if (MobSpawnLimiter.consumeAllowance((LivingEntity)e.getEntity())) {
                MobSpawnLimiter.clearAllowance((LivingEntity)e.getEntity());
                return;
            }
            MobSpawnLimiter.clearAllowance((LivingEntity)e.getEntity());
            e.setCanceled(true);
        }
    }

    private record SpawnAllowance(ResourceKey<Level> dimension, BlockPos pos) {
    }
}

