/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.tasuposed.theforgotten.Config;

public final class PlayerFlags {
    private static final String ESCAPED_TAG = "theforgotten_escaped";
    private static final String REAWAKENED_TAG = "theforgotten_reawakened";
    private static final String TRIAL_ROOT = "theforgotten_trial";
    private static final String TRIAL_PRESSED = "pressed";
    private static final String TRIAL_LAST_DEC = "last_dec_ts";
    private static final String CONSENT_ROOT = "theforgotten_consent";
    private static final String CONSENT_ACCEPTED = "accepted";
    private static final String CONSENT_DENIED = "denied";
    private static final String CONSENT_X = "x";
    private static final String CONSENT_Y = "y";
    private static final String CONSENT_Z = "z";
    private static final String LURE_FLAGS = "theforgotten_lure";
    private static final String LURE_MARK_UNTIL = "mark_until";
    private static final String LURE_TRAP_RESPAWN = "trap_respawn";

    private PlayerFlags() {
    }

    public static boolean isEscaped(ServerPlayer sp) {
        return sp.getPersistentData().m_128471_(ESCAPED_TAG);
    }

    public static void setEscaped(ServerPlayer sp, boolean value) {
        sp.getPersistentData().m_128379_(ESCAPED_TAG, value);
    }

    public static boolean isReawakened(ServerPlayer sp) {
        return sp.getPersistentData().m_128471_(REAWAKENED_TAG);
    }

    public static void setReawakened(ServerPlayer sp, boolean value) {
        sp.getPersistentData().m_128379_(REAWAKENED_TAG, value);
    }

    public static int getTrialPressedCount(ServerPlayer sp) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag trial = root.m_128469_(TRIAL_ROOT);
        long[] arr = trial.m_128467_(TRIAL_PRESSED);
        return arr == null ? 0 : arr.length;
    }

    public static boolean hasPressedTrial(ServerPlayer sp, long id) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag trial = root.m_128469_(TRIAL_ROOT);
        long[] arr = trial.m_128467_(TRIAL_PRESSED);
        if (arr == null) {
            return false;
        }
        for (long v : arr) {
            if (v != id) continue;
            return true;
        }
        return false;
    }

    public static boolean markTrialButton(ServerPlayer sp, long id) {
        if (PlayerFlags.hasPressedTrial(sp, id)) {
            return false;
        }
        CompoundTag root = sp.getPersistentData();
        CompoundTag trial = root.m_128469_(TRIAL_ROOT);
        long[] arr = trial.m_128467_(TRIAL_PRESSED);
        int n = arr == null ? 0 : arr.length;
        long[] out = new long[n + 1];
        if (n > 0) {
            System.arraycopy(arr, 0, out, 0, n);
        }
        out[n] = id;
        trial.m_128388_(TRIAL_PRESSED, out);
        root.m_128365_(TRIAL_ROOT, (Tag)trial);
        return true;
    }

    public static boolean isTrialComplete(ServerPlayer sp) {
        int req = (Integer)Config.TRIAL_REQUIRED_BUTTONS.get();
        return PlayerFlags.getTrialPressedCount(sp) >= req;
    }

    public static int decrementTrialProgress(ServerPlayer sp, int count) {
        if (count <= 0) {
            return 0;
        }
        CompoundTag root = sp.getPersistentData();
        CompoundTag trial = root.m_128469_(TRIAL_ROOT);
        long[] arr = trial.m_128467_(TRIAL_PRESSED);
        if (arr == null || arr.length == 0) {
            return 0;
        }
        int n = Math.max(0, arr.length - count);
        long[] out = new long[n];
        if (n > 0) {
            System.arraycopy(arr, 0, out, 0, n);
        }
        trial.m_128388_(TRIAL_PRESSED, out);
        trial.m_128356_(TRIAL_LAST_DEC, sp.m_20194_() != null ? (long)sp.m_20194_().m_129921_() : 0L);
        root.m_128365_(TRIAL_ROOT, (Tag)trial);
        return arr.length - n;
    }

    public static void setLureMark(ServerPlayer sp, long untilTick) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag l = root.m_128469_(LURE_FLAGS);
        l.m_128356_(LURE_MARK_UNTIL, untilTick);
        root.m_128365_(LURE_FLAGS, (Tag)l);
    }

    public static boolean hasLureMark(ServerPlayer sp, long now) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag l = root.m_128469_(LURE_FLAGS);
        long until = l.m_128454_(LURE_MARK_UNTIL);
        return until > 0L && now < until;
    }

    public static void setTrapRespawn(ServerPlayer sp, boolean v) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag l = root.m_128469_(LURE_FLAGS);
        l.m_128379_(LURE_TRAP_RESPAWN, v);
        root.m_128365_(LURE_FLAGS, (Tag)l);
    }

    public static boolean shouldTrapRespawn(ServerPlayer sp) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag l = root.m_128469_(LURE_FLAGS);
        return l.m_128471_(LURE_TRAP_RESPAWN);
    }

    public static boolean isConsentAccepted(ServerPlayer sp) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag c = root.m_128469_(CONSENT_ROOT);
        return c.m_128471_(CONSENT_ACCEPTED);
    }

    public static boolean isConsentDenied(ServerPlayer sp) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag c = root.m_128469_(CONSENT_ROOT);
        return c.m_128471_(CONSENT_DENIED);
    }

    public static void setConsentAccepted(ServerPlayer sp, boolean v) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag c = root.m_128469_(CONSENT_ROOT);
        c.m_128379_(CONSENT_ACCEPTED, v);
        if (v) {
            c.m_128379_(CONSENT_DENIED, false);
        }
        root.m_128365_(CONSENT_ROOT, (Tag)c);
    }

    public static void setConsentDenied(ServerPlayer sp, boolean v) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag c = root.m_128469_(CONSENT_ROOT);
        c.m_128379_(CONSENT_DENIED, v);
        if (v) {
            c.m_128379_(CONSENT_ACCEPTED, false);
        }
        root.m_128365_(CONSENT_ROOT, (Tag)c);
    }

    public static void setConsentRoom(ServerPlayer sp, BlockPos p) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag c = root.m_128469_(CONSENT_ROOT);
        c.m_128405_(CONSENT_X, p.m_123341_());
        c.m_128405_(CONSENT_Y, p.m_123342_());
        c.m_128405_(CONSENT_Z, p.m_123343_());
        root.m_128365_(CONSENT_ROOT, (Tag)c);
    }

    public static BlockPos getConsentRoom(ServerPlayer sp) {
        CompoundTag root = sp.getPersistentData();
        CompoundTag c = root.m_128469_(CONSENT_ROOT);
        if (!c.m_128441_(CONSENT_X)) {
            return null;
        }
        return new BlockPos(c.m_128451_(CONSENT_X), c.m_128451_(CONSENT_Y), c.m_128451_(CONSENT_Z));
    }
}

