/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.tasuposed.theforgotten.Config;
import net.tasuposed.theforgotten.commands.DebugCommands;
import net.tasuposed.theforgotten.data.Pools;
import net.tasuposed.theforgotten.network.NetworkHandler;
import net.tasuposed.theforgotten.network.S2CForceGlitchPacket;
import net.tasuposed.theforgotten.network.S2COpenToLanPacket;
import net.tasuposed.theforgotten.network.S2CPositionalSoundPacket;
import net.tasuposed.theforgotten.network.S2CStartLoopSoundPacket;
import net.tasuposed.theforgotten.network.S2CStopLoopSoundPacket;
import net.tasuposed.theforgotten.server.AmbientSoundManager;
import net.tasuposed.theforgotten.server.ApparitionManager;
import net.tasuposed.theforgotten.server.LureDimensionManager;
import net.tasuposed.theforgotten.server.Managers;
import net.tasuposed.theforgotten.server.MicroStructureManager;
import net.tasuposed.theforgotten.server.PlayerFlags;
import net.tasuposed.theforgotten.server.RuntimeTuning;
import net.tasuposed.theforgotten.server.TensionManager;
import net.tasuposed.theforgotten.server.TormentorManager;
import net.tasuposed.theforgotten.server.WorldSilenceData;

@Mod.EventBusSubscriber(modid="theforgotten")
public class ServerEvents {
    private static TensionManager TENSION;
    private static AmbientSoundManager AMBIENT;
    private static ApparitionManager APPARITIONS;
    private static MicroStructureManager MICRO;
    private static LureDimensionManager LUREDIM;
    private static final Set<UUID> CONSENT_ACTIVE;
    private static final Map<UUID, Integer> CONSENT_STEP;
    private static final Map<UUID, Long> CONSENT_NEXT_TICK;
    private static final Set<UUID> LURE_HUM_ACTIVE;
    private static boolean LAN_EVENT_TRIGGERED;
    private static Long LAN_EVENT_AT_TICK;
    private static Long FAKE_JOIN_TICK;
    private static boolean LAN_MESSAGE_SENT;
    private static UUID FAKE_TAB_UUID;
    private static String FAKE_TAB_NAME;
    private static Long FAKE_TAB_REMOVE_TICK;
    private static final Map<UUID, Long> CREEPY_NEXT_TICK;
    private static final Map<UUID, Integer> GREET_STEP;
    private static final Map<UUID, Long> GREET_NEXT_TICK;
    private static final Map<UUID, Integer> HUNT_EVENT_STEP;
    private static final Map<UUID, Long> HUNT_EVENT_NEXT_TICK;
    private static final Map<UUID, Long> HUNT_EVENT_COOLDOWN;
    private static final Map<UUID, Long> LAST_SLEEP_FRIGHT;
    private static final Map<UUID, Long> FRIGHT_ARMED_AT;
    private static final long SLEEP_FRIGHT_COOLDOWN = 2400L;
    private static final Set<UUID> FORCE_FRIGHT_NEXT_SLEEP;
    private static final long HUNT_EVENT_COOLDOWN_TICKS = 3600L;
    private static boolean WAS_SILENT;
    private static Long SILENCE_RAMP_START_TICK;
    private static Long SILENCE_RAMP_UNTIL_TICK;
    private static Double SILENCE_RAMP_START_OVERRIDE;
    private static final Pattern REAWAKE_CMD_COMPAT;
    private static final Pattern REAWAKE_CMD_VANILLA;
    private static final Map<UUID, BlockPos> ARMED_BED_POS;

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent e) {
        TENSION = new TensionManager();
        AMBIENT = new AmbientSoundManager();
        APPARITIONS = new ApparitionManager();
        MICRO = new MicroStructureManager();
        LUREDIM = new LureDimensionManager();
        Managers.TORMENTOR = new TormentorManager();
        Managers.TENSION = TENSION;
        Managers.AMBIENT = AMBIENT;
        Managers.APPARITIONS = APPARITIONS;
        Managers.MICRO = MICRO;
        Managers.LUREDIM = LUREDIM;
    }

    private static void processSleepFright(ServerPlayer sp, long now) {
        Long armTick = FRIGHT_ARMED_AT.get(sp.m_20148_());
        if (armTick == null) {
            return;
        }
        if (now < armTick) {
            return;
        }
        FRIGHT_ARMED_AT.remove(sp.m_20148_());
        BlockPos bed = ARMED_BED_POS.remove(sp.m_20148_());
        if (!sp.m_5803_()) {
            return;
        }
        sp.m_5796_();
        float damage = (float)Math.max(0.0, (Double)Config.SLEEP_FRIGHT_DAMAGE.get());
        if (damage > 0.0f) {
            sp.m_6469_(sp.m_269291_().m_269264_(), damage);
        }
        if (bed != null) {
            ServerEvents.openNearbyDoor(sp, bed);
        }
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(20, 0.7f));
    }

    public static void forceSleepFright(ServerPlayer sp) {
        if (sp == null) {
            return;
        }
        FORCE_FRIGHT_NEXT_SLEEP.add(sp.m_20148_());
        LAST_SLEEP_FRIGHT.remove(sp.m_20148_());
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent e) {
        Player entity = e.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)entity;
        Player.BedSleepingProblem status = e.getResultStatus();
        if (status != null) {
            return;
        }
        if (!((Boolean)Config.ENABLE_AMBIENT_SOUNDS.get()).booleanValue()) {
            return;
        }
        long now = sp.f_8924_.m_129921_();
        Long last = LAST_SLEEP_FRIGHT.get(sp.m_20148_());
        if (!FORCE_FRIGHT_NEXT_SLEEP.contains(sp.m_20148_()) && last != null && now - last < 2400L) {
            return;
        }
        boolean forced = FORCE_FRIGHT_NEXT_SLEEP.remove(sp.m_20148_());
        double chance = (Double)Config.SLEEP_FRIGHT_CHANCE.get();
        if (!forced) {
            if (chance <= 0.0) {
                return;
            }
            if (sp.m_217043_().m_188500_() >= chance) {
                return;
            }
        }
        long alarmTick = now + 40L + (long)sp.m_217043_().m_188503_(60);
        FRIGHT_ARMED_AT.put(sp.m_20148_(), alarmTick);
        LAST_SLEEP_FRIGHT.put(sp.m_20148_(), now);
        BlockPos bedPos = e.getPos();
        if (bedPos != null) {
            ARMED_BED_POS.put(sp.m_20148_(), bedPos.m_7949_());
        }
    }

    @SubscribeEvent
    public static void onStructureBlockBreak(BlockEvent.BreakEvent e) {
        Player player = e.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (sp.m_7500_() || sp.m_5833_()) {
            return;
        }
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)levelAccessor;
        if (Managers.MICRO == null) {
            return;
        }
        BlockPos pos = e.getPos();
        if (!Managers.MICRO.isStructureBlock(sl, pos)) {
            return;
        }
        if (sp.m_217043_().m_188500_() < 0.5) {
            long current = sl.m_46468_();
            long dayBase = current - current % 24000L;
            long target = dayBase + 13000L;
            if (target <= current) {
                target += 24000L;
            }
            sl.m_8615_(target);
        }
    }

    @SubscribeEvent
    public static void onPlayerWake(PlayerWakeUpEvent e) {
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        FRIGHT_ARMED_AT.remove(sp.m_20148_());
        ARMED_BED_POS.remove(sp.m_20148_());
    }

    private static void openNearbyDoor(ServerPlayer sp, BlockPos center) {
        ResourceLocation snd;
        ServerLevel level = sp.m_284548_();
        int radius = 6;
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    cursor.m_122178_(center.m_123341_() + dx, center.m_123342_() + dy, center.m_123343_() + dz);
                    BlockState state = level.m_8055_((BlockPos)cursor);
                    if (!(state.m_60734_() instanceof DoorBlock) || !state.m_61138_((Property)BlockStateProperties.f_61446_) || ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) continue;
                    candidates.add(cursor.m_7949_());
                }
            }
        }
        if (candidates.isEmpty()) {
            return;
        }
        Random rng = new Random(sp.m_217043_().m_188505_());
        Collections.shuffle(candidates, rng);
        BlockPos doorPos = (BlockPos)candidates.get(0);
        BlockState state = level.m_8055_(doorPos);
        level.m_7731_(doorPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true)), 2);
        ResourceLocation resourceLocation = snd = state.m_60734_() == Blocks.f_50166_ ? ResourceLocation.m_135820_((String)"minecraft:block.iron_door.open") : ResourceLocation.m_135820_((String)"minecraft:block.wooden_door.open");
        if (snd != null) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(snd, (double)doorPos.m_123341_() + 0.5, (double)doorPos.m_123342_() + 0.5, (double)doorPos.m_123343_() + 0.5, 1.0f, 1.0f, SoundSource.BLOCKS));
        }
    }

    @SubscribeEvent
    public static void onRightClickSignReawake(PlayerInteractEvent.RightClickBlock e) {
        boolean isSign;
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        Level lvl = e.getLevel();
        BlockPos pos = e.getPos();
        BlockState state = lvl.m_8055_(pos);
        Block blk = state.m_60734_();
        boolean bl = isSign = blk instanceof SignBlock || blk instanceof WallSignBlock;
        if (!isSign) {
            return;
        }
        if (!PlayerFlags.isEscaped(sp)) {
            return;
        }
        if (PlayerFlags.isReawakened(sp)) {
            return;
        }
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)lvl;
        BlockEntity be = sl.m_7702_(pos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        try {
            StringBuilder raw = new StringBuilder();
            SignText front = sign.m_277142_();
            for (int i = 0; i < 4; ++i) {
                String line = front.m_277138_(i, false).getString();
                if (line.isEmpty()) continue;
                if (raw.length() > 0) {
                    raw.append(' ');
                }
                raw.append(line);
            }
            SignText back = sign.m_277159_();
            for (int i = 0; i < 4; ++i) {
                String line = back.m_277138_(i, false).getString();
                if (line.isEmpty()) continue;
                if (raw.length() > 0) {
                    raw.append(' ');
                }
                raw.append(line);
            }
            String sanitized = raw.toString().replaceAll("[\\u200B\\u200C\\u200D\\u2060]", "");
            String collapsed = sanitized.replaceAll("[\\p{Z}\\s]+", " ").trim();
            String compact = sanitized.replaceAll("[\\p{Z}\\s]+", "");
            if (!collapsed.isEmpty() && REAWAKE_CMD_VANILLA.matcher(collapsed).matches() || REAWAKE_CMD_COMPAT.matcher(compact).matches()) {
                PlayerFlags.setReawakened(sp, true);
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(40, 0.8f));
                ResourceLocation sSucc = new ResourceLocation("theforgotten", "success");
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(sSucc, sp.m_20185_(), sp.m_20186_() + (double)sp.m_20192_(), sp.m_20189_(), 1.0f, 1.0f, SoundSource.MASTER));
                String[] cryptic = new String[]{"session: resumed", "he remembers", "link: restored", "we hear you again", "welcome back", "count again"};
                String msg = cryptic[sp.m_217043_().m_188503_(cryptic.length)];
                sp.m_213846_((Component)Component.m_237110_((String)"chat.type.text", (Object[])new Object[]{Component.m_237113_((String)"???"), Component.m_237113_((String)msg)}));
                try {
                    SignText f = sign.m_277142_();
                    f = f.m_276913_(0, (Component)Component.m_237113_((String)"\u0000e\u0000e\u0000e").m_130940_(ChatFormatting.OBFUSCATED));
                    sign.m_276956_(f, true);
                    sign.m_6596_();
                    sl.m_7260_(pos, state, state, 3);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        CompoundTag tag = sp.getPersistentData();
        String key = "theforgotten_greeted";
        if (!tag.m_128471_(key)) {
            tag.m_128379_(key, true);
            GREET_STEP.put(sp.m_20148_(), 0);
            GREET_NEXT_TICK.put(sp.m_20148_(), (long)sp.f_8924_.m_129921_() + 40L);
        }
    }

    @SubscribeEvent
    public static void onLureDeath(LivingDeathEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)livingEntity;
        ServerLevel lvl = sp.m_284548_();
        if (!lvl.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            return;
        }
        if (LURE_HUM_ACTIVE.remove(sp.m_20148_())) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CStopLoopSoundPacket("lure_bg"));
        }
        try {
            BlockEntity be;
            BlockPos at = sp.m_20183_();
            lvl.m_46745_(at);
            if (lvl.m_8055_(at).m_60795_()) {
                lvl.m_7731_(at, Blocks.f_50087_.m_49966_(), 3);
            }
            if ((be = lvl.m_7702_(at)) instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)be;
                for (int i = 0; i < sp.m_150109_().f_35974_.size() && i < chest.m_6643_(); ++i) {
                    ItemStack stack = (ItemStack)sp.m_150109_().f_35974_.get(i);
                    if (stack.m_41619_()) continue;
                    chest.m_6836_(i, stack.m_41777_());
                    sp.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
                }
                int idx = sp.m_150109_().f_35974_.size();
                for (ItemStack st : sp.m_150109_().f_35975_) {
                    if (idx >= chest.m_6643_()) continue;
                    chest.m_6836_(idx++, st.m_41777_());
                }
                for (ItemStack st : sp.m_150109_().f_35976_) {
                    if (idx >= chest.m_6643_()) continue;
                    chest.m_6836_(idx++, st.m_41777_());
                }
                chest.m_6596_();
                lvl.m_7260_(at, lvl.m_8055_(at), lvl.m_8055_(at), 3);
            }
        }
        catch (Throwable at) {
            // empty catch block
        }
        PlayerFlags.setTrapRespawn(sp, true);
        long now = sp.f_8924_.m_129921_();
        PlayerFlags.setLureMark(sp, now + 12000L);
        PlayerFlags.decrementTrialProgress(sp, 1);
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        LURE_HUM_ACTIVE.remove(sp.m_20148_());
        if (PlayerFlags.shouldTrapRespawn(sp)) {
            PlayerFlags.setTrapRespawn(sp, false);
            if (Managers.LUREDIM != null) {
                Managers.LUREDIM.teleportToSpawnRoom(sp.f_8924_, sp);
                sp.m_213846_((Component)Component.m_237113_((String)"You awaken where the whispers are loudest."));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone e) {
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer spNew = (ServerPlayer)player;
        Player player2 = e.getOriginal();
        if (!(player2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer spOld = (ServerPlayer)player2;
        CompoundTag src = spOld.getPersistentData();
        CompoundTag dst = spNew.getPersistentData();
        try {
            if (src.m_128441_("theforgotten_escaped")) {
                dst.m_128379_("theforgotten_escaped", src.m_128471_("theforgotten_escaped"));
            }
            if (src.m_128441_("theforgotten_reawakened")) {
                dst.m_128379_("theforgotten_reawakened", src.m_128471_("theforgotten_reawakened"));
            }
            if (src.m_128441_("theforgotten_trial")) {
                dst.m_128365_("theforgotten_trial", (Tag)src.m_128469_("theforgotten_trial").m_6426_());
            }
            if (src.m_128441_("theforgotten_lure")) {
                dst.m_128365_("theforgotten_lure", (Tag)src.m_128469_("theforgotten_lure").m_6426_());
            }
            if (src.m_128441_("theforgotten_consent")) {
                dst.m_128365_("theforgotten_consent", (Tag)src.m_128469_("theforgotten_consent").m_6426_());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void doPoltergeistEffects(ServerLevel level, ServerPlayer sp, long time) {
        BlockState s;
        BlockPos p;
        int i;
        int radius;
        if (sp.m_7500_() || sp.m_5833_()) {
            return;
        }
        RandomSource r = sp.m_217043_();
        BlockPos base = sp.m_20183_();
        boolean inLure = level.m_46472_().equals(LureDimensionManager.LURE_DIM);
        if (r.m_188500_() < 5.0E-4) {
            radius = 10;
            for (i = 0; i < 18; ++i) {
                p = base.m_7918_(r.m_188503_(radius * 2 + 1) - radius, r.m_188503_(3) - 1, r.m_188503_(radius * 2 + 1) - radius);
                s = level.m_8055_(p);
                Block b = s.m_60734_();
                if (!(b instanceof TorchBlock) && !(b instanceof WallTorchBlock) && !(b instanceof RedstoneTorchBlock) && !(b instanceof RedstoneWallTorchBlock)) continue;
                level.m_46961_(p, false);
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(new ResourceLocation("minecraft", "block.fire.extinguish"), (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.7, (double)p.m_123343_() + 0.5, 0.7f, 1.0f, SoundSource.BLOCKS));
                break;
            }
        }
        if (r.m_188500_() < 6.0E-4) {
            radius = 8;
            for (i = 0; i < 16; ++i) {
                p = base.m_7918_(r.m_188503_(radius * 2 + 1) - radius, 0, r.m_188503_(radius * 2 + 1) - radius);
                s = level.m_8055_(p);
                if (!(s.m_60734_() instanceof DoorBlock) || !s.m_61138_((Property)BlockStateProperties.f_61446_) || ((Boolean)s.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) continue;
                level.m_7731_(p, (BlockState)s.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true)), 2);
                ResourceLocation snd = s.m_60734_() == Blocks.f_50166_ ? new ResourceLocation("minecraft", "block.iron_door.open") : new ResourceLocation("minecraft", "block.wooden_door.open");
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(snd, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 1.0f, 1.0f, SoundSource.BLOCKS));
                break;
            }
        }
        if (!inLure && r.m_188500_() < 2.0E-4) {
            radius = 14;
            for (i = 0; i < 24; ++i) {
                p = base.m_7918_(r.m_188503_(radius * 2 + 1) - radius, 0, r.m_188503_(radius * 2 + 1) - radius);
                s = level.m_8055_(p);
                if (!(s.m_60734_() instanceof BedBlock)) continue;
                Direction facing = (Direction)s.m_61143_((Property)BlockStateProperties.f_61374_);
                boolean head = s.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.HEAD;
                BlockPos other = head ? p.m_121945_(facing.m_122424_()) : p.m_121945_(facing);
                try {
                    for (ServerPlayer op : level.m_7654_().m_6846_().m_11314_()) {
                        BlockPos rp;
                        if (!op.m_9236_().m_46472_().equals((Object)level.m_46472_()) || (rp = op.m_8961_()) == null || !rp.equals((Object)p) && !rp.equals((Object)other)) continue;
                        p = null;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (p == null) continue;
                level.m_46961_(p, false);
                level.m_46961_(other, false);
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(new ResourceLocation("minecraft", "block.wood.break"), (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 1.0f, 1.0f, SoundSource.BLOCKS));
                break;
            }
        }
        if (!inLure && r.m_188500_() < 3.0E-4) {
            radius = 16;
            for (i = 0; i < 20; ++i) {
                p = base.m_7918_(r.m_188503_(radius * 2 + 1) - radius, r.m_188503_(3) - 1, r.m_188503_(radius * 2 + 1) - radius);
                s = level.m_8055_(p);
                Block blk = s.m_60734_();
                if (!(blk instanceof GlassBlock) && !s.m_60713_(Blocks.f_50185_) && !(blk instanceof StainedGlassBlock) && !(blk instanceof StainedGlassPaneBlock)) continue;
                level.m_46961_(p, false);
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(new ResourceLocation("minecraft", "block.glass.break"), (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 1.0f, 1.0f, SoundSource.BLOCKS));
                break;
            }
        }
    }

    public static void debugOpenLan(MinecraftServer server) {
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2COpenToLanPacket());
        }
        LAN_EVENT_TRIGGERED = true;
    }

    public static void debugFakeJoinSoon(MinecraftServer server) {
        FAKE_JOIN_TICK = (long)server.m_129921_() + 100L;
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock e) {
        AttachFace face;
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        Level lvl = e.getLevel();
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)lvl;
        if (!sl.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            return;
        }
        if (!((Boolean)Config.TRIAL_ENABLED.get()).booleanValue()) {
            return;
        }
        BlockPos pos = e.getPos();
        BlockState state = sl.m_8055_(pos);
        if (!(state.m_60734_() instanceof ButtonBlock)) {
            return;
        }
        AttachFace attachFace = face = state.m_61138_((Property)BlockStateProperties.f_61376_) ? (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_) : AttachFace.WALL;
        if (face != AttachFace.FLOOR) {
            return;
        }
        BlockPos base = pos.m_7495_();
        if (!sl.m_8055_(base).m_60713_(Blocks.f_50734_)) {
            return;
        }
        e.setCanceled(true);
        e.setCancellationResult(InteractionResult.SUCCESS);
        long id = base.m_121878_();
        boolean fresh = PlayerFlags.markTrialButton(sp, id);
        int have = PlayerFlags.getTrialPressedCount(sp);
        int need = (Integer)Config.TRIAL_REQUIRED_BUTTONS.get();
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(6, 1.0f));
        ResourceLocation sSucc = new ResourceLocation("theforgotten", "success");
        ResourceLocation sFail = new ResourceLocation("theforgotten", "fail");
        if (fresh) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(sSucc, sp.m_20185_(), sp.m_20186_() + (double)sp.m_20192_(), sp.m_20189_(), 1.0f, 1.0f, SoundSource.MASTER));
            if (have >= need) {
                sp.m_213846_((Component)Component.m_237113_((String)("analysis: COMPLETE (" + have + "/" + need + ")")));
            } else {
                sp.m_213846_((Component)Component.m_237113_((String)("scan: ACCEPTED (" + have + "/" + need + ")")));
            }
        } else {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(sFail, sp.m_20185_(), sp.m_20186_() + (double)sp.m_20192_(), sp.m_20189_(), 1.0f, 1.0f, SoundSource.MASTER));
            sp.m_213846_((Component)Component.m_237113_((String)("scan: DUPLICATE (" + have + "/" + need + ")")));
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent e) {
        if (MICRO != null) {
            MICRO.shutdown(e.getServer());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        Player player;
        if (TENSION != null) {
            TENSION.onPlayerLogout(e.getEntity().m_20148_());
        }
        if (APPARITIONS != null && (player = e.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            APPARITIONS.clearFor(sp);
        }
        if (e.getEntity() != null) {
            CONSENT_ACTIVE.remove(e.getEntity().m_20148_());
        }
        if (e.getEntity() != null) {
            CONSENT_STEP.remove(e.getEntity().m_20148_());
            CONSENT_NEXT_TICK.remove(e.getEntity().m_20148_());
            LURE_HUM_ACTIVE.remove(e.getEntity().m_20148_());
            CREEPY_NEXT_TICK.remove(e.getEntity().m_20148_());
            GREET_STEP.remove(e.getEntity().m_20148_());
            GREET_NEXT_TICK.remove(e.getEntity().m_20148_());
            HUNT_EVENT_STEP.remove(e.getEntity().m_20148_());
            HUNT_EVENT_NEXT_TICK.remove(e.getEntity().m_20148_());
            HUNT_EVENT_COOLDOWN.remove(e.getEntity().m_20148_());
        }
        if (Managers.TORMENTOR != null && (player = e.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp2 = (ServerPlayer)player;
            Managers.TORMENTOR.clearFor(sp2);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        int port;
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = e.getServer();
        long time = server.m_129921_();
        boolean silenceActive = false;
        if (server != null && ((Boolean)Config.ENABLE_WORLD_SILENCE.get()).booleanValue()) {
            WorldSilenceData d = WorldSilenceData.get(server);
            boolean bl = silenceActive = d != null && d.isSilenceActive(server);
        }
        if (silenceActive) {
            WAS_SILENT = true;
            SILENCE_RAMP_START_TICK = null;
            SILENCE_RAMP_UNTIL_TICK = null;
        } else if (WAS_SILENT) {
            WAS_SILENT = false;
            int rampSec = (Integer)Config.SILENCE_RAMP_SECONDS.get();
            if (rampSec > 0) {
                SILENCE_RAMP_START_TICK = time;
                SILENCE_RAMP_UNTIL_TICK = time + (long)rampSec * 20L;
            }
        }
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            ServerEvents.tickHuntEvent(sp);
            Integer step = GREET_STEP.get(sp.m_20148_());
            Long due = GREET_NEXT_TICK.get(sp.m_20148_());
            if (step == null || due == null || time < due) continue;
            if (step == 0) {
                MutableComponent line = Component.m_237110_((String)"chat.type.text", (Object[])new Object[]{Component.m_237113_((String)"Tasuposed"), Component.m_237113_((String)"Hey! If the pacing ever feels off, you can tune it in the config to your liking.")});
                sp.m_213846_((Component)line);
                GREET_STEP.put(sp.m_20148_(), 1);
                GREET_NEXT_TICK.put(sp.m_20148_(), time + 60L);
                continue;
            }
            MutableComponent line2 = Component.m_237110_((String)"chat.type.text", (Object[])new Object[]{Component.m_237113_((String)"Tasuposed"), Component.m_237113_((String)"Check TheForgotten server config for silence, apparitions, anomalies, and creepy chat. Have fun!")});
            sp.m_213846_((Component)line2);
            GREET_STEP.remove(sp.m_20148_());
            GREET_NEXT_TICK.remove(sp.m_20148_());
        }
        if (silenceActive) {
            FRIGHT_ARMED_AT.clear();
            ARMED_BED_POS.clear();
            return;
        }
        double rampScale = 1.0;
        if (SILENCE_RAMP_START_TICK != null && SILENCE_RAMP_UNTIL_TICK != null && time < SILENCE_RAMP_UNTIL_TICK) {
            long total = Math.max(1L, SILENCE_RAMP_UNTIL_TICK - SILENCE_RAMP_START_TICK);
            long elapsed = Math.max(0L, time - SILENCE_RAMP_START_TICK);
            double start = SILENCE_RAMP_START_OVERRIDE != null ? Math.max(0.0, Math.min(1.0, SILENCE_RAMP_START_OVERRIDE)) : (Double)Config.SILENCE_RAMP_START_SCALE.get();
            start = Math.max(0.0, Math.min(1.0, start));
            double t = Math.max(0.0, Math.min(1.0, (double)elapsed / (double)total));
            rampScale = start + (1.0 - start) * t;
        } else {
            RuntimeTuning.setAmbientChance(null);
            RuntimeTuning.setApparitionChance(null);
        }
        if (rampScale < 0.9999) {
            double amb = (Double)Config.AMBIENT_ROLL_CHANCE.get() * rampScale;
            double app = (Double)Config.APPARITION_ROLL_CHANCE.get() * rampScale;
            RuntimeTuning.setAmbientChance(amb);
            RuntimeTuning.setApparitionChance(app);
        }
        if (!LAN_EVENT_TRIGGERED) {
            if (LAN_EVENT_AT_TICK == null) {
                int delayTicks = 20 * (120 + ThreadLocalRandom.current().nextInt(180));
                LAN_EVENT_AT_TICK = time + (long)delayTicks;
            } else if (time >= LAN_EVENT_AT_TICK) {
                for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2COpenToLanPacket());
                }
                LAN_EVENT_TRIGGERED = true;
                FAKE_JOIN_TICK = time + 200L;
            }
        }
        if (LAN_EVENT_TRIGGERED && !LAN_MESSAGE_SENT && (port = server.m_7010_()) > 0) {
            for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                String p = String.valueOf(port);
                MutableComponent msg = Component.m_237113_((String)"Local game hosted on port ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.GREEN));
                Random rnd = new Random((long)port * 1315423911L);
                for (int i = 0; i < p.length(); ++i) {
                    char ch = p.charAt(i);
                    boolean corrupt = rnd.nextFloat() < 0.45f;
                    msg = corrupt ? msg.m_7220_((Component)Component.m_237113_((String)String.valueOf(ch)).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.OBFUSCATED})) : msg.m_7220_((Component)Component.m_237113_((String)String.valueOf(ch)).m_130940_(ChatFormatting.GREEN));
                }
                msg = msg.m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.GREEN));
                sp.m_213846_((Component)msg);
            }
            LAN_MESSAGE_SENT = true;
        }
        if (FAKE_JOIN_TICK != null && time >= FAKE_JOIN_TICK) {
            Object msg;
            List all = server.m_6846_().m_11314_();
            if (!all.isEmpty() && ThreadLocalRandom.current().nextDouble() < 0.6) {
                ServerPlayer pick = (ServerPlayer)all.get(ThreadLocalRandom.current().nextInt(all.size()));
                Object name = pick.m_36316_().getName();
                if (((String)name).length() > 1 && ThreadLocalRandom.current().nextDouble() < 0.3) {
                    int idx = 1 + ThreadLocalRandom.current().nextInt(((String)name).length() - 1);
                    name = ((String)name).substring(0, idx) + "\u200b" + ((String)name).substring(idx);
                } else {
                    name = (String)name + "\u200b";
                }
                msg = (String)name + " joined the game";
                try {
                    if (FAKE_TAB_UUID == null) {
                        UUID id;
                        FAKE_TAB_UUID = id = UUID.randomUUID();
                        FAKE_TAB_REMOVE_TICK = time + 20L * (long)(8 + ThreadLocalRandom.current().nextInt(12));
                        FAKE_TAB_NAME = name;
                    }
                }
                catch (Throwable id) {}
            } else {
                String name = "guest\u200b";
                msg = (String)name + " joined the game";
                try {
                    if (FAKE_TAB_UUID == null) {
                        UUID id;
                        FAKE_TAB_UUID = id = UUID.randomUUID();
                        FAKE_TAB_REMOVE_TICK = time + 20L * (long)(8 + ThreadLocalRandom.current().nextInt(12));
                        FAKE_TAB_NAME = name;
                    }
                }
                catch (Throwable id) {
                    // empty catch block
                }
            }
            for (ServerPlayer sp : all) {
                sp.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.YELLOW));
            }
            FAKE_JOIN_TICK = null;
        }
        if (FAKE_TAB_UUID != null && FAKE_TAB_REMOVE_TICK != null && time >= FAKE_TAB_REMOVE_TICK) {
            try {
                if (ThreadLocalRandom.current().nextDouble() < 0.6) {
                    Object leaveMsg = FAKE_TAB_NAME != null ? FAKE_TAB_NAME + " left the game" : "left the game";
                    for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                        sp.m_213846_((Component)Component.m_237113_((String)leaveMsg).m_130940_(ChatFormatting.YELLOW));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            FAKE_TAB_UUID = null;
            FAKE_TAB_NAME = null;
            FAKE_TAB_REMOVE_TICK = null;
        }
        if (TENSION == null) {
            return;
        }
        TENSION.tick(server, time);
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            Long due;
            ServerEvents.processSleepFright(sp, time);
            TensionManager.TensionState st = TENSION.state((Player)sp);
            boolean rolledThisTick = false;
            if (time >= st.nextRollTick) {
                AMBIENT.maybePlayFor(sp);
                APPARITIONS.maybeSpawnFor(sp, time);
                if (Managers.TORMENTOR != null) {
                    Managers.TORMENTOR.maybeSpawnFor(sp, time);
                }
                TENSION.scheduleNextRoll(sp, time);
                rolledThisTick = true;
            }
            if (TENSION.eligibleForStructure(sp, time)) {
                boolean allow = true;
                if (rampScale < 0.9999 && sp.m_217043_().m_188500_() > rampScale) {
                    allow = false;
                }
                if (allow && MICRO.trySpawnNear(sp, time)) {
                    TENSION.markStructureCooldown(sp, time);
                }
            }
            ServerEvents.maybeScheduleHunt(sp, time, rolledThisTick);
            ServerEvents.doPoltergeistEffects(sp.m_284548_(), sp, time);
            if (Managers.TORMENTOR != null) {
                Managers.TORMENTOR.tickFor(sp, time);
            }
            if ((due = CREEPY_NEXT_TICK.get(sp.m_20148_())) != null && time < due) continue;
            int secs = 180 + sp.m_217043_().m_188503_(300);
            CREEPY_NEXT_TICK.put(sp.m_20148_(), time + (long)secs * 20L);
            if (!(sp.m_217043_().m_188500_() < 0.18)) continue;
            String name = sp.m_36316_().getName();
            String[] lines = new String[]{name + ", you left the door", "keep typing, " + name, name + ", don't turn", "we can hear you breathe, " + name, name + ", answer me", "the bed is wrong, " + name, "stop running, " + name, name + ", basement", name + ", stop looking", "not here, " + name, name + ", it followed you", "listen to the walls, " + name, name + ", close the trapdoor", "we kept your things, " + name, name + ", turn the light off", "back to the staircase, " + name, name + ", the water moved", "behind the furnace, " + name, name + ", don\u2019t read this", "you forgot something, " + name, name + ", keep your voice down", "it knows your steps, " + name, name + ", count to seven", "stay in the corner, " + name, name + ", the door is open"};
            String msg = lines[sp.m_217043_().m_188503_(lines.length)];
            Object sender = "???";
            if (sp.m_217043_().m_188500_() < 0.6) {
                List players = server.m_6846_().m_11314_();
                int tries = 3;
                while (tries-- > 0 && !players.isEmpty()) {
                    ServerPlayer pick = (ServerPlayer)players.get(sp.m_217043_().m_188503_(players.size()));
                    if (pick == null || pick == sp) continue;
                    sender = pick.m_36316_().getName();
                    break;
                }
            }
            if ("???".equals(sender) && sp.m_217043_().m_188500_() < 0.35) {
                sender = name + "\u200b";
            }
            if ("???".equals(sender) && sp.m_217043_().m_188500_() < 0.5) {
                sender = "guest";
            }
            sp.m_213846_((Component)Component.m_237110_((String)"chat.type.text", (Object[])new Object[]{Component.m_237113_((String)sender), Component.m_237113_((String)msg)}));
        }
        AMBIENT.tick(server, time);
        APPARITIONS.tick(server, time);
        MICRO.tick(server, time);
        if (LUREDIM != null) {
            LUREDIM.tick(server);
        }
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            boolean inLure = sp.m_9236_().m_46472_().equals(LureDimensionManager.LURE_DIM);
            boolean active = LURE_HUM_ACTIVE.contains(sp.m_20148_());
            if (inLure && !active) {
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CStartLoopSoundPacket("lure_bg", new ResourceLocation("theforgotten", "lure.hum"), SoundSource.AMBIENT, true, 0.0, 0.0, 0.0, 0.5f, 1.0f));
                LURE_HUM_ACTIVE.add(sp.m_20148_());
                continue;
            }
            if (inLure || !active) continue;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CStopLoopSoundPacket("lure_bg"));
            LURE_HUM_ACTIVE.remove(sp.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent e) {
        DebugCommands.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent e) {
        Pools.registerReloaders(e);
    }

    public static void startLureHum(ServerPlayer sp) {
        try {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CStartLoopSoundPacket("lure_bg", new ResourceLocation("theforgotten", "lure.hum"), SoundSource.AMBIENT, true, 0.0, 0.0, 0.0, 0.5f, 1.0f));
            LURE_HUM_ACTIVE.add(sp.m_20148_());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isRampActive(long nowTick) {
        return SILENCE_RAMP_START_TICK != null && SILENCE_RAMP_UNTIL_TICK != null && nowTick < SILENCE_RAMP_UNTIL_TICK;
    }

    public static long getRampStartTick() {
        return SILENCE_RAMP_START_TICK != null ? SILENCE_RAMP_START_TICK : 0L;
    }

    public static long getRampUntilTick() {
        return SILENCE_RAMP_UNTIL_TICK != null ? SILENCE_RAMP_UNTIL_TICK : 0L;
    }

    public static Double getRampStartScaleOverride() {
        return SILENCE_RAMP_START_OVERRIDE;
    }

    public static double getCurrentRampScale(long nowTick) {
        double rampScale = 1.0;
        if (SILENCE_RAMP_START_TICK != null && SILENCE_RAMP_UNTIL_TICK != null && nowTick < SILENCE_RAMP_UNTIL_TICK) {
            long total = Math.max(1L, SILENCE_RAMP_UNTIL_TICK - SILENCE_RAMP_START_TICK);
            long elapsed = Math.max(0L, nowTick - SILENCE_RAMP_START_TICK);
            double start = SILENCE_RAMP_START_OVERRIDE != null ? Math.max(0.0, Math.min(1.0, SILENCE_RAMP_START_OVERRIDE)) : (Double)Config.SILENCE_RAMP_START_SCALE.get();
            start = Math.max(0.0, Math.min(1.0, start));
            double t = Math.max(0.0, Math.min(1.0, (double)elapsed / (double)total));
            rampScale = start + (1.0 - start) * t;
        }
        return rampScale;
    }

    public static void forceStartRamp(MinecraftServer server, int seconds, Double startScaleOrNull) {
        long time = server.m_129921_();
        SILENCE_RAMP_START_TICK = time;
        SILENCE_RAMP_UNTIL_TICK = time + (long)Math.max(0, seconds) * 20L;
        SILENCE_RAMP_START_OVERRIDE = startScaleOrNull;
    }

    public static void forceEndRamp() {
        SILENCE_RAMP_START_TICK = null;
        SILENCE_RAMP_UNTIL_TICK = null;
        SILENCE_RAMP_START_OVERRIDE = null;
        RuntimeTuning.setAmbientChance(null);
        RuntimeTuning.setApparitionChance(null);
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed e) {
        float mul;
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (sp.m_7500_() || sp.m_5833_()) {
            return;
        }
        float speed = e.getNewSpeed();
        if (speed <= 0.0f) {
            return;
        }
        boolean inLure = sp.m_9236_().m_46472_().equals(LureDimensionManager.LURE_DIM);
        boolean marked = PlayerFlags.hasLureMark(sp, sp.f_8924_.m_129921_());
        float f = mul = inLure ? 0.35f : 0.7f;
        if (!inLure && marked) {
            mul *= 0.85f;
        }
        e.setNewSpeed(Math.max(0.001f, speed * mul));
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload e) {
        if (MICRO == null) {
            return;
        }
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)levelAccessor;
        ChunkAccess chunkAccess = e.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk lc = (LevelChunk)chunkAccess;
            MICRO.onChunkUnload(sl, lc);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load e) {
        if (LUREDIM == null) {
            return;
        }
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)levelAccessor;
        ChunkAccess chunkAccess = e.getChunk();
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        LevelChunk lc = (LevelChunk)chunkAccess;
        LUREDIM.onChunkLoad(sl, lc);
    }

    @SubscribeEvent
    public static void onMobSpawnCheck(MobSpawnEvent.PositionCheck e) {
        ServerLevelAccessor serverLevelAccessor = e.getLevel();
        if (!(serverLevelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)serverLevelAccessor;
        if (sl.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onMobFinalize(MobSpawnEvent.FinalizeSpawn e) {
        ServerLevelAccessor serverLevelAccessor = e.getLevel();
        if (!(serverLevelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)serverLevelAccessor;
        if (sl.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            e.setCanceled(true);
        }
    }

    private static void buildConsentRoom(ServerLevel level, BlockPos center) {
        int radius = 2;
        int floorY = center.m_123342_();
        int ceilingY = center.m_123342_() + 3;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int x = center.m_123341_() + dx;
                int z = center.m_123343_() + dz;
                level.m_7731_(new BlockPos(x, floorY - 1, z), Blocks.f_152550_.m_49966_(), 2);
                boolean wall = Math.abs(dx) == radius || Math.abs(dz) == radius;
                for (int y = floorY; y <= ceilingY; ++y) {
                    BlockPos p = new BlockPos(x, y, z);
                    if (wall) {
                        level.m_7731_(p, Blocks.f_50652_.m_49966_(), 2);
                        continue;
                    }
                    level.m_7731_(p, Blocks.f_50016_.m_49966_(), 2);
                }
                level.m_7731_(new BlockPos(x, ceilingY + 1, z), Blocks.f_50652_.m_49966_(), 2);
            }
        }
    }

    public static void finishConsent(ServerPlayer sp, boolean accepted) {
        CONSENT_ACTIVE.remove(sp.m_20148_());
        try {
            sp.m_21195_(MobEffects.f_19610_);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sp.m_20331_(false);
        try {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CStopLoopSoundPacket("consent_bg"));
            if (accepted) {
                PlayerFlags.setConsentAccepted(sp, true);
                MinecraftServer server = sp.f_8924_;
                ServerLevel dst = server != null && server.m_129783_() != null ? server.m_129783_() : sp.m_284548_();
                BlockPos spawn = dst.m_220360_();
                float angle = dst.m_220361_();
                sp.m_8999_(dst, (double)spawn.m_123341_() + 0.5, (double)(spawn.m_123342_() + 1), (double)spawn.m_123343_() + 0.5, angle, 0.0f);
                for (int i = 0; i < 50; ++i) {
                    try {
                        sp.m_213846_((Component)Component.m_237113_((String)" "));
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                sp.m_213846_((Component)Component.m_237113_((String)"You chose to proceed. Good luck."));
            } else {
                PlayerFlags.setConsentDenied(sp, true);
                MinecraftServer server = sp.f_8924_;
                if (server != null) {
                    for (ServerPlayer other : server.m_6846_().m_11314_()) {
                        other.f_8906_.m_9942_((Component)Component.m_237113_((String)"Instance sabotaged by user decline."));
                    }
                    Path worldRoot = server.m_129843_(LevelResource.f_78182_);
                    new Thread(() -> {
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            if (worldRoot != null && Files.exists(worldRoot, new LinkOption[0])) {
                                Files.walkFileTree(worldRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                    @Override
                                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                        try {
                                            Files.deleteIfExists(file);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        return FileVisitResult.CONTINUE;
                                    }

                                    @Override
                                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                        try {
                                            Files.deleteIfExists(dir);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        return FileVisitResult.CONTINUE;
                                    }
                                });
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }).start();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Component[] consentLines() {
        return new Component[]{Component.m_237113_((String)"WARNING").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), Component.m_237113_((String)"This experience contains disturbing content, sudden audio/visual effects, and psychological horror."), Component.m_237113_((String)"Avoid playing if you are sensitive to flashing lights, intense audio, or anxiety-inducing scenarios."), Component.m_237113_((String)"Some events may be irreversible within your world.").m_130940_(ChatFormatting.DARK_RED), Component.m_237113_((String)"By continuing, you acknowledge and accept full responsibility for your experience.").m_130940_(ChatFormatting.YELLOW)};
    }

    private static void tickHuntEvent(ServerPlayer sp) {
        long due;
        if (sp == null || sp.f_8924_ == null) {
            return;
        }
        UUID id = sp.m_20148_();
        Integer step = HUNT_EVENT_STEP.get(id);
        if (step == null) {
            return;
        }
        long now = sp.f_8924_.m_129921_();
        if (now < (due = HUNT_EVENT_NEXT_TICK.getOrDefault(id, now).longValue())) {
            return;
        }
        try {
            switch (step) {
                case 0: {
                    if (Managers.AMBIENT != null) {
                        Managers.AMBIENT.playFootstepsSequence(sp, 5, false);
                    }
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(8, 0.35f));
                    ServerEvents.advanceHuntStep(sp, 1, now + 40L);
                    break;
                }
                case 1: {
                    if (Managers.AMBIENT != null) {
                        Managers.AMBIENT.playBreathBehind(sp, 0.32f);
                    }
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(18, 0.65f));
                    ServerEvents.advanceHuntStep(sp, 2, now + 60L);
                    break;
                }
                case 2: {
                    if (Managers.AMBIENT != null) {
                        Managers.AMBIENT.playBlockBreakSequence(sp, 3);
                    }
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(26, 0.85f));
                    ServerEvents.advanceHuntStep(sp, 3, now + 40L);
                    break;
                }
                case 3: {
                    boolean spawned;
                    boolean bl = spawned = Managers.APPARITIONS != null && Managers.APPARITIONS.triggerAggressive(sp, now);
                    if (spawned) {
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(40, 1.0f));
                    } else {
                        if (Managers.AMBIENT != null) {
                            Managers.AMBIENT.playFootstepsSequence(sp, 4, true);
                        }
                        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(16, 0.5f));
                    }
                    HUNT_EVENT_COOLDOWN.put(id, now + 3600L);
                    ServerEvents.clearHuntEvent(sp);
                    break;
                }
                default: {
                    ServerEvents.clearHuntEvent(sp);
                    break;
                }
            }
        }
        catch (Throwable ignored) {
            ServerEvents.clearHuntEvent(sp);
        }
    }

    public static boolean triggerHuntEvent(ServerPlayer sp) {
        long nextAllowed;
        if (sp == null || sp.f_8924_ == null) {
            return false;
        }
        UUID id = sp.m_20148_();
        if (HUNT_EVENT_STEP.containsKey(id)) {
            return false;
        }
        long now = sp.f_8924_.m_129921_();
        if (now < (nextAllowed = HUNT_EVENT_COOLDOWN.getOrDefault(id, 0L).longValue())) {
            return false;
        }
        HUNT_EVENT_STEP.put(id, 0);
        HUNT_EVENT_NEXT_TICK.put(id, now);
        HUNT_EVENT_COOLDOWN.put(id, now + 3600L);
        return true;
    }

    public static boolean isHuntEventActive(ServerPlayer sp) {
        if (sp == null) {
            return false;
        }
        return HUNT_EVENT_STEP.containsKey(sp.m_20148_());
    }

    public static long huntEventCooldownRemaining(ServerPlayer sp) {
        if (sp == null || sp.f_8924_ == null) {
            return 0L;
        }
        long now = sp.f_8924_.m_129921_();
        long next = HUNT_EVENT_COOLDOWN.getOrDefault(sp.m_20148_(), 0L);
        return Math.max(0L, next - now);
    }

    private static void advanceHuntStep(ServerPlayer sp, int nextStep, long nextTick) {
        UUID id = sp.m_20148_();
        HUNT_EVENT_STEP.put(id, nextStep);
        HUNT_EVENT_NEXT_TICK.put(id, nextTick);
    }

    private static void clearHuntEvent(ServerPlayer sp) {
        UUID id = sp.m_20148_();
        HUNT_EVENT_STEP.remove(id);
        HUNT_EVENT_NEXT_TICK.remove(id);
    }

    private static void maybeScheduleHunt(ServerPlayer sp, long time, boolean rolledThisTick) {
        List others;
        if (sp == null || sp.f_8924_ == null) {
            return;
        }
        UUID id = sp.m_20148_();
        if (HUNT_EVENT_STEP.containsKey(id)) {
            return;
        }
        long nextAllowed = HUNT_EVENT_COOLDOWN.getOrDefault(id, 0L);
        if (time < nextAllowed) {
            return;
        }
        ServerLevel level = sp.m_284548_();
        if (level.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            return;
        }
        if (!((Boolean)Config.BEHIND_TURN_ENABLED.get()).booleanValue()) {
            return;
        }
        double chance = Math.max(0.0, Math.min(1.0, (Double)Config.BEHIND_TURN_CHANCE.get()));
        if (chance <= 0.0) {
            return;
        }
        if (!rolledThisTick) {
            return;
        }
        if (sp.m_217043_().m_188500_() >= chance) {
            return;
        }
        boolean underground = !level.m_46861_(sp.m_20183_());
        int light = level.m_46803_(sp.m_20183_());
        if (!underground && light > 9) {
            return;
        }
        int audienceRadius = Math.max(0, (Integer)Config.AUDIENCE_RADIUS.get());
        if (audienceRadius > 0 && !(others = level.m_6443_(ServerPlayer.class, sp.m_20191_().m_82400_((double)audienceRadius), p -> p != sp)).isEmpty()) {
            return;
        }
        ServerEvents.triggerHuntEvent(sp);
    }

    public static boolean forceEndHunt(ServerPlayer sp, boolean clearCooldown) {
        if (sp == null) {
            return false;
        }
        UUID id = sp.m_20148_();
        boolean wasActive = HUNT_EVENT_STEP.containsKey(id);
        ServerEvents.clearHuntEvent(sp);
        if (clearCooldown) {
            HUNT_EVENT_COOLDOWN.remove(id);
        }
        return wasActive;
    }

    public static Integer getHuntEventStep(ServerPlayer sp) {
        if (sp == null) {
            return null;
        }
        return HUNT_EVENT_STEP.get(sp.m_20148_());
    }

    public static long huntEventTimeUntilNext(ServerPlayer sp) {
        if (sp == null || sp.f_8924_ == null) {
            return 0L;
        }
        long now = sp.f_8924_.m_129921_();
        long next = HUNT_EVENT_NEXT_TICK.getOrDefault(sp.m_20148_(), now);
        return Math.max(0L, next - now);
    }

    static {
        CONSENT_ACTIVE = new HashSet<UUID>();
        CONSENT_STEP = new HashMap<UUID, Integer>();
        CONSENT_NEXT_TICK = new HashMap<UUID, Long>();
        LURE_HUM_ACTIVE = new HashSet<UUID>();
        LAN_EVENT_TRIGGERED = false;
        LAN_EVENT_AT_TICK = null;
        FAKE_JOIN_TICK = null;
        LAN_MESSAGE_SENT = false;
        FAKE_TAB_UUID = null;
        FAKE_TAB_NAME = null;
        FAKE_TAB_REMOVE_TICK = null;
        CREEPY_NEXT_TICK = new HashMap<UUID, Long>();
        GREET_STEP = new HashMap<UUID, Integer>();
        GREET_NEXT_TICK = new HashMap<UUID, Long>();
        HUNT_EVENT_STEP = new HashMap<UUID, Integer>();
        HUNT_EVENT_NEXT_TICK = new HashMap<UUID, Long>();
        HUNT_EVENT_COOLDOWN = new HashMap<UUID, Long>();
        LAST_SLEEP_FRIGHT = new HashMap<UUID, Long>();
        FRIGHT_ARMED_AT = new HashMap<UUID, Long>();
        FORCE_FRIGHT_NEXT_SLEEP = new HashSet<UUID>();
        WAS_SILENT = false;
        SILENCE_RAMP_START_TICK = null;
        SILENCE_RAMP_UNTIL_TICK = null;
        SILENCE_RAMP_START_OVERRIDE = null;
        REAWAKE_CMD_COMPAT = Pattern.compile("^/(tf|theforgotten):(reawake|reawaken|awake)$", 2);
        REAWAKE_CMD_VANILLA = Pattern.compile("^/(summon|function)\\s+(?:(?:minecraft:)?)(reawake|reawaken|awake)(?:\\s+.*)?$", 2);
        ARMED_BED_POS = new HashMap<UUID, BlockPos>();
    }
}

