/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.tasuposed.theforgotten.Config;
import net.tasuposed.theforgotten.server.RuntimeTuning;

public class TensionManager {
    private final Map<UUID, TensionState> players = new HashMap<UUID, TensionState>();

    public TensionState state(Player p) {
        return this.players.computeIfAbsent(p.m_20148_(), id -> new TensionState());
    }

    public void onPlayerLogout(UUID id) {
        this.players.remove(id);
    }

    public void tick(MinecraftServer server, long gameTime) {
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            this.updateForPlayer(sp, gameTime);
        }
    }

    private void updateForPlayer(ServerPlayer sp, long gameTime) {
        boolean safe;
        TensionState st = this.state((Player)sp);
        ServerLevel level = sp.m_284548_();
        Vec3 pos = sp.m_20182_();
        double dt = (double)Math.max(0L, gameTime - st.lastUpdateTick) / 20.0;
        st.lastUpdateTick = gameTime;
        double t = st.tension;
        t = Math.max(0.0, t - (Double)Config.TENSION_DECAY_PER_SEC.get() * dt);
        boolean nightOrStorm = level.m_46462_() || level.m_46470_();
        boolean undergroundOrDark = pos.f_82480_ < 32.0 || level.m_45517_(LightLayer.SKY, sp.m_20183_()) <= 4;
        boolean alone = this.isAlone(sp, (Integer)Config.AUDIENCE_RADIUS.get());
        boolean bl = safe = !nightOrStorm && !undergroundOrDark && !alone;
        if (undergroundOrDark) {
            double depthBoost = 1.0;
            if (pos.f_82480_ < 0.0) {
                depthBoost += Mth.m_14008_((double)(-pos.f_82480_ / 64.0), (double)0.0, (double)1.5);
            }
            t += (Double)Config.TENSION_INCREASE_UNDERGROUND.get() * depthBoost * dt;
        }
        if (alone) {
            t += (Double)Config.TENSION_INCREASE_SOLITUDE.get() * dt;
        }
        if (nightOrStorm || pos.f_82480_ < 32.0) {
            t += (Double)Config.TENSION_INCREASE_STORM_NIGHT.get() * dt;
        }
        if (safe) {
            t = Math.max(0.0, t - (Double)Config.TENSION_DECREASE_SAFE.get() * dt);
        }
        st.tension = t = Math.min(100.0, t);
        double min = (Double)Config.TENSION_MIN_FOR_STRUCTURE.get();
        if (t >= min) {
            if (st.aboveMinSinceTick < 0L) {
                st.aboveMinSinceTick = gameTime;
            }
        } else {
            st.aboveMinSinceTick = -1L;
        }
        if (st.nextRollTick == 0L) {
            this.scheduleNextRoll(sp, gameTime);
        }
    }

    public boolean eligibleForStructure(ServerPlayer sp, long gameTime) {
        TensionState st = this.state((Player)sp);
        if (st.tension < (Double)Config.TENSION_MIN_FOR_STRUCTURE.get()) {
            return false;
        }
        if (st.aboveMinSinceTick < 0L) {
            return false;
        }
        int sustain = (Integer)Config.TENSION_MIN_SUSTAIN_SECONDS.get();
        if (gameTime - st.aboveMinSinceTick < (long)sustain * 20L) {
            return false;
        }
        return gameTime >= st.nextStructureAllowedTick;
    }

    public void markStructureCooldown(ServerPlayer sp, long gameTime) {
        TensionState st = this.state((Player)sp);
        int min = RuntimeTuning.structureCooldownMinSec();
        int max = RuntimeTuning.structureCooldownMaxSec();
        int cd = min + sp.m_217043_().m_188503_(Math.max(1, max - min + 1));
        st.nextStructureAllowedTick = gameTime + (long)cd * 20L;
    }

    public void scheduleNextRoll(ServerPlayer sp, long gameTime) {
        TensionState st = this.state((Player)sp);
        int minS = RuntimeTuning.playerRollIntervalMinSec();
        int maxS = RuntimeTuning.playerRollIntervalMaxSec();
        int interval = minS + sp.m_217043_().m_188503_(Math.max(1, maxS - minS + 1));
        st.nextRollTick = gameTime + (long)interval * 20L;
    }

    private boolean isAlone(ServerPlayer sp, int radius) {
        for (ServerPlayer other : sp.f_8924_.m_6846_().m_11314_()) {
            if (other == sp || !other.m_9236_().m_46472_().m_135782_().equals((Object)sp.m_9236_().m_46472_().m_135782_()) || !(other.m_20280_((Entity)sp) <= (double)(radius * radius))) continue;
            return false;
        }
        return true;
    }

    public static class TensionState {
        public double tension;
        public long lastUpdateTick;
        public long aboveMinSinceTick = -1L;
        public long nextStructureAllowedTick = 0L;
        public long nextRollTick = 0L;
    }
}

