/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.tasuposed.theforgotten.network.NetworkHandler;
import net.tasuposed.theforgotten.network.S2CForceGlitchPacket;
import net.tasuposed.theforgotten.network.S2CPositionalSoundPacket;
import net.tasuposed.theforgotten.server.LureDimensionManager;
import net.tasuposed.theforgotten.server.PlayerFlags;

public class TormentorManager {
    private final Map<UUID, Tormentor> active = new HashMap<UUID, Tormentor>();
    private final Map<UUID, Long> cooldownUntil = new HashMap<UUID, Long>();

    public void clearFor(ServerPlayer sp) {
        this.active.remove(sp.m_20148_());
        this.cooldownUntil.remove(sp.m_20148_());
    }

    public void maybeSpawnFor(ServerPlayer sp, long now) {
        boolean underground;
        if (sp == null || sp.m_284548_() == null) {
            return;
        }
        if (sp.m_5833_() || sp.m_7500_()) {
            return;
        }
        ServerLevel level = sp.m_284548_();
        if (level.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            return;
        }
        boolean bl = underground = !level.m_46861_(sp.m_20183_());
        if (!underground) {
            return;
        }
        Long cd = this.cooldownUntil.get(sp.m_20148_());
        if (cd != null && now < cd) {
            return;
        }
        if (this.active.containsKey(sp.m_20148_())) {
            return;
        }
        double baseChance = 0.04;
        if (PlayerFlags.isReawakened(sp)) {
            baseChance = 0.08;
        }
        if (sp.m_217043_().m_188500_() >= baseChance) {
            return;
        }
        Vec3 look = sp.m_20154_().m_82541_();
        RandomSource r = sp.m_217043_();
        double angleDeg = (double)(r.m_188499_() ? 150 : -150) + r.m_188500_() * 30.0;
        double angleRad = Math.toRadians(angleDeg);
        Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
        Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
        double dist = 24.0 + r.m_188500_() * 14.0;
        Vec3 at = sp.m_20182_().m_82549_(dir.m_82490_(dist));
        BlockPos bp = BlockPos.m_274561_((double)at.f_82479_, (double)sp.m_20186_(), (double)at.f_82481_);
        level.m_46745_(bp);
        Vec3 pos = Vec3.m_82539_((Vec3i)bp);
        Tormentor t = new Tormentor();
        t.playerId = sp.m_20148_();
        t.pos = pos;
        t.breakSound = new ResourceLocation("minecraft", "block.stone.break");
        t.spawnTick = now;
        t.dim = level.m_46472_().m_135782_();
        t.lifetime = 20L * (long)(60 + r.m_188503_(61));
        t.nextDigTick = now + 10L;
        t.nextAmbientTick = now + 30L;
        this.active.put(sp.m_20148_(), t);
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(new ResourceLocation("minecraft", "entity.warden.nearby_close"), t.pos.f_82479_, t.pos.f_82480_, t.pos.f_82481_, 0.7f, 1.0f, SoundSource.AMBIENT));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(10, 0.8f));
        int minCd = 360;
        int jitter = 240;
        if (PlayerFlags.isReawakened(sp)) {
            minCd = 240;
            jitter = 240;
        }
        this.cooldownUntil.put(sp.m_20148_(), now + 20L * (long)(minCd + r.m_188503_(jitter)));
    }

    public void tickFor(ServerPlayer sp, long now) {
        Tormentor t = this.active.get(sp.m_20148_());
        if (t == null) {
            return;
        }
        ServerLevel level = sp.m_284548_();
        if (level == null) {
            this.active.remove(sp.m_20148_());
            return;
        }
        if (!level.m_46472_().m_135782_().equals((Object)t.dim) || now >= t.spawnTick + t.lifetime) {
            this.active.remove(sp.m_20148_());
            return;
        }
        if (level.m_46861_(sp.m_20183_())) {
            this.active.remove(sp.m_20148_());
            return;
        }
        Vec3 to = sp.m_20182_().m_82520_(0.0, 0.1, 0.0);
        Vec3 delta = to.m_82546_(t.pos);
        double d2 = delta.m_82556_();
        if (d2 < 2.5) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(35, 1.0f));
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(new ResourceLocation("minecraft", "entity.wither.ambient"), sp.m_20185_(), sp.m_20186_(), sp.m_20189_(), 0.9f, 0.6f, SoundSource.AMBIENT));
            this.active.remove(sp.m_20148_());
            return;
        }
        Vec3 stepDir = delta.m_82541_();
        double step = 0.06;
        Vec3 next = t.pos.m_82549_(stepDir.m_82490_(step));
        if (now >= t.nextDigTick) {
            t.nextDigTick = now + (long)(8 + sp.m_217043_().m_188503_(7));
            this.carveForward(level, t, stepDir, sp);
        }
        if (now >= t.nextAmbientTick) {
            t.nextAmbientTick = now + (long)(30 + sp.m_217043_().m_188503_(40));
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(new ResourceLocation("minecraft", "block.stone.hit"), t.pos.f_82479_, t.pos.f_82480_, t.pos.f_82481_, 0.6f, 0.9f + sp.m_217043_().m_188501_() * 0.2f, SoundSource.AMBIENT));
        }
        t.pos = next;
    }

    public void forceSpawnFor(ServerPlayer sp, long now) {
        if (sp == null || sp.m_284548_() == null) {
            return;
        }
        ServerLevel level = sp.m_284548_();
        if (level.m_46472_().equals(LureDimensionManager.LURE_DIM)) {
            return;
        }
        if (level.m_46861_(sp.m_20183_())) {
            return;
        }
        this.active.remove(sp.m_20148_());
        this.cooldownUntil.remove(sp.m_20148_());
        Vec3 look = sp.m_20154_().m_82541_();
        RandomSource r = sp.m_217043_();
        double angleDeg = (double)(r.m_188499_() ? 150 : -150) + r.m_188500_() * 30.0;
        double angleRad = Math.toRadians(angleDeg);
        Vec3 right = new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_();
        Vec3 dir = look.m_82490_(Math.cos(angleRad)).m_82549_(right.m_82490_(Math.sin(angleRad))).m_82541_();
        double dist = 10.0 + r.m_188500_() * 6.0;
        Vec3 at = sp.m_20182_().m_82549_(dir.m_82490_(dist));
        BlockPos bp = BlockPos.m_274561_((double)at.f_82479_, (double)sp.m_20186_(), (double)at.f_82481_);
        level.m_46745_(bp);
        Vec3 pos = Vec3.m_82539_((Vec3i)bp);
        Tormentor t = new Tormentor();
        t.playerId = sp.m_20148_();
        t.pos = pos;
        t.breakSound = new ResourceLocation("minecraft", "block.stone.break");
        t.spawnTick = now;
        t.dim = level.m_46472_().m_135782_();
        t.lifetime = 20L * (long)(40 + r.m_188503_(60));
        t.nextDigTick = now + 10L;
        t.nextAmbientTick = now + 30L;
        this.active.put(sp.m_20148_(), t);
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(new ResourceLocation("minecraft", "entity.warden.nearby_close"), t.pos.f_82479_, t.pos.f_82480_, t.pos.f_82481_, 0.7f, 1.0f, SoundSource.AMBIENT));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CForceGlitchPacket(10, 0.8f));
    }

    private void carveForward(ServerLevel level, Tormentor t, Vec3 dir, ServerPlayer sp) {
        Vec3 side;
        Vec3 ahead = t.pos.m_82549_(dir.m_82490_(0.9));
        int ax = Mth.m_14107_((double)ahead.f_82479_);
        int ay = Mth.m_14107_((double)ahead.f_82480_);
        int az = Mth.m_14107_((double)ahead.f_82481_);
        BlockPos[] targets = new BlockPos[]{new BlockPos(ax, ay, az), new BlockPos(ax, ay + 1, az)};
        boolean broke = false;
        for (BlockPos p : targets) {
            BlockState s = level.m_8055_(p);
            if (!this.isMinable(s)) continue;
            level.m_46961_(p, false);
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(t.breakSound, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 0.9f, 1.0f, SoundSource.BLOCKS));
            broke = true;
        }
        if (!broke && sp.m_217043_().m_188500_() < 0.25) {
            side = new Vec3(-dir.f_82481_, 0.0, dir.f_82479_).m_82541_();
            BlockPos sidePos = new BlockPos(Mth.m_14107_((double)(ahead.f_82479_ + side.f_82479_)), ay, Mth.m_14107_((double)(ahead.f_82481_ + side.f_82481_)));
            if (this.isMinable(level.m_8055_(sidePos))) {
                level.m_46961_(sidePos, false);
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(t.breakSound, (double)sidePos.m_123341_() + 0.5, (double)sidePos.m_123342_() + 0.5, (double)sidePos.m_123343_() + 0.5, 0.9f, 1.0f, SoundSource.BLOCKS));
            }
        }
        t.noBreakCount = !broke ? ++t.noBreakCount : 0;
        if (t.noBreakCount >= 30) {
            BlockPos[] heavy;
            side = new Vec3(-dir.f_82481_, 0.0, dir.f_82479_).m_82541_();
            BlockPos sideL = new BlockPos(Mth.m_14107_((double)(ahead.f_82479_ + side.f_82479_)), ay, Mth.m_14107_((double)(ahead.f_82481_ + side.f_82481_)));
            BlockPos sideR = new BlockPos(Mth.m_14107_((double)(ahead.f_82479_ - side.f_82479_)), ay, Mth.m_14107_((double)(ahead.f_82481_ - side.f_82481_)));
            BlockPos up = new BlockPos(ax, ay + 2, az);
            for (BlockPos p : heavy = new BlockPos[]{sideL, sideR, up}) {
                if (!this.isMinable(level.m_8055_(p))) continue;
                level.m_46961_(p, false);
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CPositionalSoundPacket(t.breakSound, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 0.9f, 1.0f, SoundSource.BLOCKS));
            }
            t.noBreakCount = 0;
        }
    }

    private boolean isMinable(BlockState s) {
        if (s.m_60795_()) {
            return false;
        }
        return s.m_60713_(Blocks.f_50069_) || s.m_60713_(Blocks.f_152550_) || s.m_60713_(Blocks.f_152496_) || s.m_60713_(Blocks.f_49994_) || s.m_60713_(Blocks.f_50334_) || s.m_60713_(Blocks.f_50228_) || s.m_60713_(Blocks.f_50122_) || s.m_60713_(Blocks.f_152497_) || s.m_60713_(Blocks.f_50493_) || s.m_60713_(Blocks.f_50546_) || s.m_60713_(Blocks.f_50352_) || s.m_60713_(Blocks.f_50137_) || s.m_60713_(Blocks.f_152597_) || s.m_60713_(Blocks.f_50134_);
    }

    private static class Tormentor {
        UUID playerId;
        Vec3 pos;
        ResourceLocation breakSound;
        long spawnTick;
        long nextDigTick;
        long nextAmbientTick;
        long lifetime;
        ResourceLocation dim;
        long nextHeartbeatTick;
        int noBreakCount;

        private Tormentor() {
        }
    }
}

