/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.tasuposed.theforgotten.Config;

public class WorldSilenceData
extends SavedData {
    private static final String KEY = "theforgotten_silence";
    private static final String NBT_UNTIL = "until";
    private long silenceUntil = 0L;

    public static WorldSilenceData load(CompoundTag tag) {
        WorldSilenceData d = new WorldSilenceData();
        d.silenceUntil = tag.m_128454_(NBT_UNTIL);
        return d;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128356_(NBT_UNTIL, this.silenceUntil);
        return tag;
    }

    public static WorldSilenceData get(MinecraftServer server) {
        ServerLevel ow = server.m_129880_(Level.f_46428_);
        if (ow == null) {
            return null;
        }
        return (WorldSilenceData)ow.m_8895_().m_164861_(WorldSilenceData::load, WorldSilenceData::new, KEY);
    }

    private void ensureInitialized(MinecraftServer server) {
        if (this.silenceUntil != 0L) {
            return;
        }
        ServerLevel ow = server.m_129880_(Level.f_46428_);
        if (ow == null) {
            return;
        }
        long now = ow.m_46467_();
        RandomSource r = ow.m_213780_();
        double pFull = (Double)Config.SILENCE_FULL_CHANCE.get();
        long full = ((Integer)Config.SILENCE_DURATION_FULL_TICKS.get()).intValue();
        long half = ((Integer)Config.SILENCE_DURATION_HALF_TICKS.get()).intValue();
        long duration = r.m_188500_() < pFull ? full : half;
        this.silenceUntil = now + duration;
        this.m_77762_();
    }

    public boolean isSilenceActive(MinecraftServer server) {
        this.ensureInitialized(server);
        ServerLevel ow = server.m_129880_(Level.f_46428_);
        if (ow == null) {
            return false;
        }
        long now = ow.m_46467_();
        return now < this.silenceUntil;
    }

    public void startFor(MinecraftServer server, long durationTicks) {
        ServerLevel ow = server.m_129880_(Level.f_46428_);
        if (ow == null) {
            return;
        }
        long now = ow.m_46467_();
        this.silenceUntil = now + Math.max(0L, durationTicks);
        this.m_77762_();
    }

    public void endNow(MinecraftServer server) {
        long now;
        ServerLevel ow = server.m_129880_(Level.f_46428_);
        if (ow == null) {
            return;
        }
        this.silenceUntil = now = ow.m_46467_();
        this.m_77762_();
    }
}

