/*
 * Decompiled with CFR 0.152.
 */
package net.tasuposed.theforgotten.server;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldSilenceState
extends SavedData {
    private static final String DATA_ID = "theforgotten_world_silence";
    private long silenceUntilGameTime = 0L;

    public static WorldSilenceState get(ServerLevel level) {
        return (WorldSilenceState)level.m_8895_().m_164861_(WorldSilenceState::load, WorldSilenceState::new, DATA_ID);
    }

    public static WorldSilenceState load(CompoundTag tag) {
        WorldSilenceState s = new WorldSilenceState();
        try {
            s.silenceUntilGameTime = tag.m_128454_("silenceUntil");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return s;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128356_("silenceUntil", this.silenceUntilGameTime);
        return tag;
    }

    public void ensureInitialized(ServerLevel level) {
        if (this.silenceUntilGameTime > 0L) {
            return;
        }
        RandomSource r = level.m_213780_();
        long now = level.m_46467_();
        long duration = r.m_188500_() < 0.6 ? 24000L : 36000L;
        this.silenceUntilGameTime = now + duration;
        this.m_77762_();
    }

    public boolean isSilenced(ServerLevel level) {
        return level.m_46467_() < this.silenceUntilGameTime;
    }

    public long getSilenceUntilGameTime() {
        return this.silenceUntilGameTime;
    }

    public void endNow(ServerLevel level) {
        this.silenceUntilGameTime = 0L;
        this.m_77762_();
    }
}

