/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.IngredientsTooltipComponent;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.gui.config.InternalKeyMappings;
import mezz.jei.gui.overlay.bookmarks.PreviewTooltipComponent;
import mezz.jei.library.gui.ingredients.TagContentTooltipComponent;
import mezz.jei.library.plugins.vanilla.crafting.JeiShapedRecipe;
import mezz.jei.library.recipes.RecipeSerializers;
import mezz.jei.library.startup.JeiStarter;
import mezz.jei.library.startup.StartData;
import mezz.jei.neoforge.events.PermanentEventSubscriptions;
import mezz.jei.neoforge.network.NetworkHandler;
import mezz.jei.neoforge.plugins.neoforge.NeoForgeGuiPlugin;
import mezz.jei.neoforge.startup.ForgePluginFinder;
import mezz.jei.neoforge.startup.StartEventObserver;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class JustEnoughItemsClient {
    private final PermanentEventSubscriptions subscriptions;

    public JustEnoughItemsClient(NetworkHandler networkHandler, PermanentEventSubscriptions subscriptions) {
        this.subscriptions = subscriptions;
        IConnectionToServer serverConnection = networkHandler.getConnectionToServer();
        List<IModPlugin> plugins = ForgePluginFinder.getModPlugins();
        StartData startData = new StartData(plugins, serverConnection);
        JeiStarter jeiStarter = new JeiStarter(startData);
        StartEventObserver startEventObserver = new StartEventObserver(jeiStarter::start, jeiStarter::stop);
        startEventObserver.register(subscriptions);
    }

    public void register() {
        this.subscriptions.register(AddClientReloadListenersEvent.class, this::onRegisterReloadListenerEvent);
        this.subscriptions.register(RegisterClientTooltipComponentFactoriesEvent.class, this::onRegisterClientTooltipEvent);
        this.subscriptions.register(RecipesReceivedEvent.class, e -> Internal.setClientSyncedRecipes(e.getRecipeMap()));
        this.subscriptions.register(RegisterKeyMappingsEvent.class, e -> {
            InternalKeyMappings keyMappings = new InternalKeyMappings(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0));
            Internal.setKeyMappings(keyMappings);
        });
        IEventBus modEventBus = this.subscriptions.getModEventBus();
        DeferredRegister deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"jei");
        deferredRegister.register(modEventBus);
        DeferredHolder jeiShaped = deferredRegister.register("jei_shaped", JeiShapedRecipe.Serializer::new);
        RecipeSerializers.register((Supplier<RecipeSerializer<? extends CraftingRecipe>>)jeiShaped);
    }

    private void onRegisterReloadListenerEvent(AddClientReloadListenersEvent event) {
        Textures textures = Internal.getTextures();
        event.addListener(ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"gui_sprite_manager"), (PreparableReloadListener)textures.getAtlasManager());
        event.addListener(ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"jei_client"), (PreparableReloadListener)this.createReloadListener());
    }

    private void onRegisterClientTooltipEvent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(IngredientsTooltipComponent.class, Function.identity());
        event.register(PreviewTooltipComponent.class, Function.identity());
        event.register(TagContentTooltipComponent.class, Function.identity());
    }

    private ResourceManagerReloadListener createReloadListener() {
        return resourceManager -> NeoForgeGuiPlugin.getResourceReloadHandler().ifPresent(r -> r.onResourceManagerReload(resourceManager));
    }
}

