/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.startup;

import java.util.Comparator;
import java.util.List;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.registration.IRuntimeRegistration;
import mezz.jei.api.runtime.IEditModeConfig;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.config.IIngredientGridConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.util.LoggedTimer;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.config.IBookmarkConfig;
import mezz.jei.gui.config.ILookupHistoryConfig;
import mezz.jei.gui.config.IngredientTypeSortingConfig;
import mezz.jei.gui.config.ModNameSortingConfig;
import mezz.jei.gui.events.GuiEventHandler;
import mezz.jei.gui.filter.FilterTextSource;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.ingredients.IngredientFilter;
import mezz.jei.gui.ingredients.IngredientFilterApi;
import mezz.jei.gui.ingredients.IngredientListElementFactory;
import mezz.jei.gui.ingredients.IngredientSorter;
import mezz.jei.gui.input.ClientInputHandler;
import mezz.jei.gui.input.CombinedRecipeFocusSource;
import mezz.jei.gui.input.GuiContainerWrapper;
import mezz.jei.gui.input.ICharTypedHandler;
import mezz.jei.gui.input.handlers.BookmarkInputHandler;
import mezz.jei.gui.input.handlers.DragRouter;
import mezz.jei.gui.input.handlers.EditInputHandler;
import mezz.jei.gui.input.handlers.FocusInputHandler;
import mezz.jei.gui.input.handlers.GlobalInputHandler;
import mezz.jei.gui.input.handlers.GuiAreaInputHandler;
import mezz.jei.gui.input.handlers.UserInputRouter;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.gui.overlay.bookmarks.history.LookupHistory;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.gui.startup.GuiConfigData;
import mezz.jei.gui.startup.JeiEventHandlers;
import mezz.jei.gui.startup.OverlayHelper;
import mezz.jei.gui.startup.ResourceReloadHandler;
import mezz.jei.gui.util.FocusUtil;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JeiGuiStarter {
    private static final Logger LOGGER = LogManager.getLogger();

    public static JeiEventHandlers start(IRuntimeRegistration registration) {
        LOGGER.info("Starting JEI GUI");
        LoggedTimer timer = new LoggedTimer();
        IConnectionToServer serverConnection = Internal.getServerConnection();
        Textures textures = Internal.getTextures();
        IInternalKeyMappings keyMappings = Internal.getKeyMappings();
        IScreenHelper screenHelper = registration.getScreenHelper();
        IRecipeTransferManager recipeTransferManager = registration.getRecipeTransferManager();
        IRecipeManager recipeManager = registration.getRecipeManager();
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IEditModeConfig editModeConfig = registration.getEditModeConfig();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IIngredientVisibility ingredientVisibility = jeiHelpers.getIngredientVisibility();
        IColorHelper colorHelper = jeiHelpers.getColorHelper();
        IModIdHelper modIdHelper = jeiHelpers.getModIdHelper();
        IFocusFactory focusFactory = jeiHelpers.getFocusFactory();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        FilterTextSource filterTextSource = new FilterTextSource();
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        ErrorUtil.checkNotNull(level, "minecraft.level");
        class_5455 registryAccess = level.method_30349();
        timer.start("Building ingredient list");
        List<IListElementInfo<?>> ingredientList = IngredientListElementFactory.createBaseList(ingredientManager, modIdHelper);
        timer.stop();
        timer.start("Building ingredient filter");
        GuiConfigData configData = GuiConfigData.create();
        ModNameSortingConfig modNameSortingConfig = configData.modNameSortingConfig();
        IngredientTypeSortingConfig ingredientTypeSortingConfig = configData.ingredientTypeSortingConfig();
        IClientToggleState toggleState = Internal.getClientToggleState();
        IBookmarkConfig bookmarkConfig = configData.bookmarkConfig();
        ILookupHistoryConfig lookupHistoryConfig = configData.lookupHistoryConfig();
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        IIngredientGridConfig ingredientListConfig = jeiClientConfigs.getIngredientListConfig();
        IIngredientGridConfig bookmarkListConfig = jeiClientConfigs.getBookmarkListConfig();
        IIngredientFilterConfig ingredientFilterConfig = jeiClientConfigs.getIngredientFilterConfig();
        Comparator<IListElement<?>> ingredientComparator = IngredientSorter.sortIngredients(clientConfig, modNameSortingConfig, ingredientTypeSortingConfig, ingredientManager, ingredientList);
        IngredientFilter ingredientFilter = new IngredientFilter(filterTextSource, clientConfig, ingredientFilterConfig, ingredientManager, ingredientComparator, ingredientList, modIdHelper, ingredientVisibility, colorHelper, toggleState);
        ingredientManager.registerIngredientListener(ingredientFilter);
        ingredientVisibility.registerListener(ingredientFilter);
        timer.stop();
        IngredientFilterApi ingredientFilterApi = new IngredientFilterApi(ingredientFilter, filterTextSource);
        registration.setIngredientFilter(ingredientFilterApi);
        LookupHistory lookupHistory = new LookupHistory(recipeManager, ingredientManager, focusFactory, clientConfig::getMaxLookupHistoryIngredients, lookupHistoryConfig);
        IngredientListOverlay ingredientListOverlay = OverlayHelper.createIngredientListOverlay(ingredientManager, screenHelper, ingredientFilter, lookupHistory, filterTextSource, keyMappings, ingredientListConfig, clientConfig, toggleState, serverConnection, ingredientFilterConfig, textures, colorHelper);
        registration.setIngredientListOverlay(ingredientListOverlay);
        BookmarkList bookmarkList = new BookmarkList(recipeManager, focusFactory, ingredientManager, registryAccess, bookmarkConfig, clientConfig, guiHelper);
        bookmarkConfig.loadBookmarks(recipeManager, focusFactory, guiHelper, ingredientManager, registryAccess, bookmarkList);
        BookmarkOverlay bookmarkOverlay = OverlayHelper.createBookmarkOverlay(ingredientManager, screenHelper, bookmarkList, lookupHistory, keyMappings, bookmarkListConfig, ingredientFilterConfig, clientConfig, toggleState, serverConnection, textures, colorHelper);
        registration.setBookmarkOverlay(bookmarkOverlay);
        GuiEventHandler guiEventHandler = new GuiEventHandler(screenHelper, bookmarkOverlay, ingredientListOverlay);
        RecipesGui recipesGui = new RecipesGui(recipeManager, recipeTransferManager, ingredientManager, keyMappings, focusFactory, bookmarkList, lookupHistory, guiHelper);
        registration.setRecipesGui(recipesGui);
        CombinedRecipeFocusSource recipeFocusSource = new CombinedRecipeFocusSource(recipesGui, ingredientListOverlay, bookmarkOverlay, new GuiContainerWrapper(screenHelper));
        List<ICharTypedHandler> charTypedHandlers = List.of(ingredientListOverlay);
        FocusUtil focusUtil = new FocusUtil(focusFactory, clientConfig, ingredientManager);
        UserInputRouter userInputRouter = new UserInputRouter("JEIGlobal", new EditInputHandler(recipeFocusSource, toggleState, editModeConfig), ingredientListOverlay.createInputHandler(), bookmarkOverlay.createInputHandler(), new FocusInputHandler(recipeFocusSource, recipesGui, focusUtil, clientConfig, ingredientManager, toggleState, serverConnection), new BookmarkInputHandler(recipeFocusSource, bookmarkList, bookmarkOverlay), new GlobalInputHandler(toggleState), new GuiAreaInputHandler(screenHelper, recipesGui, focusFactory));
        DragRouter dragRouter = new DragRouter(ingredientListOverlay.createDragHandler(), bookmarkOverlay.createDragHandler());
        ClientInputHandler clientInputHandler = new ClientInputHandler(charTypedHandlers, userInputRouter, dragRouter, keyMappings);
        ResourceReloadHandler resourceReloadHandler = new ResourceReloadHandler(ingredientListOverlay, ingredientFilter);
        return new JeiEventHandlers(guiEventHandler, clientInputHandler, resourceReloadHandler);
    }
}

