/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.file.serializers.TypedIngredientSerializer;
import mezz.jei.common.util.DeduplicatingRunner;
import mezz.jei.common.util.ServerConfigPathUtil;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.IngredientBookmark;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.config.BookmarkConfig;
import mezz.jei.gui.config.ILookupHistoryConfig;
import mezz.jei.gui.config.file.serializers.RecipeBookmarkSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Unmodifiable;

public class LookupHistoryJsonConfig
implements ILookupHistoryConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration SAVE_DELAY_TIME = Duration.ofSeconds(5L);
    private final Path jeiConfigurationDir;
    private final DeduplicatingRunner delayedSave = new DeduplicatingRunner(SAVE_DELAY_TIME, "JEI Lookup History Save Delay");

    private static Optional<Path> getPath(Path jeiConfigurationDir) {
        return ServerConfigPathUtil.getWorldPath(jeiConfigurationDir).flatMap(configPath -> {
            try {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create lookup history config folder: {}", configPath);
                return Optional.empty();
            }
            Path path = configPath.resolve("lookupHistory.ini");
            return Optional.of(path);
        });
    }

    public LookupHistoryJsonConfig(Path jeiConfigurationDir) {
        this.jeiConfigurationDir = jeiConfigurationDir;
    }

    @Override
    public void save(IRecipeManager recipeManager, IIngredientManager ingredientManager, IFocusFactory focusFactory, List<IBookmark> bookmarks) {
        LookupHistoryJsonConfig.getPath(this.jeiConfigurationDir).ifPresent(path -> this.delayedSave.run(() -> this.save((Path)path, recipeManager, ingredientManager, focusFactory, bookmarks)));
    }

    private void save(Path path, IRecipeManager recipeManager, IIngredientManager ingredientManager, IFocusFactory focusFactory, List<IBookmark> bookmarks) {
        ArrayList<CallSite> strings = new ArrayList<CallSite>();
        TypedIngredientSerializer ingredientSerializer = new TypedIngredientSerializer(ingredientManager);
        RecipeBookmarkSerializer recipeBookmarkSerializer = new RecipeBookmarkSerializer(recipeManager, focusFactory, ingredientSerializer);
        for (IBookmark bookmark : bookmarks) {
            if (bookmark instanceof IngredientBookmark) {
                IngredientBookmark ingredientBookmark = (IngredientBookmark)bookmark;
                ITypedIngredient typedIngredient = ingredientBookmark.getIngredient();
                Object t = typedIngredient.getIngredient();
                if (t instanceof class_1799) {
                    class_1799 stack = (class_1799)t;
                    strings.add((CallSite)((Object)("T:" + stack.method_7953(new class_2487()))));
                    continue;
                }
                strings.add((CallSite)((Object)("I:" + ingredientSerializer.serialize(typedIngredient))));
                continue;
            }
            if (bookmark instanceof RecipeBookmark) {
                RecipeBookmark recipeBookmark = (RecipeBookmark)bookmark;
                strings.add((CallSite)((Object)("R:" + recipeBookmarkSerializer.serialize(recipeBookmark))));
                continue;
            }
            LOGGER.error("Unknown IBookmark type, unable to save it: {}", bookmark.getClass());
        }
        try {
            Files.write(path, strings, new OpenOption[0]);
            LOGGER.debug("Saved lookup history config to file {}", (Object)path);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save lookup history config to file {}", (Object)path, (Object)e);
        }
    }

    @Override
    public List<IBookmark> load(IRecipeManager recipeManager, IIngredientManager ingredientManager, IFocusFactory focusFactory) {
        return this.loadBookmarks(ingredientManager, recipeManager, focusFactory);
    }

    private @Unmodifiable List<IBookmark> loadBookmarks(IIngredientManager ingredientManager, IRecipeManager recipeManager, IFocusFactory focusFactory) {
        return LookupHistoryJsonConfig.getPath(this.jeiConfigurationDir).map(path -> {
            List<String> lines;
            if (!Files.exists(path, new LinkOption[0])) {
                return List.of();
            }
            try {
                lines = Files.readAllLines(path);
            }
            catch (IOException e) {
                LOGGER.error("Encountered an exception when loading the lookup history config from file {}\n{}", path, (Object)e);
                return List.of();
            }
            TypedIngredientSerializer ingredientSerializer = new TypedIngredientSerializer(ingredientManager);
            RecipeBookmarkSerializer recipeBookmarkSerializer = new RecipeBookmarkSerializer(recipeManager, focusFactory, ingredientSerializer);
            IIngredientHelper<class_1799> itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
            ArrayList<IBookmark> bookmarks = new ArrayList<IBookmark>();
            for (String line : lines) {
                IBookmark bookmark = null;
                if (line.startsWith("T:")) {
                    String itemStackAsJson = line.substring("T:".length());
                    bookmark = BookmarkConfig.loadItemStackBookmark(itemStackHelper, ingredientManager, itemStackAsJson);
                } else if (line.startsWith("I:")) {
                    String serializedIngredient = line.substring("I:".length());
                    bookmark = BookmarkConfig.loadIngredientBookmark(ingredientSerializer, ingredientManager, serializedIngredient);
                } else if (line.startsWith("R:")) {
                    String serializedRecipe = line.substring("R:".length());
                    bookmark = BookmarkConfig.loadRecipeBookmark(recipeBookmarkSerializer, serializedRecipe);
                } else {
                    LOGGER.error("Failed to load unknown bookmark type:\n{}", (Object)line);
                }
                if (bookmark == null) continue;
                bookmarks.add(bookmark);
            }
            return bookmarks;
        }).orElseGet(List::of);
    }
}

