/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IClickableIngredientFactory;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.input.ClickableIngredientFactory;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.collect.ListMultiMap;
import mezz.jei.library.gui.GuiContainerHandlers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ScreenHelper
implements IScreenHelper {
    private final IIngredientManager ingredientManager;
    private final List<IGlobalGuiHandler> globalGuiHandlers;
    private final GuiContainerHandlers guiContainerHandlers;
    private final ListMultiMap<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers;
    private final ListMultiMap<Class<?>, IGhostIngredientHandler<?>> cachedGhostIngredientHandlers;
    private final Map<Class<?>, IScreenHandler<?>> guiScreenHandlers;

    public ScreenHelper(IIngredientManager ingredientManager, List<IGlobalGuiHandler> globalGuiHandlers, GuiContainerHandlers guiContainerHandlers, ListMultiMap<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers, Map<Class<?>, IScreenHandler<?>> guiScreenHandlers) {
        this.ingredientManager = ingredientManager;
        this.globalGuiHandlers = globalGuiHandlers;
        this.guiContainerHandlers = guiContainerHandlers;
        this.ghostIngredientHandlers = ghostIngredientHandlers;
        this.guiScreenHandlers = guiScreenHandlers;
        this.cachedGhostIngredientHandlers = new ListMultiMap();
    }

    @Override
    public <T extends Screen> Optional<IGuiProperties> getGuiProperties(T screen) {
        IScreenHandler<?> handler = this.guiScreenHandlers.get(screen.getClass());
        if (handler != null) {
            IGuiProperties properties = handler.apply(screen);
            return Optional.ofNullable(properties);
        }
        for (Map.Entry<Class<?>, IScreenHandler<?>> entry : this.guiScreenHandlers.entrySet()) {
            IScreenHandler<?> handler2;
            Class<?> guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(screen) || (handler2 = entry.getValue()) == null) continue;
            IGuiProperties properties = handler2.apply(screen);
            return Optional.ofNullable(properties);
        }
        return Optional.empty();
    }

    @Override
    public Stream<Rect2i> getGuiExclusionAreas(Screen screen) {
        Stream<Rect2i> globalGuiHandlerExclusionAreas = this.globalGuiHandlers.stream().map(IGlobalGuiHandler::getGuiExtraAreas).flatMap(Collection::stream);
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            Stream<Rect2i> guiExtraAreas = this.guiContainerHandlers.getGuiExtraAreas(guiContainer);
            return Stream.concat(globalGuiHandlerExclusionAreas, guiExtraAreas);
        }
        return globalGuiHandlerExclusionAreas;
    }

    @Override
    public Stream<IClickableIngredient<?>> getClickableIngredientUnderMouse(Screen screen, double mouseX, double mouseY) {
        ClickableIngredientFactory factory = new ClickableIngredientFactory(this.ingredientManager);
        return Stream.concat(this.getPluginsIngredientUnderMouse(factory, screen, mouseX, mouseY), this.getSlotIngredientUnderMouse(factory, screen).stream());
    }

    private Optional<IClickableIngredient<?>> getSlotIngredientUnderMouse(ClickableIngredientFactory factory, Screen guiScreen) {
        if (!(guiScreen instanceof AbstractContainerScreen)) {
            return Optional.empty();
        }
        AbstractContainerScreen guiContainer = (AbstractContainerScreen)guiScreen;
        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
        return screenHelper.getSlotUnderMouse(guiContainer).flatMap(slot -> this.getClickedIngredient(factory, (Slot)slot, (AbstractContainerScreen<?>)guiContainer));
    }

    private Stream<IClickableIngredient<?>> getPluginsIngredientUnderMouse(ClickableIngredientFactory factory, Screen guiScreen, double mouseX, double mouseY) {
        Stream<IClickableIngredient<?>> globalIngredients = this.globalGuiHandlers.stream().map(a -> a.getClickableIngredientUnderMouse(factory, mouseX, mouseY)).flatMap(Optional::stream);
        if (guiScreen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)guiScreen;
            Stream<IClickableIngredient<?>> containerIngredients = this.getGuiContainerHandlerIngredients(factory, guiContainer, mouseX, mouseY);
            return Stream.concat(containerIngredients, globalIngredients);
        }
        return globalIngredients;
    }

    private Optional<IClickableIngredient<ItemStack>> getClickedIngredient(ClickableIngredientFactory factory, Slot slot, AbstractContainerScreen<?> guiContainer) {
        ItemStack stack = slot.getItem();
        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
        return this.getGuiProperties((Screen)guiContainer).flatMap(guiProperties -> factory.createBuilder(stack).buildWithArea(guiProperties.guiLeft() + slot.x, guiProperties.guiTop() + slot.y, 16, 16));
    }

    private <T extends AbstractContainerScreen<?>> Stream<IClickableIngredient<?>> getGuiContainerHandlerIngredients(IClickableIngredientFactory factory, T guiContainer, double mouseX, double mouseY) {
        return this.guiContainerHandlers.getActiveGuiHandlerStream(guiContainer).map(a -> a.getClickableIngredientUnderMouse(factory, guiContainer, mouseX, mouseY)).flatMap(Optional::stream);
    }

    @Override
    public <T extends Screen> List<IGhostIngredientHandler<T>> getGhostIngredientHandlers(T guiScreen) {
        Class<?> guiScreenClass = guiScreen.getClass();
        if (this.cachedGhostIngredientHandlers.containsKey(guiScreenClass)) {
            List cached = (List)this.cachedGhostIngredientHandlers.get((Object)guiScreenClass);
            return cached;
        }
        ArrayList results = new ArrayList();
        Collection handlers = this.ghostIngredientHandlers.get((Object)guiScreen.getClass());
        if (!handlers.isEmpty()) {
            results.addAll(handlers);
        }
        for (Map.Entry entry : this.ghostIngredientHandlers.entrySet()) {
            List handlers2;
            Class handledClass = (Class)entry.getKey();
            if (!handledClass.isInstance(guiScreen) || (handlers2 = (List)entry.getValue()).isEmpty()) continue;
            results.addAll(handlers2);
        }
        this.cachedGhostIngredientHandlers.putAll(guiScreen.getClass(), results);
        List castResults = results;
        return castResults;
    }

    @Override
    public Stream<IGuiClickableArea> getGuiClickableArea(AbstractContainerScreen<?> guiContainer, double guiMouseX, double guiMouseY) {
        return this.guiContainerHandlers.getGuiClickableArea(guiContainer, guiMouseX, guiMouseY);
    }
}

