/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config.file.serializers;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import mezz.jei.common.config.file.serializers.DeserializeResult;
import mezz.jei.common.config.file.serializers.TypedIngredientSerializer;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.overlay.elements.IElement;
import net.minecraft.resources.ResourceLocation;

public class RecipeBookmarkSerializer
implements IJeiConfigValueSerializer<RecipeBookmark<?, ?>> {
    private static final String SEPARATOR = "#";
    private final IRecipeManager recipeManager;
    private final IFocusFactory focusFactory;
    private final TypedIngredientSerializer ingredientSerializer;

    public RecipeBookmarkSerializer(IRecipeManager recipeManager, IFocusFactory focusFactory, TypedIngredientSerializer ingredientSerializer) {
        this.recipeManager = recipeManager;
        this.focusFactory = focusFactory;
        this.ingredientSerializer = ingredientSerializer;
    }

    @Override
    public String serialize(RecipeBookmark<?, ?> value) {
        IRecipeCategory<?> recipeCategory = value.getRecipeCategory();
        RecipeType<?> recipeType = recipeCategory.getRecipeType();
        ResourceLocation recipeTypeUid = recipeType.getUid();
        ResourceLocation recipeUid = value.getRecipeUid();
        IElement<?> element = value.getElement();
        ITypedIngredient<?> typedIngredient = element.getTypedIngredient();
        String outputSerialized = this.ingredientSerializer.serialize(typedIngredient);
        RecipeIngredientRole displayRole = value.getDisplayRole();
        if (displayRole != RecipeIngredientRole.OUTPUT) {
            return recipeTypeUid + SEPARATOR + recipeUid + SEPARATOR + outputSerialized + SEPARATOR + displayRole.name();
        }
        return recipeTypeUid + SEPARATOR + recipeUid + SEPARATOR + outputSerialized;
    }

    @Override
    public IJeiConfigValueSerializer.IDeserializeResult<RecipeBookmark<?, ?>> deserialize(String string) {
        ResourceLocation recipeUid;
        ResourceLocation recipeTypeUid;
        String[] parts = string.split(SEPARATOR);
        if (parts.length != 3 && parts.length != 4) {
            String error = "string must be 3 or 4 parts";
            return new DeserializeResult<Object>(null, error);
        }
        try {
            recipeTypeUid = new ResourceLocation(parts[0]);
        }
        catch (RuntimeException e) {
            String error = "recipe type uid must be a valid resource location: %s\n%s".formatted(string, e.getMessage());
            return new DeserializeResult<Object>(null, error);
        }
        try {
            recipeUid = new ResourceLocation(parts[1]);
        }
        catch (RuntimeException e) {
            String error = "recipe uid must be a valid resource location: %s\n%s".formatted(string, e.getMessage());
            return new DeserializeResult<Object>(null, error);
        }
        IJeiConfigValueSerializer.IDeserializeResult<ITypedIngredient<?>> deserialized = this.ingredientSerializer.deserialize(parts[2]);
        Optional<ITypedIngredient<?>> outputResult = deserialized.getResult();
        if (outputResult.isEmpty()) {
            List<String> errors = deserialized.getErrors();
            return new DeserializeResult<Object>(null, errors);
        }
        Optional<RecipeType<?>> recipeTypeResult = this.recipeManager.getRecipeType(recipeTypeUid);
        if (recipeTypeResult.isEmpty()) {
            String error = "could not find a recipe type matching the given uid: %s".formatted(recipeTypeUid);
            return new DeserializeResult<Object>(null, error);
        }
        RecipeIngredientRole displayRole = RecipeIngredientRole.OUTPUT;
        if (parts.length == 4) {
            String value = parts[3];
            if ("false".equals(value)) {
                displayRole = RecipeIngredientRole.INPUT;
            } else {
                try {
                    displayRole = RecipeIngredientRole.valueOf(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        ITypedIngredient<?> output = outputResult.get();
        RecipeType<?> recipeType = recipeTypeResult.get();
        IRecipeCategory<?> recipeCategory = this.recipeManager.getRecipeCategory(recipeType);
        return this.createBookmark(string, recipeCategory, recipeUid, output, displayRole);
    }

    private <T> DeserializeResult<RecipeBookmark<?, ?>> createBookmark(String string, IRecipeCategory<T> recipeCategory, ResourceLocation recipeUid, ITypedIngredient<?> output, RecipeIngredientRole displayRole) {
        IFocus<?> focus = this.focusFactory.createFocus(displayRole, output);
        Optional<T> recipeResult = this.findRecipe(recipeCategory, List.of(focus), recipeUid);
        if (recipeResult.isEmpty()) {
            String error = "could not find a recipe for this string: %s".formatted(string);
            return new DeserializeResult<Object>(null, error);
        }
        T recipe = recipeResult.get();
        RecipeBookmark recipeBookmark = new RecipeBookmark(recipeCategory, recipe, recipeUid, output, displayRole);
        return new DeserializeResult(recipeBookmark);
    }

    private <T> Optional<T> findRecipe(IRecipeCategory<T> recipeCategory, List<IFocus<?>> focus, ResourceLocation recipeUid) {
        RecipeType<T> recipeType = recipeCategory.getRecipeType();
        return this.recipeManager.createRecipeLookup(recipeType).limitFocus(focus).get().filter(r -> Objects.equals(recipeCategory.getRegistryName(r), recipeUid)).findFirst();
    }

    @Override
    public boolean isValid(RecipeBookmark<?, ?> value) {
        return true;
    }

    @Override
    public Optional<Collection<RecipeBookmark<?, ?>>> getAllValidValues() {
        return Optional.empty();
    }

    @Override
    public String getValidValuesDescription() {
        return "";
    }
}

