/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.startup;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.neoforge.events.PermanentEventSubscriptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class StartEventObserver
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<? extends Event>> requiredEvents = Set.of(TagsUpdatedEvent.class, RecipesReceivedEvent.class);
    private final Set<Class<? extends Event>> observedEvents = new HashSet<Class<? extends Event>>();
    private final Runnable startRunnable;
    private final Runnable stopRunnable;
    private WeakReference<Connection> currentConnection = new WeakReference<Object>(null);
    private State state = State.LISTENING;

    public StartEventObserver(Runnable startRunnable, Runnable stopRunnable) {
        this.startRunnable = startRunnable;
        this.stopRunnable = stopRunnable;
    }

    public void register(PermanentEventSubscriptions subscriptions) {
        requiredEvents.forEach(eventClass -> subscriptions.register(EventPriority.LOWEST, eventClass, this::onEvent));
        subscriptions.register(ClientPlayerNetworkEvent.LoggingOut.class, event -> {
            if (event.getPlayer() != null) {
                StartEventObserver.logReceivedEvent(event);
                this.transitionState(State.LISTENING);
            }
        });
        subscriptions.register(ScreenEvent.Init.Pre.class, event -> {
            if (this.state != State.JEI_STARTED) {
                Screen screen = event.getScreen();
                Minecraft minecraft = screen.getMinecraft();
                if (screen instanceof AbstractContainerScreen && minecraft != null && minecraft.player != null) {
                    String missingEventsString = requiredEvents.stream().filter(e -> !this.observedEvents.contains(e)).map(Class::getName).sorted().collect(Collectors.joining(", ", "[", "]"));
                    String requiredEventsString = requiredEvents.stream().map(Class::getName).sorted().collect(Collectors.joining(", ", "[", "]"));
                    LOGGER.error("A Screen is opening but JEI hasn't started yet.\nNormally, JEI is started after these event have fired: {}.\nSomething has caused one or more of these events to fail, so JEI is starting very late.\nMissing events: {}", (Object)requiredEventsString, (Object)missingEventsString);
                    this.transitionState(State.LISTENING);
                    this.transitionState(State.JEI_STARTED);
                }
            }
        });
    }

    private <T extends Event> void onEvent(T event) {
        Connection observingConnection = (Connection)this.currentConnection.get();
        Connection currentConnection = StartEventObserver.getCurrentConnection();
        if (currentConnection != observingConnection) {
            this.observedEvents.clear();
            this.currentConnection = new WeakReference<Connection>(currentConnection);
        }
        if (currentConnection == null) {
            LOGGER.debug("JEI StartEventObserver received {} too early, ignoring", event.getClass());
            return;
        }
        StartEventObserver.logReceivedEvent(event);
        Class<?> eventClass = event.getClass();
        if (requiredEvents.contains(eventClass) && this.observedEvents.add(eventClass) && this.observedEvents.containsAll(requiredEvents)) {
            if (this.state == State.JEI_STARTED) {
                this.restart();
            } else {
                this.transitionState(State.JEI_STARTED);
            }
        }
    }

    private static <T extends Event> void logReceivedEvent(T event) {
        LOGGER.debug("JEI StartEventObserver received event: {}", event.getClass());
    }

    @Nullable
    private static Connection getCurrentConnection() {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener packetListener = minecraft.getConnection();
        if (packetListener != null) {
            return packetListener.getConnection();
        }
        if (minecraft.pendingConnection != null) {
            return minecraft.pendingConnection;
        }
        Screen screen = minecraft.screen;
        if (screen instanceof ConnectScreen) {
            ConnectScreen connectScreen = (ConnectScreen)screen;
            return connectScreen.connection;
        }
        return null;
    }

    public void onResourceManagerReload(ResourceManager pResourceManager) {
        LOGGER.debug("JEI StartEventObserver detected resource manager reload.");
        this.restart();
    }

    private void restart() {
        if (this.state != State.JEI_STARTED) {
            return;
        }
        this.transitionState(State.LISTENING);
        this.transitionState(State.JEI_STARTED);
    }

    private void transitionState(State newState) {
        LOGGER.debug("JEI StartEventObserver transitioning state from {} to {}", (Object)this.state, (Object)newState);
        switch (newState.ordinal()) {
            case 0: {
                if (this.state != State.JEI_STARTED) break;
                this.stopRunnable.run();
                break;
            }
            case 1: {
                if (this.state != State.LISTENING) {
                    throw new IllegalStateException("Attempted Illegal state transition from " + String.valueOf((Object)this.state) + " to " + String.valueOf((Object)newState));
                }
                this.startRunnable.run();
            }
        }
        this.state = newState;
        this.observedEvents.clear();
    }

    private static enum State {
        LISTENING,
        JEI_STARTED;

    }
}

