/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import net.minecraft.client.gui.GuiGraphics;

public class DrawableCombined
implements IDrawableAnimated {
    private final List<IDrawable> drawables;
    private final int width;
    private final int height;

    public DrawableCombined(IDrawable ... drawables) {
        this(List.of(drawables));
    }

    public DrawableCombined(List<IDrawable> drawables) {
        IDrawable first = drawables.getFirst();
        this.width = first.getWidth();
        this.height = first.getHeight();
        for (int i = 1; i < drawables.size(); ++i) {
            IDrawable drawable = drawables.get(i);
            if (drawable.getWidth() == this.width && drawable.getHeight() == this.height) continue;
            throw new IllegalArgumentException("Drawables must have the same width and height. Expected " + this.width + " x " + this.height + " but got " + drawable.getWidth() + " x " + drawable.getHeight());
        }
        this.drawables = drawables;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(GuiGraphics guiGraphics) {
        for (IDrawable drawable : this.drawables) {
            drawable.draw(guiGraphics);
        }
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        for (IDrawable drawable : this.drawables) {
            drawable.draw(guiGraphics, xOffset, yOffset);
        }
    }
}

