/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IngredientSortStage;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.gui.config.IngredientTypeSortingConfig;
import mezz.jei.gui.config.ModNameSortingConfig;
import mezz.jei.gui.ingredients.IListElementInfo;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class IngredientSorterComparators {
    private final IIngredientManager ingredientManager;
    private final ModNameSortingConfig modNameSortingConfig;
    private final IngredientTypeSortingConfig ingredientTypeSortingConfig;
    private final Set<String> modNames;

    public IngredientSorterComparators(IIngredientManager ingredientManager, ModNameSortingConfig modNameSortingConfig, IngredientTypeSortingConfig ingredientTypeSortingConfig, Set<String> modNames) {
        this.ingredientManager = ingredientManager;
        this.modNameSortingConfig = modNameSortingConfig;
        this.ingredientTypeSortingConfig = ingredientTypeSortingConfig;
        this.modNames = modNames;
    }

    public Comparator<IListElementInfo<?>> getComparator(List<IngredientSortStage> ingredientSorterStages) {
        return ingredientSorterStages.stream().map(this::getComparator).reduce(Comparator::thenComparing).orElseGet(this::getDefault);
    }

    public Comparator<IListElementInfo<?>> getComparator(IngredientSortStage ingredientSortStage) {
        return switch (ingredientSortStage) {
            default -> throw new MatchException(null, null);
            case IngredientSortStage.ALPHABETICAL -> IngredientSorterComparators.getAlphabeticalComparator();
            case IngredientSortStage.CREATIVE_MENU -> IngredientSorterComparators.getCreativeMenuComparator();
            case IngredientSortStage.INGREDIENT_TYPE -> this.getIngredientTypeComparator();
            case IngredientSortStage.MOD_NAME -> this.getModNameComparator();
            case IngredientSortStage.TAG -> this.getTagComparator();
            case IngredientSortStage.ARMOR -> IngredientSorterComparators.getArmorComparator();
            case IngredientSortStage.MAX_DURABILITY -> IngredientSorterComparators.getMaxDurabilityComparator();
        };
    }

    public Comparator<IListElementInfo<?>> getDefault() {
        return this.getModNameComparator().thenComparing(this.getIngredientTypeComparator()).thenComparing(IngredientSorterComparators.getCreativeMenuComparator());
    }

    private static Comparator<IListElementInfo<?>> getCreativeMenuComparator() {
        return Comparator.comparingInt(IListElementInfo::getCreatedIndex);
    }

    private static Comparator<IListElementInfo<?>> getAlphabeticalComparator() {
        return Comparator.comparing(i -> i.getNames().getFirst());
    }

    private Comparator<IListElementInfo<?>> getModNameComparator() {
        return this.modNameSortingConfig.getComparatorFromMappedValues(this.modNames);
    }

    private Comparator<IListElementInfo<?>> getIngredientTypeComparator() {
        Collection<IIngredientType<?>> ingredientTypes = this.ingredientManager.getRegisteredIngredientTypes();
        Set ingredientTypeStrings = ingredientTypes.stream().map(IngredientTypeSortingConfig::getIngredientTypeString).collect(Collectors.toSet());
        return this.ingredientTypeSortingConfig.getComparatorFromMappedValues(ingredientTypeStrings);
    }

    private static Comparator<IListElementInfo<?>> getMaxDurabilityComparator() {
        Comparator<IListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getItemStack(o).method_7936());
        return maxDamage.reversed();
    }

    private Comparator<IListElementInfo<?>> getTagComparator() {
        Comparator<IListElementInfo> isTagged = Comparator.comparing(this::hasTag);
        Comparator<IListElementInfo> tag = Comparator.comparing(this::getTagForSorting);
        return isTagged.reversed().thenComparing(tag);
    }

    private static Comparator<IListElementInfo<?>> getArmorComparator() {
        Comparator<IListElementInfo> isArmorComp = Comparator.comparing(o -> IngredientSorterComparators.isArmor(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> armorSlot = Comparator.comparing(o -> IngredientSorterComparators.getArmorSlotIndex(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> armorDamage = Comparator.comparing(o -> IngredientSorterComparators.getArmorDamageReduce(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getArmorDurability(IngredientSorterComparators.getItemStack(o)));
        return isArmorComp.reversed().thenComparing(armorSlot.reversed()).thenComparing(armorDamage.reversed()).thenComparing(maxDamage.reversed());
    }

    private static boolean isArmor(class_1799 itemStack) {
        return itemStack.method_57826(class_9334.field_54196);
    }

    private static int getArmorSlotIndex(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        class_10192 equippable = (class_10192)item.method_57347().method_58694(class_9334.field_54196);
        if (equippable != null) {
            return equippable.comp_3174().method_5927();
        }
        return 0;
    }

    private static double getArmorDamageReduce(class_1799 itemStack) {
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        class_9285 itemAttributeModifiers = itemStackHelper.getItemAttributeModifiers(itemStack);
        return itemAttributeModifiers.method_57481(1.0, class_1304.field_6174);
    }

    private static int getArmorDurability(class_1799 itemStack) {
        if (IngredientSorterComparators.isArmor(itemStack)) {
            return itemStack.method_7936();
        }
        return 0;
    }

    private String getTagForSorting(IListElementInfo<?> elementInfo) {
        return elementInfo.getTagIds(this.ingredientManager).max(Comparator.comparing(IngredientSorterComparators::tagCount)).map(class_2960::method_12832).orElse("");
    }

    private static int tagCount(class_2960 tagId) {
        if (tagId.toString().equals("itemfilters:check_nbt")) {
            return 0;
        }
        class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
        return RegistryUtil.getRegistry(class_7924.field_41197).method_46733(tagKey).map(class_6885.class_6887::method_40247).orElse(0);
    }

    private boolean hasTag(IListElementInfo<?> elementInfo) {
        return !this.getTagForSorting(elementInfo).isEmpty();
    }

    public static <V> class_1799 getItemStack(IListElementInfo<V> ingredientInfo) {
        ITypedIngredient<V> ingredient = ingredientInfo.getTypedIngredient();
        V v = ingredient.getIngredient();
        if (v instanceof class_1799) {
            class_1799 itemStack = (class_1799)v;
            return itemStack;
        }
        return class_1799.field_8037;
    }
}

