/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.looterscompass.client;

import dev.kvnmtz.looterscompass.client.GlowEntityManager;
import dev.kvnmtz.looterscompass.config.ServerConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompassGlowManager {
    private static BlockPos glowingPosition = null;
    private static long glowStartTime = 0L;

    public static void activateGlow(BlockPos position) {
        CompassGlowManager.clearGlow();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            BlockEntity blockEntity = level.m_7702_(position);
            if (blockEntity == null) {
                if (level.m_8055_(position).m_60795_()) {
                    return;
                }
                GlowEntityManager.addGlowToBlock(position, (Level)level);
            } else {
                boolean hasCustomRenderer;
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(blockEntity);
                boolean bl = hasCustomRenderer = renderer != null;
                if (!hasCustomRenderer) {
                    GlowEntityManager.addGlowToBlock(position, (Level)level);
                }
            }
        }
        glowingPosition = position;
        glowStartTime = System.currentTimeMillis();
    }

    public static void activateGlowForEntity(Entity entity) {
        CompassGlowManager.clearGlow();
        glowingPosition = null;
        glowStartTime = System.currentTimeMillis();
        GlowEntityManager.addGlowToEntity(entity);
    }

    public static void clearGlow() {
        GlowEntityManager.removeGlowFromBlock();
        GlowEntityManager.removeGlowFromEntity();
        glowingPosition = null;
        glowStartTime = 0L;
    }

    public static boolean isGlowing(BlockPos position) {
        int glowDurationMs;
        boolean isActive;
        if (glowingPosition == null || !glowingPosition.equals((Object)position)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        boolean bl = isActive = currentTime - glowStartTime < (long)(glowDurationMs = (Integer)ServerConfig.GLOW_DURATION.get() * 1000);
        if (!isActive) {
            CompassGlowManager.clearGlow();
        }
        return isActive;
    }

    public static void tick() {
        GlowEntityManager.tickGlowEntities();
    }
}

