/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.looterscompass.client;

import dev.kvnmtz.looterscompass.config.ServerConfig;
import dev.kvnmtz.looterscompass.mixin.ClientLevelAccessor;
import dev.kvnmtz.looterscompass.mixin.EntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlowEntityManager {
    private static Shulker currentGlowEntity = null;
    private static long blockGlowStartTime = 0L;
    private static Entity currentGlowingEntity = null;
    private static long entityGlowStartTime = 0L;

    public static void addGlowToBlock(BlockPos pos, Level level) {
        GlowEntityManager.removeGlowFromBlock();
        Shulker glowEntity = new Shulker(EntityType.f_20521_, level);
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)pos.m_7495_());
        glowEntity.m_6034_(blockCenter.f_82479_, blockCenter.f_82480_, blockCenter.f_82481_);
        glowEntity.m_6842_(true);
        glowEntity.m_21557_(true);
        glowEntity.m_20242_(true);
        glowEntity.m_20225_(true);
        glowEntity.m_20331_(true);
        glowEntity.m_20340_(false);
        GlowEntityManager.setClientEntityGlowing((Entity)glowEntity, true);
        GlowEntityManager.addClientEntity(level, (Entity)glowEntity);
        currentGlowEntity = glowEntity;
        blockGlowStartTime = System.currentTimeMillis();
    }

    public static void setClientEntityGlowing(Entity entity, boolean glowing) {
        ((EntityAccessor)entity).callSetSharedFlag(6, glowing);
    }

    private static void addClientEntity(Level level, Entity glowEntity) {
        int entityId = level.m_7354_();
        glowEntity.m_20234_(entityId);
        ((ClientLevelAccessor)level).callAddEntity(entityId, glowEntity);
    }

    public static void removeGlowFromBlock() {
        if (currentGlowEntity != null && currentGlowEntity.m_6084_()) {
            currentGlowEntity.m_146870_();
        }
        currentGlowEntity = null;
        blockGlowStartTime = 0L;
    }

    public static void removeGlowFromEntity() {
        if (currentGlowingEntity != null) {
            GlowEntityManager.setClientEntityGlowing(currentGlowingEntity, false);
        }
        currentGlowingEntity = null;
        entityGlowStartTime = 0L;
    }

    public static void addGlowToEntity(Entity entity) {
        GlowEntityManager.removeGlowFromEntity();
        GlowEntityManager.setClientEntityGlowing(entity, true);
        currentGlowingEntity = entity;
        entityGlowStartTime = System.currentTimeMillis();
    }

    public static void tickGlowEntities() {
        long currentTime = System.currentTimeMillis();
        int glowDurationMs = (Integer)ServerConfig.GLOW_DURATION.get() * 1000;
        if (currentGlowEntity != null && currentTime - blockGlowStartTime > (long)glowDurationMs) {
            GlowEntityManager.removeGlowFromBlock();
        }
        if (currentGlowingEntity != null && currentTime - entityGlowStartTime > (long)glowDurationMs) {
            GlowEntityManager.removeGlowFromEntity();
        }
    }
}

