/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.looterscompass.item;

import dev.kvnmtz.looterscompass.client.CompassGlowManager;
import dev.kvnmtz.looterscompass.config.ClientConfig;
import dev.kvnmtz.looterscompass.config.ServerConfig;
import dev.kvnmtz.looterscompass.mixin.ClientLevelAccessor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class LootersCompassItem
extends Item {
    private static final String FOUND_POS_TAG = "FoundPos";
    private static final int SEARCH_CACHE_DURATION_TICKS = 100;

    public LootersCompassItem() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.UNCOMMON));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> LootersCompassItemClient.registerItemProperties(this));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        Integer cooldown;
        ItemStack stack = player.m_21120_(usedHand);
        if (!((Boolean)ServerConfig.ENABLE_LOOT_CONTAINER_GLOW.get()).booleanValue()) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (level.f_46443_) {
            LootersCompassItemClient.ClientCompassData cache = LootersCompassItemClient.getCache();
            if (cache.isTrackingEntity && cache.trackedEntityUUID != null) {
                Entity entity = this.findEntityByUUID((ClientLevel)level, cache.trackedEntityUUID);
                if (entity instanceof LootrChestMinecartEntity) {
                    LootrChestMinecartEntity minecart = (LootrChestMinecartEntity)entity;
                    CompassGlowManager.activateGlowForEntity((Entity)minecart);
                }
            } else {
                BlockPos targetPos = this.getFoundPosition(stack);
                if (targetPos != null) {
                    CompassGlowManager.activateGlow(targetPos);
                } else {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
            }
        }
        if ((cooldown = (Integer)ServerConfig.GLOW_COOLDOWN.get()) > 0) {
            player.m_36335_().m_41524_((Item)this, ((Integer)ServerConfig.GLOW_COOLDOWN.get()).intValue());
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"item.looters_compass.looters_compass.desc").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LootersCompassItemClient.ClientCompassData cache = LootersCompassItemClient.getCache();
        if (cache.isTrackingEntity && cache.trackedEntityUUID != null) {
            Entity trackedEntity = this.findEntityByUUID((ClientLevel)level, cache.trackedEntityUUID);
            if (trackedEntity != null) {
                this.setFoundPosition(stack, trackedEntity.m_20183_());
            } else {
                this.clearFoundPosition(stack);
                cache.isTrackingEntity = false;
                cache.trackedEntityUUID = null;
            }
        }
        if (player.f_19797_ % (Integer)ClientConfig.SEARCH_FREQUENCY_TICKS.get() != 0) {
            return;
        }
        this.searchForLootContainers(stack, level, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void searchForLootContainers(ItemStack stack, Level level, Player player) {
        double minecartDistance;
        LootrChestMinecartEntity nearestMinecart;
        boolean isCacheApplicable;
        BlockPos playerPos = player.m_20183_();
        LootersCompassItemClient.ClientCompassData cache = LootersCompassItemClient.getCache();
        boolean playerDidntMoveMuch = cache.lastSearchPos != null && playerPos.m_123331_((Vec3i)cache.lastSearchPos) <= 9.0;
        boolean bl = isCacheApplicable = cache.lastSearchTime > 0 && player.f_19797_ - cache.lastSearchTime <= 100 && playerDidntMoveMuch;
        if (isCacheApplicable) {
            if (cache.lastSearchResult != null) {
                cache.isTrackingEntity = false;
                cache.trackedEntityUUID = null;
                this.setFoundPosition(stack, cache.lastSearchResult);
            } else {
                this.clearFoundPosition(stack);
            }
            return;
        }
        double nearestDistance = Double.MAX_VALUE;
        Integer maxRadiusXZ = (Integer)ServerConfig.SEARCH_RADIUS_XZ.get();
        Integer maxRadiusY = (Integer)ServerConfig.SEARCH_RADIUS_Y.get();
        BlockPos nearestContainer = this.searchLootrContainers(level, player, playerPos, maxRadiusXZ, maxRadiusY);
        if (nearestContainer != null) {
            nearestDistance = playerPos.m_123331_((Vec3i)nearestContainer);
        }
        if ((nearestMinecart = this.searchLootrMinecarts(level, playerPos, maxRadiusXZ, maxRadiusY)) != null && (minecartDistance = playerPos.m_123331_((Vec3i)nearestMinecart.m_20183_())) < nearestDistance) {
            this.setFoundEntity(stack, (Entity)nearestMinecart);
            this.cacheSearchResult(nearestMinecart.m_20183_(), playerPos, player.f_19797_);
            return;
        }
        if (nearestContainer != null) {
            cache.isTrackingEntity = false;
            cache.trackedEntityUUID = null;
            this.setFoundPosition(stack, nearestContainer);
            this.cacheSearchResult(nearestContainer, playerPos, player.f_19797_);
        } else {
            this.clearFoundPosition(stack);
            this.cacheSearchResult(null, playerPos, player.f_19797_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private BlockPos searchLootrContainers(Level level, Player player, BlockPos playerPos, int maxRadiusXZ, int maxRadiusY) {
        BlockPos nearestContainer = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        int chunkRadius = (maxRadiusXZ >> 4) + 1;
        int playerChunkX = playerPos.m_123341_() >> 4;
        int playerChunkZ = playerPos.m_123343_() >> 4;
        for (int chunkX = playerChunkX - chunkRadius; chunkX <= playerChunkX + chunkRadius; ++chunkX) {
            for (int chunkZ = playerChunkZ - chunkRadius; chunkZ <= playerChunkZ + chunkRadius; ++chunkZ) {
                boolean isChunkLoaded = level.m_46749_(new BlockPos(chunkX << 4, playerPos.m_123342_(), chunkZ << 4));
                if (!isChunkLoaded) continue;
                LevelChunk chunk = level.m_6325_(chunkX, chunkZ);
                Map blockEntities = chunk.m_62954_();
                for (Map.Entry entry : blockEntities.entrySet()) {
                    int distanceSq;
                    BlockPos pos = (BlockPos)entry.getKey();
                    BlockEntity blockEntity = (BlockEntity)entry.getValue();
                    if (!this.isUnopenedLootrContainer(blockEntity, player)) continue;
                    int dx = pos.m_123341_() - playerPos.m_123341_();
                    int dy = pos.m_123342_() - playerPos.m_123342_();
                    int dz = pos.m_123343_() - playerPos.m_123343_();
                    boolean isWithinSearchRadius = Math.abs(dx) <= maxRadiusXZ && Math.abs(dz) <= maxRadiusXZ && Math.abs(dy) <= maxRadiusY;
                    if (!isWithinSearchRadius || !((double)(distanceSq = dx * dx + dy * dy + dz * dz) < nearestDistanceSq)) continue;
                    nearestDistanceSq = distanceSq;
                    nearestContainer = pos;
                }
            }
        }
        return nearestContainer;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private LootrChestMinecartEntity searchLootrMinecarts(Level level, BlockPos playerPos, int maxRadiusXZ, int maxRadiusY) {
        AABB searchBox = new AABB((double)(playerPos.m_123341_() - maxRadiusXZ), (double)(playerPos.m_123342_() - maxRadiusY), (double)(playerPos.m_123343_() - maxRadiusXZ), (double)(playerPos.m_123341_() + maxRadiusXZ), (double)(playerPos.m_123342_() + maxRadiusY), (double)(playerPos.m_123343_() + maxRadiusXZ));
        List minecarts = level.m_45976_(LootrChestMinecartEntity.class, searchBox);
        LootrChestMinecartEntity nearestMinecart = null;
        double nearestDistance = Double.MAX_VALUE;
        for (LootrChestMinecartEntity minecart : minecarts) {
            BlockPos minecartPos;
            double distance;
            if (minecart.isOpened() || !((distance = playerPos.m_123331_((Vec3i)(minecartPos = minecart.m_20183_()))) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestMinecart = minecart;
        }
        return nearestMinecart;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isUnopenedLootrContainer(BlockEntity blockEntity, Player player) {
        if (!(blockEntity instanceof ILootBlockEntity)) {
            return false;
        }
        ILootBlockEntity lootBlockEntity = (ILootBlockEntity)blockEntity;
        return !lootBlockEntity.getOpeners().contains(player.m_20148_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private BlockPos getFoundPosition(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(FOUND_POS_TAG)) {
            return null;
        }
        CompoundTag posTag = tag.m_128469_(FOUND_POS_TAG);
        return new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setFoundPosition(ItemStack stack, BlockPos pos) {
        boolean hasPositionChanged;
        boolean bl = hasPositionChanged = this.getFoundPosition(stack) == null || Objects.requireNonNull(this.getFoundPosition(stack)).m_121878_() != pos.m_121878_();
        if (!hasPositionChanged) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        CompoundTag posTag = new CompoundTag();
        posTag.m_128405_("x", pos.m_123341_());
        posTag.m_128405_("y", pos.m_123342_());
        posTag.m_128405_("z", pos.m_123343_());
        tag.m_128365_(FOUND_POS_TAG, (Tag)posTag);
        CompassGlowManager.clearGlow();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clearFoundPosition(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(FOUND_POS_TAG);
        }
        CompassGlowManager.clearGlow();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setFoundEntity(ItemStack stack, Entity entity) {
        LootersCompassItemClient.ClientCompassData cache = LootersCompassItemClient.getCache();
        cache.trackedEntityUUID = entity.m_20148_();
        cache.isTrackingEntity = true;
        this.setFoundPosition(stack, entity.m_20183_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private Entity findEntityByUUID(ClientLevel level, UUID uuid) {
        return (Entity)((ClientLevelAccessor)level).callGetEntities().m_142694_(uuid);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cacheSearchResult(@Nullable BlockPos result, BlockPos playerPos, int currentTick) {
        LootersCompassItemClient.ClientCompassData cache = LootersCompassItemClient.getCache();
        cache.lastSearchPos = playerPos;
        cache.lastSearchResult = result;
        cache.lastSearchTime = currentTick;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class LootersCompassItemClient {
        private static final ClientCompassData CACHE = new ClientCompassData();

        private LootersCompassItemClient() {
        }

        public static ClientCompassData getCache() {
            return CACHE;
        }

        public static void registerItemProperties(LootersCompassItem item) {
            ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((level, stack, entity) -> {
                Item patt0$temp = stack.m_41720_();
                if (!(patt0$temp instanceof LootersCompassItem)) {
                    return null;
                }
                LootersCompassItem compass = (LootersCompassItem)patt0$temp;
                BlockPos foundPos = compass.getFoundPosition(stack);
                if (foundPos == null) {
                    return null;
                }
                return GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)foundPos);
            }));
            ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"spinning"), (stack, level, entity, seed) -> {
                Item patt0$temp = stack.m_41720_();
                if (!(patt0$temp instanceof LootersCompassItem)) {
                    return 0.0f;
                }
                LootersCompassItem compass = (LootersCompassItem)patt0$temp;
                BlockPos foundPos = compass.getFoundPosition(stack);
                return foundPos == null ? 1.0f : 0.0f;
            });
        }

        public static class ClientCompassData {
            public UUID trackedEntityUUID;
            public boolean isTrackingEntity;
            public BlockPos lastSearchPos;
            public BlockPos lastSearchResult;
            public int lastSearchTime;
        }
    }
}

