/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.looterscompass.item;

import dev.kvnmtz.looterscompass.client.CompassGlowManager;
import dev.kvnmtz.looterscompass.config.ClientConfig;
import dev.kvnmtz.looterscompass.config.ServerConfig;
import dev.kvnmtz.looterscompass.mixin.ClientLevelAccessor;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootersCompassItem
extends Item {
    private static final String FOUND_POS_TAG = "FoundPos";
    private static final String FOUND_ENTITY_UUID_TAG = "FoundEntityUUID";
    private static final String IS_TRACKING_ENTITY_TAG = "IsTrackingEntity";

    public LootersCompassItem() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.UNCOMMON));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> LootersCompassItemClient.registerItemProperties(this));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        Integer cooldown;
        ItemStack stack = player.m_21120_(usedHand);
        if (!((Boolean)ServerConfig.ENABLE_LOOT_CONTAINER_GLOW.get()).booleanValue()) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (level.f_46443_) {
            if (this.isTrackingEntity(stack)) {
                Entity entity;
                UUID entityUUID = this.getFoundEntityUUID(stack);
                if (entityUUID != null && (entity = this.findEntityByUUID((ClientLevel)level, entityUUID)) instanceof LootrChestMinecartEntity) {
                    LootrChestMinecartEntity minecart = (LootrChestMinecartEntity)entity;
                    CompassGlowManager.activateGlowForEntity((Entity)minecart);
                }
            } else {
                BlockPos targetPos = this.getFoundPosition(stack);
                if (targetPos != null) {
                    CompassGlowManager.activateGlow(targetPos);
                } else {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
            }
        }
        if ((cooldown = (Integer)ServerConfig.GLOW_COOLDOWN.get()) > 0) {
            player.m_36335_().m_41524_((Item)this, ((Integer)ServerConfig.GLOW_COOLDOWN.get()).intValue());
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"item.looters_compass.looters_compass.desc").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        UUID entityUUID;
        if (!level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isTrackingEntity(stack) && (entityUUID = this.getFoundEntityUUID(stack)) != null) {
            Entity trackedEntity = this.findEntityByUUID((ClientLevel)level, entityUUID);
            if (trackedEntity != null) {
                this.setFoundPosition(stack, trackedEntity.m_20183_());
            } else {
                this.clearFoundPosition(stack);
            }
        }
        if (player.f_19797_ % (Integer)ClientConfig.SEARCH_FREQUENCY_TICKS.get() != 0) {
            return;
        }
        this.searchForLootContainers(stack, level, player);
    }

    private void searchForLootContainers(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player) {
        double minecartDistance;
        LootrChestMinecartEntity nearestMinecart;
        BlockPos playerPos = player.m_20183_();
        double nearestDistance = Double.MAX_VALUE;
        Integer maxRadiusXZ = (Integer)ServerConfig.SEARCH_RADIUS_XZ.get();
        Integer maxRadiusY = (Integer)ServerConfig.SEARCH_RADIUS_Y.get();
        BlockPos nearestContainer = this.searchLootrContainers(level, player, playerPos, maxRadiusXZ, maxRadiusY);
        if (nearestContainer != null) {
            nearestDistance = playerPos.m_123331_((Vec3i)nearestContainer);
        }
        if ((nearestMinecart = this.searchLootrMinecarts(level, playerPos, maxRadiusXZ, maxRadiusY)) != null && (minecartDistance = playerPos.m_123331_((Vec3i)nearestMinecart.m_20183_())) < nearestDistance) {
            this.setFoundEntity(stack, (Entity)nearestMinecart);
            return;
        }
        if (nearestContainer != null) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128473_(FOUND_ENTITY_UUID_TAG);
            tag.m_128473_(IS_TRACKING_ENTITY_TAG);
            this.setFoundPosition(stack, nearestContainer);
        } else {
            this.clearFoundPosition(stack);
        }
    }

    @Nullable
    private BlockPos searchLootrContainers(@NotNull Level level, @NotNull Player player, @NotNull BlockPos playerPos, int maxRadiusXZ, int maxRadiusY) {
        for (int radius = 1; radius <= maxRadiusXZ; ++radius) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    boolean isPositionAtEdgeOfRadius;
                    boolean bl = isPositionAtEdgeOfRadius = Math.abs(x) == radius || Math.abs(z) == radius;
                    if (!isPositionAtEdgeOfRadius) continue;
                    for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                        BlockPos checkPos = playerPos.m_7918_(x, y, z);
                        if (!this.isUnopenedLootrContainer(level, checkPos, player)) continue;
                        return checkPos;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private LootrChestMinecartEntity searchLootrMinecarts(@NotNull Level level, @NotNull BlockPos playerPos, int maxRadiusXZ, int maxRadiusY) {
        AABB searchBox = new AABB((double)(playerPos.m_123341_() - maxRadiusXZ), (double)(playerPos.m_123342_() - maxRadiusY), (double)(playerPos.m_123343_() - maxRadiusXZ), (double)(playerPos.m_123341_() + maxRadiusXZ), (double)(playerPos.m_123342_() + maxRadiusY), (double)(playerPos.m_123343_() + maxRadiusXZ));
        List minecarts = level.m_45976_(LootrChestMinecartEntity.class, searchBox);
        LootrChestMinecartEntity nearestMinecart = null;
        double nearestDistance = Double.MAX_VALUE;
        for (LootrChestMinecartEntity minecart : minecarts) {
            BlockPos minecartPos;
            double distance;
            if (minecart.isOpened() || !((distance = playerPos.m_123331_((Vec3i)(minecartPos = minecart.m_20183_()))) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestMinecart = minecart;
        }
        return nearestMinecart;
    }

    private boolean isUnopenedLootrContainer(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return false;
        }
        if (!(blockEntity instanceof ILootBlockEntity)) {
            return false;
        }
        ILootBlockEntity lootBlockEntity = (ILootBlockEntity)blockEntity;
        return !lootBlockEntity.getOpeners().contains(player.m_20148_());
    }

    @Nullable
    private BlockPos getFoundPosition(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(FOUND_POS_TAG)) {
            return null;
        }
        CompoundTag posTag = tag.m_128469_(FOUND_POS_TAG);
        return new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z"));
    }

    private void setFoundPosition(@NotNull ItemStack stack, @NotNull BlockPos pos) {
        boolean hasPositionChanged;
        boolean bl = hasPositionChanged = this.getFoundPosition(stack) == null || Objects.requireNonNull(this.getFoundPosition(stack)).m_121878_() != pos.m_121878_();
        if (!hasPositionChanged) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        CompoundTag posTag = new CompoundTag();
        posTag.m_128405_("x", pos.m_123341_());
        posTag.m_128405_("y", pos.m_123342_());
        posTag.m_128405_("z", pos.m_123343_());
        tag.m_128365_(FOUND_POS_TAG, (Tag)posTag);
        CompassGlowManager.clearGlow();
    }

    private void clearFoundPosition(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(FOUND_POS_TAG);
            tag.m_128473_(FOUND_ENTITY_UUID_TAG);
            tag.m_128473_(IS_TRACKING_ENTITY_TAG);
        }
        CompassGlowManager.clearGlow();
    }

    private void setFoundEntity(@NotNull ItemStack stack, @NotNull Entity entity) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(FOUND_ENTITY_UUID_TAG, entity.m_20148_().toString());
        tag.m_128379_(IS_TRACKING_ENTITY_TAG, true);
        this.setFoundPosition(stack, entity.m_20183_());
    }

    @Nullable
    private UUID getFoundEntityUUID(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(FOUND_ENTITY_UUID_TAG)) {
            return null;
        }
        try {
            return UUID.fromString(tag.m_128461_(FOUND_ENTITY_UUID_TAG));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean isTrackingEntity(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(IS_TRACKING_ENTITY_TAG);
    }

    @Nullable
    private Entity findEntityByUUID(@NotNull ClientLevel level, @NotNull UUID uuid) {
        return (Entity)((ClientLevelAccessor)level).callGetEntities().m_142694_(uuid);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class LootersCompassItemClient {
        private LootersCompassItemClient() {
        }

        public static void registerItemProperties(LootersCompassItem item) {
            ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((level, stack, entity) -> {
                Item patt0$temp = stack.m_41720_();
                if (!(patt0$temp instanceof LootersCompassItem)) {
                    return null;
                }
                LootersCompassItem compass = (LootersCompassItem)patt0$temp;
                BlockPos foundPos = compass.getFoundPosition(stack);
                if (foundPos == null) {
                    return null;
                }
                return GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)foundPos);
            }));
            ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"spinning"), (stack, level, entity, seed) -> {
                Item patt0$temp = stack.m_41720_();
                if (!(patt0$temp instanceof LootersCompassItem)) {
                    return 0.0f;
                }
                LootersCompassItem compass = (LootersCompassItem)patt0$temp;
                BlockPos foundPos = compass.getFoundPosition(stack);
                return foundPos == null ? 1.0f : 0.0f;
            });
        }
    }
}

