/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.client;

import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.excavar.ShapeUtil;
import de.melanx.excavar.api.shape.Shape;
import de.melanx.excavar.api.shape.Shapes;
import de.melanx.excavar.client.BlockHighlighter;
import de.melanx.excavar.client.ClientConfig;
import de.melanx.excavar.client.ClientExcavar;
import de.melanx.excavar.config.ListHandler;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.state.BlockOutlineRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.CustomBlockOutlineRenderer;

public class BlockRenderer
implements CustomBlockOutlineRenderer {
    private BlockHighlighter blockHighlighter = null;
    private Matcher matcher = new Matcher(BlockPos.ZERO, null, Blocks.AIR.defaultBlockState(), null, null);

    public boolean render(@Nonnull BlockOutlineRenderState renderState, @Nonnull MultiBufferSource.BufferSource buffer, @Nonnull PoseStack poseStack, boolean translucentPass, @Nonnull LevelRenderState levelRenderState) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!((Boolean)ClientConfig.enableOutline.get()).booleanValue() || !ListHandler.isToolAllowed(player.getMainHandItem())) {
            return false;
        }
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        BlockState state = player.level().getBlockState(hitResult2.getBlockPos());
        if (!ShapeUtil.miningAllowed(state)) {
            return false;
        }
        if (ClientExcavar.EXCAVAR.isDown() && (player.isShiftKeyDown() || !((Boolean)ClientConfig.onlyWhileSneaking.get()).booleanValue())) {
            if (!this.matcher.matches(hitResult2.getBlockPos(), hitResult2.getDirection(), state, player.getMainHandItem(), Shapes.getShape(Shapes.getSelectedShape())) || this.blockHighlighter == null) {
                this.blockHighlighter = new BlockHighlighter(hitResult2);
                this.matcher = new Matcher(hitResult2.getBlockPos(), hitResult2.getDirection(), state, player.getMainHandItem(), Shapes.getShape(Shapes.getSelectedShape()));
            }
            this.blockHighlighter.render((MultiBufferSource)buffer, poseStack);
        } else {
            this.blockHighlighter = null;
        }
        return false;
    }

    private record Matcher(@Nonnull BlockPos pos, Direction side, @Nonnull BlockState state, ItemStack tool, Shape shape) {
        public boolean matches(BlockPos otherPos, Direction otherSide, BlockState state, ItemStack tool, Shape shape) {
            return this.pos.equals((Object)otherPos) && this.side == otherSide && this.state.equals((Object)state) && this.tool == tool && this.shape == shape;
        }
    }
}

