/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.network.handler;

import de.melanx.excavar.Excavar;
import de.melanx.excavar.api.PlayerHandler;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record KeyPress(UUID playerId, PressType pressType, PlayerHandler.ClientData data) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"excavar", (String)"key_press");
    public static final CustomPacketPayload.Type<KeyPress> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, KeyPress> CODEC = StreamCodec.of(KeyPress::encode, KeyPress::decode);

    public KeyPress(UUID playerId, PressType pressType) {
        this(playerId, pressType, PlayerHandler.ClientData.EMPTY);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            switch (this.pressType.ordinal()) {
                case 0: 
                case 2: {
                    Excavar.getPlayerHandler().putPlayer(this.playerId, this.data);
                    break;
                }
                case 1: {
                    Excavar.getPlayerHandler().removePlayer(this.playerId);
                }
            }
        });
    }

    private static void encode(FriendlyByteBuf buffer, KeyPress msg) {
        buffer.writeUUID(msg.playerId);
        buffer.writeEnum((Enum)msg.pressType);
        buffer.writeBoolean(msg.data.requiresSneaking());
        buffer.writeBoolean(msg.data.preventToolBreaking());
        buffer.writeResourceLocation(msg.data.shapeId());
    }

    private static KeyPress decode(FriendlyByteBuf buffer) {
        return new KeyPress(buffer.readUUID(), (PressType)buffer.readEnum(PressType.class), new PlayerHandler.ClientData(buffer.readBoolean(), buffer.readBoolean(), buffer.readResourceLocation()));
    }

    public static enum PressType {
        PRESS,
        RELEASE,
        UPDATE;

    }
}

