/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.api.shape;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.melanx.excavar.api.shape.Shape;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class Shapes {
    private static final List<ResourceLocation> selectableShapes = Lists.newArrayList();
    private static final Map<ResourceLocation, Shape> registry = Maps.newHashMap();
    public static final ResourceLocation SHAPELESS = ResourceLocation.fromNamespaceAndPath((String)"excavar", (String)"shapeless");
    public static final ResourceLocation EASY_SHAPELESS = ResourceLocation.fromNamespaceAndPath((String)"excavar", (String)"easy_shapeless");
    public static final ResourceLocation PLANTS_SHAPELESS = ResourceLocation.fromNamespaceAndPath((String)"excavar", (String)"plants_shapeless");
    public static final ResourceLocation TUNNEL = ResourceLocation.fromNamespaceAndPath((String)"excavar", (String)"tunnel");
    private static ResourceLocation currentShape = SHAPELESS;

    private Shapes() {
    }

    public static void register(ResourceLocation id, Shape shape) {
        Shapes.register(id, shape, true);
    }

    public static void register(ResourceLocation id, Shape shape, boolean selectable) {
        if (registry.containsKey(id)) {
            throw new IllegalStateException("Shape '" + String.valueOf(id) + "' already registered.");
        }
        registry.put(id, shape);
        if (selectable) {
            selectableShapes.add(id);
        }
    }

    public static Shape getShape(ResourceLocation id) {
        if (!registry.containsKey(id)) {
            throw new IllegalArgumentException("Shape '" + String.valueOf(id) + "' was not registered.");
        }
        return registry.get(id);
    }

    public static ResourceLocation nextShapeId() {
        int i = selectableShapes.indexOf(currentShape);
        i = i >= selectableShapes.size() - 1 ? 0 : ++i;
        currentShape = selectableShapes.get(i);
        return currentShape;
    }

    public static ResourceLocation previousShapeId() {
        int i = selectableShapes.indexOf(currentShape);
        i = i == 0 ? selectableShapes.size() - 1 : --i;
        currentShape = selectableShapes.get(i);
        return currentShape;
    }

    public static ResourceLocation getSelectedShape() {
        return currentShape;
    }
}

